/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.AdditionNotice;
import edu.ucar.unidata.sruth.Archive;
import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.ArchivePathSet;
import edu.ucar.unidata.sruth.CancellingExecutor;
import edu.ucar.unidata.sruth.ClearingHouse;
import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.EmptyPieceSpecSet;
import edu.ucar.unidata.sruth.FileInfoMismatchException;
import edu.ucar.unidata.sruth.FilePieceSpecSet;
import edu.ucar.unidata.sruth.FilePieceSpecSetConsumer;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.Notice;
import edu.ucar.unidata.sruth.PeerMessage;
import edu.ucar.unidata.sruth.Piece;
import edu.ucar.unidata.sruth.PieceRequest;
import edu.ucar.unidata.sruth.PieceSpec;
import edu.ucar.unidata.sruth.PieceSpecSetIface;
import edu.ucar.unidata.sruth.RemovedFileNotice;
import edu.ucar.unidata.sruth.RemovedFilesNotice;
import edu.ucar.unidata.sruth.Request;
import edu.ucar.unidata.sruth.SpecSet;
import edu.ucar.unidata.sruth.UninterruptibleTask;
import edu.ucar.unidata.sruth.Util;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.FileSystemException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class Peer
implements Callable<Boolean> {
    private static final Logger logger = Util.getLogger();
    private final ClearingHouse clearingHouse;
    private final Connection connection;
    private final NoticeQueue noticeQueue = new NoticeQueue();
    private final BlockingQueue<Piece> pieceQueue = new SynchronousQueue<Piece>();
    private final Filter localFilter;
    private final Filter remoteFilter;
    private final DataSpecQueue requestQueue = new DataSpecQueue();
    private final DataSpecQueue requestNoticeQueue = new DataSpecQueue();
    private final CancellingExecutor cancellingExecutor = new CancellingExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private volatile long counter;
    private volatile boolean counterStopped;
    private final SpecSet pendingRequests = new SpecSet();

    Peer(ClearingHouse clearingHouse, Connection connection, Filter localFilter, Filter remoteFilter) {
        if (null == clearingHouse) {
            throw new NullPointerException();
        }
        if (null == connection) {
            throw new NullPointerException();
        }
        if (null == localFilter) {
            throw new NullPointerException();
        }
        if (null == remoteFilter) {
            throw new NullPointerException();
        }
        this.clearingHouse = clearingHouse;
        this.connection = connection;
        this.localFilter = localFilter;
        this.remoteFilter = remoteFilter;
    }

    Connection getConnection() {
        return this.connection;
    }

    Filter getLocalFilter() {
        return this.localFilter;
    }

    InetSocketAddress getRemoteServerSocketAddress() {
        return this.connection.getRemoteServerSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Boolean call() throws EOFException, IOException, SocketException, InterruptedException {
        boolean validPeer;
        block23: {
            logger.trace("Starting up: {}", this);
            String origName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.toString());
            try {
                ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.cancellingExecutor);
                try {
                    if (this.remoteFilter.equals(Filter.NOTHING)) {
                        this.connection.getNoticeStream().getOutput().close();
                        this.connection.getRequestStream().getInput().close();
                        this.connection.getDataStream().getOutput().close();
                    } else {
                        completionService.submit(new PieceSender(this.connection));
                        completionService.submit(new RequestReceiver(this.connection));
                        completionService.submit(new NoticeSender(this.connection));
                    }
                    if (this.localFilter.equals(Filter.NOTHING)) {
                        this.connection.getNoticeStream().getInput().close();
                        this.connection.getRequestStream().getOutput().close();
                        this.connection.getDataStream().getInput().close();
                    } else {
                        completionService.submit(new PieceReceiver(this.connection));
                        completionService.submit(new RequestSender(this.connection));
                        completionService.submit(new NoticeReceiver(this.connection));
                    }
                    validPeer = this.clearingHouse.add(this);
                    if (!validPeer) {
                        logger.debug("Not a valid peer: {}", this);
                        break block23;
                    }
                    try {
                        Future<Void> fileScannerFuture = null;
                        if (!this.remoteFilter.equals(Filter.NOTHING)) {
                            fileScannerFuture = completionService.submit(new FileScanner());
                        }
                        Future future = completionService.take();
                        while (!future.isCancelled()) {
                            try {
                                future.get();
                            }
                            catch (ExecutionException e) {
                                Throwable cause = e.getCause();
                                logger.debug(cause.toString());
                                if (cause instanceof EOFException) {
                                    throw (EOFException)cause;
                                }
                                if (cause instanceof SocketTimeoutException) {
                                    throw (SocketTimeoutException)cause;
                                }
                                if (cause instanceof SocketException) {
                                    throw (SocketException)cause;
                                }
                                if (cause instanceof IOException) {
                                    throw (IOException)cause;
                                }
                                throw Util.launderThrowable(cause);
                            }
                            if (!future.equals(fileScannerFuture)) {
                                logger.trace("Sender or Receiver completed: {}", this);
                                break;
                            }
                            future = completionService.take();
                        }
                    }
                    finally {
                        this.clearingHouse.remove(this);
                    }
                }
                finally {
                    this.cancellingExecutor.shutdownNow();
                    Thread.interrupted();
                    this.cancellingExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                }
            }
            finally {
                this.connection.close();
                Thread.currentThread().setName(origName);
                logger.trace("Done: {}", this);
            }
        }
        return new Boolean(validPeer);
    }

    void notifyRemoteIfDesired(PieceSpec pieceSpec) throws InterruptedException {
        if (this.remoteFilter.matches(pieceSpec.getArchivePath())) {
            this.noticeQueue.newData(pieceSpec);
        }
    }

    void queueRequest(PieceSpec pieceSpec) {
        this.pendingRequests.add(pieceSpec);
        this.requestQueue.put(pieceSpec);
        logger.trace("Request added: {}", pieceSpec);
    }

    void newData(FilePieceSpecSet spec) {
        logger.trace("New data: {}", spec);
        if (this.remoteFilter.matches(spec.getArchivePath())) {
            this.noticeQueue.newData(spec);
        }
    }

    void notifyRemoteOfRemovals(ArchivePath archivePath) {
        this.noticeQueue.put(archivePath);
    }

    void remove(ArchivePath archivePath) throws IOException {
        this.clearingHouse.remove(archivePath);
    }

    void queueForSending(PieceSpecSetIface specs) throws InterruptedException, IOException {
        for (PieceSpec spec : specs) {
            try {
                Piece piece = this.clearingHouse.getPiece(spec);
                if (piece == null) continue;
                this.pieceQueue.put(piece);
            }
            catch (FileInfoMismatchException e) {
                logger.warn("Mismatched file-information: {}: {}", (Object)e.toString(), (Object)this);
            }
        }
    }

    void queueForSendingNotices(PieceSpecSetIface specs) throws FileSystemException, IOException {
        Archive archive = this.clearingHouse.getArchive();
        for (PieceSpec spec : specs) {
            if (!archive.exists(spec)) continue;
            this.noticeQueue.newData(spec);
        }
    }

    void process(Piece piece) throws IOException, InterruptedException {
        try {
            boolean wasUsed = this.clearingHouse.process(this, piece);
            if (!this.counterStopped && wasUsed) {
                this.counter += (long)piece.getSize();
            }
        }
        catch (FileInfoMismatchException e) {
            logger.warn("Mismatched file-information: {}: {}", (Object)e.toString(), (Object)this);
        }
        this.pendingRequests.remove(piece.getInfo());
    }

    private static void setThreadName(String className) {
        Thread currentThread = Thread.currentThread();
        currentThread.setName(className);
    }

    void newRemoteData(PieceSpec pieceSpec) throws IOException {
        try {
            this.clearingHouse.process(this, pieceSpec);
        }
        catch (FileInfoMismatchException e) {
            logger.warn("Mismatched file-information: {}: {}", (Object)e.toString(), (Object)this);
        }
    }

    void stopCounter() {
        this.counterStopped = true;
    }

    long getCounter() {
        return this.counter;
    }

    void restartCounter() {
        this.counter = 0L;
        this.counterStopped = false;
    }

    SpecSet getPendingRequests() {
        return this.pendingRequests;
    }

    void requestNotices(SpecSet specs) {
        this.requestNoticeQueue.put(specs.getSet());
    }

    public String toString() {
        return "Peer [connection=" + this.connection + ", remoteFilter=" + this.remoteFilter + "]";
    }

    @ThreadSafe
    private static final class NoticeQueue {
        private volatile boolean wasAddition = false;
        @GuardedBy(value="this")
        private final DataSpecQueue additions = new DataSpecQueue();
        @GuardedBy(value="this")
        private ArchivePathSet removals = new ArchivePathSet();

        private NoticeQueue() {
        }

        synchronized void newData(FilePieceSpecSet spec) {
            this.additions.put(spec);
            logger.trace("New-data notice added: {}", spec);
            this.notify();
        }

        synchronized void oldData(FilePieceSpecSet spec) throws InterruptedException {
            while (!this.additions.isEmpty()) {
                this.wait();
            }
            this.additions.put(spec);
            logger.trace("Old-data notice added: {}", spec);
            this.notify();
        }

        synchronized void put(ArchivePath archivePath) {
            this.removals.add(archivePath);
            logger.trace("Removal notice added: {}", archivePath);
            this.notify();
        }

        synchronized Notice take() throws InterruptedException {
            Notice notice;
            while (this.removals.isEmpty() && this.additions.isEmpty()) {
                this.wait();
            }
            if (this.additions.isEmpty() || !this.removals.isEmpty() && this.wasAddition) {
                notice = 1 == this.removals.size() ? new RemovedFileNotice(this.removals.iterator().next()) : new RemovedFilesNotice(this.removals);
                this.removals = new ArchivePathSet();
                this.wasAddition = false;
            } else {
                notice = new AdditionNotice(this.additions.poll());
                this.wasAddition = true;
            }
            this.notify();
            return notice;
        }
    }

    @ThreadSafe
    private static final class DataSpecQueue {
        @GuardedBy(value="this")
        private PieceSpecSetIface pieceSpecSet = EmptyPieceSpecSet.INSTANCE;

        private DataSpecQueue() {
        }

        synchronized void put(FilePieceSpecSet spec) {
            this.pieceSpecSet = this.pieceSpecSet.merge(spec);
            this.notify();
        }

        synchronized void put(PieceSpecSetIface specs) {
            this.pieceSpecSet = this.pieceSpecSet.merge(specs);
            this.notify();
        }

        synchronized boolean isEmpty() {
            return this.pieceSpecSet.isEmpty();
        }

        synchronized PieceSpecSetIface take() throws InterruptedException {
            while (this.isEmpty()) {
                this.wait();
            }
            return this.removeAndReturn();
        }

        synchronized PieceSpecSetIface poll() {
            return this.isEmpty() ? null : this.removeAndReturn();
        }

        @GuardedBy(value="this")
        private synchronized PieceSpecSetIface removeAndReturn() {
            PieceSpecSetIface specs = this.pieceSpecSet;
            this.pieceSpecSet = EmptyPieceSpecSet.INSTANCE;
            this.notify();
            return specs;
        }
    }

    @ThreadSafe
    private final class PieceSender
    extends Sender<Piece> {
        PieceSender(Connection connection) {
            super(connection.getDataStream());
        }

        @Override
        protected Piece nextMessage() throws InterruptedException {
            return (Piece)Peer.this.pieceQueue.take();
        }
    }

    @ThreadSafe
    private final class NoticeSender
    extends Sender<Notice> {
        NoticeSender(Connection connection) {
            super(connection.getNoticeStream());
        }

        @Override
        protected Notice nextMessage() throws InterruptedException {
            return Peer.this.noticeQueue.take();
        }
    }

    @ThreadSafe
    private final class RequestSender
    extends Sender<Request> {
        RequestSender(Connection connection) {
            super(connection.getRequestStream());
        }

        @Override
        public PieceRequest nextMessage() throws InterruptedException {
            return new PieceRequest(Peer.this.requestQueue.take());
        }
    }

    @ThreadSafe
    private abstract class Sender<T extends PeerMessage>
    extends UninterruptibleTask<Void> {
        private final Connection.Stream.Output stream;

        protected Sender(Connection.Stream stream) {
            this.stream = stream.getOutput();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Void call() throws IOException {
            Peer.setThreadName(this.toString());
            try {
                T message;
                while ((message = this.nextMessage()) != null) {
                    this.stream.send((Connection.Message)message);
                }
            }
            catch (SocketException e) {
                if (!this.isCancelled()) {
                    logger.debug("Stream closed: {}", this.stream);
                    throw e;
                }
            }
            catch (InterruptedException ignored) {
                logger.debug("Interrupted: {}", (Object)this.getClass().getSimpleName());
            }
            finally {
                this.stream.close();
            }
            return null;
        }

        protected abstract T nextMessage() throws InterruptedException;

        @Override
        protected final void stop() {
            this.stream.close();
        }

        public final String toString() {
            return this.getClass().getSimpleName() + " [peer=" + Peer.this + "]";
        }
    }

    @ThreadSafe
    private final class PieceReceiver
    extends Receiver<Piece> {
        PieceReceiver(Connection connection) {
            super(connection.getDataStream(), Piece.class);
        }

        @Override
        protected boolean allDone() {
            return Peer.this.clearingHouse.allDataReceived();
        }
    }

    @ThreadSafe
    private final class NoticeReceiver
    extends Receiver<Notice> {
        NoticeReceiver(Connection connection) {
            super(connection.getNoticeStream(), Notice.class);
        }
    }

    @ThreadSafe
    private final class RequestReceiver
    extends Receiver<Request> {
        RequestReceiver(Connection connection) {
            super(connection.getRequestStream(), Request.class);
        }
    }

    @ThreadSafe
    private abstract class Receiver<T extends PeerMessage>
    extends UninterruptibleTask<Void> {
        private final Connection.Stream.Input stream;
        private final Class<T> type;

        protected Receiver(Connection.Stream stream, Class<T> type) {
            if (null == type) {
                throw new NullPointerException();
            }
            this.stream = stream.getInput();
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws EOFException, IOException, SocketException, ClassNotFoundException {
            block9: {
                String origName = Thread.currentThread().getName();
                Peer.setThreadName(this.toString());
                try {
                    do {
                        Object obj = this.readObject();
                        PeerMessage message = (PeerMessage)this.type.cast(obj);
                        message.processYourself(Peer.this);
                    } while (!this.allDone());
                }
                catch (InterruptedException ignored) {
                    logger.debug("Interrupted: {}", (Object)this.getClass().getSimpleName());
                }
                catch (IOException e) {
                    if (this.isCancelled()) {
                        logger.debug("Interrupted: {}", (Object)this.getClass().getSimpleName());
                        break block9;
                    }
                    throw e;
                }
                finally {
                    this.stream.close();
                    Thread.currentThread().setName(origName);
                }
            }
            return null;
        }

        protected final Object readObject() throws EOFException, IOException, ClassNotFoundException, SocketException {
            try {
                Object obj = this.stream.receiveObject(0);
                return obj;
            }
            catch (SocketTimeoutException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        protected boolean allDone() {
            return false;
        }

        @Override
        protected final void stop() {
            this.stream.close();
        }

        public final String toString() {
            return this.getClass().getSimpleName() + " [peer=" + Peer.this + "]";
        }
    }

    @ThreadSafe
    private final class FileScanner
    implements Callable<Void> {
        private FileScanner() {
        }

        @Override
        public Void call() throws InterruptedException, IOException {
            Peer.setThreadName(this.toString());
            logger.trace("Starting up: {}", this);
            Peer.this.clearingHouse.walkArchive(new FilePieceSpecSetConsumer(){

                @Override
                public void consume(FilePieceSpecSet spec) throws InterruptedException {
                    Peer.this.noticeQueue.oldData(spec);
                }
            }, Peer.this.remoteFilter);
            return null;
        }

        public String toString() {
            return "FileScanner [rootDir=" + Peer.this.clearingHouse.getRootDir() + "]";
        }
    }
}

