/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.FileInfo;
import edu.ucar.unidata.sruth.Peer;
import edu.ucar.unidata.sruth.PeerMessage;
import edu.ucar.unidata.sruth.PieceSpec;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Arrays;

final class Piece
implements PeerMessage {
    private static final long serialVersionUID = 1L;
    private final PieceSpec pieceSpec;
    private final byte[] data;

    Piece(PieceSpec pieceSpec, byte[] data) {
        pieceSpec.vet(data);
        this.pieceSpec = pieceSpec;
        this.data = data;
    }

    PieceSpec getInfo() {
        return this.pieceSpec;
    }

    int getSize() {
        return this.pieceSpec.getSize();
    }

    int getIndex() {
        return this.pieceSpec.getIndex();
    }

    byte[] getData() {
        return this.data;
    }

    FileInfo getFileInfo() {
        return this.pieceSpec.getFileInfo();
    }

    ArchivePath getArchivePath() {
        return this.pieceSpec.getArchivePath();
    }

    long getOffset() {
        return this.pieceSpec.getOffset();
    }

    int getTimeToLive() {
        return this.pieceSpec.getTimeToLive();
    }

    @Override
    public void processYourself(Peer peer) throws IOException, InterruptedException {
        peer.process(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.pieceSpec == null ? 0 : this.pieceSpec.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Piece other = (Piece)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return !(this.pieceSpec == null ? other.pieceSpec != null : !this.pieceSpec.equals(other.pieceSpec));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pieceSpec=" + this.pieceSpec + ", size=" + this.data.length + ", dataHash=" + Arrays.hashCode(this.data) + "]";
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            return new Piece(this.pieceSpec, this.data);
        }
        catch (Exception e) {
            throw (InvalidObjectException)new InvalidObjectException("Read invalid " + this.getClass().getSimpleName()).initCause(e);
        }
    }
}

