/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.EmptyPieceSpecSet;
import edu.ucar.unidata.sruth.FileInfo;
import edu.ucar.unidata.sruth.FilePieceSpecSet;
import edu.ucar.unidata.sruth.FilePieceSpecs;
import edu.ucar.unidata.sruth.PieceSpecSet;
import edu.ucar.unidata.sruth.PieceSpecSetIface;
import edu.ucar.unidata.sruth.SimpleIterator;
import java.io.InvalidObjectException;
import java.util.Iterator;

final class PieceSpec
extends FilePieceSpecSet {
    private static final long serialVersionUID = 1L;
    private final int index;

    PieceSpec(FileInfo fileInfo, int index) {
        super(fileInfo);
        fileInfo.vet(index);
        this.index = index;
    }

    void vet(byte[] data) {
        this.fileInfo.vet(this.index, data);
    }

    int getIndex() {
        return this.index;
    }

    @Override
    ArchivePath getArchivePath() {
        return this.fileInfo.getPath();
    }

    long getOffset() {
        return this.fileInfo.getOffset(this.index);
    }

    int getSize() {
        return this.fileInfo.getSize(this.index);
    }

    int getTimeToLive() {
        return this.fileInfo.getTimeToLive();
    }

    @Override
    public PieceSpecSetIface merge(PieceSpecSetIface specs) {
        return specs.merge(this);
    }

    @Override
    public PieceSpecSetIface merge(PieceSpecSet specs) {
        return specs.merge(this);
    }

    @Override
    public PieceSpecSetIface merge(FilePieceSpecs specs) {
        return specs.merge(this);
    }

    @Override
    public PieceSpecSetIface merge(PieceSpec that) {
        if (this.getFileId().equals(that.getFileId())) {
            if (this.index == that.index) {
                return this;
            }
            return new FilePieceSpecs(this.fileInfo).merge(this).merge(that);
        }
        return new PieceSpecSet(this).merge(that);
    }

    @Override
    public PieceSpecSetIface remove(PieceSpec spec) {
        return this.equals(spec) ? EmptyPieceSpecSet.INSTANCE : this;
    }

    @Override
    public boolean contains(PieceSpec spec) {
        return this.equals(spec);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public PieceSpec clone() {
        return this;
    }

    @Override
    public Iterator<PieceSpec> iterator() {
        return new SimpleIterator<PieceSpec>(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PieceSpec other = (PieceSpec)obj;
        return this.index == other.index;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{fileInfo=" + this.fileInfo + ", index=" + this.index + "}";
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            return new PieceSpec(this.fileInfo, this.index);
        }
        catch (Exception e) {
            throw (InvalidObjectException)new InvalidObjectException("Read invalid " + this.getClass().getSimpleName()).initCause(e);
        }
    }
}

