/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.FileId;
import edu.ucar.unidata.sruth.FilePieceSpecSet;
import edu.ucar.unidata.sruth.FilePieceSpecs;
import edu.ucar.unidata.sruth.PieceSpec;
import edu.ucar.unidata.sruth.PieceSpecSetIface;
import edu.ucar.unidata.sruth.SimpleIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class PieceSpecSet
implements PieceSpecSetIface,
Serializable {
    private static final long serialVersionUID = 1L;
    @GuardedBy(value="this")
    private final Map<FileId, FilePieceSpecSet> filePieceSpecSets = new TreeMap<FileId, FilePieceSpecSet>();

    PieceSpecSet() {
    }

    PieceSpecSet(FilePieceSpecSet specs) {
        this.add(specs);
    }

    @Override
    public PieceSpecSetIface merge(PieceSpecSetIface specs) {
        return specs.merge(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PieceSpecSetIface merge(PieceSpecSet that) {
        PieceSpecSet o2;
        PieceSpecSet o1;
        if (this == that) {
            return this;
        }
        if (System.identityHashCode(this) < System.identityHashCode(that)) {
            o1 = this;
            o2 = that;
        } else {
            o1 = that;
            o2 = this;
        }
        PieceSpecSet pieceSpecSet = o1;
        synchronized (pieceSpecSet) {
            PieceSpecSet pieceSpecSet2 = o2;
            synchronized (pieceSpecSet2) {
                if (o1.filePieceSpecSets.size() < o2.filePieceSpecSets.size()) {
                    PieceSpecSet tmp = o1;
                    o1 = o2;
                    o2 = tmp;
                }
                for (FilePieceSpecSet specs : o2.filePieceSpecSets.values()) {
                    o1.add(specs);
                }
            }
        }
        return o1;
    }

    @Override
    public PieceSpecSetIface merge(FilePieceSpecs specs) {
        this.add(specs);
        return this;
    }

    @Override
    public synchronized PieceSpecSetIface merge(PieceSpec spec) {
        this.add(spec);
        return this;
    }

    @Override
    public synchronized PieceSpecSetIface remove(PieceSpec spec) {
        PieceSpecSetIface newValue;
        FileId fileId = spec.getFileId();
        FilePieceSpecSet value = this.filePieceSpecSets.get(fileId);
        if (value != null && (newValue = value.remove(spec)) != value) {
            if (newValue.isEmpty()) {
                this.filePieceSpecSets.remove(fileId);
            } else {
                this.filePieceSpecSets.put(fileId, (FilePieceSpecSet)newValue);
            }
        }
        return this;
    }

    @Override
    public boolean contains(PieceSpec spec) {
        FileId fileId = spec.getFileId();
        FilePieceSpecSet value = this.filePieceSpecSets.get(fileId);
        return value != null && value.contains(spec);
    }

    @GuardedBy(value="this")
    private synchronized void add(FilePieceSpecSet specs) {
        FileId fileId = specs.getFileId();
        FilePieceSpecSet value = this.filePieceSpecSets.get(fileId);
        value = null == value ? specs : value.merge(specs);
        this.filePieceSpecSets.put(fileId, value);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.filePieceSpecSets.isEmpty();
    }

    @Override
    public synchronized PieceSpecSet clone() {
        PieceSpecSet clone = new PieceSpecSet();
        for (FilePieceSpecSet specs : this.filePieceSpecSets.values()) {
            clone.add(specs.clone());
        }
        return clone;
    }

    @Override
    public synchronized Iterator<PieceSpec> iterator() {
        return new SimpleIterator<PieceSpec>(){
            Iterator<FilePieceSpecSet> fileIterator;
            Iterator<PieceSpec> specIterator;

            @Override
            protected PieceSpec getNext() {
                if (null == this.fileIterator) {
                    this.fileIterator = PieceSpecSet.this.filePieceSpecSets.values().iterator();
                    Iterator<Object> iterator = this.specIterator = this.fileIterator.hasNext() ? this.fileIterator.next().iterator() : null;
                }
                while (null != this.specIterator) {
                    if (this.specIterator.hasNext()) {
                        return this.specIterator.next();
                    }
                    this.specIterator = this.fileIterator.hasNext() ? this.fileIterator.next().iterator() : null;
                }
                return null;
            }
        };
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PieceSpecSet [filePieceSpecSets=");
        int size = this.filePieceSpecSets.size();
        if (size == 1) {
            builder.append(this.filePieceSpecSets);
        } else {
            builder.append("(");
            builder.append(size);
            builder.append(" entries)");
        }
        builder.append("]");
        return builder.toString();
    }

    private Object readResolve() {
        PieceSpecSet result = new PieceSpecSet();
        for (FilePieceSpecSet specs : this.filePieceSpecSets.values()) {
            result.add(specs);
        }
        return result;
    }
}

