/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@Immutable
final class PortNumberSet
implements Iterable<Integer> {
    static final int MIN_PORT_NUMBER = 1;
    static final int MAX_PORT_NUMBER = 65535;
    static final PortNumberSet EPHEMERAL = new PortNumberSet(0, 0);
    private final int minPort;
    private final int maxPort;

    private PortNumberSet(int minPort, int maxPort) {
        if (minPort < 0 || maxPort < 0 || minPort > maxPort || minPort > 65535 || maxPort > 65535) {
            throw new IllegalArgumentException("Invalid port range: minPort=" + minPort + ", maxPort=" + maxPort);
        }
        this.minPort = minPort;
        this.maxPort = maxPort;
    }

    static PortNumberSet getInstance(int minPort, int maxPort) {
        return minPort == 0 ? EPHEMERAL : new PortNumberSet(minPort, maxPort);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new PortNumberIterator();
    }

    public String toString() {
        return "PortNumberSet [minPort=" + this.minPort + ", maxPort=" + this.maxPort + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxPort;
        result = 31 * result + this.minPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortNumberSet other = (PortNumberSet)obj;
        if (this.maxPort != other.maxPort) {
            return false;
        }
        return this.minPort == other.minPort;
    }

    @NotThreadSafe
    private final class PortNumberIterator
    implements Iterator<Integer> {
        private int nextPort;

        PortNumberIterator() {
            this.nextPort = PortNumberSet.this.minPort;
        }

        @Override
        public boolean hasNext() {
            return this.nextPort <= PortNumberSet.this.maxPort;
        }

        @Override
        public Integer next() {
            return this.nextPort++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

