/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.FileInfo;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.PieceSpec;
import java.io.InvalidObjectException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.GuardedBy;

public class Predicate
implements Iterable<Filter>,
Connection.Message {
    private static final long serialVersionUID = 1L;
    public static final Predicate EVERYTHING = new Predicate(Filter.EVERYTHING){
        private static final long serialVersionUID = 1L;

        @Override
        public Predicate add(Filter filter) {
            return this;
        }

        @Override
        synchronized boolean matches(FileInfo fileInfo) {
            return true;
        }

        @Override
        synchronized void removeIfPossible(FileInfo fileInfo) {
        }

        @Override
        synchronized boolean matchesNothing() {
            return false;
        }

        @Override
        public String toString() {
            return "EVERYTHING";
        }

        @Override
        private Object readResolve() {
            return EVERYTHING;
        }
    };
    public static final Predicate NOTHING = new Predicate(){
        private static final long serialVersionUID = 1L;

        @Override
        public Predicate add(Filter filter) {
            if (filter.equals(Filter.EVERYTHING)) {
                return EVERYTHING;
            }
            return new Predicate(filter);
        }

        @Override
        synchronized boolean matches(FileInfo fileInfo) {
            return false;
        }

        @Override
        synchronized void removeIfPossible(FileInfo fileInfo) {
        }

        @Override
        synchronized boolean matchesNothing() {
            return true;
        }

        @Override
        public String toString() {
            return "NOTHING";
        }

        @Override
        private Object readResolve() {
            return NOTHING;
        }
    };
    @GuardedBy(value="this")
    private final Set<Filter> filters = new TreeSet<Filter>();

    public Predicate() {
    }

    private Predicate(Filter filter) {
        if (null == filter) {
            throw new NullPointerException();
        }
        this.filters.add(filter);
    }

    public synchronized Predicate add(Filter filter) {
        Iterator<Filter> iter = this.filters.iterator();
        while (iter.hasNext()) {
            Filter extantFilter = iter.next();
            if (filter.includes(extantFilter) && !filter.equals(extantFilter)) {
                iter.remove();
                continue;
            }
            if (!extantFilter.includes(filter)) continue;
            return this;
        }
        this.filters.add(filter);
        return this;
    }

    synchronized boolean matches(FileInfo fileInfo) {
        for (Filter filter : this.filters) {
            if (!filter.matches(fileInfo.getPath())) continue;
            return true;
        }
        return false;
    }

    final boolean matches(PieceSpec pieceSpec) {
        return this.matches(pieceSpec.getFileInfo());
    }

    synchronized void removeIfPossible(FileInfo fileInfo) {
        Iterator<Filter> iter = this.filters.iterator();
        while (iter.hasNext()) {
            if (!iter.next().matchesOnly(fileInfo.getPath())) continue;
            iter.remove();
            break;
        }
    }

    synchronized boolean matchesNothing() {
        return this.filters.isEmpty();
    }

    synchronized int getFilterCount() {
        return this.filters.size();
    }

    @Override
    public synchronized Iterator<Filter> iterator() {
        return this.filters.iterator();
    }

    Set<Filter> getFilters() {
        return new TreeSet<Filter>(this.filters);
    }

    Filter getIncludingFilter(Filter targetFilter) {
        for (Filter filter : this.filters) {
            if (!filter.includes(targetFilter)) continue;
            return filter;
        }
        return Filter.NOTHING;
    }

    boolean isMoreInclusiveThan(Predicate that) {
        for (Filter thisFilter : this.filters) {
            for (Filter thatFilter : that.filters) {
                if (!thatFilter.includes(thisFilter) || thisFilter.equals(thatFilter)) continue;
                return false;
            }
        }
        return true;
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            Predicate predicate = NOTHING;
            for (Filter filter : this.filters) {
                predicate = predicate.add(filter);
            }
            return predicate;
        }
        catch (Exception e) {
            throw (InvalidObjectException)new InvalidObjectException("Read invalid " + this.getClass().getSimpleName()).initCause(e);
        }
    }

    public synchronized String toString() {
        return "Predicate [filters=" + this.filters + "]";
    }
}

