/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Action;
import edu.ucar.unidata.sruth.DataProduct;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class Processor
implements Callable<Void> {
    private static final Logger logger = Util.getLogger();
    private final ConcurrentMap<Pattern, List<Action>> actions = new ConcurrentHashMap<Pattern, List<Action>>();
    private final BlockingQueue<DataProduct> processingQueue = new LinkedBlockingQueue<DataProduct>();
    private final CountDownLatch isRunningLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Pattern pattern, Action action) {
        LinkedList<Action> newList = new LinkedList<Action>();
        LinkedList<Action> list = this.actions.putIfAbsent(pattern, newList);
        if (list == null) {
            list = newList;
        }
        LinkedList<Action> linkedList = list;
        synchronized (linkedList) {
            list.add(action);
        }
    }

    @Override
    public Void call() throws InterruptedException {
        logger.trace("Starting up: {}", this);
        this.isRunningLatch.countDown();
        block4: while (true) {
            try {
                while (true) {
                    DataProduct product = this.processingQueue.take();
                    try {
                        this.matchAndProcess(product);
                        continue block4;
                    }
                    catch (IOException e) {
                        logger.error("Couldn't process data-product: " + product, e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                logger.trace("Done: {}", this);
                throw throwable;
            }
        }
    }

    public void waitUntilRunning() throws InterruptedException {
        this.isRunningLatch.await();
    }

    boolean offer(DataProduct dataProduct) {
        return this.processingQueue.offer(dataProduct);
    }

    private boolean matchAndProcess(DataProduct dataProduct) throws IOException, InterruptedException {
        boolean processed = false;
        for (Map.Entry entry : this.actions.entrySet()) {
            Matcher matcher = dataProduct.matcher((Pattern)entry.getKey());
            if (!matcher.matches()) continue;
            for (Action action : (List)entry.getValue()) {
                action.execute(matcher, dataProduct);
                processed = true;
            }
        }
        return processed;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + " [" + this.actions.size() + " actions]";
    }
}

