/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Archive;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class PubFile {
    private final Archive archive;
    private final Path hiddenPath;
    private final SeekableByteChannel channel;

    PubFile(Archive archive, Path path) throws FileAlreadyExistsException, IOException {
        if (null == archive || null == path) {
            throw new NullPointerException();
        }
        this.archive = archive;
        this.hiddenPath = archive.getHiddenAbsolutePath(path);
        Files.createDirectories(this.hiddenPath.getParent(), new FileAttribute[0]);
        this.channel = Files.newByteChannel(this.hiddenPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
    }

    void write(ByteBuffer buf) throws IOException {
        this.channel.write(buf);
    }

    void publish() throws IOException {
        this.channel.close();
        Path newPath = this.archive.getVisiblePath(this.hiddenPath);
        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
        Files.move(this.hiddenPath, newPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }
}

