/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Archive;
import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.CancellingExecutor;
import edu.ucar.unidata.sruth.FileInfoMismatchException;
import edu.ucar.unidata.sruth.SourceNode;
import edu.ucar.unidata.sruth.Topology;
import edu.ucar.unidata.sruth.Tracker;
import edu.ucar.unidata.sruth.Util;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class Publisher
implements Callable<Void> {
    private static final Logger logger = Util.getLogger();
    private final SourceNode sourceNode;
    private final Tracker tracker;
    private final CancellingExecutor executor = new CancellingExecutor(2, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final ExecutorCompletionService<Void> completionService = new ExecutorCompletionService(this.executor);
    private final Archive archive;
    private final Archive.DistributedTrackerFiles distributedTrackerFiles;

    public Publisher(Path rootDir) throws IOException {
        this(rootDir, 38800, 0, 0);
    }

    public Publisher(Path rootDir, int trackerPort, int serverPort, int reportingPort) throws IOException {
        this.archive = new Archive(rootDir);
        InetAddress localHostAddress = InetAddress.getLocalHost();
        InetSocketAddress serverSocketAddress = new InetSocketAddress(localHostAddress, serverPort);
        this.sourceNode = new SourceNode(this.archive, serverSocketAddress);
        InetSocketAddress trackerSocketAddress = new InetSocketAddress(localHostAddress, trackerPort);
        this.tracker = new Tracker(this.sourceNode.getServerSocketAddress(), trackerSocketAddress);
        this.distributedTrackerFiles = this.archive.getDistributedTrackerFiles(this.tracker.getServerAddress());
        this.tracker.addNetworkTopologyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Publisher.this.distributedTrackerFiles.distribute((Topology)evt.getNewValue());
            }
        });
        this.distributedTrackerFiles.distribute(this.tracker.getReportingAddress());
    }

    @Override
    public Void call() throws InterruptedException, IOException {
        logger.trace("Starting up: {}", this);
        String origThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.toString());
        try {
            this.completionService.submit(this.sourceNode);
            Future<Void> trackerFuture = this.completionService.submit(this.tracker);
            Future<Void> future = this.completionService.take();
            if (!future.isCancelled()) {
                try {
                    future.get();
                    throw new AssertionError();
                }
                catch (ExecutionException e) {
                    Callable<Void> task;
                    Throwable cause = e.getCause();
                    Callable<Void> callable = task = future == trackerFuture ? this.tracker : this.sourceNode;
                    if (cause instanceof IOException) {
                        throw new IOException("IO error: " + task, cause);
                    }
                    throw new RuntimeException("Unexpected error: " + task, cause);
                }
            }
        }
        catch (RejectedExecutionException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.executor.shutdownNow();
            this.awaitCompletion();
            try {
                this.archive.close();
            }
            catch (IOException ignored) {}
            Thread.currentThread().setName(origThreadName);
            logger.trace("Done: {}", this);
        }
        return null;
    }

    void waitUntilRunning() throws InterruptedException {
        this.sourceNode.waitUntilRunning();
        this.tracker.waitUntilRunning();
    }

    public InetSocketAddress getTrackerAddress() {
        return this.tracker.getServerAddress();
    }

    public InetSocketAddress getSourceAddress() {
        return this.sourceNode.getServerSocketAddress();
    }

    public int getTrackerPort() {
        return this.tracker.getServerAddress().getPort();
    }

    public void publish(ArchivePath path, ByteBuffer data, int timeToLive) throws FileAlreadyExistsException, IOException, FileInfoMismatchException {
        byte[] bytes = data.array();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ReadableByteChannel channel = Channels.newChannel(inputStream);
        this.archive.save(path, channel, timeToLive);
    }

    public int getClientCount() {
        return this.sourceNode.getServletCount();
    }

    private SocketAddress getTrackerSocketAddress() {
        return this.tracker.getSocketAddress();
    }

    Path getAbsolutePath(ArchivePath archivePath) {
        return this.archive.resolve(archivePath);
    }

    void awaitCompletion() throws InterruptedException {
        Thread.interrupted();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    public String toString() {
        return "Publisher [sourceNode=" + this.sourceNode + "]";
    }

    public static void main(String[] args) throws SecurityException, IOException {
        int status = 0;
        Path rootDir = null;
        int trackerPort = 38800;
        int serverPort = 0;
        int reportingPort = 0;
        try {
            String arg;
            int iarg;
            for (iarg = 0; iarg < args.length; ++iarg) {
                arg = args[iarg];
                try {
                    if (arg.charAt(0) != '-') break;
                    String optString = arg.substring(1);
                    arg = args[++iarg];
                    if (optString.equals("r")) {
                        try {
                            reportingPort = Integer.valueOf(arg);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error("Couldn't decode reporting-port argument: \"{}\": {}", (Object)arg, (Object)e.toString());
                            throw new IllegalArgumentException();
                        }
                    }
                    if (optString.equals("s")) {
                        try {
                            serverPort = Integer.valueOf(arg);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error("Couldn't decode server-port argument: \"{}\": {}", (Object)arg, (Object)e.toString());
                            throw new IllegalArgumentException();
                        }
                    }
                    if (optString.equals("t")) {
                        try {
                            trackerPort = Integer.valueOf(arg);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error("Couldn't decode tracker-port argument: \"{}\": {}", (Object)arg, (Object)e.toString());
                            throw new IllegalArgumentException();
                        }
                    }
                    logger.error("Invalid option: \"{}\"", (Object)optString);
                    throw new IllegalArgumentException();
                }
                catch (IndexOutOfBoundsException e) {
                    logger.error("Invalid argument: \"{}\"", (Object)arg);
                    throw new IllegalArgumentException();
                }
            }
            if (iarg >= args.length) {
                logger.error("The archive-directory argument is missing");
                throw new IllegalArgumentException();
            }
            arg = args[iarg];
            try {
                rootDir = Paths.get(arg, new String[0]);
            }
            catch (InvalidPathException e) {
                logger.error("Invalid pathname of root-directory: \"{}\"", (Object)arg);
                throw new IllegalArgumentException();
            }
            if (++iarg < args.length) {
                logger.error("Too many arguments");
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException e) {
            logger.info("Usage: ... [-r reportingPort] [-s serverPort] [-t trackerPort] rootDir\nwhere:\n    -r reportingPort   Port number on which the tracker will listen for\n                       UDP reports of unavailable data-exchange servers.\n                       If zero, then an ephemeral port will be chosen by\n                       the operating-system (which is the default).\n    -s serverPort      Port number on which the local data-exchange server\n                       will listen for connections. If zero, then an\n                       ephemeral port will be chosen by the operating-\n                       system (which is the default).\n    -t trackerPort     Port number on which the tracker will listen. If\n                       zero, then an ephemeral port will be chosen by the\n                       operating-system. The default is the IANA-assigned\n                       port, 38800.\n    rootDir            Pathname of the root of the data archive.\n");
            status = 1;
        }
        if (status == 0) {
            try {
                Publisher publisher = new Publisher(rootDir, trackerPort, serverPort, reportingPort);
                try {
                    System.out.println(publisher.getTrackerSocketAddress());
                    System.out.flush();
                    publisher.call();
                }
                catch (InterruptedException e) {
                    logger.info("Interrupted: " + publisher);
                    status = 3;
                }
            }
            catch (Exception e) {
                logger.error("Couldn't create publisher for archive \"" + rootDir + "\"", e);
                status = 2;
            }
        }
        System.exit(status);
    }
}

