/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.ArchivePathSet;
import edu.ucar.unidata.sruth.Peer;
import edu.ucar.unidata.sruth.RemovalNotice;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class RemovedFilesNotice
implements RemovalNotice {
    private static final long serialVersionUID = 1L;
    private final ArchivePathSet archivePaths;

    RemovedFilesNotice(ArchivePathSet archivePaths) {
        if (null == archivePaths) {
            throw new NullPointerException();
        }
        this.archivePaths = archivePaths;
    }

    @Override
    public void processYourself(Peer peer) throws IOException {
        for (ArchivePath archivePath : this.archivePaths) {
            peer.remove(archivePath);
        }
    }

    public String toString() {
        return "RemovedFilesNotice [archivePaths=" + this.archivePaths + "]";
    }
}

