/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.ArchivePath;
import edu.ucar.unidata.sruth.CancellingExecutor;
import edu.ucar.unidata.sruth.ClearingHouse;
import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.ConnectionFactory;
import edu.ucar.unidata.sruth.FilePieceSpecSet;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.InetSocketAddressSet;
import edu.ucar.unidata.sruth.Peer;
import edu.ucar.unidata.sruth.Predicate;
import edu.ucar.unidata.sruth.UninterruptibleTask;
import edu.ucar.unidata.sruth.Util;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
abstract class Server
extends UninterruptibleTask<Void> {
    private static final Logger logger = Util.getLogger();
    private static final int MAX_NUM_ACTIVE_SERVLETS;
    private static final String MAX_NUM_ACTIVE_SERVLETS_KEY = "maximum number of active servlets";
    private static final int MAX_NUM_ACTIVE_SERVLETS_DEFAULT = 8;
    private static final int MAX_NUM_PENDING_SERVLETS;
    private static final String MAX_NUM_PENDING_SERVLETS_KEY = "maximum number of pending servlets";
    private static final int MAX_NUM_PENDING_SERVLETS_DEFAULT = 8;
    private final ConnectionFactory connectionFactory;
    private final ServletManager servletManager;
    private final ServerSocket serverSocket;
    private final CountDownLatch isRunningLatch = new CountDownLatch(1);
    private final AtomicLong startTimeRef = new AtomicLong(System.currentTimeMillis());

    Server(ClearingHouse clearingHouse) throws IOException {
        this(clearingHouse, new InetSocketAddressSet());
    }

    Server(ClearingHouse clearingHouse, InetSocketAddressSet inetSockAddrSet) throws IOException, SocketException {
        this.serverSocket = new ServerSocket();
        try {
            this.adjustSocket(this.serverSocket);
            if (!inetSockAddrSet.bind(this.serverSocket)) {
                throw new IOException("Couldn't find unused port in " + inetSockAddrSet);
            }
            this.servletManager = new ServletManager(this.serverSocket, clearingHouse, MAX_NUM_PENDING_SERVLETS, MAX_NUM_ACTIVE_SERVLETS);
            this.connectionFactory = new ConnectionFactory((InetSocketAddress)this.serverSocket.getLocalSocketAddress());
        }
        catch (SocketException e) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw e;
        }
    }

    abstract void adjustSocket(ServerSocket var1) throws IOException;

    InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort());
    }

    InetSocketAddress getInetSocketAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws InterruptedException, IOException {
        logger.trace("Starting up: {}", this);
        String origThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.toString());
        this.startTimeRef.set(System.currentTimeMillis());
        this.isRunningLatch.countDown();
        block10: while (true) {
            try {
                try {
                    while (true) {
                        Socket socket = this.serverSocket.accept();
                        try {
                            Connection connection = this.connectionFactory.getInstance(socket);
                            if (connection == null) continue block10;
                            this.servletManager.submit(connection);
                            continue block10;
                        }
                        catch (IOException e) {
                            logger.error("Error on {}: {}", socket, (Object)e.toString());
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    if (!this.isCancelled()) {
                        throw e;
                    }
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.servletManager.shutdownNow();
                    this.servletManager.awaitCompletion();
                    Thread.currentThread().setName(origThreadName);
                    logger.trace("Done: {}", this);
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                this.servletManager.shutdownNow();
                this.servletManager.awaitCompletion();
                Thread.currentThread().setName(origThreadName);
                logger.trace("Done: {}", this);
                throw throwable;
            }
        }
        return null;
    }

    void waitUntilRunning() throws InterruptedException {
        this.isRunningLatch.await();
    }

    @Override
    protected void stop() {
        try {
            logger.debug("Closing {}", this.serverSocket);
            this.serverSocket.close();
        }
        catch (Error e) {
            logger.error("Error closing server-socket", e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void awaitCompletion() throws InterruptedException {
        Thread.interrupted();
        this.servletManager.awaitCompletion();
    }

    int getServletCount() {
        return this.servletManager.size();
    }

    void newData(FilePieceSpecSet spec) {
        logger.trace("New data: {}", spec);
        this.servletManager.newData(spec);
    }

    void removed(ArchivePath archivePath) {
        this.servletManager.removed(archivePath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [server socket=" + this.serverSocket + ", servlets=(" + this.servletManager.size() + "), incomplete connections=(" + this.connectionFactory.getNumIncomplete() + ")]";
    }

    static {
        Preferences prefs = Preferences.userNodeForPackage(Server.class);
        MAX_NUM_ACTIVE_SERVLETS = prefs.getInt(MAX_NUM_ACTIVE_SERVLETS_KEY, 8);
        if (MAX_NUM_ACTIVE_SERVLETS < 0) {
            throw new IllegalArgumentException("Invalid preference: \"maximum number of active servlets\"=" + MAX_NUM_ACTIVE_SERVLETS);
        }
        MAX_NUM_PENDING_SERVLETS = prefs.getInt(MAX_NUM_PENDING_SERVLETS_KEY, 8);
        if (MAX_NUM_PENDING_SERVLETS < 0) {
            throw new IllegalArgumentException("Invalid preference: \"maximum number of pending servlets\"=" + MAX_NUM_PENDING_SERVLETS);
        }
    }

    @ThreadSafe
    static final class ServletManager {
        private final ServerSocket serverSocket;
        private final ClearingHouse clearingHouse;
        private final CancellingExecutor servletExecutor;
        @GuardedBy(value="this")
        private final List<Servlet> servlets = new LinkedList<Servlet>();
        private final int maxNumActiveServlets;
        private final int maxNumPendingServlets;
        @GuardedBy(value="this")
        private int numPendingServlets;

        ServletManager(ServerSocket serverSocket, ClearingHouse clearingHouse, int maxNumPendingServlets, int maxNumActiveServlets) {
            if (serverSocket == null) {
                throw new NullPointerException();
            }
            if (clearingHouse == null) {
                throw new NullPointerException();
            }
            if (maxNumPendingServlets <= 0) {
                throw new IllegalArgumentException();
            }
            if (maxNumActiveServlets <= 0) {
                throw new IllegalArgumentException();
            }
            this.serverSocket = serverSocket;
            this.clearingHouse = clearingHouse;
            this.maxNumActiveServlets = maxNumActiveServlets;
            this.maxNumPendingServlets = maxNumPendingServlets;
            this.servletExecutor = new CancellingExecutor(0, maxNumActiveServlets + maxNumPendingServlets, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }

        synchronized void submit(Connection connection) {
            if (this.numPendingServlets >= this.maxNumPendingServlets) {
                logger.warn("Too many pending servlets ({}). Denied {}", this.numPendingServlets, (Object)connection);
                connection.close();
            } else {
                Servlet servlet = new Servlet(connection);
                this.servletExecutor.submit(servlet);
                ++this.numPendingServlets;
            }
        }

        void shutdownNow() {
            logger.trace("Shutting down {}", this);
            this.servletExecutor.shutdownNow();
        }

        void awaitCompletion() throws InterruptedException {
            Thread.interrupted();
            this.servletExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }

        synchronized void newData(FilePieceSpecSet spec) {
            logger.trace("New data: {}", spec);
            for (Servlet servlet : this.servlets) {
                servlet.newData(spec);
            }
        }

        synchronized void removed(ArchivePath archivePath) {
            for (Servlet servlet : this.servlets) {
                servlet.removed(archivePath);
            }
        }

        synchronized int size() {
            return this.servlets.size();
        }

        public synchronized String toString() {
            return "ServletManager [serverSocket=" + this.serverSocket + ", servlets=(" + this.size() + ")]";
        }

        @ThreadSafe
        private class Servlet
        extends UninterruptibleTask<Void> {
            private final Connection connection;
            private final AtomicReference<Filter> clientFilterRef = new AtomicReference();
            private final AtomicReference<Peer> peerRef = new AtomicReference();

            Servlet(Connection connection) {
                if (connection == null) {
                    throw new NullPointerException();
                }
                this.connection = connection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws InterruptedException, IOException {
                logger.trace("Starting up: {}", this);
                Predicate predicate = ServletManager.this.clearingHouse.getPredicate();
                try {
                    Connection.Stream requestStream = this.connection.getRequestStream();
                    Filter filter = (Filter)requestStream.receiveObject(Connection.SO_TIMEOUT);
                    this.clientFilterRef.set(filter);
                    try {
                        Filter serverFilter = predicate.getIncludingFilter(filter);
                        requestStream.send(serverFilter);
                        Peer peer = new Peer(ServletManager.this.clearingHouse, this.connection, serverFilter, filter);
                        this.peerRef.set(peer);
                        if (this.addIfAppropriate()) {
                            this.execute();
                        }
                    }
                    catch (IOException e) {
                        if (!this.isCancelled()) {
                            logger.error("Couldn't send server's filter on {}: {}", this.connection, (Object)e.toString());
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("Interrupt: {}", this);
                    throw e;
                }
                catch (Exception e) {
                    if (!this.isCancelled()) {
                        logger.trace("Couldn't receive client's filter on {}: {}", this.connection, (Object)e.toString());
                    }
                }
                finally {
                    this.connection.close();
                    logger.trace("Done: {}", this);
                }
                return null;
            }

            @Override
            protected void stop() {
                this.connection.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean addIfAppropriate() {
                boolean addInstance = false;
                ServletManager servletManager = ServletManager.this;
                synchronized (servletManager) {
                    if (ServletManager.this.servlets.size() < ServletManager.this.maxNumActiveServlets) {
                        addInstance = true;
                    } else {
                        for (Servlet that : ServletManager.this.servlets) {
                            if (!this.isBetterThan(that)) continue;
                            that.cancel();
                            addInstance = true;
                            break;
                        }
                    }
                    if (addInstance) {
                        ServletManager.this.servlets.add(this);
                        ServletManager.this.numPendingServlets--;
                    } else {
                        logger.debug("Not sufficiently better: {}", this);
                    }
                }
                return addInstance;
            }

            boolean isBetterThan(Servlet that) {
                Filter thatFilter;
                Filter thisFilter = this.clientFilterRef.get();
                return thisFilter.includes(thatFilter = that.clientFilterRef.get()) && !thisFilter.equals(thatFilter);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void execute() throws InterruptedException {
                Peer peer = this.peerRef.get();
                try {
                    peer.call();
                }
                catch (Exception e) {
                    if (!this.isCancelled()) {
                        if (e instanceof InterruptedException) {
                        } else if (e instanceof EOFException) {
                            logger.info("Connection closed by remote client: {}: {}", this.connection, (Object)e);
                        } else if (e instanceof ConnectException) {
                            logger.info("Couldn't connect to remote client: {}: {}", this.connection, (Object)e);
                        } else if (e instanceof SocketException) {
                            logger.info("Connection to remote client closed: {}: {}", this.connection, (Object)e);
                        } else if (e instanceof IOException) {
                            logger.error("Servlet I/O failure: " + this, e);
                        } else {
                            logger.error("Logic error", e);
                        }
                    }
                }
                finally {
                    ServletManager servletManager = ServletManager.this;
                    synchronized (servletManager) {
                        ServletManager.this.servlets.remove(this);
                    }
                }
            }

            void newData(FilePieceSpecSet spec) {
                logger.trace("New data: {}", spec);
                Peer peer = this.peerRef.get();
                if (peer != null) {
                    peer.newData(spec);
                }
            }

            void removed(ArchivePath archivePath) {
                Peer peer = this.peerRef.get();
                if (peer != null) {
                    peer.notifyRemoteOfRemovals(archivePath);
                }
            }

            public String toString() {
                return "Servlet [connection=" + this.connection + ", clientFilter=" + this.clientFilterRef.get() + "]";
            }
        }
    }
}

