/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.AbstractNode;
import edu.ucar.unidata.sruth.Archive;
import edu.ucar.unidata.sruth.CancellingExecutor;
import edu.ucar.unidata.sruth.ClearingHouse;
import edu.ucar.unidata.sruth.InetSocketAddressSet;
import edu.ucar.unidata.sruth.PortNumberSet;
import edu.ucar.unidata.sruth.Predicate;
import edu.ucar.unidata.sruth.PubFile;
import edu.ucar.unidata.sruth.Server;
import edu.ucar.unidata.sruth.SourceServer;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class SourceNode
extends AbstractNode {
    private static final Logger logger = Util.getLogger();
    private final CompletionService<Void> completionService;
    private final ArchiveWatcher archiveWatcher;

    SourceNode(Archive archive) throws IOException {
        this(archive, new InetSocketAddressSet());
    }

    SourceNode(Archive archive, int serverPort) throws IOException {
        this(archive, new InetSocketAddressSet(PortNumberSet.getInstance(serverPort, serverPort)));
    }

    SourceNode(Archive archive, InetSocketAddress serverSocketAddress) throws UnknownHostException, IOException {
        this(archive, new InetSocketAddressSet(serverSocketAddress.getAddress(), PortNumberSet.getInstance(serverSocketAddress.getPort(), serverSocketAddress.getPort())));
    }

    SourceNode(Archive archive, InetSocketAddressSet inetSockAddrSet) throws IOException {
        super(archive, Predicate.NOTHING, inetSockAddrSet, new CancellingExecutor(2, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()));
        this.completionService = new ExecutorCompletionService<Void>(this.executorService);
        this.archiveWatcher = new ArchiveWatcher();
    }

    @Override
    Server createServer(ClearingHouse clearingHouse, InetSocketAddressSet inetSockAddrSet) throws SocketException, IOException {
        return new SourceServer(clearingHouse, inetSockAddrSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws InterruptedException, IOException {
        block7: {
            logger.trace("Starting up: {}", this);
            String origThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.toString());
            try {
                Future<Void> serverFuture = this.completionService.submit(this.localServer);
                this.completionService.submit(this.archiveWatcher);
                Future<Void> future = this.completionService.take();
                if (future.isCancelled()) break block7;
                Callable<Void> task = future == serverFuture ? this.localServer : this.archiveWatcher;
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof InterruptedException) {
                        logger.trace("Interrupted: {}", task);
                        throw (InterruptedException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw new IOException("IO Error: " + task, cause);
                    }
                    throw new RuntimeException("Unexpected error: " + task, cause);
                }
            }
            finally {
                this.executorService.shutdownNow();
                this.awaitCompletion();
                Thread.currentThread().setName(origThreadName);
                logger.trace("Done: {}", this);
            }
        }
        return null;
    }

    void waitUntilRunning() throws InterruptedException {
        this.localServer.waitUntilRunning();
        this.archiveWatcher.waitUntilRunning();
    }

    SeekableByteChannel newBytechannel(Path path) throws IOException {
        path = this.getArchive().getHiddenPath(path);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        return channel;
    }

    PubFile newPubFile(Path path) throws IOException {
        return new PubFile(this.getArchive(), path);
    }

    @Override
    int getClientCount() {
        return 0;
    }

    public String toString() {
        return "SourceNode [archive=" + this.getArchive() + "]";
    }

    private final class ArchiveWatcher
    implements Callable<Void> {
        private final CountDownLatch isRunningLatch = new CountDownLatch(1);

        private ArchiveWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws InterruptedException, IOException {
            logger.trace("Starting up: {}", (Object)this.toString());
            String origThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.toString());
            try {
                this.isRunningLatch.countDown();
                SourceNode.this.getArchive().watchArchive(SourceNode.this.localServer);
                Void void_ = null;
                return void_;
            }
            finally {
                Thread.currentThread().setName(origThreadName);
                logger.trace("Done: {}", (Object)this.toString());
            }
        }

        void waitUntilRunning() throws InterruptedException {
            this.isRunningLatch.await();
        }

        public String toString() {
            return "ArchiveWatcher [rootDir=" + SourceNode.this.clearingHouse.getRootDir() + "]";
        }
    }
}

