/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class Subscription {
    private final InetSocketAddress trackerAddress;
    private final Predicate predicate;

    Subscription(InetSocketAddress trackerAddress, Predicate predicate) {
        if (null == trackerAddress) {
            throw new NullPointerException();
        }
        if (null == predicate) {
            throw new NullPointerException();
        }
        this.trackerAddress = trackerAddress;
        this.predicate = predicate;
    }

    Subscription(InputStream input) throws IOException {
        InetAddress inetAddress;
        Document doc;
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        try {
            doc = docBuilder.parse(input);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        Element docElt = doc.getDocumentElement();
        NodeList nodeList = docElt.getElementsByTagName("tracker");
        if (nodeList.getLength() != 1) {
            throw new IllegalArgumentException("nodeList.getLength() = " + nodeList.getLength());
        }
        Element elt = (Element)nodeList.item(0);
        String attrString = elt.getAttribute("host");
        try {
            inetAddress = InetAddress.getByName(attrString);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown host: \"" + attrString + "\"");
        }
        int port = 38800;
        attrString = elt.getAttribute("port");
        if (!attrString.isEmpty()) {
            try {
                port = Integer.valueOf(attrString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid port: \"" + attrString + "\"");
            }
        }
        this.trackerAddress = new InetSocketAddress(inetAddress, port);
        nodeList = docElt.getElementsByTagName("predicate");
        if (nodeList.getLength() != 1) {
            throw new IllegalArgumentException("nodeList.getLength() = " + nodeList.getLength());
        }
        elt = (Element)nodeList.item(0);
        String type = elt.getAttribute("type");
        if (type.equalsIgnoreCase("everything")) {
            this.predicate = Predicate.EVERYTHING;
        } else if (type.equalsIgnoreCase("nothing")) {
            this.predicate = Predicate.NOTHING;
        } else {
            throw new IllegalArgumentException("Unknown predicate: \"" + type + "\"");
        }
    }

    InetSocketAddress getTrackerAddress() {
        return this.trackerAddress;
    }

    Predicate getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return "Subscription [predicate=" + this.predicate + ", trackerAddress=" + this.trackerAddress + "]";
    }
}

