/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.AddressComparator;
import edu.ucar.unidata.sruth.Filter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class Topology
implements Serializable {
    private static final long serialVersionUID = 1L;
    @GuardedBy(value="this")
    private final NavigableMap<Filter, Set<InetSocketAddress>> serverSets = new TreeMap<Filter, Set<InetSocketAddress>>();
    @GuardedBy(value="this")
    private final Map<InetSocketAddress, Set<Filter>> filterSets = new HashMap<InetSocketAddress, Set<Filter>>();
    @GuardedBy(value="this")
    private final transient Random random = new Random();

    Topology(Set<Filter> filters) {
        for (Filter filter : filters) {
            Set<InetSocketAddress> servers = this.newServerSet();
            this.serverSets.put(filter, servers);
        }
    }

    Topology() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Topology(Topology that) {
        Topology o2;
        Topology o1;
        if (System.identityHashCode(this) < System.identityHashCode(that)) {
            o1 = this;
            o2 = that;
        } else {
            o1 = that;
            o2 = this;
        }
        Topology topology = o1;
        synchronized (topology) {
            Topology topology2 = o2;
            synchronized (topology2) {
                for (Map.Entry<InetSocketAddress, Set<Filter>> entry : that.filterSets.entrySet()) {
                    this.add(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    synchronized Set<InetSocketAddress> getServers(Filter filter) {
        Set<InetSocketAddress> nodes = this.newServerSet();
        for (Map.Entry entry : this.serverSets.entrySet()) {
            if (!((Filter)entry.getKey()).includes(filter)) continue;
            nodes.addAll((Collection)entry.getValue());
        }
        return nodes;
    }

    synchronized void add(Filter filter, InetSocketAddress server) {
        Set<InetSocketAddress> servers = (Set<InetSocketAddress>)this.serverSets.get(filter);
        if (null == servers) {
            servers = this.newServerSet();
            this.serverSets.put(filter, servers);
        }
        servers.add(server);
        Set<Filter> filters = this.filterSets.get(server);
        if (filters == null) {
            filters = this.newFilterSet();
            this.filterSets.put(server, filters);
        }
        filters.add(filter);
    }

    synchronized void add(Filter filter, Set<InetSocketAddress> servers) {
        Set<InetSocketAddress> serverInfos = (Set<InetSocketAddress>)this.serverSets.get(filter);
        if (null == serverInfos) {
            serverInfos = this.newServerSet();
            this.serverSets.put(filter, serverInfos);
        }
        serverInfos.addAll(servers);
        for (InetSocketAddress server : servers) {
            Set<Filter> filters = this.filterSets.get(server);
            if (filters == null) {
                filters = this.newFilterSet();
                this.filterSets.put(server, filters);
            }
            filters.add(filter);
        }
    }

    private synchronized void add(InetSocketAddress server, Set<Filter> filters) {
        Set<Filter> entryFilters = this.filterSets.get(server);
        if (entryFilters == null) {
            entryFilters = this.newFilterSet();
            this.filterSets.put(server, entryFilters);
        }
        entryFilters.addAll(filters);
        for (Filter filter : filters) {
            Set<InetSocketAddress> entryServers = (Set<InetSocketAddress>)this.serverSets.get(filter);
            if (entryServers == null) {
                entryServers = this.newServerSet();
                this.serverSets.put(filter, entryServers);
            }
            entryServers.add(server);
        }
    }

    synchronized Set<InetSocketAddress> getServers() {
        Set<InetSocketAddress> servers = this.newServerSet();
        servers.addAll(this.filterSets.keySet());
        return servers;
    }

    synchronized Topology subset(Filter filter) {
        Set<InetSocketAddress> servers = this.getServers(filter);
        Topology subset = new Topology();
        for (InetSocketAddress server : servers) {
            Set<Filter> filters = this.filterSets.get(server);
            for (Filter filt : filters) {
                if (!filt.includes(filter)) continue;
                subset.add(filt, server);
            }
        }
        return subset;
    }

    synchronized void remove(InetSocketAddress server) {
        Set<Filter> filters = this.filterSets.remove(server);
        if (filters != null) {
            for (Filter filter : filters) {
                Set servers = (Set)this.serverSets.get(filter);
                if (servers == null) continue;
                servers.remove(server);
                if (!servers.isEmpty()) continue;
                this.serverSets.remove(filter);
            }
        }
    }

    synchronized void remove(Set<InetSocketAddress> servers) {
        for (InetSocketAddress server : servers) {
            this.remove(server);
        }
    }

    synchronized InetSocketAddress getBestServer(Filter filter) {
        Set<InetSocketAddress> servers = this.getServers(filter);
        Filter targetFilter = Filter.EVERYTHING;
        Set<InetSocketAddress> candidates = this.newServerSet();
        block0: for (InetSocketAddress server : servers) {
            Set<Filter> filters = this.filterSets.get(server);
            if (filters == null) continue;
            for (Filter f : filters) {
                if (!f.includes(filter) || !targetFilter.includes(f)) continue;
                if (!targetFilter.equals(f)) {
                    candidates.clear();
                    targetFilter = f;
                }
                candidates.add(server);
                continue block0;
            }
        }
        int size = candidates.size();
        if (size == 0) {
            return null;
        }
        int i = this.random.nextInt(size);
        Iterator<InetSocketAddress> iter = candidates.iterator();
        while (i-- > 0) {
            iter.next();
        }
        return iter.next();
    }

    private Set<InetSocketAddress> newServerSet() {
        return new TreeSet<InetSocketAddress>(AddressComparator.INSTANCE);
    }

    private Set<Filter> newFilterSet() {
        return new TreeSet<Filter>();
    }

    synchronized int getServerCount(Filter filter) {
        return ((Set)this.serverSets.get(filter)).size();
    }

    synchronized Filter getLeastFilter() {
        Filter filter = null;
        int n = Integer.MAX_VALUE;
        for (Map.Entry entry : this.serverSets.entrySet()) {
            int s = ((Set)entry.getValue()).size();
            if (s >= n) continue;
            filter = (Filter)entry.getKey();
            n = s;
        }
        return filter;
    }

    synchronized int getLeastFilterCount() {
        int n = Integer.MAX_VALUE;
        for (Map.Entry entry : this.serverSets.entrySet()) {
            int s = ((Set)entry.getValue()).size();
            if (s >= n) continue;
            n = s;
        }
        return n == Integer.MAX_VALUE ? 0 : n;
    }

    synchronized void clear() {
        this.serverSets.clear();
        this.filterSets.clear();
    }

    synchronized boolean isEmpty() {
        return this.serverSets.isEmpty() && this.filterSets.isEmpty();
    }

    public synchronized String toString() {
        return "Topology [serverSets=" + this.serverSets + ", filterSets=" + this.filterSets + "]";
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private Object readResolve() {
        Topology instance = new Topology();
        for (Map.Entry entry : this.serverSets.entrySet()) {
            instance.add((Filter)entry.getKey(), (Set)entry.getValue());
        }
        return instance;
    }
}

