/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.InvalidMessageException;
import edu.ucar.unidata.sruth.Topology;
import edu.ucar.unidata.sruth.Tracker;
import edu.ucar.unidata.sruth.TrackerProxy;
import edu.ucar.unidata.sruth.TrackerTask;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class TopologyGetter
extends TrackerTask {
    private static final long serialVersionUID = 1L;
    private final InetSocketAddress localServer;
    private final Filter filter;

    TopologyGetter(Filter filter, InetSocketAddress localServer, Socket socket) throws SocketException {
        super(socket);
        if (filter == null) {
            throw new NullPointerException();
        }
        if (localServer == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
        this.localServer = localServer;
    }

    static void execute(Filter filter, InetSocketAddress localServer, Socket socket, TrackerProxy trackerProxy) throws InvalidMessageException, IOException {
        TopologyGetter topologyGetter = new TopologyGetter(filter, localServer, socket);
        topologyGetter.getTopologyAndRegister(trackerProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopologyAndRegister(TrackerProxy trackerProxy) throws InvalidMessageException, IOException {
        try {
            this.callTracker();
            this.processResponse(trackerProxy);
        }
        finally {
            this.close();
        }
    }

    private void processResponse(TrackerProxy trackerProxy) throws InvalidMessageException, IOException {
        ObjectInputStream ois = new ObjectInputStream(this.trackerSocket.getInputStream());
        try {
            Topology topology = (Topology)ois.readObject();
            trackerProxy.setRawTopology(topology);
            InetSocketAddress reportingAddress = (InetSocketAddress)ois.readObject();
            trackerProxy.setReportingAddress(reportingAddress);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidMessageException("Couldn't get topology: " + this, e);
        }
    }

    @Override
    public void process(Tracker tracker, Socket socket) throws IOException {
        OutputStream outputStream = socket.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        Topology network = tracker.getNetwork();
        oos.writeObject(network);
        oos.writeObject(tracker.getReportingAddress());
        oos.flush();
        tracker.register(this.localServer, this.filter);
    }

    public String toString() {
        return "FilteredProxy [filter=" + this.filter + ",localServer=" + this.localServer + "]";
    }

    private Object readResolve() throws ObjectStreamException, SocketException {
        try {
            return new TopologyGetter(this.filter, this.localServer, null);
        }
        catch (NullPointerException e) {
            throw (InvalidObjectException)new InvalidObjectException(this.toString()).initCause(e);
        }
    }
}

