/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.CancellingExecutor;
import edu.ucar.unidata.sruth.ConnectionToServer;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.Topology;
import edu.ucar.unidata.sruth.TrackerTask;
import edu.ucar.unidata.sruth.UninterruptibleTask;
import edu.ucar.unidata.sruth.Util;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class Tracker
implements Callable<Void> {
    private static final int MAX_NUM_SERVER_CHECKER_THREADS;
    private static final String MAX_NUM_SERVER_CHECKER_THREADS_KEY = "maximum number of server-checker threads";
    private static final int MAX_NUM_SERVER_CHECKER_THREADS_DEFAULT = 16;
    private static final long SERVER_CHECKER_KEEPALIVE;
    private static final String SERVER_CHECKER_KEEPALIVE_KEY = "server-checker thread keepalive-time in seconds";
    private static final long SERVER_CHECKER_KEEPALIVE_DEFAULT = 60L;
    private static final Logger logger;
    private static final String NETWORK_TOPOLOGY_PROPERTY_NAME = "Network Topology";
    private final CancellingExecutor executor = new CancellingExecutor(2, 2, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final ServerSocket trackerSocket;
    @GuardedBy(value="this")
    private final Topology topology = new Topology();
    private final InetSocketAddress sourceServer;
    private final PropertyChangeSupport propertySupport;
    private final CountDownLatch isRunningLatch = new CountDownLatch(1);
    private final ServerCheckerTask serverCheckerTask;
    public static final int IANA_PORT = 38800;

    Tracker(InetSocketAddress sourceServer) throws UnknownHostException, IOException {
        this(sourceServer, new InetSocketAddress(InetAddress.getLocalHost(), 38800));
    }

    Tracker(InetSocketAddress sourceServer, InetSocketAddress trackerSocketAddress) throws BindException, SocketException, IOException {
        if (sourceServer == null) {
            throw new NullPointerException();
        }
        if (trackerSocketAddress == null) {
            throw new NullPointerException();
        }
        this.trackerSocket = new ServerSocket();
        try {
            this.trackerSocket.setReuseAddress(true);
            this.trackerSocket.bind(trackerSocketAddress);
            this.topology.add(Filter.EVERYTHING, sourceServer);
            this.sourceServer = sourceServer;
            this.propertySupport = new PropertyChangeSupport(this);
            this.serverCheckerTask = new ServerCheckerTask();
            return;
        }
        catch (IOException e) {
            try {
                this.trackerSocket.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new IOException("Couldn't bind tracker socket to " + trackerSocketAddress + ": " + e.toString());
        }
    }

    InetSocketAddress getServerAddress() {
        return new InetSocketAddress(this.trackerSocket.getInetAddress(), this.trackerSocket.getLocalPort());
    }

    InetSocketAddress getReportingAddress() {
        return this.serverCheckerTask.getInetSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws InterruptedException, IOException {
        block13: {
            logger.trace("Starting up: {}", this);
            String origThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.toString());
            try {
                ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.executor);
                Future<Void> checkerFuture = completionService.submit(this.serverCheckerTask);
                try {
                    Accepter accepterTask = new Accepter();
                    completionService.submit(accepterTask);
                    this.isRunningLatch.countDown();
                    Future future = completionService.take();
                    if (future.isCancelled()) break block13;
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        UninterruptibleTask task;
                        Throwable cause = e.getCause();
                        UninterruptibleTask uninterruptibleTask = task = future == checkerFuture ? this.serverCheckerTask : accepterTask;
                        if (cause instanceof IOException) {
                            throw new IOException("I/O error: " + task, cause);
                        }
                        throw new RuntimeException("Unexpected error: " + task, cause);
                    }
                }
                finally {
                    block14: {
                        this.executor.shutdownNow();
                        this.awaitCompletion();
                        try {
                            this.trackerSocket.close();
                        }
                        catch (IOException e) {
                            if (this.trackerSocket.isClosed()) break block14;
                            logger.error("Couldn't close tracker's server-socket", e);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setName(origThreadName);
                logger.trace("Done: {}", this);
            }
        }
        return null;
    }

    void waitUntilRunning() throws InterruptedException {
        this.isRunningLatch.await();
    }

    void awaitCompletion() throws InterruptedException {
        Thread.interrupted();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    void register(InetSocketAddress server, Filter filter) throws IOException {
        this.topology.add(filter, server);
        this.propertySupport.firePropertyChange(NETWORK_TOPOLOGY_PROPERTY_NAME, null, new Topology(this.topology));
    }

    void addNetworkTopologyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(NETWORK_TOPOLOGY_PROPERTY_NAME, listener);
    }

    void removeNetworkTopologyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(NETWORK_TOPOLOGY_PROPERTY_NAME, listener);
    }

    Topology getNetwork() {
        return this.topology;
    }

    Topology getNetwork(Filter filter) {
        return this.topology.subset(filter);
    }

    SocketAddress getSocketAddress() {
        return this.trackerSocket.getLocalSocketAddress();
    }

    public String toString() {
        return "Tracker [trackerSocket=" + this.trackerSocket + ", sourceServer=" + this.sourceServer + "]";
    }

    static /* synthetic */ int access$300() {
        return MAX_NUM_SERVER_CHECKER_THREADS;
    }

    static /* synthetic */ long access$400() {
        return SERVER_CHECKER_KEEPALIVE;
    }

    static {
        Preferences prefs = Preferences.userNodeForPackage(Tracker.class);
        MAX_NUM_SERVER_CHECKER_THREADS = prefs.getInt(MAX_NUM_SERVER_CHECKER_THREADS_KEY, 16);
        if (MAX_NUM_SERVER_CHECKER_THREADS <= 0) {
            throw new IllegalArgumentException("Invalid user preference: \"maximum number of server-checker threads\"=" + MAX_NUM_SERVER_CHECKER_THREADS);
        }
        SERVER_CHECKER_KEEPALIVE = prefs.getLong(SERVER_CHECKER_KEEPALIVE_KEY, 60L);
        if (SERVER_CHECKER_KEEPALIVE < 0L) {
            throw new IllegalArgumentException("Invalid user preference: \"server-checker thread keepalive-time in seconds\"=" + SERVER_CHECKER_KEEPALIVE);
        }
        logger = Util.getLogger();
    }

    @NotThreadSafe
    class Trackerlet
    extends UninterruptibleTask<Void> {
        private final Socket socket;

        Trackerlet(Socket socket) {
            if (null == socket) {
                throw new NullPointerException();
            }
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            String origThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.toString());
            try {
                this.socket.setSoLinger(false, 0);
                this.socket.setTcpNoDelay(false);
                this.socket.setKeepAlive(true);
                InputStream inputStream = this.socket.getInputStream();
                ObjectInputStream ois = new ObjectInputStream(inputStream);
                try {
                    TrackerTask trackerTask = (TrackerTask)ois.readObject();
                    try {
                        trackerTask.process(Tracker.this, this.socket);
                    }
                    catch (IOException e) {
                        if (!this.isCancelled()) {
                            logger.error("Couldn't process client request: " + trackerTask, e);
                        }
                    }
                }
                finally {
                    try {
                        ois.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (IOException e) {
                if (!this.isCancelled()) {
                    logger.error("I/O error on {}: {}", this.socket, (Object)e.toString());
                }
            }
            catch (Throwable t) {
                logger.error("Unexpected error on {}: {}", this.socket, (Object)t.toString());
            }
            finally {
                Thread.currentThread().setName(origThreadName);
                try {
                    this.socket.close();
                }
                catch (IOException ignored) {}
            }
            return null;
        }

        @Override
        protected void stop() {
            block2: {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (this.isCancelled()) break block2;
                    logger.error("Couldn't close trackerlet's server-socket", e);
                }
            }
        }

        public String toString() {
            return "Trackerlet [socket=" + this.socket + "]";
        }
    }

    private final class Accepter
    extends UninterruptibleTask<Void> {
        private final CancellingExecutor trackerletExecutor = new CancellingExecutor(0, 25, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

        private Accepter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws InterruptedException, IOException {
            logger.trace("Starting up: {}", this);
            try {
                Thread.currentThread().setName("Tracker-accepter");
                while (!this.trackerletExecutor.isShutdown()) {
                    Socket socket = Tracker.this.trackerSocket.accept();
                    Trackerlet trackerlet = new Trackerlet(socket);
                    try {
                        this.trackerletExecutor.submit(trackerlet);
                    }
                    catch (Throwable e) {
                        try {
                            socket.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        if (this.trackerletExecutor.isShutdown()) continue;
                        throw new RuntimeException("Unexpected error", e);
                        return null;
                    }
                }
            }
            finally {
                this.trackerletExecutor.shutdownNow();
                Thread.interrupted();
                this.trackerletExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                logger.trace("Done: {}", this);
            }
        }

        @Override
        protected void stop() {
            block2: {
                this.trackerletExecutor.shutdownNow();
                try {
                    Tracker.this.trackerSocket.close();
                }
                catch (IOException e) {
                    if (Tracker.this.trackerSocket.isClosed()) break block2;
                    logger.error("Couldn't close tracker's server-socket", e);
                }
            }
        }

        public String toString() {
            return "Accepter []";
        }
    }

    private class ServerCheckerTask
    extends UninterruptibleTask<Void> {
        private final CancellingExecutor executor = new CancellingExecutor(0, Tracker.access$300(), Tracker.access$400(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        private final DatagramSocket socket;

        ServerCheckerTask() throws SocketException {
            InetSocketAddress reportingAddress = new InetSocketAddress(Tracker.this.getServerAddress().getAddress(), 0);
            this.socket = new DatagramSocket(reportingAddress);
        }

        InetSocketAddress getInetSocketAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws IOException {
            logger.trace("Starting up: {}", this);
            String origThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.toString());
            byte[] packetBuf = new byte[2048];
            DatagramPacket packet = new DatagramPacket(packetBuf, packetBuf.length);
            block12: while (true) {
                try {
                    try {
                        while (true) {
                            packet.setData(packetBuf);
                            this.socket.receive(packet);
                            int length = packet.getLength();
                            if (length > packetBuf.length) {
                                logger.error("Incoming datagram from " + packet.getAddress() + " overan buffer: " + length + " > " + packetBuf.length);
                                continue;
                            }
                            try {
                                InetSocketAddress serverAddress = (InetSocketAddress)Util.deserialize(packetBuf, 0, length);
                                logger.debug("Server reported offline: {}", serverAddress);
                                ServerChecker serverChecker = new ServerChecker(serverAddress);
                                try {
                                    this.executor.submit(serverChecker);
                                }
                                catch (RejectedExecutionException e) {
                                    logger.debug("Couldn't submit server-checker: {}: {}", serverAddress, (Object)e.toString());
                                }
                                continue block12;
                            }
                            catch (Exception e) {
                                logger.warn("Invalid datagram from {}: {}", packet.getSocketAddress(), (Object)e.toString());
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        if (!this.isCancelled()) {
                            throw e;
                        }
                        try {
                            this.socket.close();
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        Thread.currentThread().setName(origThreadName);
                        logger.trace("Done: {}", this);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    Thread.currentThread().setName(origThreadName);
                    logger.trace("Done: {}", this);
                    throw throwable;
                }
            }
            return null;
        }

        @Override
        protected void stop() {
            this.socket.close();
        }

        public String toString() {
            return "ServerCheckerTask []";
        }

        private class ServerChecker
        extends UninterruptibleTask<Void> {
            private final InetSocketAddress serverAddress;
            @GuardedBy(value="this")
            private final ConnectionToServer connection;

            ServerChecker(InetSocketAddress serverAddress) {
                if (serverAddress == null) {
                    throw new NullPointerException();
                }
                this.serverAddress = serverAddress;
                this.connection = new ConnectionToServer(Tracker.this.sourceServer, serverAddress);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                logger.trace("Starting up: {}", this);
                String origThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName("Server-checker");
                try {
                    this.connection.open();
                    logger.debug("Connection to server succeeded: {}", this.serverAddress);
                    this.connection.close();
                }
                catch (IOException e) {
                    Tracker.this.topology.remove(this.serverAddress);
                    logger.debug("Removed server: {}", this.serverAddress);
                }
                finally {
                    Thread.currentThread().setName(origThreadName);
                    logger.trace("Done: {}", this);
                }
                return null;
            }

            @Override
            protected void stop() {
                this.connection.close();
            }

            public String toString() {
                return "ServerChecker [serverAddress=" + this.serverAddress + "]";
            }
        }
    }
}

