/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Archive;
import edu.ucar.unidata.sruth.ClientManager;
import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.Filter;
import edu.ucar.unidata.sruth.InvalidMessageException;
import edu.ucar.unidata.sruth.Topology;
import edu.ucar.unidata.sruth.TopologyGetter;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.NoSuchFileException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class TrackerProxy {
    private static Logger logger = Util.getLogger();
    private final InetSocketAddress trackerAddress;
    @GuardedBy(value="this")
    private boolean isClosed;
    @GuardedBy(value="this")
    public int currentVersion;
    @GuardedBy(value="this")
    private Topology rawTopology;
    private final DatagramSocket datagramSocket;
    private final DatagramPacket packet;
    private final Archive.DistributedTrackerFiles distributedTrackerFiles;
    private InetSocketAddress reportingAddress;
    @GuardedBy(value="this")
    private final Set<ClientManager> clientManagers = new TreeSet<ClientManager>(new Comparator<ClientManager>(){

        @Override
        public int compare(ClientManager o1, ClientManager o2) {
            return o1.getFilter().compareTo(o2.getFilter());
        }
    });

    TrackerProxy(InetSocketAddress trackerAddress, InetSocketAddress localServer, Archive.DistributedTrackerFiles distributedTrackerFiles) throws IOException {
        if (null == trackerAddress) {
            throw new NullPointerException();
        }
        if (null == distributedTrackerFiles) {
            throw new NullPointerException();
        }
        this.trackerAddress = trackerAddress;
        this.distributedTrackerFiles = distributedTrackerFiles;
        this.datagramSocket = new DatagramSocket();
        this.packet = new DatagramPacket(new byte[1], 1);
    }

    InetSocketAddress getAddress() {
        return this.trackerAddress;
    }

    synchronized void register(ClientManager clientManager) {
        this.clientManagers.add(clientManager);
    }

    synchronized void deregister(ClientManager clientManager) {
        this.clientManagers.remove(clientManager);
    }

    FilteredProxy getFilteredProxy(ClientManager clientManager) {
        return new FilteredProxy(clientManager);
    }

    synchronized Topology getTopology() {
        return this.rawTopology;
    }

    private synchronized Topology getTopology(Filter filter, InetSocketAddress localServer, Socket socket) throws IOException {
        if (localServer == null) {
            throw new NullPointerException();
        }
        if (this.isClosed) {
            throw new IllegalStateException("Closed: " + this);
        }
        if (this.rawTopology == null || !this.topologyIsBeingReceived()) {
            if (!this.setTopologyFromTracker(filter, localServer, socket)) {
                this.setTopologyFromFile();
                logger.warn("Using stale network topology file {}; last modified {}", this.distributedTrackerFiles.getTopologyArchivePath(), (Object)this.distributedTrackerFiles.getTopologyArchiveTime());
            }
        } else {
            try {
                this.setTopologyFromFile();
            }
            catch (NoSuchFileException e) {
                logger.info("Network topology file, {}, doesn't exist", this.distributedTrackerFiles.getTopologyArchivePath());
            }
        }
        return this.rawTopology;
    }

    private synchronized boolean topologyIsBeingReceived() {
        for (ClientManager manager : this.clientManagers) {
            if (manager.getClientCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean setTopologyFromTracker(Filter filter, InetSocketAddress localServer, Socket socket) {
        try {
            socket.connect(this.trackerAddress, Connection.SO_TIMEOUT);
            TopologyGetter.execute(filter, localServer, socket, this);
            return true;
        }
        catch (Exception e) {
            logger.warn("Couldn't set network topology from tracker: {}: {}", this.trackerAddress, (Object)e);
            return false;
        }
    }

    synchronized void setRawTopology(Topology topology) {
        this.rawTopology = topology;
    }

    synchronized void setReportingAddress(InetSocketAddress reportingAddress) {
        if (reportingAddress == null) {
            throw new NullPointerException();
        }
        this.reportingAddress = reportingAddress;
    }

    private synchronized void setTopologyFromFile() throws IOException {
        Topology currFilterServerMap = this.distributedTrackerFiles.getTopology();
        if (currFilterServerMap != this.rawTopology) {
            this.rawTopology = currFilterServerMap;
        }
    }

    synchronized void reportOffline(InetSocketAddress serverAddress) throws IOException {
        logger.debug("Reporting offline server {} to {}", serverAddress, (Object)this.reportingAddress);
        this.datagramSocket.connect(this.reportingAddress);
        byte[] buf = Util.serialize(serverAddress);
        this.packet.setData(buf);
        this.packet.setSocketAddress(this.reportingAddress);
        this.datagramSocket.send(this.packet);
    }

    synchronized void close() {
        this.isClosed = true;
    }

    public String toString() {
        return "TrackerProxy [trackerAddress=" + this.trackerAddress + "]";
    }

    class FilteredProxy {
        private final Filter filter;
        private final InetSocketAddress localServer;
        private final ClientManager clientManager;
        @GuardedBy(value="this")
        private Topology rawTopology;
        @GuardedBy(value="TrackerProxy.this")
        private Topology filteredTopology;
        @GuardedBy(value="this")
        private Socket socket;
        @GuardedBy(value="this")
        private boolean deregistered;

        FilteredProxy(ClientManager clientManager) {
            this.filter = clientManager.getFilter();
            this.localServer = clientManager.getLocalServerAddress();
            this.clientManager = clientManager;
            TrackerProxy.this.register(clientManager);
        }

        private synchronized void openSocket() {
            if (this.socket == null) {
                this.socket = new Socket();
            }
        }

        private synchronized void closeSocket() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register() throws SocketTimeoutException, ConnectException, SocketException, IOException, InvalidMessageException {
            FilteredProxy filteredProxy = this;
            synchronized (filteredProxy) {
                if (this.deregistered) {
                    throw new IllegalStateException();
                }
                this.openSocket();
            }
            try {
                this.socket.connect(TrackerProxy.this.trackerAddress, Connection.SO_TIMEOUT);
                TopologyGetter.execute(this.filter, this.localServer, this.socket, TrackerProxy.this);
                this.setTopology(TrackerProxy.this.getTopology());
                TrackerProxy.this.register(this.clientManager);
            }
            finally {
                this.closeSocket();
            }
        }

        synchronized void deregister() {
            if (!this.deregistered) {
                TrackerProxy.this.deregister(this.clientManager);
                this.closeSocket();
                this.deregistered = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Topology getTopology() throws IOException {
            this.openSocket();
            try {
                Topology latestTopology = TrackerProxy.this.getTopology(this.filter, this.localServer, this.socket);
                FilteredProxy filteredProxy = this;
                synchronized (filteredProxy) {
                    if (this.rawTopology != latestTopology) {
                        this.setTopology(latestTopology);
                    }
                    Topology topology = this.filteredTopology;
                    return topology;
                }
            }
            finally {
                this.closeSocket();
            }
        }

        private synchronized void setTopology(Topology rawTopology) {
            this.filteredTopology = rawTopology.subset(this.filter);
            this.rawTopology = rawTopology;
        }
    }
}

