/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Connection;
import edu.ucar.unidata.sruth.Tracker;
import edu.ucar.unidata.sruth.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;

abstract class TrackerTask
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = Util.getLogger();
    protected final transient Socket trackerSocket;

    protected TrackerTask(Socket trackerSocket) throws SocketException {
        if (trackerSocket != null) {
            trackerSocket.setSoTimeout(Connection.SO_TIMEOUT);
            trackerSocket.setKeepAlive(true);
            trackerSocket.setSoLinger(false, 0);
            trackerSocket.setTcpNoDelay(false);
        }
        this.trackerSocket = trackerSocket;
    }

    protected final void callTracker() throws IOException {
        OutputStream outputStream = this.trackerSocket.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(this);
        oos.flush();
    }

    abstract void process(Tracker var1, Socket var2) throws IOException;

    protected void close() {
        try {
            this.trackerSocket.close();
        }
        catch (IOException e) {
            logger.error("Couldn't close socket to tracker: {}", (Object)e.toString());
        }
    }
}

