/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.Decoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Util {
    private static final Logger logger;
    static final String PACKAGE_NAME;

    Util() {
    }

    static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Unhandled checked exception", t);
    }

    static String getCommand(List<String> command) {
        return Util.formatCommand(command.toArray(new String[command.size()]));
    }

    static String formatCommand(String[] command) {
        StringBuilder builder = new StringBuilder();
        for (String arg : command) {
            builder.append(arg.replace(" ", "\\ "));
            builder.append(" ");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    static InputStream openUrlOrFile(String spec) throws IOException {
        InputStream input = null;
        try {
            URL url = new URL(spec);
            input = url.openStream();
        }
        catch (MalformedURLException e) {
            input = new FileInputStream(spec);
        }
        catch (IOException e) {
            input = new FileInputStream(spec);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T decodeUrlOrFile(String spec, Decoder<T> decoder) throws IOException {
        InputStream input = Util.openUrlOrFile(spec);
        T t = decoder.decode(input);
        return t;
        finally {
            try {
                input.close();
            }
            catch (IOException ignored) {}
        }
    }

    static Object deserialize(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buf, offset, length);
        ObjectInputStream ois = new ObjectInputStream(inputStream);
        return ois.readObject();
    }

    static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(obj);
        oos.close();
        return outputStream.toByteArray();
    }

    static Logger getLogger() {
        return logger;
    }

    static {
        String packagePath = Util.class.getPackage().getName();
        PACKAGE_NAME = packagePath.substring(packagePath.lastIndexOf(46) + 1).toUpperCase();
        String JDK14_LOGGING_CONFIG_FILE = "logging.properties";
        InputStream inStream = null;
        String path = System.getProperty("java.util.logging.config.file");
        if (path != null) {
            try {
                inStream = new FileInputStream(path);
            }
            catch (FileNotFoundException ignored) {
                // empty catch block
            }
        }
        if (inStream == null) {
            try {
                inStream = new FileInputStream("logging.properties");
            }
            catch (FileNotFoundException e) {
                inStream = Util.class.getClassLoader().getResourceAsStream("logging.properties");
            }
        }
        try {
            LogManager.getLogManager().readConfiguration(inStream);
            logger = LoggerFactory.getLogger(Util.class);
        }
        catch (SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

