/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.sruth;

import edu.ucar.unidata.sruth.DecodeAction;
import edu.ucar.unidata.sruth.FileAction;
import edu.ucar.unidata.sruth.Processor;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

@ThreadSafe
final class XmlActionFile {
    XmlActionFile() {
    }

    static Processor getProcessor(InputStream input) throws IOException {
        Processor processor;
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(input);
            processor = XmlActionFile.process(doc);
        }
        catch (JDOMException e) {
            throw (IOException)new IOException().initCause(e);
        }
        return processor;
    }

    static Processor getProcessor(URL url) throws IOException {
        Processor processor;
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(url);
            processor = XmlActionFile.process(doc);
        }
        catch (JDOMException e) {
            throw (IOException)new IOException().initCause(e);
        }
        return processor;
    }

    static Processor getProcessor(String xml) throws IOException {
        Processor processor;
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            processor = XmlActionFile.process(doc);
        }
        catch (JDOMException e) {
            throw (IOException)new IOException().initCause(e);
        }
        return processor;
    }

    private static Processor process(Document doc) throws IOException {
        Processor processor = new Processor();
        Element rootElt = doc.getRootElement();
        XmlActionFile.processRootElt(rootElt, processor);
        return processor;
    }

    private static void processRootElt(Element rootElt, Processor processor) throws IOException {
        if (!"actions".equalsIgnoreCase(rootElt.getName())) {
            throw new IOException("No \"actions\" element");
        }
        for (Element elt : rootElt.getChildren("entry")) {
            XmlActionFile.processEntryElt(elt, processor);
        }
    }

    private static String getAttribute(Element elt, String name) throws IOException {
        Attribute attr = elt.getAttribute(name);
        if (attr == null) {
            throw new IOException("Missing attribute: + \"" + name + "\"");
        }
        return attr.getValue();
    }

    private static void processEntryElt(Element entryElt, Processor processor) throws IOException {
        String string = XmlActionFile.getAttribute(entryElt, "pattern");
        Pattern pattern = Pattern.compile(string);
        for (Element elt : entryElt.getChildren()) {
            String eltName = elt.getName();
            if (eltName.equalsIgnoreCase("file")) {
                XmlActionFile.processFileElt(elt, pattern, processor);
                continue;
            }
            if (!eltName.equalsIgnoreCase("decode")) continue;
            XmlActionFile.processDecodeElt(elt, pattern, processor);
        }
    }

    private static void processFileElt(Element fileElt, Pattern pattern, Processor processor) throws IOException {
        String path = XmlActionFile.getAttribute(fileElt, "path");
        FileAction action = new FileAction(path);
        processor.add(pattern, action);
    }

    private static void processDecodeElt(Element decodeElt, Pattern pattern, Processor processor) throws IOException {
        LinkedList<String> command = new LinkedList<String>();
        String string = XmlActionFile.getAttribute(decodeElt, "program");
        command.add(string);
        for (Element elt : decodeElt.getChildren()) {
            String eltName = elt.getName();
            if (!eltName.equalsIgnoreCase("arg")) continue;
            string = elt.getTextTrim();
            command.add(string);
        }
        DecodeAction action = new DecodeAction(command);
        processor.add(pattern, action);
    }
}

