/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.iosp.gempak.AbstractGempakStationFileReader;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakParameters;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

public class GempakSoundingFileReader
extends AbstractGempakStationFileReader {
    public static final String SNDT = "SNDT";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final int PRES_COORD = 1;
    public static final int THTA_COORD = 2;
    public static final int HGHT_COORD = 3;
    public static final String MERGED = "merged";
    public static final String UNMERGED = "unmerged";
    private int ivert = -1;
    private List<String> unmergedParts;
    private final String[] mandpp = new String[]{"PRES", "TEMP", "DWPT", "DRCT", "SPED", "HGHT"};
    private final String[] sigtpp = new String[]{"PRES", "TEMP", "DWPT"};
    private final String[] sigwpp = new String[]{"HGHT", "DRCT", "SPED"};
    private final String[] troppp = new String[]{"PRES", "TEMP", "DWPT", "DRCT", "SPED"};
    private final String[] maxwpp = new String[]{"PRES", "DRCT", "SPED"};
    private final String[] belowGroups = new String[]{"TTAA", "TRPA", "MXWA", "PPAA", "TTBB", "PPBB"};
    private final String[] aboveGroups = new String[]{"TTCC", "TRPC", "MXWC", "PPCC", "TTDD", "PPDD"};
    private final String[][] parmLists = new String[][]{this.mandpp, this.troppp, this.maxwpp, this.maxwpp, this.sigtpp, this.sigwpp};

    GempakSoundingFileReader() {
    }

    public static GempakSoundingFileReader getInstance(RandomAccessFile raf, boolean fullCheck) throws IOException {
        GempakSoundingFileReader gsfr = new GempakSoundingFileReader();
        gsfr.init(raf, fullCheck);
        return gsfr;
    }

    @Override
    protected boolean init() throws IOException {
        return this.init(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean init(boolean fullCheck) throws IOException {
        block9: {
            boolean haveUnMerged;
            block10: {
                if (!super.init(fullCheck)) {
                    return false;
                }
                if (this.dmLabel.kftype != 2) {
                    this.logError("not a sounding data file ");
                    return false;
                }
                GempakFileReader.DMPart part = this.getPart(SNDT);
                if (part == null) break block10;
                this.subType = MERGED;
                String vertName = part.params.get((int)0).kprmnm;
                if (vertName.equals("PRES")) {
                    this.ivert = 1;
                    break block9;
                } else if (vertName.equals("THTA")) {
                    this.ivert = 2;
                    break block9;
                } else {
                    if (!(vertName.equals("HGHT") || vertName.equals("MHGT") || vertName.equals("DHGT"))) {
                        this.logError("unknown vertical coordinate in merged file");
                        return false;
                    }
                    this.ivert = 3;
                }
                break block9;
            }
            this.unmergedParts = this.SN_CKUA();
            boolean bl = haveUnMerged = !this.unmergedParts.isEmpty();
            if (!haveUnMerged) {
                this.logError("unknown sounding file type - not merged/unmerged");
                return false;
            }
            this.ivert = 1;
            this.subType = UNMERGED;
        }
        if (!this.readStationsAndTimes(true)) {
            this.logError("Unable to read stations and times");
            return false;
        }
        return true;
    }

    public int getVerticalCoordinate() {
        return this.ivert;
    }

    public List<String> getMergedParts() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(SNDT);
        return list;
    }

    public List<String> getUnmergedParts() {
        return new ArrayList<String>(this.unmergedParts);
    }

    @Override
    protected void makeFileSubType() {
    }

    public void printOb(int row, int col) {
        List<String> parts;
        GempakStation station = this.getStations().get(col - 1);
        String time = this.getDateString(row - 1);
        StringBuilder builder = new StringBuilder("\n");
        builder.append(this.makeHeader(station, time));
        builder.append("\n");
        boolean merge = this.getFileSubType().equals(MERGED);
        if (merge) {
            parts = new ArrayList<String>();
            parts.add(SNDT);
        } else {
            parts = this.unmergedParts;
        }
        for (String part : parts) {
            GempakFileReader.RData rd = null;
            try {
                rd = this.DM_RDTR(row, col, part);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                rd = null;
            }
            if (rd == null) continue;
            if (!merge) {
                builder.append("    ");
                builder.append(part);
                builder.append("    ");
                builder.append(time.substring(time.indexOf("/") + 1));
            }
            builder.append("\n");
            if (!merge) {
                builder.append("\t");
            }
            List<GempakParameter> params = this.getParameters(part);
            for (GempakParameter parm : params) {
                builder.append(StringUtil2.padLeft((String)parm.getName(), (int)7));
                builder.append("\t");
            }
            builder.append("\n");
            if (!merge) {
                builder.append("\t");
            }
            float[] data = rd.data;
            int numParams = params.size();
            int numLevels = data.length / numParams;
            for (int j = 0; j < numLevels; ++j) {
                for (int i = 0; i < numParams; ++i) {
                    builder.append(StringUtil2.padLeft((String)Format.formatDouble((double)data[j * numParams + i], (int)7, (int)1), (int)7));
                    builder.append("\t");
                }
                builder.append("\n");
                if (merge) continue;
                builder.append("\t");
            }
            builder.append("\n");
        }
        builder.append("\n");
        System.out.println(builder.toString());
    }

    private String makeHeader(GempakStation stn, String date) {
        StringBuilder builder = new StringBuilder();
        builder.append("STID = ");
        builder.append(StringUtil2.padRight((String)(stn.getSTID().trim() + stn.getSTD2().trim()), (int)8));
        builder.append("\t");
        builder.append("STNM = ");
        builder.append(Format.i((int)stn.getSTNM(), (int)6));
        builder.append("\t");
        builder.append("TIME = ");
        builder.append(date);
        builder.append("\n");
        builder.append("SLAT = ");
        builder.append(Format.d((double)stn.getLatitude(), (int)5));
        builder.append("\t");
        builder.append("SLON = ");
        builder.append(Format.d((double)stn.getLongitude(), (int)5));
        builder.append("\t");
        builder.append("SELV = ");
        builder.append(Format.d((double)stn.getAltitude(), (int)5));
        builder.append("\n");
        return builder.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("need to supply a GEMPAK sounding file name");
            System.exit(1);
        }
        try {
            GempakParameters.addParameters("resources/nj22/tables/gempak/params.tbl");
        }
        catch (Exception e) {
            System.out.println("unable to init param tables");
        }
        GempakSoundingFileReader gsfr = GempakSoundingFileReader.getInstance(GempakSoundingFileReader.getFile(args[0]), true);
        System.out.println("Type = " + gsfr.getFileType());
        gsfr.printFileLabel();
        gsfr.printKeys();
        gsfr.printHeaders();
        gsfr.printParts();
        gsfr.printDates();
        gsfr.printStations(false);
        int row = 1;
        int col = 1;
        if (args.length > 1) {
            row = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            try {
                col = Integer.parseInt(args[2]);
            }
            catch (Exception npe) {
                col = gsfr.findStationIndex(args[2]);
                if (col == -1) {
                    System.out.println("couldn't find station " + args[2]);
                    System.exit(1);
                }
                System.out.println("found station at column " + col);
            }
        }
        gsfr.printOb(row, col);
    }

    private List<String> SN_CKUA() {
        ArrayList<String> types = new ArrayList<String>();
        boolean above = false;
        boolean done = false;
        String partToCheck = "";
        while (!done) {
            for (int group = 0; group < this.belowGroups.length; ++group) {
                partToCheck = above ? this.aboveGroups[group] : this.belowGroups[group];
                if (!this.checkForValidGroup(partToCheck, this.parmLists[group])) continue;
                types.add(partToCheck);
            }
            if (!above) {
                above = true;
                continue;
            }
            done = true;
        }
        return types;
    }

    private boolean checkForValidGroup(String partToCheck, String[] params) {
        GempakFileReader.DMPart part = this.getPart(partToCheck);
        if (part == null) {
            return false;
        }
        int i = 0;
        for (GempakFileReader.DMParam parm : part.params) {
            if (parm.kprmnm.equals(params[i++])) continue;
            return false;
        }
        return true;
    }
}

