/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import java.util.Formatter;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.mcidas.McGridDefRecord;

public class McIDASGridRecord
extends GridDirectory
implements GridRecord {
    private int offsetToHeader;
    private McGridDefRecord gridDefRecord;
    private int decimalScale = 0;

    public McIDASGridRecord(int offset, int[] header) throws McIDASException {
        super(header);
        this.gridDefRecord = new McGridDefRecord(header);
        this.offsetToHeader = offset;
    }

    public double getLevel1() {
        return this.getLevelValue();
    }

    public double getLevel2() {
        return this.getSecondLevelValue();
    }

    public int getLevelType1() {
        int gribLevel = this.getDirBlock()[51];
        int levelType = 0;
        levelType = gribLevel != -2139062144 && gribLevel != 0 ? gribLevel : 1;
        return levelType;
    }

    public int getLevelType2() {
        return this.getLevelType1();
    }

    public int getValidTimeOffset() {
        return this.getForecastHour();
    }

    public String getParameterName() {
        return this.getParamName();
    }

    public String getParameterDescription() {
        return this.getParamName();
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public String getGridDefRecordId() {
        return this.gridDefRecord.toString();
    }

    public McGridDefRecord getGridDefRecord() {
        return this.gridDefRecord;
    }

    public int getOffsetToHeader() {
        return this.offsetToHeader;
    }

    public boolean hasGribInfo() {
        int gribSection = this.getDirBlock()[48];
        return gribSection != -2139062144 && gribSection != 0;
    }

    public int getTimeUnit() {
        return 0;
    }

    public String getTimeUdunitName() {
        return "minutes";
    }

    public int cdmVariableHash() {
        return this.getParamName().hashCode() + 37 * this.getLevelType1();
    }

    public String cdmVariableName(GridTableLookup lookup, boolean useLevel, boolean useStat) {
        String levelName;
        Formatter f = new Formatter();
        f.format("%s", this.getParameterName());
        if (useLevel && (levelName = lookup.getLevelName((GridRecord)this)).length() != 0) {
            if (lookup.isLayer((GridRecord)this)) {
                f.format("_%s_layer", lookup.getLevelName((GridRecord)this));
            } else {
                f.format("_%s", lookup.getLevelName((GridRecord)this));
            }
        }
        return f.toString();
    }
}

