/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.nc2.iosp.mcidas.McIDASAreaProjection;
import ucar.unidata.geoloc.ProjectionImpl;

public class McIDASAreaTransformBuilder
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return McIDASAreaProjection.GRID_MAPPING_NAME;
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        int[] area = this.getIntArray(ctv, McIDASAreaProjection.ATTR_AREADIR);
        int[] nav = this.getIntArray(ctv, McIDASAreaProjection.ATTR_NAVBLOCK);
        int[] aux = null;
        if (ctv.findAttributeIgnoreCase(McIDASAreaProjection.ATTR_AUXBLOCK) != null) {
            aux = this.getIntArray(ctv, McIDASAreaProjection.ATTR_AUXBLOCK);
        }
        McIDASAreaProjection proj = new McIDASAreaProjection(area, nav, aux);
        return new ProjectionCT(ctv.getShortName(), "FGDC", (ProjectionImpl)proj);
    }

    private int[] getIntArray(Variable ctv, String attName) {
        Attribute att = ctv.findAttribute(attName);
        if (att == null) {
            throw new IllegalArgumentException("McIDASArea coordTransformVariable " + ctv.getFullName() + " must have " + attName + " attribute");
        }
        Array arr = att.getValues();
        return (int[])arr.get1DJavaArray(Integer.TYPE);
    }
}

