/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.units.SimpleUnit;

public class GridCoordSys {
    private GridHorizCoordSys hcs;
    private GridRecord record;
    private String verticalName;
    private GridTableLookup lookup;
    private List<Double> levels;
    boolean dontUseVertical = false;
    String positive = "up";
    String units;

    GridCoordSys(GridHorizCoordSys hcs, GridRecord record, String name, GridTableLookup lookup) {
        this.hcs = hcs;
        this.record = record;
        this.verticalName = name;
        this.lookup = lookup;
        this.levels = new ArrayList<Double>();
        this.dontUseVertical = !lookup.isVerticalCoordinate(record);
        this.positive = lookup.isPositiveUp(record) ? "up" : "down";
        this.units = lookup.getLevelUnit(record);
        if (GridServiceProvider.debugVert) {
            System.out.println("GridCoordSys: " + this.getVerticalDesc() + " useVertical= " + !this.dontUseVertical + " positive=" + this.positive + " units=" + this.units);
        }
    }

    String getCoordSysName() {
        return this.verticalName + "_CoordSys";
    }

    String getVerticalName() {
        return this.verticalName;
    }

    String getVerticalDesc() {
        return this.verticalName + "(" + this.record.getLevelType1() + ")";
    }

    int getNLevels() {
        return this.dontUseVertical ? 1 : this.levels.size();
    }

    void addLevels(List<GridRecord> records) {
        for (GridRecord record : records) {
            Double d = new Double(record.getLevel1());
            if (!this.levels.contains(d)) {
                this.levels.add(d);
            }
            if (!this.dontUseVertical || this.levels.size() <= 1 || !GridServiceProvider.debugVert) continue;
            System.out.println("GribCoordSys: unused level coordinate has > 1 levels = " + this.verticalName + " " + record.getLevelType1() + " " + this.levels.size());
        }
        Collections.sort(this.levels);
        if (this.positive.equals("down")) {
            Collections.reverse(this.levels);
        }
    }

    boolean matchLevels(List<GridRecord> records) {
        ArrayList<Double> levelList = new ArrayList<Double>(records.size());
        for (GridRecord record : records) {
            Double d = new Double(record.getLevel1());
            if (levelList.contains(d)) continue;
            levelList.add(d);
        }
        Collections.sort(levelList);
        if (this.positive.equals("down")) {
            Collections.reverse(levelList);
        }
        return levelList.equals(this.levels);
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (this.dontUseVertical) {
            return;
        }
        int nlevs = this.levels.size();
        ncfile.addDimension(g, new Dimension(this.verticalName, nlevs, true));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (this.dontUseVertical) {
            return;
        }
        if (g == null) {
            g = ncfile.getRootGroup();
        }
        String dims = "time";
        if (!this.dontUseVertical) {
            dims = dims + " " + this.verticalName;
        }
        dims = this.hcs.isLatLon() ? dims + " lat lon" : dims + " y x";
        int nlevs = this.levels.size();
        Variable v = new Variable(ncfile, g, null, this.verticalName);
        v.setDataType(DataType.DOUBLE);
        v.addAttribute(new Attribute("long_name", this.lookup.getLevelDescription(this.record)));
        v.addAttribute(new Attribute("units", this.lookup.getLevelUnit(this.record)));
        if (this.positive != null) {
            v.addAttribute(new Attribute("positive", this.positive));
        }
        if (this.units != null) {
            AxisType axisType = SimpleUnit.isCompatible((String)"millibar", (String)this.units) ? AxisType.Pressure : (SimpleUnit.isCompatible((String)"m", (String)this.units) ? AxisType.Height : AxisType.GeoZ);
            v.addAttribute(new Attribute("grid_level_type", Integer.toString(this.record.getLevelType1())));
            v.addAttribute(new Attribute("_CoordinateAxisType", axisType.toString()));
            v.addAttribute(new Attribute("_CoordinateAxes", dims));
            if (!this.hcs.isLatLon()) {
                v.addAttribute(new Attribute("_CoordinateTransforms", this.hcs.getGridName()));
            }
        }
        double[] data = new double[nlevs];
        for (int i = 0; i < this.levels.size(); ++i) {
            Double d = this.levels.get(i);
            data[i] = d;
        }
        Array dataArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nlevs}, (Object)data);
        v.setDimensions(this.verticalName);
        v.setCachedData(dataArray, false);
        ncfile.addVariable(g, v);
        if (this.record.getLevelType1() == 109) {
            this.findCoordinateTransform(g, "Pressure", this.record.getLevelType1());
        }
    }

    void findCoordinateTransform(Group g, String nameStartsWith, int levelType) {
        List vars = g.getVariables();
        for (Variable v : vars) {
            Attribute att;
            if (!v.getShortName().equals(nameStartsWith) || (att = v.findAttribute("grid_level_type")) == null || att.getNumericValue().intValue() != levelType) continue;
            v.addAttribute(new Attribute("_CoordinateTransformType", "Vertical"));
            v.addAttribute(new Attribute("transform_name", "Existing3DField"));
        }
    }

    int getIndex(GridRecord record) {
        Double d = new Double(record.getLevel1());
        return this.levels.indexOf(d);
    }
}

