/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.array.ByteArray;
import com.cohort.array.CharArray;
import com.cohort.array.DoubleArray;
import com.cohort.array.FloatArray;
import com.cohort.array.IntArray;
import com.cohort.array.LongArray;
import com.cohort.array.PrimitiveArray;
import com.cohort.array.ShortArray;
import com.cohort.array.StringArray;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class Attributes {
    public static boolean verbose = false;
    private ConcurrentHashMap hashmap = new ConcurrentHashMap(16, 0.75f, 4);

    public Attributes() {
    }

    public Attributes(Attributes attributes) {
        attributes.copyTo(this);
    }

    public Attributes(Attributes moreImportant, Attributes lessImportant) {
        lessImportant.copyTo(this);
        this.set(moreImportant);
    }

    public void clear() {
        this.hashmap.clear();
    }

    public int size() {
        return this.hashmap.size();
    }

    public Object clone() {
        Attributes attributes2 = new Attributes();
        this.copyTo(attributes2);
        return attributes2;
    }

    public PrimitiveArray get(String name) {
        return (PrimitiveArray)this.hashmap.get(name);
    }

    public String[] getNames() {
        StringArray names = new StringArray(this.hashmap.keys());
        names.sortIgnoreCase();
        return names.toArray();
    }

    public String getString(String name) {
        try {
            PrimitiveArray pa = this.get(name);
            if (pa == null || pa.size() == 0) {
                return null;
            }
            return pa.getString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getStringsFromCSV(String name) {
        try {
            PrimitiveArray pa = this.get(name);
            if (pa == null || pa.size() == 0) {
                return null;
            }
            String csv = pa.getString(0);
            return StringArray.arrayFromCSV(csv);
        }
        catch (Exception e) {
            return null;
        }
    }

    public double getDouble(String name) {
        try {
            PrimitiveArray pa = this.get(name);
            if (pa == null || pa.size() == 0) {
                return Double.NaN;
            }
            return pa.getDouble(0);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public double getNiceDouble(String name) {
        try {
            PrimitiveArray pa = this.get(name);
            if (pa == null || pa.size() == 0) {
                return Double.NaN;
            }
            return pa.getNiceDouble(0);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public float getFloat(String name) {
        try {
            PrimitiveArray pa = this.get(name);
            if (pa == null || pa.size() == 0) {
                return Float.NaN;
            }
            return pa.getFloat(0);
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    public long getLong(String name) {
        try {
            PrimitiveArray pa = this.get(name);
            if (pa == null || pa.size() == 0) {
                return Long.MAX_VALUE;
            }
            return pa.getLong(0);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    public int getInt(String name) {
        try {
            PrimitiveArray pa = this.get(name);
            if (pa == null || pa.size() == 0) {
                return Integer.MAX_VALUE;
            }
            return pa.getInt(0);
        }
        catch (Exception e) {
            return Integer.MAX_VALUE;
        }
    }

    public PrimitiveArray remove(String name) {
        return (PrimitiveArray)this.hashmap.remove(name);
    }

    public PrimitiveArray set(String name, PrimitiveArray value) {
        if (value == null || value.size() == 0 || value.size() == 1 && value instanceof StringArray && value.getString(0).trim().length() == 0) {
            return (PrimitiveArray)this.hashmap.remove(name);
        }
        return this.hashmap.put(String2.canonical(name), value);
    }

    public Attributes add(String name, PrimitiveArray value) {
        this.set(name, value);
        return this;
    }

    public void set(Attributes moreImportant) {
        Enumeration en = moreImportant.hashmap.keys();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            this.set(name, (PrimitiveArray)moreImportant.get(name).clone());
        }
    }

    public Attributes add(Attributes moreImportant) {
        this.set(moreImportant);
        return this;
    }

    public PrimitiveArray set(String name, String value) {
        if (value == null || value.trim().length() == 0) {
            return this.remove(name);
        }
        return this.set(name, new StringArray(new String[]{value}));
    }

    public PrimitiveArray setIfNotAlreadySet(String name, String value) {
        PrimitiveArray pa = this.get(name);
        if (pa != null) {
            return pa;
        }
        return this.set(name, value);
    }

    public Attributes add(String name, String value) {
        this.set(name, value);
        return this;
    }

    public PrimitiveArray set(String name, double value) {
        return this.set(name, new DoubleArray(new double[]{value}));
    }

    public Attributes add(String name, double value) {
        this.set(name, value);
        return this;
    }

    public PrimitiveArray set(String name, float value) {
        return this.set(name, new FloatArray(new float[]{value}));
    }

    public Attributes add(String name, float value) {
        this.set(name, value);
        return this;
    }

    public PrimitiveArray set(String name, long value) {
        return this.set(name, new LongArray(new long[]{value}));
    }

    public Attributes add(String name, long value) {
        this.set(name, value);
        return this;
    }

    public PrimitiveArray set(String name, int value) {
        return this.set(name, new IntArray(new int[]{value}));
    }

    public Attributes add(String name, int value) {
        this.set(name, value);
        return this;
    }

    public PrimitiveArray set(String name, short value) {
        return this.set(name, new ShortArray(new short[]{value}));
    }

    public Attributes add(String name, short value) {
        this.set(name, value);
        return this;
    }

    public PrimitiveArray set(String name, char value) {
        return this.set(name, new CharArray(new char[]{value}));
    }

    public Attributes add(String name, char value) {
        this.set(name, value);
        return this;
    }

    public PrimitiveArray set(String name, byte value) {
        return this.set(name, new ByteArray(new byte[]{value}));
    }

    public Attributes add(String name, byte value) {
        this.set(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            sb.append("    " + names[i] + "=" + this.get(names[i]).toJsonCsvString() + "\n");
        }
        return sb.toString();
    }

    public void removeValue(String value) {
        Iterator it = this.hashmap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.get(name).toString().equals(value)) continue;
            it.remove();
        }
    }

    public String toNcString(String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        String[] names = this.getNames();
        for (int index = 0; index < names.length; ++index) {
            int i;
            int n;
            sb.append(prefix + names[index] + " = ");
            Object o = this.hashmap.get(names[index]);
            String connect = "";
            if (o instanceof StringArray) {
                StringArray sa = (StringArray)o;
                n = sa.size();
                for (i = 0; i < n; ++i) {
                    sb.append(connect);
                    connect = ", ";
                    String s = String2.replaceAll(sa.get(i), "\\", "\\\\");
                    s = String2.replaceAll(s, "\"", "\\\"");
                    sb.append("\"" + s + "\"");
                }
            } else if (o instanceof FloatArray) {
                FloatArray fa = (FloatArray)o;
                n = fa.size();
                for (i = 0; i < n; ++i) {
                    sb.append(connect);
                    connect = ", ";
                    sb.append(fa.get(i));
                    sb.append("f");
                }
            } else {
                sb.append(o.toString());
            }
            sb.append(suffix + "\n");
        }
        return sb.toString();
    }

    public void copyTo(Attributes destination) {
        destination.hashmap.clear();
        Enumeration en = this.hashmap.keys();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            destination.set(name, (PrimitiveArray)this.get(name).clone());
        }
    }

    public boolean equals(Object o) {
        return this.testEquals(o).length() == 0;
    }

    public String testEquals(Object o) {
        if (o == null) {
            return "The new Attributes object is null.";
        }
        if (!(o instanceof Attributes)) {
            return "The new object isn't an Attributes object.";
        }
        return Test.testEqual(this.toString(), ((Attributes)o).toString(), "");
    }

    public static String valueToNcString(PrimitiveArray pa) {
        if (pa instanceof StringArray) {
            return String2.toSVString(((StringArray)pa).toStringArray(), "\n", false);
        }
        return pa.toString();
    }

    public void removeIfSame(Attributes otherAtts) {
        Iterator it = this.hashmap.keySet().iterator();
        while (it.hasNext()) {
            PrimitiveArray pa;
            String name = (String)it.next();
            PrimitiveArray otherPa = otherAtts.get(name);
            if (otherPa == null || !(pa = this.get(name)).equals(otherPa)) continue;
            it.remove();
        }
    }

    public void trim() {
        for (String name : this.hashmap.keySet()) {
            String tName = name.trim();
            PrimitiveArray pa = null;
            if (!name.equals(tName)) {
                pa = this.remove(name);
                name = tName;
                this.set(name, pa);
            } else {
                pa = this.get(name);
            }
            if (!(pa instanceof StringArray) || pa.size() <= 0) continue;
            pa.setString(0, String2.trimStart(pa.getString(0)));
            pa.setString(pa.size() - 1, String2.trimEnd(pa.getString(pa.size() - 1)));
        }
    }

    public static void test() throws Exception {
        String2.log("\n*** test Attributes...");
        Attributes atts = new Attributes();
        Test.ensureEqual(atts.size(), 0L, "");
        atts.set("byte", (byte)1);
        atts.set("char", 'a');
        atts.set("short", (short)3000);
        atts.set("int", 1000000);
        atts.set("long", 1000000000000L);
        atts.set("float", 2.5f);
        atts.set("double", Math.PI);
        atts.set("String", "a, csv, string");
        atts.set("PA", new IntArray(new int[]{1, 2, 3}));
        Test.ensureEqual(atts.size(), 9L, "");
        Test.ensureEqual(atts.set("zz", new IntArray(new int[]{1})), null, "");
        Test.ensureEqual(atts.size(), 10L, "");
        Test.ensureEqual(atts.set("zz", (PrimitiveArray)null), new IntArray(new int[]{1}), "");
        Test.ensureEqual(atts.size(), 9L, "");
        Test.ensureEqual(atts.set("zz", new IntArray(new int[]{2})), null, "");
        Test.ensureEqual(atts.size(), 10L, "");
        Test.ensureEqual(atts.remove("zz"), new IntArray(new int[]{2}), "");
        Test.ensureEqual(atts.size(), 9L, "");
        atts.set("zz", "a");
        Test.ensureEqual(atts.size(), 10L, "");
        atts.set("zz", "");
        Test.ensureEqual(atts.size(), 9L, "");
        Test.ensureEqual(atts.get("byte"), new ByteArray(new byte[]{1}), "");
        Test.ensureEqual(atts.get("char"), new CharArray(new char[]{'a'}), "");
        Test.ensureEqual(atts.get("short"), new ShortArray(new short[]{3000}), "");
        Test.ensureEqual(atts.get("int"), new IntArray(new int[]{1000000}), "");
        Test.ensureEqual(atts.get("long"), new LongArray(new long[]{1000000000000L}), "");
        Test.ensureEqual(atts.get("float"), new FloatArray(new float[]{2.5f}), "");
        Test.ensureEqual(atts.get("double"), new DoubleArray(new double[]{Math.PI}), "");
        Test.ensureEqual(atts.get("String"), new StringArray(new String[]{"a, csv, string"}), "");
        Test.ensureEqual(atts.get("PA"), new IntArray(new int[]{1, 2, 3}), "");
        Test.ensureEqual(atts.getInt("byte"), 1L, "");
        Test.ensureEqual(atts.getInt("char"), 97L, "");
        Test.ensureEqual(atts.getInt("short"), 3000L, "");
        Test.ensureEqual(atts.getInt("int"), 1000000L, "");
        Test.ensureEqual(atts.getLong("int"), 1000000L, "");
        Test.ensureEqual(atts.getString("int"), "1000000", "");
        Test.ensureEqual(atts.getLong("long"), 1000000000000L, "");
        Test.ensureEqual(atts.getInt("long"), Integer.MAX_VALUE, "");
        Test.ensureEqual(atts.getFloat("float"), 2.5f, "");
        Test.ensureEqual(atts.getDouble("float"), 2.5, "");
        Test.ensureEqual(atts.getString("float"), "2.5", "");
        Test.ensureEqual(atts.getDouble("double"), Math.PI, "");
        Test.ensureEqual(atts.getInt("double"), 3L, "");
        Test.ensureEqual(atts.getString("String"), "a, csv, string", "");
        Test.ensureEqual(atts.getStringsFromCSV("String"), new String[]{"a", "csv", "string"}, "");
        Test.ensureEqual(atts.getInt("String"), Integer.MAX_VALUE, "");
        Test.ensureEqual(atts.get("PA"), new IntArray(new int[]{1, 2, 3}), "");
        Test.ensureEqual(atts.getInt("PA"), 1L, "");
        Test.ensureEqual(atts.getDouble("PA"), 1.0, "");
        Test.ensureEqual(atts.getString("PA"), "1", "");
        Test.ensureEqual(atts.getNames(), new String[]{"byte", "char", "double", "float", "int", "long", "PA", "short", "String"}, "");
        Test.ensureEqual(atts.toString(), "    byte=1\n    char=97\n    double=3.141592653589793\n    float=2.5\n    int=1000000\n    long=1000000000000\n    PA=1, 2, 3\n    short=3000\n    String=\"a, csv, string\"\n", "");
        Attributes atts2 = (Attributes)atts.clone();
        Test.ensureEqual(atts2.get("byte"), new ByteArray(new byte[]{1}), "");
        Test.ensureEqual(atts2.get("char"), new CharArray(new char[]{'a'}), "");
        Test.ensureEqual(atts2.get("short"), new ShortArray(new short[]{3000}), "");
        Test.ensureEqual(atts2.get("int"), new IntArray(new int[]{1000000}), "");
        Test.ensureEqual(atts2.get("long"), new LongArray(new long[]{1000000000000L}), "");
        Test.ensureEqual(atts2.get("float"), new FloatArray(new float[]{2.5f}), "");
        Test.ensureEqual(atts2.get("double"), new DoubleArray(new double[]{Math.PI}), "");
        Test.ensureEqual(atts2.get("String"), new StringArray(new String[]{"a, csv, string"}), "");
        Test.ensureEqual(atts2.get("PA"), new IntArray(new int[]{1, 2, 3}), "");
        Test.ensureEqual(atts2.getNames(), new String[]{"byte", "char", "double", "float", "int", "long", "PA", "short", "String"}, "");
        atts2.clear();
        Test.ensureEqual(atts2.getNames(), new String[0], "");
        atts.copyTo(atts2);
        Test.ensureEqual(atts2.getNames(), new String[]{"byte", "char", "double", "float", "int", "long", "PA", "short", "String"}, "");
        Test.ensureEqual(atts2.get("String"), new StringArray(new String[]{"a, csv, string"}), "");
        Test.ensureTrue(atts.equals(atts2), "");
        Attributes atts3 = new Attributes().add("byte", (byte)1).add("char", 'a').add("short", (short)3000).add("int", 1000000).add("long", 1000000000000L).add("float", 2.5f).add("double", Math.PI).add("String", "a, csv, string").add("PA", new IntArray(new int[]{1, 2, 3}));
        Test.ensureTrue(atts3.equals(atts), "");
        Attributes atts4 = new Attributes().add("zztop", 77).add("char", 'd').add("short", (short)3000);
        atts3.set(atts4);
        Test.ensureEqual(atts3.toString(), "    byte=1\n    char=100\n    double=3.141592653589793\n    float=2.5\n    int=1000000\n    long=1000000000000\n    PA=1, 2, 3\n    short=3000\n    String=\"a, csv, string\"\n    zztop=77\n", "");
        atts.clear();
        atts.set("_FillValue", new ShortArray(new short[]{Short.MAX_VALUE}));
        String2.log("atts.size()=" + atts.size());
        PrimitiveArray fv = atts.get("_FillValue");
        if (fv == null || fv.size() != 1 || !(fv instanceof ShortArray)) {
            throw new Exception("fv=" + fv);
        }
        atts.remove("_FillValue");
        atts.clear();
        atts.add("a", 1);
        atts.add("b", "2");
        atts.add("c", 3.0f);
        atts2.clear();
        atts2.add("b", "2");
        atts2.add("c", 3.0);
        atts2.add("d", 4.0);
        atts.removeIfSame(atts2);
        Test.ensureEqual(atts.toString(), "    a=1\n    c=3.0\n", "");
        atts.clear();
        atts.add(" a ", " A ");
        atts.add("b ", "B");
        atts.add("c", "C");
        atts.add("d", 4);
        atts.trim();
        Test.ensureEqual(atts.toString(), "    a=\"A\"\n    b=\"B\"\n    c=\"C\"\n    d=4\n", "");
        String2.log("*** test Attributes finished successfully.");
    }
}

