/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.array.IntArray;
import com.cohort.array.PrimitiveArray;
import com.cohort.array.StringArray;
import com.cohort.util.Math2;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ByteArray
extends PrimitiveArray {
    public byte[] array;

    public ByteArray() {
        this.array = new byte[8];
    }

    public ByteArray(PrimitiveArray primitiveArray) {
        this.array = new byte[8];
        this.append(primitiveArray);
    }

    public ByteArray(int capacity, boolean active) {
        Math2.ensureMemoryAvailable(1L * (long)capacity, "ByteArray");
        this.array = new byte[capacity];
        if (active) {
            this.size = capacity;
        }
    }

    public ByteArray(byte[] anArray) {
        this.array = anArray;
        this.size = anArray.length;
    }

    public ByteArray(int first, int last) {
        this.size = last - first + 1;
        this.array = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = (byte)(first + i);
        }
    }

    public ByteArray(String fileName) throws Exception {
        this();
        FileInputStream stream = new FileInputStream(fileName);
        int available = stream.available();
        while (available > 0) {
            this.ensureCapacity((long)this.size + (long)available);
            this.size += stream.read(this.array, this.size, available);
            available = stream.available();
        }
        stream.close();
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.size; ++i) {
            code = 31 * code + this.array[i];
        }
        return code;
    }

    @Override
    public PrimitiveArray subset(int startIndex, int stride, int stopIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(ArraySubsetStart, this.getClass().getSimpleName(), "" + startIndex));
        }
        if (stride < 1) {
            throw new IllegalArgumentException(MessageFormat.format(ArraySubsetStride, this.getClass().getSimpleName(), "" + stride));
        }
        if (stopIndex >= this.size) {
            stopIndex = this.size - 1;
        }
        if (stopIndex < startIndex) {
            return new ByteArray(new byte[0]);
        }
        int willFind = ByteArray.strideWillFind(stopIndex - startIndex + 1, stride);
        Math2.ensureMemoryAvailable(1L * (long)willFind, "ByteArray");
        byte[] tar = new byte[willFind];
        if (stride == 1) {
            System.arraycopy(this.array, startIndex, tar, 0, willFind);
        } else {
            int po = 0;
            for (int i = startIndex; i <= stopIndex; i += stride) {
                tar[po++] = this.array[i];
            }
        }
        return new ByteArray(tar);
    }

    @Override
    public Class elementClass() {
        return Byte.TYPE;
    }

    @Override
    public int elementClassIndex() {
        return 0;
    }

    public void add(byte value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        this.array[this.size++] = value;
    }

    public void add(byte[] ar) {
        this.add(ar, 0, ar.length);
    }

    public void add(byte[] ar, int offset, int nBytes) {
        this.ensureCapacity((long)this.size + (long)nBytes);
        System.arraycopy(ar, offset, this.array, this.size, nBytes);
        this.size += nBytes;
    }

    public void addN(int n, byte value) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayAddN, this.getClass().getSimpleName(), "" + n));
        }
        this.ensureCapacity((long)this.size + (long)n);
        Arrays.fill(this.array, this.size, this.size + n, value);
        this.size += n;
    }

    public void add(int index, byte value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        ++this.size;
        this.array[index] = value;
    }

    @Override
    public void addString(int index, String value) {
        this.add(index, Math2.narrowToByte(String2.parseInt(value)));
    }

    @Override
    public void addNStrings(int n, String value) {
        this.addN(n, Math2.narrowToByte(String2.parseInt(value)));
    }

    @Override
    public void addString(String value) {
        this.add(Math2.narrowToByte(String2.parseInt(value)));
    }

    @Override
    public void addFloat(float value) {
        this.add(Math2.roundToByte(value));
    }

    @Override
    public void addDouble(double value) {
        this.add(Math2.roundToByte(value));
    }

    @Override
    public void addNDoubles(int n, double value) {
        this.addN(n, Math2.roundToByte(value));
    }

    @Override
    public void addInt(int value) {
        this.add(Math2.narrowToByte(value));
    }

    @Override
    public void addNInts(int n, int value) {
        this.addN(n, Math2.narrowToByte(value));
    }

    @Override
    public void addLong(long value) {
        this.add(Math2.narrowToByte(value));
    }

    @Override
    public void addFromPA(PrimitiveArray otherPA, int otherIndex) {
        this.addInt(otherPA.getInt(otherIndex));
    }

    @Override
    public void setFromPA(int index, PrimitiveArray otherPA, int otherIndex) {
        this.setInt(index, otherPA.getInt(otherIndex));
    }

    @Override
    public void remove(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayRemove, this.getClass().getSimpleName(), "" + index, "" + this.size));
        }
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
    }

    @Override
    public void removeRange(int from, int to) {
        if (to > this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ByteArray.removeRange: to (" + to + ") > size (" + this.size + ").");
        }
        if (from >= to) {
            if (from == to) {
                return;
            }
            throw new IllegalArgumentException(String2.ERROR + " in ByteArray.removeRange: from (" + from + ") > to (" + to + ").");
        }
        System.arraycopy(this.array, to, this.array, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void move(int first, int last, int destination) {
        String errorIn = String2.ERROR + " in ByteArray.move:\n";
        Test.ensureTrue(first >= 0, errorIn + "first (" + first + ") must be >= 0.");
        Test.ensureTrue(last >= first && last <= this.size, errorIn + "last (" + last + ") must be >= first (" + first + ") and <= size (" + this.size + ").");
        Test.ensureTrue(destination >= 0 && destination <= this.size, errorIn + "destination (" + destination + ") must be between 0 and size (" + this.size + ").");
        Test.ensureTrue(destination <= first || destination >= last, errorIn + "destination (" + destination + ") must be <= first (" + first + ") or >= last (" + last + ").");
        if (first == last || destination == first || destination == last) {
            return;
        }
        int nToMove = last - first;
        byte[] temp = new byte[nToMove];
        System.arraycopy(this.array, first, temp, 0, nToMove);
        if (destination < first) {
            System.arraycopy(this.array, destination, this.array, destination + nToMove, first - destination);
            System.arraycopy(temp, 0, this.array, destination, nToMove);
        } else {
            System.arraycopy(this.array, last, this.array, first, destination - last);
            System.arraycopy(temp, 0, this.array, destination - nToMove, nToMove);
        }
    }

    @Override
    public void justKeep(BitSet bitset) {
        int newSize = 0;
        for (int row = 0; row < this.size; ++row) {
            if (!bitset.get(row)) continue;
            this.array[newSize++] = this.array[row];
        }
        this.removeRange(newSize, this.size);
    }

    @Override
    public void ensureCapacity(long minCapacity) {
        if ((long)this.array.length < minCapacity) {
            Math2.ensureArraySizeOkay(minCapacity, "ByteArray");
            int newCapacity = (int)Math.min(0x7FFFFFFEL, (long)this.array.length + (long)this.array.length);
            if ((long)newCapacity < minCapacity) {
                newCapacity = (int)minCapacity;
            }
            Math2.ensureMemoryAvailable(newCapacity, "ByteArray");
            byte[] newArray = new byte[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public byte[] toArray() {
        if (this.array.length == this.size) {
            return this.array;
        }
        Math2.ensureMemoryAvailable(1L * (long)this.size, "ByteArray.toArray");
        byte[] tArray = new byte[this.size];
        System.arraycopy(this.array, 0, tArray, 0, this.size);
        return tArray;
    }

    @Override
    public Object toObjectArray() {
        return this.toArray();
    }

    @Override
    public double[] toDoubleArray() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "ByteArray.toDoubleArray");
        double[] dar = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            byte b = this.array[i];
            dar[i] = b == 127 ? Double.NaN : (double)b;
        }
        return dar;
    }

    @Override
    public String[] toStringArray() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "ByteArray.toStringArray");
        String[] sar = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            byte b = this.array[i];
            sar[i] = b == 127 ? "" : String.valueOf(b);
        }
        return sar;
    }

    public byte get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ByteArray.get: index (" + index + ") >= size (" + this.size + ").");
        }
        return this.array[index];
    }

    public void set(int index, byte value) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ByteArray.set: index (" + index + ") >= size (" + this.size + ").");
        }
        this.array[index] = value;
    }

    @Override
    public int getInt(int index) {
        byte i = this.get(index);
        return i == 127 ? Integer.MAX_VALUE : (int)i;
    }

    @Override
    public void setInt(int index, int i) {
        this.set(index, Math2.narrowToByte(i));
    }

    @Override
    public long getLong(int index) {
        byte i = this.get(index);
        return i == 127 ? Long.MAX_VALUE : (long)i;
    }

    @Override
    public void setLong(int index, long i) {
        this.set(index, Math2.narrowToByte(i));
    }

    @Override
    public float getFloat(int index) {
        byte b = this.get(index);
        return b == 127 ? Float.NaN : (float)b;
    }

    @Override
    public void setFloat(int index, float d) {
        this.set(index, Math2.roundToByte(d));
    }

    @Override
    public double getDouble(int index) {
        byte b = this.get(index);
        return b == 127 ? Double.NaN : (double)b;
    }

    @Override
    public void setDouble(int index, double d) {
        this.set(index, Math2.roundToByte(d));
    }

    @Override
    public String getString(int index) {
        byte b = this.get(index);
        return b == 127 ? "" : String.valueOf(b);
    }

    @Override
    public void setString(int index, String s) {
        this.set(index, Math2.narrowToByte(String2.parseInt(s)));
    }

    public int indexOf(byte lookFor) {
        return this.indexOf(lookFor, 0);
    }

    public int indexOf(byte lookFor, int startIndex) {
        for (int i = startIndex; i < this.size; ++i) {
            if (this.array[i] != lookFor) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(String lookFor, int startIndex) {
        return this.indexOf(Math2.roundToByte(String2.parseInt(lookFor)), startIndex);
    }

    public int lastIndexOf(byte lookFor, int startIndex) {
        if (startIndex >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ByteArray.get: startIndex (" + startIndex + ") >= size (" + this.size + ").");
        }
        for (int i = startIndex; i >= 0; --i) {
            if (this.array[i] != lookFor) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(String lookFor, int startIndex) {
        return this.lastIndexOf(Math2.roundToByte(String2.parseInt(lookFor)), startIndex);
    }

    @Override
    public void trimToSize() {
        this.array = this.toArray();
    }

    public boolean equals(Object o) {
        return this.testEquals(o).length() == 0;
    }

    @Override
    public String testEquals(Object o) {
        if (!(o instanceof ByteArray)) {
            return "The two objects aren't equal: this object is a ByteArray; the other is a " + o.getClass().getName() + ".";
        }
        ByteArray other = (ByteArray)o;
        if (other.size() != this.size) {
            return "The two ByteArrays aren't equal: one has " + this.size + " value" + (this.size == 0 ? "s" : (this.size == 1 ? " (" + this.array[0] + ")" : "s (from " + this.array[0] + " to " + this.array[this.size - 1] + ")")) + "; the other has " + other.size() + " value" + (other.size == 0 ? "s" : (other.size == 1 ? " (" + other.array[0] + ")" : "s (from " + other.array[0] + " to " + other.array[other.size - 1] + ")")) + ".";
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == other.array[i]) continue;
            return "The two ByteArrays aren't equal: this[" + i + "]=" + this.array[i] + "; other[" + i + "]=" + other.array[i] + ".";
        }
        return "";
    }

    @Override
    public String toString() {
        return String2.toCSSVString(this.toArray());
    }

    @Override
    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    @Override
    public int compare(int index1, int index2) {
        return this.array[index1] - this.array[index2];
    }

    @Override
    public void copy(int from, int to) {
        this.array[to] = this.array[from];
    }

    @Override
    public void reorder(int[] rank) {
        int n = rank.length;
        byte[] newArray = new byte[this.array.length];
        for (int i = 0; i < n; ++i) {
            newArray[i] = this.array[rank[i]];
        }
        this.array = newArray;
    }

    @Override
    public int writeDos(DataOutputStream dos) throws Exception {
        dos.write(this.array, 0, this.size);
        return this.size == 0 ? 0 : 1;
    }

    @Override
    public int writeDos(DataOutputStream dos, int i) throws Exception {
        dos.writeByte(this.array[i]);
        return 1;
    }

    @Override
    public void readDis(DataInputStream dis, int n) throws Exception {
        this.ensureCapacity((long)this.size + (long)n);
        dis.readFully(this.array, this.size, n);
        this.size += n;
    }

    @Override
    public void externalizeForDODS(DataOutputStream dos) throws Exception {
        super.externalizeForDODS(dos);
        int tSize = this.size;
        while (tSize++ % 4 != 0) {
            dos.writeByte(0);
        }
    }

    @Override
    public void externalizeForDODS(DataOutputStream dos, int i) throws Exception {
        dos.writeInt(this.array[i] << 24);
    }

    @Override
    public void internalizeFromDODS(DataInputStream dis) throws IOException {
        int nValues = dis.readInt();
        dis.readInt();
        this.ensureCapacity((long)this.size + (long)nValues);
        dis.readFully(this.array, this.size, nValues);
        this.size += nValues;
        while (nValues++ % 4 != 0) {
            dis.readByte();
        }
    }

    public static double rafReadDouble(RandomAccessFile raf, long start, long index) throws Exception {
        raf.seek(start + index);
        byte b = raf.readByte();
        return b == 127 ? Double.NaN : (double)b;
    }

    public static void rafWriteDouble(RandomAccessFile raf, double value) throws Exception {
        raf.writeByte(Math2.roundToByte(value));
    }

    public static void rafWriteDouble(RandomAccessFile raf, long start, long index, double value) throws Exception {
        raf.seek(start + index);
        raf.writeByte(Math2.roundToByte(value));
    }

    @Override
    public void append(PrimitiveArray primitiveArray) {
        int otherSize = primitiveArray.size();
        this.ensureCapacity((long)this.size + (long)otherSize);
        if (primitiveArray instanceof ByteArray) {
            System.arraycopy(((ByteArray)primitiveArray).array, 0, this.array, this.size, otherSize);
        } else {
            for (int i = 0; i < otherSize; ++i) {
                this.array[this.size + i] = Math2.narrowToByte(primitiveArray.getInt(i));
            }
        }
        this.size += otherSize;
    }

    @Override
    public PrimitiveArray makeIndices(IntArray indices) {
        indices.clear();
        if (this.size == 0) {
            return new ByteArray();
        }
        Integer dummy = new Integer(-1);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(Math2.roundToInt(1.4 * (double)this.size));
        byte lastValue = this.array[0];
        hashMap.put(new Byte(lastValue), dummy);
        boolean alreadySorted = true;
        for (int i = 1; i < this.size; ++i) {
            byte currentValue = this.array[i];
            if (currentValue == lastValue) continue;
            if (currentValue < lastValue) {
                alreadySorted = false;
            }
            lastValue = currentValue;
            hashMap.put(new Byte(lastValue), dummy);
        }
        Set keySet = hashMap.keySet();
        int nUnique = keySet.size();
        if (nUnique == this.size && alreadySorted) {
            indices.ensureCapacity(this.size);
            for (int i = 0; i < this.size; ++i) {
                indices.add(i);
            }
            return this;
        }
        Object[] unique = new Object[nUnique];
        Iterator iterator = keySet.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            unique[count++] = iterator.next();
        }
        Test.ensureEqual(nUnique, count, "ByteArray.makeRankArray nUnique != count!");
        Arrays.sort(unique);
        byte[] tUnique = new byte[nUnique];
        for (int i = 0; i < count; ++i) {
            hashMap.put(unique[i], new Integer(i));
            tUnique[i] = (Byte)unique[i];
        }
        int[] ranks = new int[this.size];
        lastValue = this.array[0];
        ranks[0] = (Integer)hashMap.get(new Byte(lastValue));
        int lastRank = ranks[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i] == lastValue) {
                ranks[i] = lastRank;
                continue;
            }
            lastValue = this.array[i];
            ranks[i] = (Integer)hashMap.get(new Byte(lastValue));
            lastRank = ranks[i];
        }
        indices.append(new IntArray(ranks));
        return new ByteArray(tUnique);
    }

    @Override
    public int switchFromTo(String tFrom, String tTo) {
        byte to;
        byte from = Math2.roundToByte(String2.parseDouble(tFrom));
        if (from == (to = Math2.roundToByte(String2.parseDouble(tTo)))) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != from) continue;
            this.array[i] = to;
            ++count;
        }
        return count;
    }

    @Override
    public String isAscending() {
        if (this.size == 0) {
            return "";
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i - 1] <= this.array[i]) continue;
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + this.array[i - 1] + " > [" + i + "]=" + this.array[i]);
        }
        if (this.array[this.size - 1] == 127) {
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + (this.size - 1) + "]=(" + ArrayMissingValue + ")");
        }
        return "";
    }

    @Override
    public String isDescending() {
        if (this.size == 0) {
            return "";
        }
        if (this.array[0] == 127) {
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[0]=(" + ArrayMissingValue + ")");
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i - 1] >= this.array[i]) continue;
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + this.array[i - 1] + " < [" + i + "]=" + this.array[i]);
        }
        return "";
    }

    @Override
    public int firstTie() {
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i - 1] != this.array[i]) continue;
            return i - 1;
        }
        return -1;
    }

    @Override
    public String minValue() {
        return "-128";
    }

    @Override
    public String maxValue() {
        return "126";
    }

    @Override
    public int[] getNMinMaxIndex() {
        int n = 0;
        int tmini = -1;
        int tmaxi = -1;
        byte tmin = 126;
        byte tmax = -128;
        for (int i = 0; i < this.size; ++i) {
            byte v = this.array[i];
            if (v == 127) continue;
            ++n;
            if (v <= tmin) {
                tmini = i;
                tmin = v;
            }
            if (v < tmax) continue;
            tmaxi = i;
            tmax = v;
        }
        return new int[]{n, tmini, tmaxi};
    }

    public static void test() throws Throwable {
        String2.log("*** Testing ByteArray");
        ByteArray anArray = new ByteArray();
        Test.ensureEqual(anArray.size(), 0L, "");
        anArray.add((byte)120);
        Test.ensureEqual(anArray.size(), 1L, "");
        Test.ensureEqual(anArray.get(0), 120L, "");
        Test.ensureEqual(anArray.getInt(0), 120L, "");
        Test.ensureEqual(anArray.getFloat(0), 120.0f, "");
        Test.ensureEqual(anArray.getDouble(0), 120.0, "");
        Test.ensureEqual(anArray.getString(0), "120", "");
        Test.ensureEqual(anArray.elementClass(), Byte.TYPE, "");
        byte[] tArray = anArray.toArray();
        Test.ensureEqual((Object)tArray, (Object)new byte[]{120}, "");
        try {
            anArray.get(1);
            throw new Throwable("It should have failed.");
        }
        catch (Exception e) {
            try {
                anArray.set(1, (byte)100);
                throw new Throwable("It should have failed.");
            }
            catch (Exception e2) {
                try {
                    anArray.getInt(1);
                    throw new Throwable("It should have failed.");
                }
                catch (Exception e3) {
                    try {
                        anArray.setInt(1, 100);
                        throw new Throwable("It should have failed.");
                    }
                    catch (Exception e4) {
                        try {
                            anArray.getLong(1);
                            throw new Throwable("It should have failed.");
                        }
                        catch (Exception e5) {
                            try {
                                anArray.setLong(1, 100L);
                                throw new Throwable("It should have failed.");
                            }
                            catch (Exception e6) {
                                try {
                                    anArray.getFloat(1);
                                    throw new Throwable("It should have failed.");
                                }
                                catch (Exception e7) {
                                    try {
                                        anArray.setFloat(1, 100.0f);
                                        throw new Throwable("It should have failed.");
                                    }
                                    catch (Exception e8) {
                                        try {
                                            anArray.getDouble(1);
                                            throw new Throwable("It should have failed.");
                                        }
                                        catch (Exception e9) {
                                            try {
                                                anArray.setDouble(1, 100.0);
                                                throw new Throwable("It should have failed.");
                                            }
                                            catch (Exception e10) {
                                                try {
                                                    anArray.getString(1);
                                                    throw new Throwable("It should have failed.");
                                                }
                                                catch (Exception e11) {
                                                    try {
                                                        anArray.setString(1, "100");
                                                        throw new Throwable("It should have failed.");
                                                    }
                                                    catch (Exception e12) {
                                                        anArray.setDouble(0, Double.NaN);
                                                        Test.ensureEqual(anArray.getDouble(0), Double.NaN, "");
                                                        anArray.setDouble(0, -1.0E300);
                                                        Test.ensureEqual(anArray.getDouble(0), Double.NaN, "");
                                                        anArray.setDouble(0, 2.2);
                                                        Test.ensureEqual(anArray.getDouble(0), 2.0, "");
                                                        anArray.setFloat(0, Float.NaN);
                                                        Test.ensureEqual(anArray.getFloat(0), Float.NaN, "");
                                                        anArray.setFloat(0, -1.0E33f);
                                                        Test.ensureEqual(anArray.getFloat(0), Float.NaN, "");
                                                        anArray.setFloat(0, 3.3f);
                                                        Test.ensureEqual(anArray.getFloat(0), 3.0f, "");
                                                        anArray.setLong(0, Long.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getLong(0), Long.MAX_VALUE, "");
                                                        anArray.setLong(0, 9123456789L);
                                                        Test.ensureEqual(anArray.getLong(0), Long.MAX_VALUE, "");
                                                        anArray.setLong(0, 4L);
                                                        Test.ensureEqual(anArray.getLong(0), 4L, "");
                                                        anArray.setInt(0, Integer.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getInt(0), Integer.MAX_VALUE, "");
                                                        anArray.setInt(0, 1123456789);
                                                        Test.ensureEqual(anArray.getInt(0), Integer.MAX_VALUE, "");
                                                        anArray.setInt(0, 5);
                                                        Test.ensureEqual(anArray.getInt(0), 5L, "");
                                                        anArray = new ByteArray(2, false);
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        for (int i = 0; i < 10; ++i) {
                                                            anArray.add((byte)i);
                                                            Test.ensureEqual(anArray.get(i), i, "");
                                                            Test.ensureEqual(anArray.size(), i + 1, "");
                                                        }
                                                        Test.ensureEqual(anArray.size(), 10L, "");
                                                        anArray.clear();
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        anArray = new ByteArray(3, true);
                                                        Test.ensureEqual(anArray.size(), 3L, "");
                                                        Test.ensureEqual(anArray.get(2), 0L, "");
                                                        anArray = new ByteArray(new byte[]{0, 2, 4, 6, 8});
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 2L, "");
                                                        Test.ensureEqual(anArray.get(2), 4L, "");
                                                        Test.ensureEqual(anArray.get(3), 6L, "");
                                                        Test.ensureEqual(anArray.get(4), 8L, "");
                                                        Test.ensureEqual(anArray.compare(1, 3), -4L, "");
                                                        Test.ensureEqual(anArray.compare(1, 1), 0L, "");
                                                        Test.ensureEqual(anArray.compare(3, 1), 4L, "");
                                                        Test.ensureEqual(anArray.toString(), "0, 2, 4, 6, 8", "");
                                                        anArray.addString("");
                                                        double[] stats = anArray.calculateStats();
                                                        anArray.remove(5);
                                                        Test.ensureEqual(stats[0], 5.0, "");
                                                        Test.ensureEqual(stats[1], 0.0, "");
                                                        Test.ensureEqual(stats[2], 8.0, "");
                                                        Test.ensureEqual(stats[3], 20.0, "");
                                                        Test.ensureEqual(anArray.indexOf((byte)0, 0), 0L, "");
                                                        Test.ensureEqual(anArray.indexOf((byte)0, 1), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf((byte)8, 0), 4L, "");
                                                        Test.ensureEqual(anArray.indexOf((byte)9, 0), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 0), 0L, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 1), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf("8", 0), 4L, "");
                                                        Test.ensureEqual(anArray.indexOf("9", 0), -1L, "");
                                                        anArray.remove(1);
                                                        Test.ensureEqual(anArray.size(), 4L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 4L, "");
                                                        Test.ensureEqual(anArray.get(3), 8L, "");
                                                        anArray.add(1, (byte)22);
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 22L, "");
                                                        Test.ensureEqual(anArray.get(2), 4L, "");
                                                        Test.ensureEqual(anArray.get(4), 8L, "");
                                                        anArray.remove(1);
                                                        anArray.removeRange(4, 4);
                                                        anArray.removeRange(1, 3);
                                                        Test.ensureEqual(anArray.size(), 2L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 8L, "");
                                                        Test.ensureEqual(anArray.toString(), "0, 8", "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        Test.ensureEqual(anArray.toStringArray(), new String[]{"0", "8"}, "");
                                                        anArray.trimToSize();
                                                        Test.ensureEqual(anArray.array.length, 2L, "");
                                                        ByteArray anArray2 = new ByteArray();
                                                        anArray2.add((byte)0);
                                                        Test.ensureEqual(anArray.testEquals("A String"), "The two objects aren't equal: this object is a ByteArray; the other is a java.lang.String.", "");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two ByteArrays aren't equal: one has 2 values (from 0 to 8); the other has 1 value (0).", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.addString("7");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two ByteArrays aren't equal: this[1]=8; other[1]=7.", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.setString(1, "8");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "", "");
                                                        Test.ensureTrue(anArray.equals(anArray2), "");
                                                        Test.ensureEqual((Object)anArray.toArray(), anArray.toObjectArray(), "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        int[] rank = new int[]{1, 0};
                                                        anArray.reorder(rank);
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{8.0, 0.0}, "");
                                                        anArray = new ByteArray(new byte[]{1});
                                                        anArray.append(new ByteArray(new byte[]{5, -5}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0}, "");
                                                        anArray.append(new StringArray(new String[]{"a", "9"}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray2 = (ByteArray)anArray.clone();
                                                        Test.ensureEqual((Object)anArray2.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray = new ByteArray(new byte[]{0, 1, 2, 3, 4});
                                                        anArray.move(1, 3, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new byte[]{1, 2, 0, 3, 4}, "");
                                                        anArray = new ByteArray(new byte[]{0, 1, 2, 3, 4});
                                                        anArray.move(1, 2, 4);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new byte[]{0, 2, 3, 1, 4}, "");
                                                        anArray = new ByteArray(new byte[]{0, 1, 2, 3, 4});
                                                        anArray.move(1, 1, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new byte[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(1, 2, 1);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new byte[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(1, 2, 2);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new byte[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(5, 5, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new byte[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(3, 5, 5);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new byte[]{0, 1, 2, 3, 4}, "");
                                                        anArray = new ByteArray(new byte[]{25, 1, 1, 10});
                                                        IntArray indices = new IntArray();
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "1, 10, 25", "");
                                                        Test.ensureEqual(indices.toString(), "2, 0, 0, 1", "");
                                                        anArray = new ByteArray(new byte[]{35, 35, 127, 1, 2});
                                                        indices = new IntArray();
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "1, 2, 35, 127", "");
                                                        Test.ensureEqual(indices.toString(), "2, 2, 3, 0, 1", "");
                                                        anArray = new ByteArray(new byte[]{10, 20, 30, 40});
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "10, 20, 30, 40", "");
                                                        Test.ensureEqual(indices.toString(), "0, 1, 2, 3", "");
                                                        anArray = new ByteArray(new byte[]{127, 1, 2, 127, 3, 127});
                                                        Test.ensureEqual(anArray.switchFromTo("", "75"), 3L, "");
                                                        Test.ensureEqual(anArray.toString(), "75, 1, 2, 75, 3, 75", "");
                                                        anArray.switchFromTo("75", "");
                                                        Test.ensureEqual(anArray.toString(), "127, 1, 2, 127, 3, 127", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 1, 4}, "");
                                                        anArray = new ByteArray(new byte[]{25});
                                                        anArray.addN(2, (byte)5);
                                                        Test.ensureEqual(anArray.toString(), "25, 5, 5", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 2, 0}, "");
                                                        anArray.add(new byte[]{17, 19});
                                                        Test.ensureEqual(anArray.toString(), "25, 5, 5, 17, 19", "");
                                                        PrimitiveArray ss = anArray.subset(1, 3, 4);
                                                        Test.ensureEqual(ss.toString(), "5, 19", "");
                                                        ss = anArray.subset(0, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "25", "");
                                                        ss = anArray.subset(0, 1, -1);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        ss = anArray.subset(1, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        anArray = new ByteArray(new byte[]{10, 20, 30});
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "", "");
                                                        anArray.set(2, (byte)31);
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "ByteArray isn't evenly spaced: [0]=10.0, [1]=20.0, spacing=10.0, average spacing=10.5.", "");
                                                        Test.ensureEqual(anArray.smallestBiggestSpacing(), "  smallest spacing=10.0: [0]=10.0, [1]=20.0\n  biggest  spacing=11.0: [1]=20.0, [2]=31.0", "");
                                                        anArray = new ByteArray(new byte[]{10, 10, 30});
                                                        Test.ensureEqual(anArray.isAscending(), "", "");
                                                        anArray.set(2, (byte)127);
                                                        Test.ensureEqual(anArray.isAscending(), "ByteArray isn't sorted in ascending order: [2]=(missing value).", "");
                                                        anArray.set(1, (byte)9);
                                                        Test.ensureEqual(anArray.isAscending(), "ByteArray isn't sorted in ascending order: [0]=10 > [1]=9.", "");
                                                        anArray = new ByteArray(new byte[]{30, 10, 10});
                                                        Test.ensureEqual(anArray.isDescending(), "", "");
                                                        anArray.set(2, (byte)127);
                                                        Test.ensureEqual(anArray.isDescending(), "ByteArray isn't sorted in descending order: [1]=10 < [2]=127.", "");
                                                        anArray.set(1, (byte)35);
                                                        Test.ensureEqual(anArray.isDescending(), "ByteArray isn't sorted in descending order: [0]=30 < [1]=35.", "");
                                                        anArray = new ByteArray(new byte[]{30, 35, 10});
                                                        Test.ensureEqual(anArray.firstTie(), -1L, "");
                                                        anArray.set(1, (byte)30);
                                                        Test.ensureEqual(anArray.firstTie(), 0L, "");
                                                        anArray = new ByteArray();
                                                        for (int i = 5; i < 1000; ++i) {
                                                            anArray.add((byte)i);
                                                        }
                                                        String2.log("hashcode1=" + anArray.hashCode());
                                                        anArray2 = (ByteArray)anArray.clone();
                                                        Test.ensureEqual(anArray.hashCode(), anArray2.hashCode(), "");
                                                        anArray.add(0, (byte)2);
                                                        Test.ensureTrue(anArray.hashCode() != anArray2.hashCode(), "");
                                                        BitSet bitset = new BitSet();
                                                        anArray = new ByteArray(new byte[]{0, 11, 22, 33, 44});
                                                        bitset.set(1);
                                                        bitset.set(4);
                                                        anArray.justKeep(bitset);
                                                        Test.ensureEqual(anArray.toString(), "11, 44", "");
                                                        anArray = new ByteArray();
                                                        anArray.addString(anArray.minValue());
                                                        anArray.addString(anArray.maxValue());
                                                        Test.ensureEqual(anArray.getString(0), anArray.minValue(), "");
                                                        Test.ensureEqual(anArray.getString(0), "-128", "");
                                                        Test.ensureEqual(anArray.getString(1), anArray.maxValue(), "");
                                                        return;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

