/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.array.ByteArray;
import com.cohort.array.IntArray;
import com.cohort.array.PrimitiveArray;
import com.cohort.array.StringArray;
import com.cohort.util.Math2;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DoubleArray
extends PrimitiveArray {
    public double[] array;

    public DoubleArray() {
        this.array = new double[8];
    }

    public DoubleArray(PrimitiveArray primitiveArray) {
        this.array = new double[8];
        this.append(primitiveArray);
    }

    public DoubleArray(int capacity, boolean active) {
        Math2.ensureMemoryAvailable(8L * (long)capacity, "DoubleArray");
        this.array = new double[capacity];
        if (active) {
            this.size = capacity;
        }
    }

    public DoubleArray(double[] anArray) {
        this.array = anArray;
        this.size = anArray.length;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.size; ++i) {
            long v = Double.doubleToLongBits(this.array[i]);
            code = 31 * code + (int)(v ^ v >>> 32);
        }
        return code;
    }

    @Override
    public PrimitiveArray subset(int startIndex, int stride, int stopIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(ArraySubsetStart, this.getClass().getSimpleName(), "" + startIndex));
        }
        if (stride < 1) {
            throw new IllegalArgumentException(MessageFormat.format(ArraySubsetStride, this.getClass().getSimpleName(), "" + stride));
        }
        if (stopIndex >= this.size) {
            stopIndex = this.size - 1;
        }
        if (stopIndex < startIndex) {
            return new DoubleArray(new double[0]);
        }
        int willFind = DoubleArray.strideWillFind(stopIndex - startIndex + 1, stride);
        Math2.ensureMemoryAvailable(8L * (long)willFind, "DoubleArray");
        double[] tar = new double[willFind];
        if (stride == 1) {
            System.arraycopy(this.array, startIndex, tar, 0, willFind);
        } else {
            int po = 0;
            for (int i = startIndex; i <= stopIndex; i += stride) {
                tar[po++] = this.array[i];
            }
        }
        return new DoubleArray(tar);
    }

    @Override
    public Class elementClass() {
        return Double.TYPE;
    }

    @Override
    public int elementClassIndex() {
        return 6;
    }

    public void add(double value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        this.array[this.size++] = value;
    }

    public void add(double[] ar) {
        int arSize = ar.length;
        this.ensureCapacity((long)this.size + (long)arSize);
        System.arraycopy(ar, 0, this.array, this.size, arSize);
        this.size += arSize;
    }

    public void addN(int n, double value) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayAddN, this.getClass().getSimpleName(), "" + n));
        }
        this.ensureCapacity((long)this.size + (long)n);
        Arrays.fill(this.array, this.size, this.size + n, value);
        this.size += n;
    }

    public void add(int index, double value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        ++this.size;
        this.array[index] = value;
    }

    @Override
    public void addString(int index, String value) {
        this.add(index, String2.parseDouble(value));
    }

    @Override
    public void addString(String value) {
        this.add(String2.parseDouble(value));
    }

    @Override
    public void addNStrings(int n, String value) {
        this.addN(n, String2.parseDouble(value));
    }

    @Override
    public void addFloat(float value) {
        this.add(value);
    }

    @Override
    public void addDouble(double value) {
        this.add(value);
    }

    @Override
    public void addNDoubles(int n, double value) {
        this.addN(n, value);
    }

    @Override
    public void addInt(int value) {
        this.add(value == Integer.MAX_VALUE ? Double.NaN : (double)value);
    }

    @Override
    public void addNInts(int n, int value) {
        this.addN(n, value == Integer.MAX_VALUE ? Double.NaN : (double)value);
    }

    @Override
    public void addLong(long value) {
        this.add(value == Long.MAX_VALUE ? Double.NaN : (double)value);
    }

    @Override
    public void addFromPA(PrimitiveArray otherPA, int otherIndex) {
        this.add(otherPA.getDouble(otherIndex));
    }

    @Override
    public void setFromPA(int index, PrimitiveArray otherPA, int otherIndex) {
        this.set(index, otherPA.getDouble(otherIndex));
    }

    @Override
    public void remove(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayRemove, this.getClass().getSimpleName(), "" + index, "" + this.size));
        }
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
    }

    @Override
    public void removeRange(int from, int to) {
        if (to > this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in DoubleArray.removeRange: to (" + to + ") > size (" + this.size + ").");
        }
        if (from >= to) {
            if (from == to) {
                return;
            }
            throw new IllegalArgumentException(String2.ERROR + " in DoubleArray.removeRange: from (" + from + ") > to (" + to + ").");
        }
        System.arraycopy(this.array, to, this.array, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void move(int first, int last, int destination) {
        String errorIn = String2.ERROR + " in DoubleArray.move:\n";
        Test.ensureTrue(first >= 0, errorIn + "first (" + first + ") must be >= 0.");
        Test.ensureTrue(last >= first && last <= this.size, errorIn + "last (" + last + ") must be >= first (" + first + ") and <= size (" + this.size + ").");
        Test.ensureTrue(destination >= 0 && destination <= this.size, errorIn + "destination (" + destination + ") must be between 0 and size (" + this.size + ").");
        Test.ensureTrue(destination <= first || destination >= last, errorIn + "destination (" + destination + ") must be <= first (" + first + ") or >= last (" + last + ").");
        if (first == last || destination == first || destination == last) {
            return;
        }
        int nToMove = last - first;
        double[] temp = new double[nToMove];
        System.arraycopy(this.array, first, temp, 0, nToMove);
        if (destination < first) {
            System.arraycopy(this.array, destination, this.array, destination + nToMove, first - destination);
            System.arraycopy(temp, 0, this.array, destination, nToMove);
        } else {
            System.arraycopy(this.array, last, this.array, first, destination - last);
            System.arraycopy(temp, 0, this.array, destination - nToMove, nToMove);
        }
    }

    @Override
    public void justKeep(BitSet bitset) {
        int newSize = 0;
        for (int row = 0; row < this.size; ++row) {
            if (!bitset.get(row)) continue;
            this.array[newSize++] = this.array[row];
        }
        this.removeRange(newSize, this.size);
    }

    @Override
    public void ensureCapacity(long minCapacity) {
        if ((long)this.array.length < minCapacity) {
            Math2.ensureArraySizeOkay(minCapacity, "DoubleArray");
            int newCapacity = (int)Math.min(0x7FFFFFFEL, (long)this.array.length + (long)this.array.length);
            if ((long)newCapacity < minCapacity) {
                newCapacity = (int)minCapacity;
            }
            Math2.ensureMemoryAvailable(8L * (long)newCapacity, "DoubleArray");
            double[] newArray = new double[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public double[] toArray() {
        if (this.array.length == this.size) {
            return this.array;
        }
        Math2.ensureMemoryAvailable(8L * (long)this.size, "DoubleArray.toArray");
        double[] tArray = new double[this.size];
        System.arraycopy(this.array, 0, tArray, 0, this.size);
        return tArray;
    }

    @Override
    public Object toObjectArray() {
        return this.toArray();
    }

    @Override
    public double[] toDoubleArray() {
        return this.toArray();
    }

    @Override
    public String[] toStringArray() {
        Math2.ensureMemoryAvailable(12L * (long)this.size, "DoubleArray.toStringArray");
        String[] sar = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            double d = this.array[i];
            sar[i] = Math2.isFinite(d) ? String.valueOf(d) : "";
        }
        return sar;
    }

    public double get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in DoubleArray.get: index (" + index + ") >= size (" + this.size + ").");
        }
        return this.array[index];
    }

    public void set(int index, double value) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in DoubleArray.set: index (" + index + ") >= size (" + this.size + ").");
        }
        this.array[index] = value;
    }

    @Override
    public int getInt(int index) {
        return Math2.roundToInt(this.get(index));
    }

    @Override
    public void setInt(int index, int i) {
        this.set(index, i == Integer.MAX_VALUE ? Double.NaN : (double)i);
    }

    @Override
    public long getLong(int index) {
        return Math2.roundToLong(this.get(index));
    }

    @Override
    public void setLong(int index, long i) {
        this.set(index, i == Long.MAX_VALUE ? Double.NaN : (double)i);
    }

    @Override
    public float getFloat(int index) {
        return Math2.doubleToFloatNaN(this.get(index));
    }

    @Override
    public void setFloat(int index, float d) {
        this.set(index, d);
    }

    @Override
    public double getDouble(int index) {
        return this.get(index);
    }

    @Override
    public void setDouble(int index, double d) {
        this.set(index, d);
    }

    @Override
    public String getString(int index) {
        double b = this.get(index);
        return Math2.isFinite(b) ? String.valueOf(b) : "";
    }

    @Override
    public void setString(int index, String s) {
        this.set(index, String2.parseDouble(s));
    }

    public int indexOf(double lookFor) {
        return this.indexOf(lookFor, 0);
    }

    public int indexOf(double lookFor, int startIndex) {
        if (Double.isNaN(lookFor)) {
            for (int i = startIndex; i < this.size; ++i) {
                if (!Double.isNaN(this.array[i])) continue;
                return i;
            }
            return -1;
        }
        for (int i = startIndex; i < this.size; ++i) {
            if (this.array[i] != lookFor) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(String lookFor, int startIndex) {
        return this.indexOf(String2.parseDouble(lookFor), startIndex);
    }

    public int lastIndexOf(double lookFor, int startIndex) {
        if (startIndex >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in DoubleArray.get: startIndex (" + startIndex + ") >= size (" + this.size + ").");
        }
        for (int i = startIndex; i >= 0; --i) {
            if (this.array[i] != lookFor) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(String lookFor, int startIndex) {
        return this.lastIndexOf(String2.parseDouble(lookFor), startIndex);
    }

    @Override
    public void trimToSize() {
        this.array = this.toArray();
    }

    public boolean equals(Object o) {
        return this.testEquals(o).length() == 0;
    }

    @Override
    public String testEquals(Object o) {
        if (!(o instanceof DoubleArray)) {
            return "The two objects aren't equal: this object is a DoubleArray; the other is a " + o.getClass().getName() + ".";
        }
        DoubleArray other = (DoubleArray)o;
        if (other.size() != this.size) {
            return "The two DoubleArrays aren't equal: one has " + this.size + " value" + (this.size == 0 ? "s" : (this.size == 1 ? " (" + this.array[0] + ")" : "s (from " + this.array[0] + " to " + this.array[this.size - 1] + ")")) + "; the other has " + other.size() + " value" + (other.size() == 0 ? "s" : (other.size() == 1 ? " (" + other.array[0] + ")" : "s (from " + other.array[0] + " to " + other.array[other.size() - 1] + ")")) + ".";
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == other.array[i]) continue;
            return "The two DoubleArrays aren't equal: this[" + i + "]=" + this.array[i] + "; other[" + i + "]=" + other.array[i] + ".";
        }
        return "";
    }

    @Override
    public String toString() {
        return String2.toCSSVString(this.toArray());
    }

    @Override
    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    @Override
    public int compare(int index1, int index2) {
        return Double.compare(this.array[index1], this.array[index2]);
    }

    @Override
    public void copy(int from, int to) {
        this.array[to] = this.array[from];
    }

    @Override
    public void reorder(int[] rank) {
        int n = rank.length;
        double[] newArray = new double[this.array.length];
        for (int i = 0; i < n; ++i) {
            newArray[i] = this.array[rank[i]];
        }
        this.array = newArray;
    }

    @Override
    public int writeDos(DataOutputStream dos, int i) throws Exception {
        dos.writeDouble(this.array[i]);
        return 8;
    }

    @Override
    public void readDis(DataInputStream dis, int n) throws Exception {
        this.ensureCapacity((long)this.size + (long)n);
        for (int i = 0; i < n; ++i) {
            this.array[this.size++] = dis.readDouble();
        }
    }

    @Override
    public void internalizeFromDODS(DataInputStream dis) throws IOException {
        int nValues = dis.readInt();
        dis.readInt();
        this.ensureCapacity((long)this.size + (long)nValues);
        for (int i = 0; i < nValues; ++i) {
            this.array[this.size++] = dis.readDouble();
        }
    }

    public static double rafReadDouble(RandomAccessFile raf, long start, long index) throws Exception {
        raf.seek(start + 8L * index);
        return raf.readDouble();
    }

    public static void rafWriteDouble(RandomAccessFile raf, double value) throws Exception {
        raf.writeDouble(value);
    }

    public static void rafWriteDouble(RandomAccessFile raf, long start, long index, double value) throws Exception {
        raf.seek(start + 8L * index);
        raf.writeDouble(value);
    }

    @Override
    public void append(PrimitiveArray primitiveArray) {
        int otherSize = primitiveArray.size();
        this.ensureCapacity((long)this.size + (long)otherSize);
        if (primitiveArray instanceof DoubleArray) {
            System.arraycopy(((DoubleArray)primitiveArray).array, 0, this.array, this.size, otherSize);
        } else {
            for (int i = 0; i < otherSize; ++i) {
                this.array[this.size + i] = primitiveArray.getDouble(i);
            }
        }
        this.size += otherSize;
    }

    @Override
    public PrimitiveArray makeIndices(IntArray indices) {
        indices.clear();
        if (this.size == 0) {
            return new DoubleArray();
        }
        Integer dummy = new Integer(-1);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(Math2.roundToInt(1.4 * (double)this.size));
        double lastValue = this.array[0];
        hashMap.put(new Double(lastValue), dummy);
        boolean alreadySorted = true;
        for (int i = 1; i < this.size; ++i) {
            double currentValue = this.array[i];
            if (currentValue == lastValue) continue;
            if (currentValue < lastValue) {
                alreadySorted = false;
            }
            lastValue = currentValue;
            hashMap.put(new Double(lastValue), dummy);
        }
        Set keySet = hashMap.keySet();
        int nUnique = keySet.size();
        if (nUnique == this.size && alreadySorted) {
            indices.ensureCapacity(this.size);
            for (int i = 0; i < this.size; ++i) {
                indices.add(i);
            }
            return this;
        }
        Object[] unique = new Object[nUnique];
        Iterator iterator = keySet.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            unique[count++] = iterator.next();
        }
        Test.ensureEqual(nUnique, count, "DoubleArray.makeRankArray nUnique != count!");
        Arrays.sort(unique);
        double[] tUnique = new double[nUnique];
        for (int i = 0; i < count; ++i) {
            hashMap.put(unique[i], new Integer(i));
            tUnique[i] = (Double)unique[i];
        }
        int[] ranks = new int[this.size];
        lastValue = this.array[0];
        ranks[0] = (Integer)hashMap.get(new Double(lastValue));
        int lastRank = ranks[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i] == lastValue) {
                ranks[i] = lastRank;
                continue;
            }
            lastValue = this.array[i];
            ranks[i] = (Integer)hashMap.get(new Double(lastValue));
            lastRank = ranks[i];
        }
        indices.append(new IntArray(ranks));
        return new DoubleArray(tUnique);
    }

    @Override
    public int switchFromTo(String tFrom, String tTo) {
        double from = String2.parseDouble(tFrom);
        double to = String2.parseDouble(tTo);
        if (Double.isNaN(from) && Double.isNaN(to) || from == to) {
            return 0;
        }
        int count = 0;
        if (Double.isNaN(from)) {
            for (int i = 0; i < this.size; ++i) {
                if (!Double.isNaN(this.array[i])) continue;
                this.array[i] = to;
                ++count;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!Math2.almostEqual(9, this.array[i], from)) continue;
                this.array[i] = to;
                ++count;
            }
        }
        return count;
    }

    public void removeDuplicatesAE5() {
        if (this.size <= 1) {
            return;
        }
        int nValid = 1;
        for (int i = 1; i < this.size; ++i) {
            if (Math2.almostEqual(5, this.array[i], this.array[nValid - 1])) continue;
            this.array[nValid++] = this.array[i];
        }
        this.size = nValid;
    }

    @Override
    public String isAscending() {
        if (this.size == 0) {
            return "";
        }
        if (!Math2.isFinite(this.array[0])) {
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[0]=" + this.array[0]);
        }
        for (int i = 1; i < this.size; ++i) {
            if (!Math2.isFinite(this.array[i])) {
                return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + i + "]=" + this.array[i]);
            }
            if (!(this.array[i - 1] > this.array[i])) continue;
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + this.array[i - 1] + " > [" + i + "]=" + this.array[i]);
        }
        return "";
    }

    @Override
    public String isDescending() {
        if (this.size == 0) {
            return "";
        }
        if (!Math2.isFinite(this.array[0])) {
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[0]=" + this.array[0]);
        }
        for (int i = 1; i < this.size; ++i) {
            if (!Math2.isFinite(this.array[i])) {
                return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[" + i + "]=" + this.array[i]);
            }
            if (!(this.array[i - 1] < this.array[i])) continue;
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + this.array[i - 1] + " < [" + i + "]=" + this.array[i]);
        }
        return "";
    }

    @Override
    public int firstTie() {
        for (int i = 1; i < this.size; ++i) {
            if (!(Double.isNaN(this.array[i - 1]) ? Double.isNaN(this.array[i]) : this.array[i - 1] == this.array[i])) continue;
            return i - 1;
        }
        return -1;
    }

    @Override
    public String isEvenlySpaced() {
        if (this.size <= 2) {
            return "";
        }
        double diff = (this.array[this.size - 1] - this.array[0]) / (double)(this.size - 1);
        for (int i = 1; i < this.size; ++i) {
            if (Math2.almostEqual(9, (this.array[i] - this.array[i - 1]) * 1.0E7, diff * 1.0E7) || Math2.almostEqual(12, this.array[i - 1] + diff, this.array[i]) && Math2.almostEqual(2, (this.array[i] - this.array[i - 1]) * 1.0E7, diff * 1.0E7)) continue;
            return MessageFormat.format(ArrayNotEvenlySpaced, this.getClass().getSimpleName(), "" + (i - 1), "" + this.array[i - 1], "" + i, "" + this.array[i], "" + (this.array[i] - this.array[i - 1]), "" + diff);
        }
        return "";
    }

    @Override
    public String minValue() {
        return "-1.7976931348623157E308";
    }

    @Override
    public String maxValue() {
        return "1.7976931348623157E308";
    }

    @Override
    public int[] getNMinMaxIndex() {
        int n = 0;
        int tmini = -1;
        int tmaxi = -1;
        double tmin = Double.MAX_VALUE;
        double tmax = -1.7976931348623157E308;
        for (int i = 0; i < this.size; ++i) {
            double v = this.array[i];
            if (!Math2.isFinite(v)) continue;
            ++n;
            if (v <= tmin) {
                tmini = i;
                tmin = v;
            }
            if (!(v >= tmax)) continue;
            tmaxi = i;
            tmax = v;
        }
        return new int[]{n, tmini, tmaxi};
    }

    public static void test() throws Throwable {
        String2.log("*** Testing DoubleArray");
        DoubleArray anArray = new DoubleArray();
        String2.log("getClass().getName()=" + anArray.getClass().getName());
        String2.log("getClass().getSimpleName()=" + anArray.getClass().getSimpleName());
        Test.ensureEqual(anArray.size(), 0L, "");
        anArray.add(1.0E307);
        Test.ensureEqual(anArray.size(), 1L, "");
        Test.ensureEqual(anArray.get(0), 1.0E307, "");
        Test.ensureEqual(anArray.getInt(0), Integer.MAX_VALUE, "");
        Test.ensureEqual(anArray.getFloat(0), Float.NaN, "");
        Test.ensureEqual(anArray.getDouble(0), 1.0E307, "");
        Test.ensureEqual(anArray.getString(0), "1.0E307", "");
        Test.ensureEqual(anArray.elementClass(), Double.TYPE, "");
        double[] tArray = anArray.toArray();
        Test.ensureEqual((Object)tArray, (Object)new double[]{1.0E307}, "");
        try {
            anArray.get(1);
            throw new Throwable("It should have failed.");
        }
        catch (Exception e) {
            try {
                anArray.set(1, 100.0);
                throw new Throwable("It should have failed.");
            }
            catch (Exception e2) {
                try {
                    anArray.getInt(1);
                    throw new Throwable("It should have failed.");
                }
                catch (Exception e3) {
                    try {
                        anArray.setInt(1, 100);
                        throw new Throwable("It should have failed.");
                    }
                    catch (Exception e4) {
                        try {
                            anArray.getLong(1);
                            throw new Throwable("It should have failed.");
                        }
                        catch (Exception e5) {
                            try {
                                anArray.setLong(1, 100L);
                                throw new Throwable("It should have failed.");
                            }
                            catch (Exception e6) {
                                try {
                                    anArray.getFloat(1);
                                    throw new Throwable("It should have failed.");
                                }
                                catch (Exception e7) {
                                    try {
                                        anArray.setFloat(1, 100.0f);
                                        throw new Throwable("It should have failed.");
                                    }
                                    catch (Exception e8) {
                                        try {
                                            anArray.getDouble(1);
                                            throw new Throwable("It should have failed.");
                                        }
                                        catch (Exception e9) {
                                            try {
                                                anArray.setDouble(1, 100.0);
                                                throw new Throwable("It should have failed.");
                                            }
                                            catch (Exception e10) {
                                                try {
                                                    anArray.getString(1);
                                                    throw new Throwable("It should have failed.");
                                                }
                                                catch (Exception e11) {
                                                    try {
                                                        anArray.setString(1, "100");
                                                        throw new Throwable("It should have failed.");
                                                    }
                                                    catch (Exception e12) {
                                                        anArray.setDouble(0, Double.NaN);
                                                        Test.ensureEqual(anArray.getDouble(0), Double.NaN, "");
                                                        anArray.setDouble(0, -1.0E300);
                                                        Test.ensureEqual(anArray.getDouble(0), -1.0E300, "");
                                                        anArray.setDouble(0, 2.2);
                                                        Test.ensureEqual(anArray.getDouble(0), 2.2, "");
                                                        anArray.setFloat(0, Float.NaN);
                                                        Test.ensureEqual(anArray.getFloat(0), Float.NaN, "");
                                                        anArray.setFloat(0, -1.0E33f);
                                                        Test.ensureEqual(anArray.getFloat(0), -1.0E33f, "");
                                                        anArray.setFloat(0, 3.3f);
                                                        Test.ensureEqual(anArray.getFloat(0), 3.3f, "");
                                                        anArray.setLong(0, Long.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getLong(0), Long.MAX_VALUE, "");
                                                        anArray.setLong(0, 9123456789L);
                                                        Test.ensureEqual(anArray.getLong(0), 9123456789L, "");
                                                        anArray.setLong(0, 4L);
                                                        Test.ensureEqual(anArray.getLong(0), 4L, "");
                                                        anArray.setInt(0, Integer.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getInt(0), Integer.MAX_VALUE, "");
                                                        anArray.setInt(0, 1123456789);
                                                        Test.ensureEqual(anArray.getInt(0), 1123456789L, "");
                                                        anArray.setInt(0, 5);
                                                        Test.ensureEqual(anArray.getInt(0), 5L, "");
                                                        anArray = new DoubleArray(2, false);
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        for (int i = 0; i < 10; ++i) {
                                                            anArray.add(i);
                                                            Test.ensureEqual(anArray.get(i), (double)i, "");
                                                            Test.ensureEqual(anArray.size(), i + 1, "");
                                                        }
                                                        Test.ensureEqual(anArray.size(), 10L, "");
                                                        anArray.clear();
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        anArray = new DoubleArray(3, true);
                                                        Test.ensureEqual(anArray.size(), 3L, "");
                                                        Test.ensureEqual(anArray.get(2), 0.0, "");
                                                        anArray = new DoubleArray(new double[]{0.0, 2.2, 4.0, 6.0, 8.0});
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), 0.0, "");
                                                        Test.ensureEqual(anArray.get(1), 2.2, "");
                                                        Test.ensureEqual(anArray.get(2), 4.0, "");
                                                        Test.ensureEqual(anArray.get(3), 6.0, "");
                                                        Test.ensureEqual(anArray.get(4), 8.0, "");
                                                        Test.ensureEqual(anArray.compare(1, 3), -1L, "");
                                                        Test.ensureEqual(anArray.compare(1, 1), 0L, "");
                                                        Test.ensureEqual(anArray.compare(3, 1), 1L, "");
                                                        Test.ensureEqual(anArray.toString(), "0.0, 2.2, 4.0, 6.0, 8.0", "");
                                                        anArray.addString("");
                                                        double[] stats = anArray.calculateStats();
                                                        anArray.remove(5);
                                                        Test.ensureEqual(stats[0], 5.0, "");
                                                        Test.ensureEqual(stats[1], 0.0, "");
                                                        Test.ensureEqual(stats[2], 8.0, "");
                                                        Test.ensureEqual(stats[3], 20.2, "");
                                                        Test.ensureEqual(anArray.indexOf(0.0, 0), 0L, "");
                                                        Test.ensureEqual(anArray.indexOf(0.0, 1), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf(8.0, 0), 4L, "");
                                                        Test.ensureEqual(anArray.indexOf(9.0, 0), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 0), 0L, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 1), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf("8", 0), 4L, "");
                                                        Test.ensureEqual(anArray.indexOf("9", 0), -1L, "");
                                                        anArray.remove(1);
                                                        Test.ensureEqual(anArray.size(), 4L, "");
                                                        Test.ensureEqual(anArray.get(0), 0.0, "");
                                                        Test.ensureEqual(anArray.get(1), 4.0, "");
                                                        Test.ensureEqual(anArray.get(3), 8.0, "");
                                                        anArray.add(1, 22.0);
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), 0.0, "");
                                                        Test.ensureEqual(anArray.get(1), 22.0, "");
                                                        Test.ensureEqual(anArray.get(2), 4.0, "");
                                                        Test.ensureEqual(anArray.get(4), 8.0, "");
                                                        anArray.remove(1);
                                                        anArray.removeRange(4, 4);
                                                        anArray.removeRange(1, 3);
                                                        Test.ensureEqual(anArray.size(), 2L, "");
                                                        Test.ensureEqual(anArray.get(0), 0.0, "");
                                                        Test.ensureEqual(anArray.get(1), 8.0, "");
                                                        Test.ensureEqual(anArray.toString(), "0.0, 8.0", "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        Test.ensureEqual(anArray.toStringArray(), new String[]{"0.0", "8.0"}, "");
                                                        anArray.trimToSize();
                                                        Test.ensureEqual(anArray.array.length, 2L, "");
                                                        DoubleArray anArray2 = new DoubleArray();
                                                        anArray2.add(0.0);
                                                        Test.ensureEqual(anArray.testEquals("A String"), "The two objects aren't equal: this object is a DoubleArray; the other is a java.lang.String.", "");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two DoubleArrays aren't equal: one has 2 values (from 0.0 to 8.0); the other has 1 value (0.0).", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.addString("7");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two DoubleArrays aren't equal: this[1]=8.0; other[1]=7.0.", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.setString(1, "8");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "", "");
                                                        Test.ensureTrue(anArray.equals(anArray2), "");
                                                        Test.ensureEqual((Object)anArray.toArray(), anArray.toObjectArray(), "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        int[] rank = new int[]{1, 0};
                                                        anArray.reorder(rank);
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{8.0, 0.0}, "");
                                                        anArray = new DoubleArray(new double[]{1.0});
                                                        anArray.append(new ByteArray(new byte[]{5, -5}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0}, "");
                                                        anArray.append(new StringArray(new String[]{"a", "9"}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray2 = (DoubleArray)anArray.clone();
                                                        Test.ensureEqual((Object)anArray2.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray = new DoubleArray(new double[]{-1.0, 1.0, Double.NaN});
                                                        anArray.sort();
                                                        Test.ensureEqual(anArray.toString(), "-1.0, 1.0, NaN", "");
                                                        anArray = new DoubleArray(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
                                                        double[] ar = anArray.array;
                                                        anArray.move(1, 3, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{1.0, 2.0, 0.0, 3.0, 4.0}, "");
                                                        Test.ensureTrue(ar == anArray.array, "");
                                                        anArray = new DoubleArray(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
                                                        ar = anArray.array;
                                                        anArray.move(3, 5, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{3.0, 4.0, 0.0, 1.0, 2.0}, "");
                                                        Test.ensureTrue(ar == anArray.array, "");
                                                        anArray = new DoubleArray(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
                                                        ar = anArray.array;
                                                        anArray.move(1, 2, 4);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{0.0, 2.0, 3.0, 1.0, 4.0}, "");
                                                        Test.ensureTrue(ar == anArray.array, "");
                                                        anArray = new DoubleArray(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
                                                        ar = anArray.array;
                                                        anArray.move(1, 1, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0}, "");
                                                        anArray.move(1, 2, 1);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0}, "");
                                                        anArray.move(1, 2, 2);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0}, "");
                                                        anArray.move(5, 5, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0}, "");
                                                        anArray.move(3, 5, 5);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0}, "");
                                                        Test.ensureTrue(ar == anArray.array, "");
                                                        anArray = new DoubleArray(new double[]{25.0, 1.0, 1.0, 10.0});
                                                        IntArray indices = new IntArray();
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "1.0, 10.0, 25.0", "");
                                                        Test.ensureEqual(indices.toString(), "2, 0, 0, 1", "");
                                                        anArray = new DoubleArray(new double[]{35.0, 35.0, Double.NaN, 1.0, 2.0});
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "1.0, 2.0, 35.0, NaN", "");
                                                        Test.ensureEqual(indices.toString(), "2, 2, 3, 0, 1", "");
                                                        anArray = new DoubleArray(new double[]{10.0, 20.0, 30.0, 40.0});
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "10.0, 20.0, 30.0, 40.0", "");
                                                        Test.ensureEqual(indices.toString(), "0, 1, 2, 3", "");
                                                        anArray = new DoubleArray(new double[]{Double.NaN, 1.0, 2.0, Double.NaN, 3.0, Double.NaN});
                                                        Test.ensureEqual(anArray.switchFromTo("", "75"), 3L, "");
                                                        Test.ensureEqual(anArray.toString(), "75.0, 1.0, 2.0, 75.0, 3.0, 75.0", "");
                                                        anArray.switchFromTo("75", "");
                                                        Test.ensureEqual(anArray.toString(), "NaN, 1.0, 2.0, NaN, 3.0, NaN", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 1, 4}, "");
                                                        anArray = new DoubleArray(new double[]{1.0, 2.0, 2.0000001, 2.0000002, 3.0});
                                                        anArray.removeDuplicatesAE5();
                                                        Test.ensureEqual(anArray.toString(), "1.0, 2.0, 3.0", "");
                                                        anArray = new DoubleArray(new double[]{1.0, 0.9999999, 2.0, 2.0000001, 2.0000002, 3.0, 3.000000001});
                                                        anArray.removeDuplicatesAE5();
                                                        Test.ensureEqual(anArray.toString(), "1.0, 2.0, 3.0", "");
                                                        anArray = new DoubleArray(new double[]{25.0});
                                                        anArray.addN(2, 5.0);
                                                        Test.ensureEqual(anArray.toString(), "25.0, 5.0, 5.0", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 2, 0}, "");
                                                        anArray.add(new double[]{17.0, 19.0});
                                                        Test.ensureEqual(anArray.toString(), "25.0, 5.0, 5.0, 17.0, 19.0", "");
                                                        PrimitiveArray ss = anArray.subset(1, 3, 4);
                                                        Test.ensureEqual(ss.toString(), "5.0, 19.0", "");
                                                        ss = anArray.subset(0, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "25.0", "");
                                                        ss = anArray.subset(0, 1, -1);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        ss = anArray.subset(1, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        String2.log("\nevenlySpaced test #1");
                                                        anArray = new DoubleArray(new double[]{10.0, 20.0, 30.0});
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "", "");
                                                        String2.log("\nevenlySpaced test #2");
                                                        anArray.set(2, 30.1);
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "DoubleArray isn't evenly spaced: [0]=10.0, [1]=20.0, spacing=10.0, average spacing=10.05.", "");
                                                        Test.ensureEqual(anArray.smallestBiggestSpacing(), "  smallest spacing=10.0: [0]=10.0, [1]=20.0\n  biggest  spacing=10.100000000000001: [1]=20.0, [2]=30.1", "");
                                                        String2.log("\nevenlySpaced test #3");
                                                        anArray = new DoubleArray(new double[]{1.2345678906, 1.2345678907, 1.2345678908001});
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "", "");
                                                        String2.log("\nevenlySpaced test #4");
                                                        anArray.set(2, 1.23456789081);
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "DoubleArray isn't evenly spaced: [0]=1.2345678906, [1]=1.2345678907, spacing=1.000000082740371E-10, average spacing=1.0500000868773895E-10.", "");
                                                        anArray = new DoubleArray(new double[]{10.0, 10.0, 30.0});
                                                        Test.ensureEqual(anArray.isAscending(), "", "");
                                                        anArray.set(2, Double.NaN);
                                                        Test.ensureEqual(anArray.isAscending(), "DoubleArray isn't sorted in ascending order: [2]=NaN.", "");
                                                        anArray.set(1, 9.0);
                                                        Test.ensureEqual(anArray.isAscending(), "DoubleArray isn't sorted in ascending order: [0]=10.0 > [1]=9.0.", "");
                                                        anArray = new DoubleArray(new double[]{30.0, 10.0, 10.0});
                                                        Test.ensureEqual(anArray.isDescending(), "", "");
                                                        anArray.set(2, Double.NaN);
                                                        Test.ensureEqual(anArray.isDescending(), "DoubleArray isn't sorted in descending order: [2]=NaN.", "");
                                                        anArray.set(1, 35.0);
                                                        Test.ensureEqual(anArray.isDescending(), "DoubleArray isn't sorted in descending order: [0]=30.0 < [1]=35.0.", "");
                                                        anArray = new DoubleArray(new double[]{30.0, 35.0, 10.0});
                                                        Test.ensureEqual(anArray.firstTie(), -1L, "");
                                                        anArray.set(1, 30.0);
                                                        Test.ensureEqual(anArray.firstTie(), 0L, "");
                                                        anArray.set(1, Double.NaN);
                                                        Test.ensureEqual(anArray.firstTie(), -1L, "");
                                                        anArray.set(2, Double.NaN);
                                                        Test.ensureEqual(anArray.firstTie(), 1L, "");
                                                        anArray = new DoubleArray();
                                                        for (int i = 5; i < 1000; ++i) {
                                                            anArray.add((double)i / 100.0);
                                                        }
                                                        String2.log("hashcode1=" + anArray.hashCode());
                                                        anArray2 = (DoubleArray)anArray.clone();
                                                        Test.ensureEqual(anArray.hashCode(), anArray2.hashCode(), "");
                                                        anArray.add(0, 2.0);
                                                        Test.ensureTrue(anArray.hashCode() != anArray2.hashCode(), "");
                                                        BitSet bitset = new BitSet();
                                                        anArray = new DoubleArray(new double[]{0.0, 11.0, 22.0, 33.0, 44.0});
                                                        bitset.set(1);
                                                        bitset.set(4);
                                                        anArray.justKeep(bitset);
                                                        Test.ensureEqual(anArray.toString(), "11.0, 44.0", "");
                                                        anArray = new DoubleArray();
                                                        anArray.addString(anArray.minValue());
                                                        anArray.addString(anArray.maxValue());
                                                        Test.ensureEqual(anArray.getString(0), anArray.minValue(), "");
                                                        Test.ensureEqual(anArray.getString(0), "-1.7976931348623157E308", "");
                                                        Test.ensureEqual(anArray.getString(1), anArray.maxValue(), "");
                                                        return;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

