/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.util.String2;
import com.cohort.util.Test;
import java.util.Arrays;

public class NDimensionalIndex {
    protected int[] shape;
    protected long[] factors;
    protected int nDimensions;
    protected long size;
    protected long index;
    protected int[] current;

    public NDimensionalIndex(int[] tShape) {
        this.shape = tShape;
        this.nDimensions = this.shape.length;
        if (this.nDimensions == 0) {
            throw new RuntimeException(String2.ERROR + " in NDimensionalIndex constructor: nDimensions=0.");
        }
        this.factors = new long[this.nDimensions];
        this.size = 1L;
        for (int i = this.nDimensions - 1; i >= 0; --i) {
            if (this.shape[i] < 1) {
                throw new RuntimeException(String2.ERROR + " in NDimensionalIndex constructor: shape=[" + String2.toCSSVString(this.shape) + "] has a value less than 1.");
            }
            this.factors[i] = this.size;
            this.size *= (long)this.shape[i];
        }
        this.current = new int[this.nDimensions];
        this.reset();
    }

    public String toString() {
        return "NDimensionalIndex([" + String2.toCSSVString(this.shape) + "])";
    }

    public void reset() {
        this.index = -1L;
        Arrays.fill(this.current, 0);
        this.current[this.nDimensions - 1] = -1;
    }

    public boolean increment() {
        ++this.index;
        for (int tDimension = this.nDimensions - 1; tDimension >= 0; --tDimension) {
            int n = tDimension;
            this.current[n] = this.current[n] + 1;
            if (this.current[tDimension] < this.shape[tDimension]) {
                return true;
            }
            this.current[tDimension] = 0;
        }
        this.current[0] = this.shape[0];
        return false;
    }

    public boolean incrementCM() {
        if (this.index < 0L) {
            this.index = 0L;
            Arrays.fill(this.current, 0);
            return true;
        }
        for (int tDimension = 0; tDimension < this.nDimensions; ++tDimension) {
            int n = tDimension;
            this.current[n] = this.current[n] + 1;
            if (this.current[tDimension] < this.shape[tDimension]) {
                if (tDimension == 0) {
                    this.index += this.factors[0];
                } else {
                    this.index = 0L;
                    for (int i = 0; i < this.nDimensions; ++i) {
                        this.index += (long)this.current[i] * this.factors[i];
                    }
                }
                return true;
            }
            this.current[tDimension] = 0;
        }
        this.current[0] = this.shape[0];
        this.index = this.size;
        return false;
    }

    public int[] shape() {
        return this.shape;
    }

    public long[] factors() {
        return this.factors;
    }

    public long size() {
        return this.size;
    }

    public int nDimensions() {
        return this.nDimensions;
    }

    public long getIndex() {
        return this.index;
    }

    public int[] getCurrent() {
        return this.current;
    }

    public int[] setIndex(long tIndex) {
        if (tIndex < 0L || tIndex >= this.size) {
            throw new RuntimeException(String2.ERROR + " in NDimensionalIndex.setIndex: tIndex=" + tIndex + " is less than 0 or greater than or equal to size=" + this.size);
        }
        this.index = tIndex;
        for (int i = 0; i < this.nDimensions; ++i) {
            this.current[i] = (int)(tIndex / this.factors[i]);
            tIndex %= this.factors[i];
        }
        return this.current;
    }

    public long setCurrent(int[] tCurrent) {
        this.index = 0L;
        if (tCurrent.length != this.nDimensions) {
            throw new RuntimeException(String2.ERROR + " in NDimensionalIndex.setCurrent: tCurrent.length=" + tCurrent.length + " isn't " + this.nDimensions + ".");
        }
        System.arraycopy(tCurrent, 0, this.current, 0, this.nDimensions);
        for (int i = 0; i < this.nDimensions; ++i) {
            if (tCurrent[i] < 0 || tCurrent[i] >= this.shape[i]) {
                throw new RuntimeException(String2.ERROR + " in NDimensionalIndex.setCurrent: tCurrent=[" + String2.toCSSVString(tCurrent) + "] is invalid for shape=[" + String2.toCSSVString(this.shape) + "].");
            }
            this.index += (long)this.current[i] * this.factors[i];
        }
        return this.index;
    }

    public static void test() throws Exception {
        String2.log("*** NDimensionalIndex.test");
        NDimensionalIndex a = new NDimensionalIndex(new int[]{2, 2, 3});
        Test.ensureEqual(a.size, 12L, "");
        Test.ensureTrue(a.increment(), "0");
        Test.ensureEqual(a.getIndex(), 0L, "0");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 0, 0}, "0");
        Test.ensureTrue(a.increment(), "1");
        Test.ensureEqual(a.getIndex(), 1L, "1");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 0, 1}, "1");
        Test.ensureTrue(a.increment(), "2");
        Test.ensureEqual(a.getIndex(), 2L, "2");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 0, 2}, "2");
        Test.ensureTrue(a.increment(), "3");
        Test.ensureEqual(a.getIndex(), 3L, "3");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 1, 0}, "3");
        Test.ensureTrue(a.increment(), "4");
        Test.ensureEqual(a.getIndex(), 4L, "4");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 1, 1}, "4");
        Test.ensureTrue(a.increment(), "5");
        Test.ensureEqual(a.getIndex(), 5L, "5");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 1, 2}, "5");
        Test.ensureTrue(a.increment(), "6");
        Test.ensureEqual(a.getIndex(), 6L, "6");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 0, 0}, "6");
        Test.ensureTrue(a.increment(), "7");
        Test.ensureEqual(a.getIndex(), 7L, "7");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 0, 1}, "7");
        Test.ensureTrue(a.increment(), "8");
        Test.ensureEqual(a.getIndex(), 8L, "8");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 0, 2}, "8");
        Test.ensureTrue(a.increment(), "9");
        Test.ensureEqual(a.getIndex(), 9L, "9");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 1, 0}, "9");
        Test.ensureTrue(a.increment(), "10");
        Test.ensureEqual(a.getIndex(), 10L, "10");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 1, 1}, "10");
        Test.ensureTrue(a.increment(), "11");
        Test.ensureEqual(a.getIndex(), 11L, "11");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 1, 2}, "11");
        Test.ensureTrue(!a.increment(), "12");
        Test.ensureEqual(a.getIndex(), 12L, "12");
        a.reset();
        Test.ensureTrue(a.increment(), "0");
        Test.ensureEqual(a.getIndex(), 0L, "0");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 0, 0}, "0");
        a.reset();
        Test.ensureTrue(a.incrementCM(), "0");
        Test.ensureEqual(a.getIndex(), 0L, "0");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 0, 0}, "0");
        Test.ensureTrue(a.incrementCM(), "1");
        Test.ensureEqual(a.getIndex(), 6L, "1");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 0, 0}, "1");
        Test.ensureTrue(a.incrementCM(), "2");
        Test.ensureEqual(a.getIndex(), 3L, "2");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 1, 0}, "2");
        Test.ensureTrue(a.incrementCM(), "3");
        Test.ensureEqual(a.getIndex(), 9L, "3");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 1, 0}, "3");
        Test.ensureTrue(a.incrementCM(), "4");
        Test.ensureEqual(a.getIndex(), 1L, "4");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 0, 1}, "4");
        Test.ensureTrue(a.incrementCM(), "5");
        Test.ensureEqual(a.getIndex(), 7L, "5");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 0, 1}, "5");
        Test.ensureTrue(a.incrementCM(), "6");
        Test.ensureEqual(a.getIndex(), 4L, "6");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 1, 1}, "6");
        Test.ensureTrue(a.incrementCM(), "7");
        Test.ensureEqual(a.getIndex(), 10L, "7");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 1, 1}, "7");
        Test.ensureTrue(a.incrementCM(), "8");
        Test.ensureEqual(a.getIndex(), 2L, "8");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 0, 2}, "8");
        Test.ensureTrue(a.incrementCM(), "9");
        Test.ensureEqual(a.getIndex(), 8L, "9");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 0, 2}, "9");
        Test.ensureTrue(a.incrementCM(), "10");
        Test.ensureEqual(a.getIndex(), 5L, "10");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{0, 1, 2}, "10");
        Test.ensureTrue(a.incrementCM(), "11");
        Test.ensureEqual(a.getIndex(), 11L, "11");
        Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 1, 2}, "11");
        Test.ensureTrue(!a.incrementCM(), "12");
        Test.ensureEqual(a.getIndex(), 12L, "12");
        try {
            NDimensionalIndex b = new NDimensionalIndex(new int[0]);
            throw new Exception("");
        }
        catch (Exception e) {
            if (e.toString().indexOf("nDimensions=0") < 0) {
                throw new Exception("originalError=" + e.toString());
            }
            try {
                NDimensionalIndex b = new NDimensionalIndex(new int[]{2, 0});
                throw new Exception("");
            }
            catch (Exception e2) {
                if (e2.toString().indexOf("value less than 1") < 0) {
                    throw new Exception("originalError=" + e2.toString());
                }
                try {
                    a.setIndex(-1L);
                    throw new Exception("");
                }
                catch (Exception e3) {
                    if (e3.toString().indexOf("less than 0") < 0) {
                        throw new Exception("originalError=" + e3.toString());
                    }
                    try {
                        a.setCurrent(new int[]{1, 1});
                        throw new Exception("");
                    }
                    catch (Exception e4) {
                        if (e4.toString().indexOf("isn't 3") < 0) {
                            throw new Exception("originalError=" + e4.toString());
                        }
                        try {
                            a.setCurrent(new int[]{1, -1, 1});
                            throw new Exception("");
                        }
                        catch (Exception e5) {
                            if (e5.toString().indexOf("is invalid") < 0) {
                                throw new Exception("originalError=" + e5.toString());
                            }
                            Test.ensureEqual(a.setCurrent(new int[]{1, 1, 2}), 11L, "");
                            Test.ensureEqual(a.getIndex(), 11L, "");
                            Test.ensureEqual((Object)a.setIndex(9L), (Object)new int[]{1, 1, 0}, "");
                            Test.ensureEqual((Object)a.getCurrent(), (Object)new int[]{1, 1, 0}, "");
                            return;
                        }
                    }
                }
            }
        }
    }
}

