/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.array.ByteArray;
import com.cohort.array.CharArray;
import com.cohort.array.DoubleArray;
import com.cohort.array.FloatArray;
import com.cohort.array.IntArray;
import com.cohort.array.LongArray;
import com.cohort.array.RowComparator;
import com.cohort.array.RowComparatorIgnoreCase;
import com.cohort.array.ShortArray;
import com.cohort.array.StringArray;
import com.cohort.util.File2;
import com.cohort.util.Math2;
import com.cohort.util.SimpleException;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Pattern;

public abstract class PrimitiveArray {
    protected int size = 0;
    public static final int STATS_N = 0;
    public static final int STATS_MIN = 1;
    public static final int STATS_MAX = 2;
    public static final int STATS_SUM = 3;
    public static final int CLASS_INDEX_BYTE = 0;
    public static final int CLASS_INDEX_SHORT = 1;
    public static final int CLASS_INDEX_CHAR = 2;
    public static final int CLASS_INDEX_INT = 3;
    public static final int CLASS_INDEX_LONG = 4;
    public static final int CLASS_INDEX_FLOAT = 5;
    public static final int CLASS_INDEX_DOUBLE = 6;
    public static final int CLASS_INDEX_STRING = 7;
    public static final String REGEX_OP = "=~";
    public static String ArrayAddN = String2.ERROR + " in {0}.addN: n ({1}) < 0.";
    public static String ArrayAppendTables = String2.ERROR + " in PrimitiveArray.append:\n" + "the tables have a different number of columns ({0} != {1}).";
    public static String ArrayDiff = String2.ERROR + ": The PrimitiveArrays differ at [{0}] ({1} != {2}).";
    public static String ArrayDifferentSize = "The other primitiveArray has a different size ({0} != {1}).";
    public static String ArrayDifferentValue = "The other primitiveArray has a different value for [{0}] ({1} != {2}).";
    public static String ArrayDiffString = "old [{0}]={1},\n  new [{0}]={2}.";
    public static String ArrayMissingValue = "missing value";
    public static String ArrayNotAscending = "{0} isn''t sorted in ascending order: {1}.";
    public static String ArrayNotDescending = "{0} isn''t sorted in descending order: {1}.";
    public static String ArrayNotEvenlySpaced = "{0} isn''t evenly spaced: [{1}]={2}, [{3}]={4}, spacing={5}, expected spacing={6}.";
    public static String ArrayRemove = String2.ERROR + " in {0}.remove: index ({1}) >= size ({2}).";
    public static String ArraySubsetStart = String2.ERROR + " in {0}.subset: startIndex={1} must be at least 0.";
    public static String ArraySubsetStride = String2.ERROR + " in {0}.subset: stride={1} must greater than 0.";

    public static PrimitiveArray factory(Object o) {
        if (o instanceof char[][]) {
            char[][] car = (char[][])o;
            int nStrings = car.length;
            StringArray sa = new StringArray(nStrings, false);
            for (int i = 0; i < nStrings; ++i) {
                String s = new String(car[i]);
                int po0 = s.indexOf(0);
                if (po0 >= 0) {
                    s = s.substring(0, po0);
                }
                sa.add(s);
            }
            return sa;
        }
        if (o instanceof double[]) {
            return new DoubleArray((double[])o);
        }
        if (o instanceof float[]) {
            return new FloatArray((float[])o);
        }
        if (o instanceof long[]) {
            return new LongArray((long[])o);
        }
        if (o instanceof int[]) {
            return new IntArray((int[])o);
        }
        if (o instanceof short[]) {
            return new ShortArray((short[])o);
        }
        if (o instanceof byte[]) {
            return new ByteArray((byte[])o);
        }
        if (o instanceof char[]) {
            return new CharArray((char[])o);
        }
        if (o instanceof String[]) {
            return new StringArray((String[])o);
        }
        if (o instanceof Object[]) {
            Object[] oar = (Object[])o;
            int n = oar.length;
            StringArray sa = new StringArray(n, false);
            for (int i = 0; i < n; ++i) {
                sa.add(oar[i].toString());
            }
            return sa;
        }
        if (o == null) {
            throw new IllegalArgumentException(String2.ERROR + " in PrimitiveArray.factory: o is null.");
        }
        throw new IllegalArgumentException(String2.ERROR + " in PrimitiveArray.factory: unexpected object type: " + o.toString());
    }

    public abstract int capacity();

    public Object clone() {
        return this.subset(0, 1, this.size - 1);
    }

    public static PrimitiveArray factory(Class elementClass, int capacity, boolean active) {
        if (elementClass == Double.TYPE) {
            return new DoubleArray(capacity, active);
        }
        if (elementClass == Float.TYPE) {
            return new FloatArray(capacity, active);
        }
        if (elementClass == Long.TYPE) {
            return new LongArray(capacity, active);
        }
        if (elementClass == Integer.TYPE) {
            return new IntArray(capacity, active);
        }
        if (elementClass == Short.TYPE) {
            return new ShortArray(capacity, active);
        }
        if (elementClass == Byte.TYPE) {
            return new ByteArray(capacity, active);
        }
        if (elementClass == Character.TYPE) {
            return new CharArray(capacity, active);
        }
        if (elementClass == String.class) {
            return new StringArray(capacity, active);
        }
        throw new IllegalArgumentException(String2.ERROR + " in PrimitiveArray.factory: unexpected elementClass: " + elementClass);
    }

    public static PrimitiveArray factory(Class elementClass, PrimitiveArray pa) {
        if (elementClass == Double.TYPE) {
            return pa.elementClass() == Double.TYPE ? pa : new DoubleArray(pa);
        }
        if (elementClass == Float.TYPE) {
            return pa.elementClass() == Float.TYPE ? pa : new FloatArray(pa);
        }
        if (elementClass == Long.TYPE) {
            return pa.elementClass() == Long.TYPE ? pa : new LongArray(pa);
        }
        if (elementClass == Integer.TYPE) {
            return pa.elementClass() == Integer.TYPE ? pa : new IntArray(pa);
        }
        if (elementClass == Short.TYPE) {
            return pa.elementClass() == Short.TYPE ? pa : new ShortArray(pa);
        }
        if (elementClass == Byte.TYPE) {
            return pa.elementClass() == Byte.TYPE ? pa : new ByteArray(pa);
        }
        if (elementClass == Character.TYPE) {
            return pa.elementClass() == Character.TYPE ? pa : new CharArray(pa);
        }
        if (elementClass == String.class) {
            return pa.elementClass() == String.class ? pa : new StringArray(pa);
        }
        throw new IllegalArgumentException(String2.ERROR + " in PrimitiveArray.factory: unexpected elementClass: " + elementClass);
    }

    public static PrimitiveArray factory(Class elementClass, int size, String constantValue) {
        Test.ensureNotNull(constantValue, String2.ERROR + " in PrimitiveArray.factory: constantValue is null.");
        if (elementClass == Double.TYPE) {
            Math2.ensureMemoryAvailable((long)size * 8L, "PrimitiveArray.factory(double, " + size + ")");
            double[] ar = new double[size];
            Arrays.fill(ar, String2.parseDouble(constantValue));
            return new DoubleArray(ar);
        }
        if (elementClass == Float.TYPE) {
            Math2.ensureMemoryAvailable((long)size * 4L, "PrimitiveArray.factory(float, " + size + ")");
            float[] ar = new float[size];
            Arrays.fill(ar, String2.parseFloat(constantValue));
            return new FloatArray(ar);
        }
        if (elementClass == Long.TYPE) {
            Math2.ensureMemoryAvailable((long)size * 8L, "PrimitiveArray.factory(long, " + size + ")");
            long[] ar = new long[size];
            Arrays.fill(ar, String2.parseLong(constantValue));
            return new LongArray(ar);
        }
        if (elementClass == Integer.TYPE) {
            Math2.ensureMemoryAvailable((long)size * 4L, "PrimitiveArray.factory(int, " + size + ")");
            int[] ar = new int[size];
            Arrays.fill(ar, String2.parseInt(constantValue));
            return new IntArray(ar);
        }
        if (elementClass == Short.TYPE) {
            Math2.ensureMemoryAvailable((long)size * 2L, "PrimitiveArray.factory(short, " + size + ")");
            short[] ar = new short[size];
            Arrays.fill(ar, Math2.roundToShort(String2.parseInt(constantValue)));
            return new ShortArray(ar);
        }
        if (elementClass == Byte.TYPE) {
            Math2.ensureMemoryAvailable(size, "PrimitiveArray.factory(byte, " + size + ")");
            byte[] ar = new byte[size];
            Arrays.fill(ar, Math2.roundToByte(String2.parseInt(constantValue)));
            return new ByteArray(ar);
        }
        if (elementClass == Character.TYPE) {
            Math2.ensureMemoryAvailable((long)size * 2L, "PrimitiveArray.factory(char, " + size + ")");
            char[] ar = new char[size];
            Arrays.fill(ar, constantValue.charAt(0));
            return new CharArray(ar);
        }
        if (elementClass == String.class) {
            Math2.ensureMemoryAvailable((long)size * 8L, "PrimitiveArray.factory(String, " + size + ")");
            Object[] ar = new String[size];
            Arrays.fill(ar, constantValue);
            return new StringArray((String[])ar);
        }
        throw new IllegalArgumentException(String2.ERROR + " in PrimitiveArray.factory: unexpected elementClass: " + elementClass);
    }

    public static PrimitiveArray csvFactory(Class elementClass, String csv) {
        String[] sa = StringArray.arrayFromCSV(csv);
        if (elementClass == String.class) {
            return new StringArray(sa);
        }
        int n = sa.length;
        PrimitiveArray pa = PrimitiveArray.factory(elementClass, n, false);
        for (int i = 0; i < n; ++i) {
            pa.addString(sa[i]);
        }
        return pa;
    }

    public static PrimitiveArray ssvFactory(Class elementClass, String ssv) {
        StringArray sa = StringArray.wordsAndQuotedPhrases(ssv);
        if (elementClass == String.class) {
            return sa;
        }
        int n = sa.size();
        PrimitiveArray pa = PrimitiveArray.factory(elementClass, n, false);
        for (int i = 0; i < n; ++i) {
            pa.addString(sa.get(i));
        }
        return pa;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public abstract Class elementClass();

    public String elementClassString() {
        return PrimitiveArray.elementClassToString(this.elementClass());
    }

    public static String elementClassToString(Class type) {
        if (type == Double.TYPE) {
            return "double";
        }
        if (type == Float.TYPE) {
            return "float";
        }
        if (type == Long.TYPE) {
            return "long";
        }
        if (type == Integer.TYPE) {
            return "int";
        }
        if (type == Short.TYPE) {
            return "short";
        }
        if (type == Byte.TYPE) {
            return "byte";
        }
        if (type == Character.TYPE) {
            return "char";
        }
        if (type == String.class) {
            return "String";
        }
        throw new IllegalArgumentException("PrimitiveArray.elementClassToString unsupported type: " + type.toString());
    }

    public static Class elementStringToClass(String type) {
        if (type.equals("double")) {
            return Double.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("char")) {
            return Character.TYPE;
        }
        if (type.equals("String")) {
            return String.class;
        }
        throw new IllegalArgumentException("PrimitiveArray.elementStringToType unsupported type: " + type);
    }

    public static int elementSize(String type) {
        if (type.equals("double")) {
            return 8;
        }
        if (type.equals("float")) {
            return 4;
        }
        if (type.equals("long")) {
            return 8;
        }
        if (type.equals("int")) {
            return 4;
        }
        if (type.equals("short")) {
            return 2;
        }
        if (type.equals("byte")) {
            return 1;
        }
        if (type.equals("char")) {
            return 2;
        }
        if (type.equals("String")) {
            return 20;
        }
        throw new IllegalArgumentException("PrimitiveArray.sizeOf unsupported type: " + type);
    }

    public static int elementSize(Class type) {
        return PrimitiveArray.elementSize(PrimitiveArray.elementClassToString(type));
    }

    public int elementSize() {
        return PrimitiveArray.elementSize(this.elementClassString());
    }

    public static String classToEsriPixelType(Class tClass) {
        if (tClass == Double.TYPE) {
            return "F64";
        }
        if (tClass == Float.TYPE) {
            return "F32";
        }
        if (tClass == Long.TYPE) {
            return "F64";
        }
        if (tClass == Integer.TYPE) {
            return "S32";
        }
        if (tClass == Short.TYPE) {
            return "S16";
        }
        if (tClass == Byte.TYPE) {
            return "S8";
        }
        if (tClass == Character.TYPE) {
            return "U16";
        }
        return "UNKNOWN";
    }

    public String getSqlTypeString(double stringLengthFactor) {
        Class type = this.elementClass();
        if (type == Double.TYPE) {
            return "double precision";
        }
        if (type == Float.TYPE) {
            return "real";
        }
        if (type == Long.TYPE) {
            return "bigint";
        }
        if (type == Integer.TYPE) {
            return "integer";
        }
        if (type == Short.TYPE) {
            return "smallint";
        }
        if (type == Byte.TYPE) {
            return "smallint";
        }
        if (type == Character.TYPE) {
            return "char(1)";
        }
        if (type == String.class) {
            StringArray sa = (StringArray)this;
            int max = Math.max(1, sa.maxStringLength());
            if (stringLengthFactor > 1.0) {
                max = Math2.roundToInt((double)max * stringLengthFactor);
                max = Math2.hiDiv(max, 10) * 10;
            }
            return "varchar(" + max + ")";
        }
        throw new IllegalArgumentException(String2.ERROR + " in PrimitiveArray.getSqlTypeString: unexpected type: " + type.toString());
    }

    public static PrimitiveArray sqlFactory(int sqlType) {
        if (sqlType == -7 || sqlType == 16 || sqlType == -6) {
            return new ByteArray();
        }
        if (sqlType == 5) {
            return new ShortArray();
        }
        if (sqlType == 4) {
            return new IntArray();
        }
        if (sqlType == -5) {
            return new LongArray();
        }
        if (sqlType == 7) {
            return new FloatArray();
        }
        if (sqlType == 6 || sqlType == 8 || sqlType == 3 || sqlType == 2) {
            return new DoubleArray();
        }
        if (sqlType == 91 || sqlType == 93) {
            return new DoubleArray();
        }
        return new StringArray();
    }

    public static boolean isIntegerType(Class type) {
        return type == Long.TYPE || type == Integer.TYPE || type == Short.TYPE || type == Byte.TYPE || type == Character.TYPE;
    }

    public static double getMissingValue(Class type) {
        if (type == Double.TYPE) {
            return Double.NaN;
        }
        if (type == Float.TYPE) {
            return Double.NaN;
        }
        if (type == Long.TYPE) {
            return 9.223372036854776E18;
        }
        if (type == Integer.TYPE) {
            return 2.147483647E9;
        }
        if (type == Short.TYPE) {
            return 32767.0;
        }
        if (type == Byte.TYPE) {
            return 127.0;
        }
        if (type == Character.TYPE) {
            return 65535.0;
        }
        if (type == String.class) {
            return Double.NaN;
        }
        return Double.NaN;
    }

    public abstract int elementClassIndex();

    public abstract void addString(int var1, String var2);

    public abstract void addString(String var1);

    public abstract void addNStrings(int var1, String var2);

    public abstract void addFloat(float var1);

    public abstract void addDouble(double var1);

    public abstract void addNDoubles(int var1, double var2);

    public abstract void addInt(int var1);

    public abstract void addNInts(int var1, int var2);

    public abstract void addLong(long var1);

    public abstract void addFromPA(PrimitiveArray var1, int var2);

    public abstract void setFromPA(int var1, PrimitiveArray var2, int var3);

    public abstract void remove(int var1);

    public abstract void removeRange(int var1, int var2);

    public abstract void move(int var1, int var2, int var3);

    public abstract void justKeep(BitSet var1);

    public abstract void ensureCapacity(long var1);

    public abstract Object toObjectArray();

    public abstract double[] toDoubleArray();

    public abstract String[] toStringArray();

    public abstract int getInt(int var1);

    public abstract void setInt(int var1, int var2);

    public abstract long getLong(int var1);

    public abstract void setLong(int var1, long var2);

    public abstract float getFloat(int var1);

    public abstract void setFloat(int var1, float var2);

    public abstract double getDouble(int var1);

    public double getNiceDouble(int index) {
        return this.getDouble(index);
    }

    public abstract void setDouble(int var1, double var2);

    public abstract String getString(int var1);

    public abstract void setString(int var1, String var2);

    public abstract int indexOf(String var1, int var2);

    public int indexOf(String lookFor) {
        return this.indexOf(lookFor, 0);
    }

    public abstract int lastIndexOf(String var1, int var2);

    public int lastIndexOf(String lookFor) {
        return this.lastIndexOf(lookFor, this.size() - 1);
    }

    public abstract void trimToSize();

    public String toCSVString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getString(i));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getString(i));
        }
        return sb.toString();
    }

    public String toJsonCsvString() {
        return this.toString();
    }

    public abstract void sort();

    public void sortIgnoreCase() {
        this.sort();
    }

    public double[] calculateStats() {
        long time = System.currentTimeMillis();
        int n = 0;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double d = this.getDouble(i);
            if (!Math2.isFinite(d)) continue;
            ++n;
            min = Math.min(min, d);
            max = Math.max(max, d);
            sum += d;
        }
        if (n == 0) {
            min = Double.NaN;
            max = Double.NaN;
        }
        return new double[]{n, min, max, sum};
    }

    public static String displayStats(double[] stats) {
        return "n=" + String2.right(String2.genEFormat6(stats[0]), 7) + " min=" + String2.right(String2.genEFormat6(stats[1]), 15) + " max=" + String2.right(String2.genEFormat6(stats[2]), 15);
    }

    public String statsString() {
        double[] stats = this.calculateStats();
        return "nNaN=" + String2.right(String2.genEFormat6((double)this.size() - stats[0]), 7) + " " + PrimitiveArray.displayStats(stats);
    }

    public abstract int compare(int var1, int var2);

    public int compareIgnoreCase(int index1, int index2) {
        return this.compare(index1, index2);
    }

    public abstract void copy(int var1, int var2);

    public abstract void reorder(int[] var1);

    public void reverse() {
        int[] rank = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            rank[this.size - 1 - i] = i;
        }
        this.reorder(rank);
    }

    public int writeDos(DataOutputStream dos) throws Exception {
        int nb = 0;
        for (int i = 0; i < this.size; ++i) {
            nb = this.writeDos(dos, i);
        }
        return nb;
    }

    public abstract int writeDos(DataOutputStream var1, int var2) throws Exception;

    public abstract void readDis(DataInputStream var1, int var2) throws Exception;

    public void externalizeForDODS(DataOutputStream dos) throws Exception {
        dos.writeInt(this.size);
        dos.writeInt(this.size);
        this.writeDos(dos);
    }

    public void externalizeForDODS(DataOutputStream dos, int i) throws Exception {
        this.writeDos(dos, i);
    }

    public abstract void internalizeFromDODS(DataInputStream var1) throws IOException;

    public static PrimitiveArray rafFactory(RandomAccessFile raf, Class type, long start, long startIndex, long endIndex) throws Exception {
        long longN = endIndex - startIndex;
        String cause = "PrimitiveArray.rafFactory";
        Math2.ensureArraySizeOkay(longN, cause);
        int n = (int)longN;
        if (type == Byte.TYPE) {
            int nBytesPer = 1;
            byte[] tar = new byte[n];
            Math2.ensureMemoryAvailable((long)nBytesPer * longN, cause);
            raf.seek(start + (long)nBytesPer * startIndex);
            for (int i = 0; i < n; ++i) {
                tar[i] = raf.readByte();
            }
            return PrimitiveArray.factory(tar);
        }
        if (type == Character.TYPE) {
            int nBytesPer = 2;
            char[] tar = new char[n];
            Math2.ensureMemoryAvailable((long)nBytesPer * longN, cause);
            raf.seek(start + (long)nBytesPer * startIndex);
            for (int i = 0; i < n; ++i) {
                tar[i] = raf.readChar();
            }
            return PrimitiveArray.factory(tar);
        }
        if (type == Double.TYPE) {
            int nBytesPer = 8;
            double[] tar = new double[n];
            Math2.ensureMemoryAvailable((long)nBytesPer * longN, cause);
            raf.seek(start + (long)nBytesPer * startIndex);
            for (int i = 0; i < n; ++i) {
                tar[i] = raf.readDouble();
            }
            return PrimitiveArray.factory(tar);
        }
        if (type == Float.TYPE) {
            int nBytesPer = 4;
            float[] tar = new float[n];
            Math2.ensureMemoryAvailable((long)nBytesPer * longN, cause);
            raf.seek(start + (long)nBytesPer * startIndex);
            for (int i = 0; i < n; ++i) {
                tar[i] = raf.readFloat();
            }
            return PrimitiveArray.factory(tar);
        }
        if (type == Integer.TYPE) {
            int nBytesPer = 4;
            int[] tar = new int[n];
            Math2.ensureMemoryAvailable((long)nBytesPer * longN, cause);
            raf.seek(start + (long)nBytesPer * startIndex);
            for (int i = 0; i < n; ++i) {
                tar[i] = raf.readInt();
            }
            return PrimitiveArray.factory(tar);
        }
        if (type == Byte.TYPE) {
            int nBytesPer = 8;
            long[] tar = new long[n];
            Math2.ensureMemoryAvailable((long)nBytesPer * longN, cause);
            raf.seek(start + (long)nBytesPer * startIndex);
            for (int i = 0; i < n; ++i) {
                tar[i] = raf.readLong();
            }
            return PrimitiveArray.factory(tar);
        }
        if (type == Byte.TYPE) {
            int nBytesPer = 2;
            short[] tar = new short[n];
            Math2.ensureMemoryAvailable((long)nBytesPer * longN, cause);
            raf.seek(start + (long)nBytesPer * startIndex);
            for (int i = 0; i < n; ++i) {
                tar[i] = raf.readShort();
            }
            return PrimitiveArray.factory(tar);
        }
        throw new Exception("PrimitiveArray.rafFactory type '" + type + "' not supported.");
    }

    public static double rafReadDouble(RandomAccessFile raf, Class type, long start, long index) throws Exception {
        if (type == Byte.TYPE) {
            return ByteArray.rafReadDouble(raf, start, index);
        }
        if (type == Character.TYPE) {
            return CharArray.rafReadDouble(raf, start, index);
        }
        if (type == Double.TYPE) {
            return DoubleArray.rafReadDouble(raf, start, index);
        }
        if (type == Float.TYPE) {
            return FloatArray.rafReadDouble(raf, start, index);
        }
        if (type == Integer.TYPE) {
            return IntArray.rafReadDouble(raf, start, index);
        }
        if (type == Long.TYPE) {
            return LongArray.rafReadDouble(raf, start, index);
        }
        if (type == Short.TYPE) {
            return ShortArray.rafReadDouble(raf, start, index);
        }
        throw new Exception("PrimitiveArray.rafReadDouble type '" + type + "' not supported.");
    }

    public static void rafWriteDouble(RandomAccessFile raf, Class type, double value) throws Exception {
        if (type == Byte.TYPE) {
            raf.writeByte(Math2.roundToByte(value));
            return;
        }
        if (type == Character.TYPE) {
            raf.writeChar(Math2.roundToChar(value));
            return;
        }
        if (type == Double.TYPE) {
            raf.writeDouble(value);
            return;
        }
        if (type == Float.TYPE) {
            raf.writeFloat(Math2.doubleToFloatNaN(value));
            return;
        }
        if (type == Integer.TYPE) {
            raf.writeInt(Math2.roundToInt(value));
            return;
        }
        if (type == Long.TYPE) {
            raf.writeLong(Math2.roundToLong(value));
            return;
        }
        if (type == Short.TYPE) {
            raf.writeShort(Math2.roundToShort(value));
            return;
        }
        throw new Exception("PrimitiveArray.rafWriteDouble type '" + type + "' not supported.");
    }

    public static void rafWriteDouble(RandomAccessFile raf, Class type, long start, long index, double value) throws Exception {
        if (type == Byte.TYPE) {
            ByteArray.rafWriteDouble(raf, start, index, value);
            return;
        }
        if (type == Character.TYPE) {
            CharArray.rafWriteDouble(raf, start, index, value);
            return;
        }
        if (type == Double.TYPE) {
            DoubleArray.rafWriteDouble(raf, start, index, value);
            return;
        }
        if (type == Float.TYPE) {
            FloatArray.rafWriteDouble(raf, start, index, value);
            return;
        }
        if (type == Integer.TYPE) {
            IntArray.rafWriteDouble(raf, start, index, value);
            return;
        }
        if (type == Long.TYPE) {
            LongArray.rafWriteDouble(raf, start, index, value);
            return;
        }
        if (type == Short.TYPE) {
            ShortArray.rafWriteDouble(raf, start, index, value);
            return;
        }
        throw new Exception("PrimitiveArray.rafWriteDouble type '" + type + "' not supported.");
    }

    public abstract String testEquals(Object var1);

    public String almostEqual(PrimitiveArray other) {
        if (this.size != other.size()) {
            return MessageFormat.format(ArrayDifferentSize, "" + this.size, "" + other.size());
        }
        if (this instanceof StringArray || other instanceof StringArray) {
            for (int i = 0; i < this.size; ++i) {
                String s1 = this.getString(i);
                String s2 = other.getString(i);
                if (s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2)) continue;
                return MessageFormat.format(ArrayDifferentValue, "" + i, String2.toJson(s1), String2.toJson(s2));
            }
            return "";
        }
        if (this instanceof LongArray && other instanceof LongArray) {
            for (int i = 0; i < this.size; ++i) {
                if (Test.equal(this.getLong(i), other.getLong(i))) continue;
                return MessageFormat.format(ArrayDifferentValue, "" + i, "" + this.getLong(i), "" + other.getLong(i));
            }
            return "";
        }
        if (this instanceof DoubleArray || this instanceof LongArray || other instanceof DoubleArray || other instanceof LongArray) {
            for (int i = 0; i < this.size; ++i) {
                if (Test.equal(this.getDouble(i), other.getDouble(i))) continue;
                return MessageFormat.format(ArrayDifferentValue, "" + i, "" + this.getDouble(i), "" + other.getDouble(i));
            }
            return "";
        }
        if (this instanceof FloatArray || other instanceof FloatArray) {
            for (int i = 0; i < this.size; ++i) {
                if (Test.equal(this.getFloat(i), other.getFloat(i))) continue;
                return MessageFormat.format(ArrayDifferentValue, "" + i, "" + this.getFloat(i), "" + other.getFloat(i));
            }
            return "";
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.getInt(i) == other.getInt(i)) continue;
            return MessageFormat.format(ArrayDifferentValue, "" + i, "" + this.getInt(i), "" + other.getInt(i));
        }
        return "";
    }

    public static long rafBinarySearch(RandomAccessFile raf, Class type, long start, long lowPo, long highPo, double value) throws Exception {
        Test.ensureTrue(lowPo <= highPo, String2.ERROR + "in PrimitiveArray.rafBinarySearch: lowPo > highPo.");
        double tValue = PrimitiveArray.rafReadDouble(raf, type, start, lowPo);
        if (tValue == value) {
            return lowPo;
        }
        if (tValue > value) {
            return -lowPo - 1L;
        }
        tValue = PrimitiveArray.rafReadDouble(raf, type, start, highPo);
        if (tValue == value) {
            return highPo;
        }
        if (tValue < value) {
            return -(highPo + 1L) - 1L;
        }
        while (highPo - lowPo > 1L) {
            long midPo = (highPo + lowPo) / 2L;
            tValue = PrimitiveArray.rafReadDouble(raf, type, start, midPo);
            if (tValue == value) {
                return midPo;
            }
            if (tValue < value) {
                lowPo = midPo;
                continue;
            }
            highPo = midPo;
        }
        return -highPo - 1L;
    }

    public static long rafFirstGE(RandomAccessFile raf, Class type, long start, long lowPo, long highPo, double value) throws Exception {
        if (lowPo > highPo) {
            return highPo + 1L;
        }
        long po = PrimitiveArray.rafBinarySearch(raf, type, start, lowPo, highPo, value);
        if (po >= 0L) {
            while (po > lowPo && PrimitiveArray.rafReadDouble(raf, type, start, po - 1L) == value) {
                --po;
            }
            return po;
        }
        return -po - 1L;
    }

    public static long rafFirstGAE5(RandomAccessFile raf, Class type, long start, long lowPo, long highPo, double value) throws Exception {
        if (lowPo > highPo) {
            return highPo + 1L;
        }
        long po = PrimitiveArray.rafBinarySearch(raf, type, start, lowPo, highPo, value);
        if (po < 0L) {
            po = -po - 1L;
        }
        while (po > lowPo && Math2.almostEqual(5, PrimitiveArray.rafReadDouble(raf, type, start, po - 1L), value)) {
            --po;
        }
        return po;
    }

    public static long rafLastLE(RandomAccessFile raf, Class type, long start, long lowPo, long highPo, double value) throws Exception {
        if (lowPo > highPo) {
            return -1L;
        }
        long po = PrimitiveArray.rafBinarySearch(raf, type, start, lowPo, highPo, value);
        if (po >= 0L) {
            while (po < highPo && PrimitiveArray.rafReadDouble(raf, type, start, po + 1L) == value) {
                ++po;
            }
            return po;
        }
        return -po - 1L - 1L;
    }

    public static long rafLastLAE5(RandomAccessFile raf, Class type, long start, long lowPo, long highPo, double value) throws Exception {
        if (lowPo > highPo) {
            return -1L;
        }
        long po = PrimitiveArray.rafBinarySearch(raf, type, start, lowPo, highPo, value);
        if (po < 0L) {
            po = -po - 1L - 1L;
        }
        while (po < highPo && Math2.almostEqual(5, PrimitiveArray.rafReadDouble(raf, type, start, po + 1L), value)) {
            ++po;
        }
        return po;
    }

    public int binarySearch(int lowPo, int highPo, double value) {
        Test.ensureTrue(lowPo <= highPo, String2.ERROR + " in PrimitiveArray.binarySearch: lowPo > highPo.");
        double tValue = this.getDouble(lowPo);
        if (tValue == value) {
            return lowPo;
        }
        if (tValue > value) {
            return -lowPo - 1;
        }
        tValue = this.getDouble(highPo);
        if (tValue == value) {
            return highPo;
        }
        if (tValue < value) {
            return -(highPo + 1) - 1;
        }
        while (highPo - lowPo > 1) {
            int midPo = (highPo + lowPo) / 2;
            tValue = this.getDouble(midPo);
            if (tValue == value) {
                return midPo;
            }
            if (tValue < value) {
                lowPo = midPo;
                continue;
            }
            highPo = midPo;
        }
        return -highPo - 1;
    }

    public int binaryFindFirstGE(int lowPo, int highPo, double value) {
        if (lowPo > highPo) {
            return highPo + 1;
        }
        int po = this.binarySearch(lowPo, highPo, value);
        if (po >= 0) {
            while (po > lowPo && this.getDouble(po - 1) == value) {
                --po;
            }
            return po;
        }
        return -po - 1;
    }

    public int binaryFindFirstGAE5(int lowPo, int highPo, double value) {
        if (lowPo > highPo) {
            return highPo + 1;
        }
        int po = this.binarySearch(lowPo, highPo, value);
        if (po < 0) {
            po = -po - 1;
        }
        while (po > lowPo && Math2.almostEqual(5, this.getDouble(po - 1), value)) {
            --po;
        }
        return po;
    }

    public int binaryFindLastLE(int lowPo, int highPo, double value) {
        if (lowPo > highPo) {
            return -1;
        }
        int po = this.binarySearch(lowPo, highPo, value);
        if (po >= 0) {
            while (po < highPo && this.getDouble(po + 1) == value) {
                ++po;
            }
            return po;
        }
        return -po - 1 - 1;
    }

    public int binaryFindLastLAE5(int lowPo, int highPo, double value) {
        if (lowPo > highPo) {
            return -1;
        }
        int po = this.binarySearch(lowPo, highPo, value);
        if (po < 0) {
            po = -po - 1 - 1;
        }
        while (po < highPo && Math2.almostEqual(5, this.getDouble(po + 1), value)) {
            ++po;
        }
        return po;
    }

    public int binaryFindClosest(double x) {
        if (Double.isNaN(x)) {
            return -1;
        }
        int i = this.binarySearch(0, this.size - 1, x);
        if (i >= 0) {
            return i;
        }
        int insertionPoint = -i - 1;
        if (insertionPoint == 0) {
            return 0;
        }
        if (insertionPoint >= this.size) {
            return this.size - 1;
        }
        if (Math.abs(this.getDouble(insertionPoint - 1) - x) < Math.abs(this.getDouble(insertionPoint) - x)) {
            return insertionPoint - 1;
        }
        return insertionPoint;
    }

    public int linearFindClosest(double x) {
        if (Double.isNaN(x)) {
            return -1;
        }
        double diff = Double.MAX_VALUE;
        int which = -1;
        for (int i = 0; i < this.size; ++i) {
            double tDiff = Math.abs(this.getDouble(i) - x);
            if (!(tDiff < diff)) continue;
            diff = tDiff;
            which = i;
        }
        return which;
    }

    public PrimitiveArray simplify() {
        int type = 0;
        int n = this.size();
        boolean isStringArray = this instanceof StringArray;
        double[] dar = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            dar[i] = d = this.getDouble(i);
            if (isStringArray) {
                String s = this.getString(i);
                if (s == null || s.equals(".") || s.equals("") || s.equals("NaN")) continue;
                if (s.length() >= 2 && s.charAt(0) == '0' && s.charAt(1) >= '0' && s.charAt(1) <= '9') {
                    return this;
                }
                if (Double.isNaN(d)) {
                    return this;
                }
                if (s.indexOf(46) >= 0) {
                    type = Math.max(type, 4);
                }
            }
            if (Double.isNaN(d)) continue;
            if (type == 0 && (d != Math.rint(d) || d < -128.0 || d > 127.0)) {
                ++type;
                if (this instanceof CharArray || this instanceof ShortArray) {
                    return this;
                }
            }
            if (type == 1 && (d != Math.rint(d) || d < -32768.0 || d > 32767.0)) {
                ++type;
                if (this instanceof IntArray) {
                    return this;
                }
            }
            if (type == 2 && (d != Math.rint(d) || d < -2.147483648E9 || d > 2.147483647E9)) {
                ++type;
                if (this instanceof LongArray) {
                    return this;
                }
            }
            if (type == 3 && (d != (double)Math.round(d) || d < -9.223372036854776E18 || d > 9.223372036854776E18)) {
                ++type;
                if (this instanceof FloatArray) {
                    return this;
                }
            }
            if (type != 4 || !(d < -3.4028234663852886E38) && !(d > 3.4028234663852886E38) && d == Math2.niceDouble(d, 7)) continue;
            ++type;
            if (!(this instanceof DoubleArray)) continue;
            return this;
        }
        if (type == 0) {
            byte[] array = new byte[n];
            for (int i = 0; i < n; ++i) {
                array[i] = Math2.roundToByte(dar[i]);
            }
            return new ByteArray(array);
        }
        if (type == 1) {
            short[] array = new short[n];
            for (int i = 0; i < n; ++i) {
                array[i] = Math2.roundToShort(dar[i]);
            }
            return new ShortArray(array);
        }
        if (type == 2) {
            int[] array = new int[n];
            for (int i = 0; i < n; ++i) {
                array[i] = Math2.roundToInt(dar[i]);
            }
            return new IntArray(array);
        }
        if (type == 3) {
            if (isStringArray) {
                return this;
            }
            return new StringArray(this);
        }
        if (type == 4) {
            float[] array = new float[n];
            for (int i = 0; i < n; ++i) {
                array[i] = (float)dar[i];
            }
            return new FloatArray(array);
        }
        if (type == 5) {
            return new DoubleArray(dar);
        }
        throw new IllegalArgumentException(String2.ERROR + " in PrimitiveArray.simplify: unknown type (" + type + ").");
    }

    public abstract void append(PrimitiveArray var1);

    public static int[] rank(List table, int[] keys, boolean[] ascending) {
        return PrimitiveArray.lowRank(new RowComparator(table, keys, ascending), table);
    }

    public static int[] rankIgnoreCase(List table, int[] keys, boolean[] ascending) {
        return PrimitiveArray.lowRank(new RowComparatorIgnoreCase(table, keys, ascending), table);
    }

    private static int[] lowRank(RowComparator comparator, List table) {
        int n = ((PrimitiveArray)table.get(0)).size();
        Integer[] rowArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            rowArray[i] = new Integer(i);
        }
        Arrays.sort(rowArray, comparator);
        int[] newArray = new int[n];
        for (int i = 0; i < n; ++i) {
            newArray[i] = rowArray[i];
        }
        return newArray;
    }

    public static void sort(List table, int[] keys, boolean[] ascending) {
        int[] ranks = PrimitiveArray.rank(table, keys, ascending);
        for (int col = 0; col < table.size(); ++col) {
            ((PrimitiveArray)table.get(col)).reorder(ranks);
        }
    }

    public static void sortIgnoreCase(List table, int[] keys, boolean[] ascending) {
        int[] ranks = PrimitiveArray.rankIgnoreCase(table, keys, ascending);
        for (int col = 0; col < table.size(); ++col) {
            ((PrimitiveArray)table.get(col)).reorder(ranks);
        }
    }

    public static void copyRow(List table, int from, int to) {
        int nColumns = table.size();
        for (int col = 0; col < nColumns; ++col) {
            ((PrimitiveArray)table.get(col)).copy(from, to);
        }
    }

    public int removeDuplicates() {
        return this.removeDuplicates(false);
    }

    public int removeDuplicates(boolean logDuplicates) {
        int nRows = this.size;
        if (nRows <= 1) {
            return 0;
        }
        int nUnique = 1;
        for (int row = 1; row < nRows; ++row) {
            boolean equal;
            boolean bl = equal = this.compare(row - 1, row) == 0;
            if (equal) {
                if (!logDuplicates) continue;
                String2.log("  duplicate=" + this.getString(row));
                continue;
            }
            if (row != nUnique) {
                this.copy(row, nUnique);
            }
            ++nUnique;
        }
        this.removeRange(nUnique, nRows);
        return nRows - nUnique;
    }

    public static int removeDuplicates(List table) {
        int nRows = ((PrimitiveArray)table.get(0)).size();
        if (nRows <= 1) {
            return 0;
        }
        int nColumns = table.size();
        int nUnique = 1;
        for (int row = 1; row < nRows; ++row) {
            int col;
            boolean equal = true;
            for (col = 0; col < nColumns; ++col) {
                if (((PrimitiveArray)table.get(col)).compare(row - 1, row) == 0) continue;
                equal = false;
                break;
            }
            if (equal) continue;
            if (row != nUnique) {
                for (col = 0; col < nColumns; ++col) {
                    ((PrimitiveArray)table.get(col)).copy(row, nUnique);
                }
            }
            ++nUnique;
        }
        for (int col = 0; col < nColumns; ++col) {
            ((PrimitiveArray)table.get(col)).removeRange(nUnique, nRows);
        }
        return nRows - nUnique;
    }

    public void inCommon(PrimitiveArray pa2) {
        boolean isNumeric2;
        int size1 = this.size;
        int size2 = pa2.size();
        int po1 = 0;
        int po2 = 0;
        BitSet keep1 = new BitSet(size1);
        keep1.set(0, size1, false);
        boolean isNumeric1 = !(this instanceof StringArray);
        boolean bl = isNumeric2 = !(pa2 instanceof StringArray);
        while (po1 < size1 && po2 < size2) {
            int compare;
            String s1 = this.getString(po1);
            String s2 = pa2.getString(po2);
            if (isNumeric1) {
                if (s1.length() == 0) {
                    s1 = "NaN";
                }
            } else if (s1 == null) {
                if (s2 == null) {
                    keep1.set(po1);
                    ++po1;
                    ++po2;
                    continue;
                }
                ++po1;
                continue;
            }
            if (isNumeric2) {
                if (s2.length() == 0) {
                    s2 = "NaN";
                }
            } else if (s2 == null) {
                ++po2;
                continue;
            }
            if ((compare = s1.compareTo(s2)) < 0) {
                ++po1;
                continue;
            }
            if (compare > 0) {
                ++po2;
                continue;
            }
            keep1.set(po1);
            ++po1;
            ++po2;
        }
        this.justKeep(keep1);
    }

    public static int ensureAscending(List table, int column) {
        PrimitiveArray columnPA = (PrimitiveArray)table.get(column);
        int nRows = columnPA.size();
        int nColumns = table.size();
        int nGood = 0;
        double lastGood = -1.7976931348623157E308;
        for (int row = 0; row < nRows; ++row) {
            double d = columnPA.getDouble(row);
            if (!Math2.isFinite(d) || !(d < 1.0E300) || !(d >= lastGood)) continue;
            if (row != nGood) {
                for (int col = 0; col < nColumns; ++col) {
                    ((PrimitiveArray)table.get(col)).copy(row, nGood);
                }
            }
            ++nGood;
            lastGood = d;
        }
        for (int col = 0; col < nColumns; ++col) {
            ((PrimitiveArray)table.get(col)).removeRange(nGood, nRows);
        }
        int nRemoved = nRows - nGood;
        if (nRemoved > 0) {
            String2.log("PrimitveArray.ensureAscending nRowsRemoved=" + nRemoved + " lastGood=" + lastGood);
        }
        return nRemoved;
    }

    public static void append(List table1, List table2) {
        if (table1.size() != table2.size()) {
            throw new RuntimeException(MessageFormat.format(ArrayAppendTables, "" + table1.size(), "" + table2.size()));
        }
        for (int col = 0; col < table1.size(); ++col) {
            if (((PrimitiveArray)table2.get(col)).elementClassIndex() > ((PrimitiveArray)table1.get(col)).elementClassIndex()) {
                PrimitiveArray oldTable1Col = (PrimitiveArray)table1.get(col);
                PrimitiveArray newTable1Col = PrimitiveArray.factory(((PrimitiveArray)table2.get(col)).elementClass(), oldTable1Col.size() + ((PrimitiveArray)table2.get(col)).size(), false);
                newTable1Col.append(oldTable1Col);
                table1.set(col, newTable1Col);
            }
            ((PrimitiveArray)table1.get(col)).append((PrimitiveArray)table2.get(col));
        }
    }

    public static void merge(List table1, List table2, int[] keys, boolean[] ascending, boolean removeDuplicates) {
        PrimitiveArray.append(table1, table2);
        PrimitiveArray.sort(table1, keys, ascending);
        if (removeDuplicates) {
            PrimitiveArray.removeDuplicates(table1);
        }
    }

    public void scaleAddOffset(double scale, double addOffset) {
        if (scale == 1.0 && addOffset == 0.0) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.setDouble(i, this.getDouble(i) * scale + addOffset);
        }
    }

    public void addOffsetScale(double addOffset, double scale) {
        if (scale == 1.0 && addOffset == 0.0) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.setDouble(i, (this.getDouble(i) + addOffset) * scale);
        }
    }

    public PrimitiveArray scaleAddOffset(Class elementClass, double scale, double addOffset) {
        PrimitiveArray pa = PrimitiveArray.factory(elementClass, this.size, true);
        for (int i = 0; i < this.size; ++i) {
            pa.setDouble(i, this.getDouble(i) * scale + addOffset);
        }
        return pa;
    }

    public PrimitiveArray addOffsetScale(Class elementClass, double addOffset, double scale) {
        PrimitiveArray pa = PrimitiveArray.factory(elementClass, this.size, true);
        for (int i = 0; i < this.size; ++i) {
            pa.setDouble(i, (this.getDouble(i) + addOffset) * scale);
        }
        return pa;
    }

    public abstract PrimitiveArray makeIndices(IntArray var1);

    public abstract int switchFromTo(String var1, String var2);

    public int convertToStandardMissingValues(double fakeFillValue, double fakeMissingValue) {
        if (this.elementClass() == String.class) {
            return 0;
        }
        int nSwitched = 0;
        if (!Double.isNaN(fakeFillValue)) {
            nSwitched += this.switchFromTo("" + fakeFillValue, "");
        }
        if (!Double.isNaN(fakeMissingValue) && fakeMissingValue != fakeFillValue) {
            nSwitched += this.switchFromTo("" + fakeMissingValue, "");
        }
        return nSwitched;
    }

    public int switchNaNToFakeMissingValue(double fakeMissingValue) {
        if (Math2.isFinite(fakeMissingValue) && this.elementClass() != String.class) {
            return this.switchFromTo("", "" + fakeMissingValue);
        }
        return 0;
    }

    public int switchFakeMissingValueToNaN(double fakeMissingValue) {
        if (Math2.isFinite(fakeMissingValue) && (this instanceof FloatArray || this instanceof DoubleArray)) {
            return this.switchFromTo("" + fakeMissingValue, "");
        }
        return 0;
    }

    public abstract String isAscending();

    public abstract String isDescending();

    public abstract int firstTie();

    public int diffIndex(PrimitiveArray other) {
        int i = 0;
        int otherSize = other.size();
        while (i != this.size || this.size != otherSize) {
            if (i == this.size || i == otherSize) {
                return i;
            }
            String s = this.getString(i);
            String so = other.getString(i);
            if (s == null && so != null) {
                return i;
            }
            if (so == null && s != null) {
                return i;
            }
            if (s != null && so != null && !s.equals(so)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String diffString(PrimitiveArray other) {
        int diffi = this.diffIndex(other);
        if (diffi == -1) {
            return "";
        }
        String s1 = diffi == this.size ? null : this.getString(diffi);
        String s2 = diffi == other.size() ? null : other.getString(diffi);
        return MessageFormat.format("  " + ArrayDiffString, "" + diffi, s2, s1);
    }

    public void diff(PrimitiveArray other) throws Exception {
        String s2;
        int diffi = this.diffIndex(other);
        if (diffi == -1) {
            return;
        }
        String s1 = diffi == this.size ? null : this.getString(diffi);
        String string = s2 = diffi == other.size() ? null : other.getString(diffi);
        if (!Test.equal(s1, s2)) {
            throw new RuntimeException(MessageFormat.format(ArrayDiff, "" + diffi, s1, s2));
        }
    }

    public String isEvenlySpaced() {
        if (this.size <= 2) {
            return "";
        }
        double average = (this.getDouble(this.size - 1) - this.getDouble(0)) / ((double)this.size - 1.0);
        for (int i = 1; i < this.size; ++i) {
            if (this.getDouble(i) - this.getDouble(i - 1) == average) continue;
            return MessageFormat.format(ArrayNotEvenlySpaced, this.getClass().getSimpleName(), "" + (i - 1), "" + this.getDouble(i - 1), "" + i, "" + this.getDouble(i), "" + (this.getDouble(i) - this.getDouble(i - 1)), "" + average);
        }
        return "";
    }

    public String smallestBiggestSpacing() {
        double small;
        if (this.size <= 2) {
            return "";
        }
        int smalli = 1;
        int bigi = 1;
        double big = small = this.getDouble(1) - this.getDouble(0);
        for (int i = 2; i < this.size; ++i) {
            double diff = this.getDouble(i) - this.getDouble(i - 1);
            if (diff < small) {
                smalli = i;
                small = diff;
                continue;
            }
            if (!(diff > big)) continue;
            bigi = i;
            big = diff;
        }
        return "  smallest spacing=" + small + ": [" + (smalli - 1) + "]=" + this.getDouble(smalli - 1) + ", [" + smalli + "]=" + this.getDouble(smalli) + "\n" + "  biggest  spacing=" + big + ": [" + (bigi - 1) + "]=" + this.getDouble(bigi - 1) + ", [" + bigi + "]=" + this.getDouble(bigi);
    }

    public abstract String minValue();

    public abstract String maxValue();

    public abstract int[] getNMinMaxIndex();

    public static int strideWillFind(int nHave, int stride) {
        return 1 + (nHave - 1) / stride;
    }

    public abstract PrimitiveArray subset(int var1, int var2, int var3);

    public static boolean testValueOpValue(long value1, String op, long value2) {
        if (op.equals("=")) {
            return value1 == value2;
        }
        if (op.equals("!=")) {
            return value1 != value2;
        }
        if (value1 == Long.MAX_VALUE || value2 == Long.MAX_VALUE) {
            return false;
        }
        if (op.equals("<=")) {
            return value1 <= value2;
        }
        if (op.equals(">=")) {
            return value1 >= value2;
        }
        if (op.equals("<")) {
            return value1 < value2;
        }
        if (op.equals(">")) {
            return value1 > value2;
        }
        throw new SimpleException("Query error: Unknown operator=\"" + op + "\".");
    }

    public static boolean testValueOpValue(float value1, String op, float value2) {
        if (op.equals("<=")) {
            return value1 <= value2 || Math2.almostEqual(6, value1, value2);
        }
        if (op.equals(">=")) {
            return value1 >= value2 || Math2.almostEqual(6, value1, value2);
        }
        if (op.equals("=")) {
            return Float.isNaN(value1) && Float.isNaN(value2) || Math2.almostEqual(6, value1, value2);
        }
        if (op.equals("<")) {
            return value1 < value2;
        }
        if (op.equals(">")) {
            return value1 > value2;
        }
        if (op.equals("!=")) {
            return Float.isNaN(value1) && Float.isNaN(value2) ? false : value1 != value2;
        }
        throw new SimpleException("Query error: Unknown operator=\"" + op + "\".");
    }

    public static boolean testValueOpValue(double value1, String op, double value2) {
        if (op.equals("<=")) {
            return value1 <= value2 || Math2.almostEqual(9, value1, value2);
        }
        if (op.equals(">=")) {
            return value1 >= value2 || Math2.almostEqual(9, value1, value2);
        }
        if (op.equals("=")) {
            return Double.isNaN(value1) && Double.isNaN(value2) || Math2.almostEqual(9, value1, value2);
        }
        if (op.equals("<")) {
            return value1 < value2;
        }
        if (op.equals(">")) {
            return value1 > value2;
        }
        if (op.equals("!=")) {
            return Double.isNaN(value1) && Double.isNaN(value2) ? false : value1 != value2;
        }
        throw new SimpleException("Query error: Unknown operator=\"" + op + "\".");
    }

    public static boolean testValueOpValue(String value1, String op, String value2) {
        if (op.equals("=")) {
            return value1.equals(value2);
        }
        if (op.equals("!=")) {
            return !value1.equals(value2);
        }
        if (op.equals(REGEX_OP)) {
            return value1.matches(value2);
        }
        int t = value1.toLowerCase().compareTo(value2.toLowerCase());
        if (op.equals("<=")) {
            return t <= 0;
        }
        if (op.equals(">=")) {
            return t >= 0;
        }
        if (op.equals("<")) {
            return t < 0;
        }
        if (op.equals(">")) {
            return t > 0;
        }
        throw new SimpleException("Query error: Unknown operator=\"" + op + "\".");
    }

    public int applyConstraint(BitSet keep, String op, String value2) {
        if (op.equals(REGEX_OP)) {
            int nStillGood = 0;
            Pattern p = Pattern.compile(value2);
            int row = keep.nextSetBit(0);
            while (row >= 0) {
                if (p.matcher(this.getString(row)).matches()) {
                    ++nStillGood;
                } else {
                    keep.clear(row);
                }
                row = keep.nextSetBit(row + 1);
            }
            return nStillGood;
        }
        if (this.elementClass() == String.class) {
            int nStillGood = 0;
            int row = keep.nextSetBit(0);
            while (row >= 0) {
                if (PrimitiveArray.testValueOpValue(this.getString(row), op, value2)) {
                    ++nStillGood;
                } else {
                    keep.clear(row);
                }
                row = keep.nextSetBit(row + 1);
            }
            return nStillGood;
        }
        long value2l = String2.parseLong(value2);
        if (value2l != Long.MAX_VALUE && PrimitiveArray.isIntegerType(this.elementClass())) {
            int nStillGood = 0;
            int row = keep.nextSetBit(0);
            while (row >= 0) {
                if (PrimitiveArray.testValueOpValue(this.getLong(row), op, value2l)) {
                    ++nStillGood;
                } else {
                    keep.clear(row);
                }
                row = keep.nextSetBit(row + 1);
            }
            return nStillGood;
        }
        if (this.elementClass() == Float.TYPE) {
            int nStillGood = 0;
            float value2f = String2.parseFloat(value2);
            int row = keep.nextSetBit(0);
            while (row >= 0) {
                if (PrimitiveArray.testValueOpValue(this.getFloat(row), op, value2f)) {
                    ++nStillGood;
                } else {
                    keep.clear(row);
                }
                row = keep.nextSetBit(row + 1);
            }
            return nStillGood;
        }
        int nStillGood = 0;
        double value2d = String2.parseDouble(value2);
        int row = keep.nextSetBit(0);
        while (row >= 0) {
            if (PrimitiveArray.testValueOpValue(this.getDouble(row), op, value2d)) {
                ++nStillGood;
            } else {
                keep.clear(row);
            }
            row = keep.nextSetBit(row + 1);
        }
        return nStillGood;
    }

    public static void testBasic() throws Throwable {
        String2.log("*** PrimitiveArray.testBasic");
        Test.ensureEqual(PrimitiveArray.factory(new byte[]{1}).elementClass(), Byte.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(new char[]{'\u0001'}).elementClass(), Character.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(new short[]{1}).elementClass(), Short.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(new int[]{1}).elementClass(), Integer.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(new long[]{1L}).elementClass(), Long.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(new float[]{1.0f}).elementClass(), Float.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(new double[]{1.0}).elementClass(), Double.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(new String[]{"1"}).elementClass(), String.class, "");
        Test.ensureEqual(PrimitiveArray.factory(Byte.TYPE, 1, true).elementClass(), Byte.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(Character.TYPE, 1, true).elementClass(), Character.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(Short.TYPE, 1, true).elementClass(), Short.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(Integer.TYPE, 1, true).elementClass(), Integer.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(Long.TYPE, 1, true).elementClass(), Long.TYPE, "");
        Test.ensureEqual(PrimitiveArray.factory(Float.TYPE, 1, true).elementClass(), Float.TYPE, "");
        PrimitiveArray pa = PrimitiveArray.factory(Double.TYPE, 1, true);
        Test.ensureEqual(pa.elementClass(), Double.TYPE, "");
        Test.ensureEqual(pa.getDouble(0), 0.0, "");
        pa = PrimitiveArray.factory(String.class, 1, true);
        Test.ensureEqual(pa.elementClass(), String.class, "");
        Test.ensureEqual(pa.getString(0), "", "");
        Test.ensureEqual(PrimitiveArray.factory(Byte.TYPE, 1, "10").toString(), "10", "");
        Test.ensureEqual(PrimitiveArray.factory(Character.TYPE, 2, "abc").toString(), "97, 97", "");
        Test.ensureEqual(PrimitiveArray.factory(Short.TYPE, 3, "30").toString(), "30, 30, 30", "");
        Test.ensureEqual(PrimitiveArray.factory(Integer.TYPE, 4, "40").toString(), "40, 40, 40, 40", "");
        Test.ensureEqual(PrimitiveArray.factory(Long.TYPE, 5, "50").toString(), "50, 50, 50, 50, 50", "");
        Test.ensureEqual(PrimitiveArray.factory(Float.TYPE, 6, "60").toString(), "60.0, 60.0, 60.0, 60.0, 60.0, 60.0", "");
        Test.ensureEqual(PrimitiveArray.factory(Double.TYPE, 7, "70").toString(), "70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0", "");
        Test.ensureEqual(PrimitiveArray.factory(String.class, 8, "ab").toString(), "ab, ab, ab, ab, ab, ab, ab, ab", "");
        pa = new StringArray(new String[]{"-127", "126", ".", "NaN", null});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof ByteArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getDouble(0), -127.0, "");
        Test.ensureEqual(pa.getDouble(1), 126.0, "");
        Test.ensureEqual(pa.getDouble(2), Double.NaN, "");
        Test.ensureEqual(pa.getDouble(3), Double.NaN, "");
        Test.ensureEqual(pa.getDouble(4), Double.NaN, "");
        pa = new StringArray(new String[]{"-32767", "32766", "."});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof ShortArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getDouble(0), -32767.0, "");
        Test.ensureEqual(pa.getDouble(1), 32766.0, "");
        Test.ensureEqual(pa.getDouble(2), Double.NaN, "");
        pa = new StringArray(new String[]{"-2000000000", "2000000000", "."});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof IntArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getDouble(0), -2.0E9, "");
        Test.ensureEqual(pa.getDouble(1), 2.0E9, "");
        Test.ensureEqual(pa.getDouble(2), Double.NaN, "");
        pa = new StringArray(new String[]{"-2000000000000000", "2000000000000000", ""});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof StringArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getString(0), "-2000000000000000", "");
        Test.ensureEqual(pa.getString(1), "2000000000000000", "");
        Test.ensureEqual(pa.getString(2), "", "");
        pa = new StringArray(new String[]{"-1e33", "1e33", "."});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof FloatArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getDouble(0), (double)-1.0E33f, "");
        Test.ensureEqual(pa.getDouble(1), (double)1.0E33f, "");
        Test.ensureEqual(pa.getDouble(2), Double.NaN, "");
        pa = new StringArray(new String[]{"-1e307", "1e307", "."});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof DoubleArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getDouble(0), -1.0E307, "");
        Test.ensureEqual(pa.getDouble(1), 1.0E307, "");
        Test.ensureEqual(pa.getDouble(2), Double.NaN, "");
        pa = new StringArray(new String[]{".", "123", "4b"});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof StringArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getString(0), ".", "");
        Test.ensureEqual(pa.getString(1), "123", "");
        Test.ensureEqual(pa.getString(2), "4b", "");
        pa = new StringArray(new String[]{".", "33.0"});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof FloatArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getString(0), "", "");
        Test.ensureEqual(pa.getString(1), "33.0", "");
        pa = new StringArray(new String[]{".", "33"});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof ByteArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getString(0), "", "");
        Test.ensureEqual(pa.getString(1), "33", "");
        pa = new DoubleArray(new double[]{Double.NaN, 123.4, 12.0});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof FloatArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getFloat(0), Float.NaN, "");
        Test.ensureEqual(pa.getFloat(1), 123.4f, "");
        Test.ensureEqual(pa.getFloat(2), 12.0f, "");
        pa = new DoubleArray(new double[]{Double.NaN, 100000.0, 12.0});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof IntArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getInt(0), Integer.MAX_VALUE, "");
        Test.ensureEqual(pa.getInt(1), 100000L, "");
        Test.ensureEqual(pa.getInt(2), 12L, "");
        pa = new DoubleArray(new double[]{Double.NaN, 100.0, 12.0});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof ByteArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getInt(0), Integer.MAX_VALUE, "");
        Test.ensureEqual(pa.getInt(1), 100L, "");
        Test.ensureEqual(pa.getInt(2), 12L, "");
        pa = new IntArray(new int[]{Integer.MAX_VALUE, 100, 12});
        pa = pa.simplify();
        Test.ensureTrue(pa instanceof ByteArray, "elementClass=" + pa.elementClass());
        Test.ensureEqual(pa.getInt(0), Integer.MAX_VALUE, "");
        Test.ensureEqual(pa.getInt(1), 100L, "");
        Test.ensureEqual(pa.getInt(2), 12L, "");
        ByteArray arByte = new ByteArray(new byte[]{0, 100, 50, 110});
        FloatArray arFloat = new FloatArray(new float[]{1.0f, 3.0f, 3.0f, -5.0f});
        DoubleArray arDouble = new DoubleArray(new double[]{17.0, 1.0E300, 3.0, 0.0});
        StringArray arString = new StringArray(new String[]{"a", "abe", "A", "ABE"});
        ArrayList table = String2.toArrayList(new Object[]{arByte, arFloat, arDouble, arString});
        Test.ensureEqual((Object)PrimitiveArray.rank(table, new int[]{0}, new boolean[]{true}), (Object)new int[]{0, 2, 1, 3}, "");
        Test.ensureEqual((Object)PrimitiveArray.rank(table, new int[]{0}, new boolean[]{false}), (Object)new int[]{3, 1, 2, 0}, "");
        Test.ensureEqual((Object)PrimitiveArray.rank(table, new int[]{1}, new boolean[]{true}), (Object)new int[]{3, 0, 1, 2}, "");
        Test.ensureEqual((Object)PrimitiveArray.rank(table, new int[]{2}, new boolean[]{true}), (Object)new int[]{3, 2, 0, 1}, "");
        Test.ensureEqual((Object)PrimitiveArray.rank(table, new int[]{3}, new boolean[]{true}), (Object)new int[]{2, 3, 0, 1}, "");
        Test.ensureEqual((Object)PrimitiveArray.rank(table, new int[]{1, 0}, new boolean[]{true, true}), (Object)new int[]{3, 0, 2, 1}, "");
        Test.ensureEqual((Object)PrimitiveArray.rank(table, new int[]{1, 0}, new boolean[]{true, false}), (Object)new int[]{3, 0, 1, 2}, "");
        Test.ensureEqual(arByte.elementClass(), Byte.TYPE, "");
        Test.ensureEqual(arFloat.elementClass(), Float.TYPE, "");
        Test.ensureEqual(arDouble.elementClass(), Double.TYPE, "");
        Test.ensureEqual(arString.elementClass(), String.class, "");
        Test.ensureEqual(arByte.elementClassString(), "byte", "");
        Test.ensureEqual(arFloat.elementClassString(), "float", "");
        Test.ensureEqual(arDouble.elementClassString(), "double", "");
        Test.ensureEqual(arString.elementClassString(), "String", "");
        PrimitiveArray.sort(table, new int[]{1, 0}, new boolean[]{true, true});
        Test.ensureEqual((Object)arByte.array, (Object)new byte[]{110, 0, 50, 100}, "");
        Test.ensureEqual((Object)arFloat.array, (Object)new float[]{-5.0f, 1.0f, 3.0f, 3.0f}, "");
        Test.ensureEqual((Object)arDouble.array, (Object)new double[]{0.0, 17.0, 3.0, 1.0E300}, "");
        Test.ensureEqual(arString.array, new String[]{"ABE", "a", "A", "abe"}, "");
        PrimitiveArray.sort(table, new int[]{1, 0}, new boolean[]{true, false});
        Test.ensureEqual((Object)arByte.array, (Object)new byte[]{110, 0, 100, 50}, "");
        Test.ensureEqual((Object)arFloat.array, (Object)new float[]{-5.0f, 1.0f, 3.0f, 3.0f}, "");
        Test.ensureEqual((Object)arDouble.array, (Object)new double[]{0.0, 17.0, 1.0E300, 3.0}, "");
        Test.ensureEqual(arString.array, new String[]{"ABE", "a", "abe", "A"}, "");
        PrimitiveArray.sortIgnoreCase(table, new int[]{3}, new boolean[]{true});
        Test.ensureEqual(arString.array, new String[]{"A", "a", "ABE", "abe"}, "arString=" + arString);
        Test.ensureEqual((Object)arByte.array, (Object)new byte[]{50, 0, 110, 100}, "");
        Test.ensureEqual((Object)arFloat.array, (Object)new float[]{3.0f, 1.0f, -5.0f, 3.0f}, "");
        Test.ensureEqual((Object)arDouble.array, (Object)new double[]{3.0, 17.0, 0.0, 1.0E300}, "");
        PrimitiveArray.sortIgnoreCase(table, new int[]{3}, new boolean[]{false});
        Test.ensureEqual(arString.array, new String[]{"abe", "ABE", "a", "A"}, "");
        Test.ensureEqual((Object)arByte.array, (Object)new byte[]{100, 110, 0, 50}, "");
        Test.ensureEqual((Object)arFloat.array, (Object)new float[]{3.0f, -5.0f, 1.0f, 3.0f}, "");
        Test.ensureEqual((Object)arDouble.array, (Object)new double[]{1.0E300, 0.0, 17.0, 3.0}, "");
        IntArray arInt3a = new IntArray(new int[]{1, 5, 5, 7, 7, 7});
        IntArray arInt3b = new IntArray(new int[]{2, 6, 6, 8, 8, 8});
        ArrayList table3 = String2.toArrayList(new Object[]{arInt3a, arInt3b});
        PrimitiveArray.removeDuplicates(table3);
        Test.ensureEqual(arInt3a.toString(), "1, 5, 7", "");
        Test.ensureEqual(arInt3b.toString(), "2, 6, 8", "");
        ByteArray arByte2 = new ByteArray(new byte[]{5, 15, 50, 25});
        FloatArray arFloat2 = new FloatArray(new float[]{4.0f, 14.0f, 3.0f, 24.0f});
        IntArray arInt2 = new IntArray(new int[]{3, 13, 3, 1});
        StringArray arString2 = new StringArray(new String[]{"b", "aa", "A", "c"});
        ArrayList table2 = String2.toArrayList(new Object[]{arByte2, arFloat2, arInt2, arString2});
        PrimitiveArray.merge(table2, table, new int[]{1, 0}, new boolean[]{true, true}, false);
        Test.ensureEqual((Object)((PrimitiveArray)table2.get(0)).toDoubleArray(), (Object)new double[]{110.0, 0.0, 50.0, 50.0, 100.0, 5.0, 15.0, 25.0}, "");
        Test.ensureEqual((Object)((PrimitiveArray)table2.get(1)).toDoubleArray(), (Object)new double[]{-5.0, 1.0, 3.0, 3.0, 3.0, 4.0, 14.0, 24.0}, "");
        Test.ensureEqual((Object)((PrimitiveArray)table2.get(2)).toDoubleArray(), (Object)new double[]{0.0, 17.0, 3.0, 3.0, 1.0E300, 3.0, 13.0, 1.0}, "");
        Test.ensureEqual(((PrimitiveArray)table2.get(3)).toStringArray(), new String[]{"ABE", "a", "A", "A", "abe", "b", "aa", "c"}, "");
        PrimitiveArray.merge(table2, table, new int[]{1, 0}, new boolean[]{true, false}, true);
        Test.ensureEqual((Object)((PrimitiveArray)table2.get(0)).toDoubleArray(), (Object)new double[]{110.0, 0.0, 100.0, 50.0, 5.0, 15.0, 25.0}, "");
        Test.ensureEqual((Object)((PrimitiveArray)table2.get(1)).toDoubleArray(), (Object)new double[]{-5.0, 1.0, 3.0, 3.0, 4.0, 14.0, 24.0}, "");
        Test.ensureEqual((Object)((PrimitiveArray)table2.get(2)).toDoubleArray(), (Object)new double[]{0.0, 17.0, 1.0E300, 3.0, 3.0, 13.0, 1.0}, "");
        Test.ensureEqual(((PrimitiveArray)table2.get(3)).toStringArray(), new String[]{"ABE", "a", "abe", "A", "b", "aa", "c"}, "");
        int n = 10000000;
        long time1 = System.currentTimeMillis();
        int[] iar = new int[]{13, 24, 56};
        int sum = 0;
        for (int i = 0; i < n; ++i) {
            sum += iar[2];
        }
        time1 = System.currentTimeMillis() - time1;
        long time2 = System.currentTimeMillis();
        IntArray ia = new IntArray(new int[]{13, 24, 56});
        sum = 0;
        for (int i = 0; i < n; ++i) {
            sum += ia.get(2);
        }
        time2 = System.currentTimeMillis() - time2;
        String2.log("[] time=" + time1 + " IntArray time=" + time2);
        ByteArray bar = new ByteArray(new byte[]{2, 4, 6, 6, 6, 8});
        CharArray car = new CharArray(new char[]{'\u0002', '\u0004', '\u0006', '\u0006', '\u0006', '\b'});
        DoubleArray dar = new DoubleArray(new double[]{2.0, 4.0, 6.0, 6.0, 6.0, 8.0});
        FloatArray far = new FloatArray(new float[]{2.0f, 4.0f, 6.0f, 6.0f, 6.0f, 8.0f});
        IntArray Iar = new IntArray(new int[]{2, 4, 6, 6, 6, 8});
        LongArray lar = new LongArray(new long[]{2L, 4L, 6L, 6L, 6L, 8L});
        ShortArray sar = new ShortArray(new short[]{2, 4, 6, 6, 6, 8});
        StringArray Sar = new StringArray(new String[]{"22", "4444", "666666", "666666", "666666", "88888888"});
        Test.ensureEqual(bar.indexOf("6"), 2L, "");
        Test.ensureEqual(car.indexOf("6"), 2L, "");
        Test.ensureEqual(dar.indexOf("6"), 2L, "");
        Test.ensureEqual(far.indexOf("6"), 2L, "");
        Test.ensureEqual(Iar.indexOf("6"), 2L, "");
        Test.ensureEqual(lar.indexOf("6"), 2L, "");
        Test.ensureEqual(sar.indexOf("6"), 2L, "");
        Test.ensureEqual(Sar.indexOf("666666"), 2L, "");
        Test.ensureEqual(bar.indexOf("a"), -1L, "");
        Test.ensureEqual(car.indexOf("a"), -1L, "");
        Test.ensureEqual(dar.indexOf("a"), -1L, "");
        Test.ensureEqual(far.indexOf("a"), -1L, "");
        Test.ensureEqual(Iar.indexOf("a"), -1L, "");
        Test.ensureEqual(lar.indexOf("a"), -1L, "");
        Test.ensureEqual(sar.indexOf("a"), -1L, "");
        Test.ensureEqual(Sar.indexOf("a"), -1L, "");
        Test.ensureEqual(bar.indexOf("6", 3), 3L, "");
        Test.ensureEqual(car.indexOf("6", 3), 3L, "");
        Test.ensureEqual(dar.indexOf("6", 3), 3L, "");
        Test.ensureEqual(far.indexOf("6", 3), 3L, "");
        Test.ensureEqual(Iar.indexOf("6", 3), 3L, "");
        Test.ensureEqual(lar.indexOf("6", 3), 3L, "");
        Test.ensureEqual(sar.indexOf("6", 3), 3L, "");
        Test.ensureEqual(Sar.indexOf("666666", 3), 3L, "");
        Test.ensureEqual(bar.lastIndexOf("6"), 4L, "");
        Test.ensureEqual(car.lastIndexOf("6"), 4L, "");
        Test.ensureEqual(dar.lastIndexOf("6"), 4L, "");
        Test.ensureEqual(far.lastIndexOf("6"), 4L, "");
        Test.ensureEqual(Iar.lastIndexOf("6"), 4L, "");
        Test.ensureEqual(lar.lastIndexOf("6"), 4L, "");
        Test.ensureEqual(sar.lastIndexOf("6"), 4L, "");
        Test.ensureEqual(Sar.lastIndexOf("666666"), 4L, "");
        Test.ensureEqual(bar.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(car.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(dar.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(far.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(Iar.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(lar.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(sar.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(Sar.lastIndexOf("a"), -1L, "");
        Test.ensureEqual(bar.lastIndexOf("6", 3), 3L, "");
        Test.ensureEqual(car.lastIndexOf("6", 3), 3L, "");
        Test.ensureEqual(dar.lastIndexOf("6", 3), 3L, "");
        Test.ensureEqual(far.lastIndexOf("6", 3), 3L, "");
        Test.ensureEqual(Iar.lastIndexOf("6", 3), 3L, "");
        Test.ensureEqual(lar.lastIndexOf("6", 3), 3L, "");
        Test.ensureEqual(sar.lastIndexOf("6", 3), 3L, "");
        Test.ensureEqual(Sar.lastIndexOf("666666", 3), 3L, "");
        String raf2Name = File2.getSystemTempDirectory() + "PrimitiveArrayRaf2Test.bin";
        String2.log("raf2Name=" + raf2Name);
        File2.delete(raf2Name);
        Test.ensureEqual(File2.isFile(raf2Name), false, "");
        RandomAccessFile raf2 = new RandomAccessFile(raf2Name, "rw");
        long bStart = raf2.getFilePointer();
        PrimitiveArray.rafWriteDouble(raf2, Byte.TYPE, 1.0);
        PrimitiveArray.rafWriteDouble(raf2, Byte.TYPE, Double.NaN);
        long cStart = raf2.getFilePointer();
        PrimitiveArray.rafWriteDouble(raf2, Character.TYPE, 2.0);
        PrimitiveArray.rafWriteDouble(raf2, Character.TYPE, Double.NaN);
        long dStart = raf2.getFilePointer();
        PrimitiveArray.rafWriteDouble(raf2, Double.TYPE, 3.0);
        PrimitiveArray.rafWriteDouble(raf2, Double.TYPE, Double.NaN);
        long fStart = raf2.getFilePointer();
        PrimitiveArray.rafWriteDouble(raf2, Float.TYPE, 4.0);
        PrimitiveArray.rafWriteDouble(raf2, Float.TYPE, Double.NaN);
        long iStart = raf2.getFilePointer();
        PrimitiveArray.rafWriteDouble(raf2, Integer.TYPE, 5.0);
        PrimitiveArray.rafWriteDouble(raf2, Integer.TYPE, Double.NaN);
        long lStart = raf2.getFilePointer();
        PrimitiveArray.rafWriteDouble(raf2, Long.TYPE, 6.0);
        PrimitiveArray.rafWriteDouble(raf2, Long.TYPE, Double.NaN);
        long sStart = raf2.getFilePointer();
        PrimitiveArray.rafWriteDouble(raf2, Short.TYPE, 7.0);
        PrimitiveArray.rafWriteDouble(raf2, Short.TYPE, Double.NaN);
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Short.TYPE, sStart, 1L), Double.NaN, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Short.TYPE, sStart, 0L), 7.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Long.TYPE, lStart, 1L), Double.NaN, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Long.TYPE, lStart, 0L), 6.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Integer.TYPE, iStart, 1L), Double.NaN, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Integer.TYPE, iStart, 0L), 5.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Float.TYPE, fStart, 1L), Double.NaN, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Float.TYPE, fStart, 0L), 4.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Double.TYPE, dStart, 1L), Double.NaN, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Double.TYPE, dStart, 0L), 3.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Character.TYPE, cStart, 1L), Double.NaN, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Character.TYPE, cStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Byte.TYPE, bStart, 1L), Double.NaN, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf2, Byte.TYPE, bStart, 0L), 1.0, "");
        raf2.close();
        String rafName = File2.getSystemTempDirectory() + "PrimitiveArrayRafTest.bin";
        String2.log("rafName=" + rafName);
        File2.delete(rafName);
        Test.ensureEqual(File2.isFile(rafName), false, "");
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(rafName)));
        long barStart = 0L;
        long carStart = barStart + (long)(6 * bar.writeDos(dos));
        long darStart = carStart + (long)(6 * car.writeDos(dos));
        long farStart = darStart + (long)(6 * dar.writeDos(dos));
        long IarStart = farStart + (long)(6 * far.writeDos(dos));
        long larStart = IarStart + (long)(6 * Iar.writeDos(dos));
        long sarStart = larStart + (long)(6 * lar.writeDos(dos));
        long SarStart = sarStart + (long)(6 * sar.writeDos(dos));
        Test.ensureEqual(Sar.writeDos(dos), 10L, "");
        int nBytesPerS = 9;
        dos.close();
        RandomAccessFile raf = new RandomAccessFile(rafName, "rw");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Byte.TYPE, barStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Byte.TYPE, barStart, 5L), 8.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Character.TYPE, carStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Character.TYPE, carStart, 5L), 8.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Double.TYPE, darStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Double.TYPE, darStart, 5L), 8.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Float.TYPE, farStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Float.TYPE, farStart, 5L), 8.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Integer.TYPE, IarStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Integer.TYPE, IarStart, 5L), 8.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Long.TYPE, larStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Long.TYPE, larStart, 5L), 8.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Short.TYPE, sarStart, 0L), 2.0, "");
        Test.ensureEqual(PrimitiveArray.rafReadDouble(raf, Short.TYPE, sarStart, 5L), 8.0, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 2.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 4.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 6.0), 2L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 8.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 1.0), -1L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 3.0), -2L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 5.0), -3L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 7.0), -6L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 5L, 9.0), -7L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 4L, 2.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 4L, 4.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 4L, 6.0), 4L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 4L, 1.0), -1L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 4L, 3.0), -2L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 4L, 5.0), -3L, "");
        Test.ensureEqual(PrimitiveArray.rafBinarySearch(raf, Float.TYPE, farStart, 0L, 4L, 7.0), -6L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 2.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 4.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 6.0), 2L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 8.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 1.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 3.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 5.0), 2L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 7.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGE(raf, Float.TYPE, farStart, 0L, 5L, 9.0), 6L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 2.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 2.0000001), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 1.9999999), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 4.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 6.0), 2L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 6.0000001), 2L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 5.9999999), 2L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 8.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 1.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 3.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 3.0000001), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 2.9999999), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 5.0), 2L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 7.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafFirstGAE5(raf, Float.TYPE, farStart, 0L, 5L, 9.0), 6L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 2.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 4.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 6.0), 4L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 8.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 1.0), -1L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 3.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 5.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 7.0), 4L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLE(raf, Float.TYPE, farStart, 0L, 5L, 9.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 2.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 2.0000001), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 1.9999999), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 4.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 6.0), 4L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 6.0000001), 4L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 5.9999999), 4L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 8.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 1.0), -1L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 3.0), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 3.0000001), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 2.9999999), 0L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 5.0), 1L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 7.0), 4L, "");
        Test.ensureEqual(PrimitiveArray.rafLastLAE5(raf, Float.TYPE, farStart, 0L, 5L, 9.0), 5L, "");
        raf.close();
        Test.ensureEqual(far.binarySearch(0, 5, 2.0), 0L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 4.0), 1L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 6.0), 2L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 8.0), 5L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 1.0), -1L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 3.0), -2L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 5.0), -3L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 7.0), -6L, "");
        Test.ensureEqual(far.binarySearch(0, 5, 9.0), -7L, "");
        Test.ensureEqual(far.binarySearch(0, 4, 2.0), 0L, "");
        Test.ensureEqual(far.binarySearch(0, 4, 4.0), 1L, "");
        Test.ensureEqual(far.binarySearch(0, 4, 6.0), 4L, "");
        Test.ensureEqual(far.binarySearch(0, 4, 1.0), -1L, "");
        Test.ensureEqual(far.binarySearch(0, 4, 3.0), -2L, "");
        Test.ensureEqual(far.binarySearch(0, 4, 5.0), -3L, "");
        Test.ensureEqual(far.binarySearch(0, 4, 7.0), -6L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 2.0), 0L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 4.0), 1L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 6.0), 2L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 8.0), 5L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 1.0), 0L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 3.0), 1L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 5.0), 2L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 7.0), 5L, "");
        Test.ensureEqual(far.binaryFindFirstGE(0, 5, 9.0), 6L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 2.0), 0L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 2.0000001), 0L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 1.9999999), 0L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 4.0), 1L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 6.0), 2L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 6.0000001), 2L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 5.9999999), 2L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 8.0), 5L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 1.0), 0L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 3.0), 1L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 3.0000001), 1L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 2.9999999), 1L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 5.0), 2L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 7.0), 5L, "");
        Test.ensureEqual(far.binaryFindFirstGAE5(0, 5, 9.0), 6L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 2.0), 0L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 4.0), 1L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 6.0), 4L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 8.0), 5L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 1.0), -1L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 3.0), 0L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 5.0), 1L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 7.0), 4L, "");
        Test.ensureEqual(far.binaryFindLastLE(0, 5, 9.0), 5L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 2.0), 0L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 2.0000001), 0L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 1.9999999), 0L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 4.0), 1L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 6.0), 4L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 6.0000001), 4L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 5.9999999), 4L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 8.0), 5L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 1.0), -1L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 3.0), 0L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 3.0000001), 0L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 2.9999999), 0L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 5.0), 1L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 7.0), 4L, "");
        Test.ensureEqual(far.binaryFindLastLAE5(0, 5, 9.0), 5L, "");
        Test.ensureEqual(far.binaryFindClosest(2.0), 0L, "");
        Test.ensureEqual(far.binaryFindClosest(2.1), 0L, "");
        Test.ensureEqual(far.binaryFindClosest(1.9), 0L, "");
        Test.ensureEqual(far.binaryFindClosest(4.0), 1L, "");
        Test.ensureEqual(far.binaryFindClosest(6.0), 2L, "");
        Test.ensureEqual(far.binaryFindClosest(5.9), 2L, "");
        Test.ensureEqual(far.binaryFindClosest(6.1), 4L, "");
        Test.ensureEqual(far.binaryFindClosest(8.0), 5L, "");
        Test.ensureEqual(far.binaryFindClosest(1.0), 0L, "");
        Test.ensureEqual(far.binaryFindClosest(2.9), 0L, "");
        Test.ensureEqual(far.binaryFindClosest(3.1), 1L, "");
        Test.ensureEqual(far.binaryFindClosest(5.1), 2L, "");
        Test.ensureEqual(far.binaryFindClosest(7.1), 5L, "");
        Test.ensureEqual(far.binaryFindClosest(9.0), 5L, "");
        Test.ensureEqual(far.linearFindClosest(2.0), 0L, "");
        Test.ensureEqual(far.linearFindClosest(2.1), 0L, "");
        Test.ensureEqual(far.linearFindClosest(1.9), 0L, "");
        Test.ensureEqual(far.linearFindClosest(4.0), 1L, "");
        Test.ensureEqual(far.linearFindClosest(6.0), 2L, "");
        Test.ensureEqual(far.linearFindClosest(5.9), 2L, "");
        Test.ensureEqual(far.linearFindClosest(6.1), 2L, "");
        Test.ensureEqual(far.linearFindClosest(8.0), 5L, "");
        Test.ensureEqual(far.linearFindClosest(1.0), 0L, "");
        Test.ensureEqual(far.linearFindClosest(2.9), 0L, "");
        Test.ensureEqual(far.linearFindClosest(3.1), 1L, "");
        Test.ensureEqual(far.linearFindClosest(5.1), 2L, "");
        Test.ensureEqual(far.linearFindClosest(7.1), 5L, "");
        Test.ensureEqual(far.linearFindClosest(9.0), 5L, "");
        Test.ensureEqual(PrimitiveArray.strideWillFind(5, 1), 5L, "");
        Test.ensureEqual(PrimitiveArray.strideWillFind(5, 2), 3L, "");
        Test.ensureEqual(PrimitiveArray.strideWillFind(5, 3), 2L, "");
        Test.ensureEqual(PrimitiveArray.strideWillFind(5, 4), 2L, "");
        Test.ensureEqual(PrimitiveArray.strideWillFind(5, 5), 1L, "");
        ia = new IntArray(new int[]{0, 1, 2, 3, Integer.MAX_VALUE});
        ia.scaleAddOffset(1.5, 10.0);
        Test.ensureEqual(ia.toString(), "10, 12, 13, 15, 2147483647", "");
        String2.log("PrimitiveArray.testBasic finished successfully.");
    }

    public static void testTestValueOpValue() {
        int i;
        String2.log("\n*** PrimitiveArray.testTestValueOpValue()");
        long lnan = Long.MAX_VALUE;
        float fnan = Float.NaN;
        double dnan = Double.NaN;
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "=", 1L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "=", 2L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "=", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "=", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "=", lnan), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "=", 1.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "=", 2.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "=", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "=", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "=", fnan), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "=", 1.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "=", 2.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "=", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "=", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "=", dnan), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "!=", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "!=", 2L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "!=", lnan), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "!=", 1L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "!=", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "!=", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "!=", 2.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "!=", fnan), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "!=", 1.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "!=", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "!=", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "!=", 2.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "!=", dnan), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "!=", 1.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "!=", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<=", 1L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<=", 2L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2L, "<=", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<=", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "<=", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "<=", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<=", 1.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<=", 2.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0f, "<=", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<=", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "<=", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "<=", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<=", 1.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<=", 2.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0, "<=", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<=", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "<=", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "<=", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<", 2L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "<", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, "<", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<", 2.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "<", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, "<", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<", 2.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "<", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, "<", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, ">=", 1L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, ">=", 2L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2L, ">=", 1L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, ">=", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, ">=", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, ">=", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, ">=", 1.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, ">=", 2.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0f, ">=", 1.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, ">=", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, ">=", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, ">=", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, ">=", 1.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, ">=", 2.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0, ">=", 1.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, ">=", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, ">=", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, ">=", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2L, ">", 1L), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, ">", 2L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, ">", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, ">", 1L), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(lnan, ">", lnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0f, ">", 1.0f), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, ">", 2.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, ">", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, ">", 1.0f), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(fnan, ">", fnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0, ">", 1.0), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, ">", 2.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, ">", dnan), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, ">", 1.0), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(dnan, ">", dnan), false, "");
        String s = "";
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "=", "a"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "=", "B"), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "=", s), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(s, "=", "a"), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(s, "=", s), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "!=", "a"), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "!=", "B"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "!=", s), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(s, "!=", "a"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(s, "!=", s), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "<=", "a"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "<=", "B"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("B", "<=", "a"), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "<=", s), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(s, "<=", "a"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue(s, "<=", s), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "<", "a"), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", "<", "B"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", ">=", "a"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", ">=", "B"), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("B", ">=", "a"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("B", ">", "a"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("a", ">", "B"), false, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("12345", REGEX_OP, "[0-9]+"), true, "");
        Test.ensureEqual(PrimitiveArray.testValueOpValue("12a45", REGEX_OP, "[0-9]+"), false, "");
        long tTime = System.currentTimeMillis();
        int n = 1000000;
        for (i = 0; i < n; ++i) {
            Test.ensureEqual(PrimitiveArray.testValueOpValue("abcdefghijk", "=", "abcdefghijk"), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue("abcdefghijk", "!=", "abcdefghijk"), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue("abcdefghijk", "<=", "abcdefghijk"), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue("abcdefghijk", "<", "abcdefghijk"), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue("abcdefghijk", ">=", "abcdefghijk"), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue("abcdefghijk", ">", "abcdefghijk"), false, "");
        }
        String2.log("time for " + 6 * n + " testValueOpValue(string): " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 312ms, 2012-06-29: 1859 ms)");
        for (i = 0; i < n; ++i) {
            Test.ensureEqual(PrimitiveArray.testValueOpValue("12345", REGEX_OP, "[0-9]+"), true, "");
        }
        String2.log("time for " + n + " regex testValueOpValue(string, regex): " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 718ms, 2012-06-29: 4453 ms)");
        tTime = System.currentTimeMillis();
        for (i = 0; i < n; ++i) {
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "=", 1L), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "!=", 1L), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<=", 1L), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<", 1L), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, ">=", 1L), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(2L, ">", 1L), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, ">", 2L), false, "");
        }
        String2.log("time for " + 7 * n + " testValueOpValue(long): " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 78ms, 2012-06-29: 328 ms)");
        tTime = System.currentTimeMillis();
        for (i = 0; i < n; ++i) {
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "=", 1.0f), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "!=", 1.0f), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<=", 1.0f), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, "<", 1.0f), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, ">=", 1.0f), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0f, ">", 1.0f), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0f, ">", 2.0f), false, "");
        }
        String2.log("time for " + 7 * n + " testValueOpValue(float): " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 109ms, 2012-06-29: 328 ms)");
        tTime = System.currentTimeMillis();
        for (i = 0; i < n; ++i) {
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "=", 1.0), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "!=", 1.0), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<=", 1.0), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, "<", 1.0), false, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, ">=", 1.0), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(2.0, ">", 1.0), true, "");
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1.0, ">", 2.0), false, "");
        }
        String2.log("time for " + 7 * n + " testValueOpValue(double): " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 78ms, 2012-06-29: 329 ms)");
        tTime = System.currentTimeMillis();
        for (i = 0; i < 7 * n; ++i) {
            Test.ensureEqual(PrimitiveArray.testValueOpValue(1L, "<=", 1L), true, "");
        }
        String2.log("time for " + 7 * n + " testValueOpValue(double <=): " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 62ms, 2012-06-29: 234 ms)");
        PrimitiveArray pa = PrimitiveArray.factory(Integer.TYPE, n, "5");
        pa.addInt(10);
        pa.addString("");
        BitSet keep = new BitSet();
        keep.set(0, pa.size());
        tTime = System.currentTimeMillis();
        pa.applyConstraint(keep, REGEX_OP, "(10|zztop)");
        pa.justKeep(keep);
        Test.ensureEqual(pa.size(), 1L, "");
        Test.ensureEqual(pa.getDouble(0), 10.0, "");
        String2.log("time for applyConstraint(regex) n=" + n + ": " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 139ms, 2012-06-29: 500 ms)");
        pa = PrimitiveArray.factory(String.class, n, "Apple");
        pa.addString("Nate");
        pa.addString("");
        keep = new BitSet();
        keep.set(0, pa.size());
        tTime = System.currentTimeMillis();
        pa.applyConstraint(keep, ">=", "hubert");
        pa.justKeep(keep);
        Test.ensureEqual(pa.size(), 1L, "");
        Test.ensureEqual(pa.getString(0), "Nate", "");
        String2.log("time for applyConstraint(String) n=" + n + ": " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 93ms, 2012-06-29: 406 ms)");
        pa = PrimitiveArray.factory(Float.TYPE, n, "5");
        pa.addInt(10);
        pa.addString("");
        keep = new BitSet();
        keep.set(0, pa.size());
        tTime = System.currentTimeMillis();
        pa.applyConstraint(keep, ">=", "9");
        pa.justKeep(keep);
        Test.ensureEqual(pa.size(), 1L, "");
        Test.ensureEqual(pa.getDouble(0), 10.0, "");
        String2.log("time for applyConstraint(float) n=" + n + ": " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 93ms, 2012-06-29: 140 ms)");
        pa = PrimitiveArray.factory(Double.TYPE, n, "5");
        pa.addInt(10);
        pa.addString("");
        keep = new BitSet();
        keep.set(0, pa.size());
        tTime = System.currentTimeMillis();
        pa.applyConstraint(keep, ">=", "9");
        pa.justKeep(keep);
        Test.ensureEqual(pa.size(), 1L, "");
        Test.ensureEqual(pa.getDouble(0), 10.0, "");
        String2.log("time for applyConstraint(double) n=" + n + ": " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 31ms, 2012-06-29: 125 ms)");
        pa = PrimitiveArray.factory(Integer.TYPE, n, "5");
        pa.addInt(10);
        pa.addString("");
        keep = new BitSet();
        keep.set(0, pa.size());
        tTime = System.currentTimeMillis();
        pa.applyConstraint(keep, ">=", "9");
        pa.justKeep(keep);
        Test.ensureEqual(pa.size(), 1L, "");
        Test.ensureEqual(pa.getDouble(0), 10.0, "");
        String2.log("time for applyConstraint(int) n=" + n + ": " + (System.currentTimeMillis() - tTime) + " (Java 1.7M4700 16ms, 2012-06-29: 141 ms)");
    }

    public static void test() throws Throwable {
        String2.log("*** PrimitiveArray.test");
        PrimitiveArray.testBasic();
        PrimitiveArray.testTestValueOpValue();
    }

    public static void main(String[] args) throws Throwable {
        PrimitiveArray.test();
    }
}

