/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.array.PrimitiveArray;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.util.Comparator;
import java.util.List;

public class RowComparator
implements Comparator {
    protected List table;
    protected int[] keys;
    protected boolean[] ascending;

    public RowComparator(List table, int[] keys, boolean[] ascending) {
        String errorInMethod = String2.ERROR + " in RowComparator constructor:\n";
        Test.ensureNotEqual(keys.length, 0L, errorInMethod + "keys.length must not be 0.");
        Test.ensureEqual(keys.length, ascending.length, errorInMethod + "keys.length must equal ascending.length.");
        for (int k = 0; k < keys.length; ++k) {
            Test.ensureBetween(keys[k], 0.0, table.size(), errorInMethod + "keys[" + k + "] points to a column that isn't in the table.");
        }
        this.table = table;
        this.keys = keys;
        this.ascending = ascending;
    }

    public int compare(Object o1, Object o2) {
        for (int k = 0; k < this.keys.length; ++k) {
            int result = ((PrimitiveArray)this.table.get(this.keys[k])).compare((Integer)o1, (Integer)o2);
            if (result == 0) continue;
            return this.ascending[k] ? result : -result;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RowComparator)) {
            return false;
        }
        RowComparator other = (RowComparator)obj;
        if (other.table.size() != this.table.size() || other.keys.length != this.keys.length || other.ascending.length != this.ascending.length) {
            return false;
        }
        for (int t = 0; t < this.table.size(); ++t) {
            if (other.table.get(t) == this.table.get(t)) continue;
            return false;
        }
        for (int k = 0; k < this.keys.length; ++k) {
            if (other.keys[k] == this.keys[k] && other.ascending[k] == this.ascending[k]) continue;
            return false;
        }
        return true;
    }
}

