/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.array.ByteArray;
import com.cohort.array.IntArray;
import com.cohort.array.PrimitiveArray;
import com.cohort.array.StringArray;
import com.cohort.util.Math2;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ShortArray
extends PrimitiveArray {
    public short[] array;

    public ShortArray() {
        this.array = new short[8];
    }

    public ShortArray(PrimitiveArray primitiveArray) {
        this.array = new short[8];
        this.append(primitiveArray);
    }

    public ShortArray(int capacity, boolean active) {
        Math2.ensureMemoryAvailable(2L * (long)capacity, "ShortArray");
        this.array = new short[capacity];
        if (active) {
            this.size = capacity;
        }
    }

    public ShortArray(int first, int last) {
        this.size = last - first + 1;
        this.array = new short[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = (short)(first + i);
        }
    }

    public ShortArray(short[] anArray) {
        this.array = anArray;
        this.size = anArray.length;
    }

    public ShortArray(char[] charArray) {
        this.size = charArray.length;
        this.array = new short[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = (short)charArray[i];
        }
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.size; ++i) {
            code = 31 * code + this.array[i];
        }
        return code;
    }

    @Override
    public PrimitiveArray subset(int startIndex, int stride, int stopIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(ArraySubsetStart, this.getClass().getSimpleName(), "" + startIndex));
        }
        if (stride < 1) {
            throw new IllegalArgumentException(MessageFormat.format(ArraySubsetStride, this.getClass().getSimpleName(), "" + stride));
        }
        if (stopIndex >= this.size) {
            stopIndex = this.size - 1;
        }
        if (stopIndex < startIndex) {
            return new ShortArray(new short[0]);
        }
        int willFind = ShortArray.strideWillFind(stopIndex - startIndex + 1, stride);
        Math2.ensureMemoryAvailable(2L * (long)willFind, "ShortArray");
        short[] tar = new short[willFind];
        if (stride == 1) {
            System.arraycopy(this.array, startIndex, tar, 0, willFind);
        } else {
            int po = 0;
            for (int i = startIndex; i <= stopIndex; i += stride) {
                tar[po++] = this.array[i];
            }
        }
        return new ShortArray(tar);
    }

    @Override
    public Class elementClass() {
        return Short.TYPE;
    }

    @Override
    public int elementClassIndex() {
        return 1;
    }

    public void add(short value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        this.array[this.size++] = value;
    }

    public void add(short[] ar) {
        int arSize = ar.length;
        this.ensureCapacity((long)this.size + (long)arSize);
        System.arraycopy(ar, 0, this.array, this.size, arSize);
        this.size += arSize;
    }

    public void addN(int n, short value) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayAddN, this.getClass().getSimpleName(), "" + n));
        }
        this.ensureCapacity((long)this.size + (long)n);
        Arrays.fill(this.array, this.size, this.size + n, value);
        this.size += n;
    }

    public void add(int index, short value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        ++this.size;
        this.array[index] = value;
    }

    @Override
    public void addString(int index, String value) {
        this.add(index, Math2.narrowToShort(String2.parseInt(value)));
    }

    @Override
    public void addNStrings(int n, String value) {
        this.addN(n, Math2.narrowToShort(String2.parseInt(value)));
    }

    @Override
    public void addString(String value) {
        this.add(Math2.narrowToShort(String2.parseInt(value)));
    }

    @Override
    public void addFloat(float value) {
        this.add(Math2.roundToShort(value));
    }

    @Override
    public void addDouble(double value) {
        this.add(Math2.roundToShort(value));
    }

    @Override
    public void addNDoubles(int n, double value) {
        this.addN(n, Math2.roundToShort(value));
    }

    @Override
    public void addInt(int value) {
        this.add(Math2.narrowToShort(value));
    }

    @Override
    public void addNInts(int n, int value) {
        this.addN(n, Math2.narrowToShort(value));
    }

    @Override
    public void addLong(long value) {
        this.add(Math2.narrowToShort(value));
    }

    @Override
    public void addFromPA(PrimitiveArray otherPA, int otherIndex) {
        this.addInt(otherPA.getInt(otherIndex));
    }

    @Override
    public void setFromPA(int index, PrimitiveArray otherPA, int otherIndex) {
        this.setInt(index, otherPA.getInt(otherIndex));
    }

    @Override
    public void remove(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayRemove, this.getClass().getSimpleName(), "" + index, "" + this.size));
        }
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
    }

    @Override
    public void removeRange(int from, int to) {
        if (to > this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ShortArray.removeRange: to (" + to + ") > size (" + this.size + ").");
        }
        if (from >= to) {
            if (from == to) {
                return;
            }
            throw new IllegalArgumentException(String2.ERROR + " in ShortArray.removeRange: from (" + from + ") > to (" + to + ").");
        }
        System.arraycopy(this.array, to, this.array, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void move(int first, int last, int destination) {
        String errorIn = String2.ERROR + " in ShortArray.move:\n";
        Test.ensureTrue(first >= 0, errorIn + "first (" + first + ") must be >= 0.");
        Test.ensureTrue(last >= first && last <= this.size, errorIn + "last (" + last + ") must be >= first (" + first + ") and <= size (" + this.size + ").");
        Test.ensureTrue(destination >= 0 && destination <= this.size, errorIn + "destination (" + destination + ") must be between 0 and size (" + this.size + ").");
        Test.ensureTrue(destination <= first || destination >= last, errorIn + "destination (" + destination + ") must be <= first (" + first + ") or >= last (" + last + ").");
        if (first == last || destination == first || destination == last) {
            return;
        }
        int nToMove = last - first;
        short[] temp = new short[nToMove];
        System.arraycopy(this.array, first, temp, 0, nToMove);
        if (destination < first) {
            System.arraycopy(this.array, destination, this.array, destination + nToMove, first - destination);
            System.arraycopy(temp, 0, this.array, destination, nToMove);
        } else {
            System.arraycopy(this.array, last, this.array, first, destination - last);
            System.arraycopy(temp, 0, this.array, destination - nToMove, nToMove);
        }
    }

    @Override
    public void justKeep(BitSet bitset) {
        int newSize = 0;
        for (int row = 0; row < this.size; ++row) {
            if (!bitset.get(row)) continue;
            this.array[newSize++] = this.array[row];
        }
        this.removeRange(newSize, this.size);
    }

    @Override
    public void ensureCapacity(long minCapacity) {
        if ((long)this.array.length < minCapacity) {
            Math2.ensureArraySizeOkay(minCapacity, "ShortArray");
            int newCapacity = (int)Math.min(0x7FFFFFFEL, (long)this.array.length + (long)this.array.length);
            if ((long)newCapacity < minCapacity) {
                newCapacity = (int)minCapacity;
            }
            Math2.ensureMemoryAvailable(2L * (long)newCapacity, "ShortArray");
            short[] newArray = new short[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public short[] toArray() {
        if (this.array.length == this.size) {
            return this.array;
        }
        Math2.ensureMemoryAvailable(2L * (long)this.size, "ShortArray.toArray");
        short[] tArray = new short[this.size];
        System.arraycopy(this.array, 0, tArray, 0, this.size);
        return tArray;
    }

    @Override
    public Object toObjectArray() {
        return this.toArray();
    }

    @Override
    public double[] toDoubleArray() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "ShortArray.toDoubleArray");
        double[] dar = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            short s = this.array[i];
            dar[i] = s == Short.MAX_VALUE ? Double.NaN : (double)s;
        }
        return dar;
    }

    @Override
    public String[] toStringArray() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "ShortArray.toStringArray");
        String[] sar = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            short s = this.array[i];
            sar[i] = s == Short.MAX_VALUE ? "" : String.valueOf(s);
        }
        return sar;
    }

    public short get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ShortArray.get: index (" + index + ") >= size (" + this.size + ").");
        }
        return this.array[index];
    }

    public void set(int index, short value) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ShortArray.set: index (" + index + ") >= size (" + this.size + ").");
        }
        this.array[index] = value;
    }

    @Override
    public int getInt(int index) {
        short i = this.get(index);
        return i == Short.MAX_VALUE ? Integer.MAX_VALUE : (int)i;
    }

    @Override
    public void setInt(int index, int i) {
        this.set(index, Math2.narrowToShort(i));
    }

    @Override
    public long getLong(int index) {
        short i = this.get(index);
        return i == Short.MAX_VALUE ? Long.MAX_VALUE : (long)i;
    }

    @Override
    public void setLong(int index, long i) {
        this.set(index, Math2.narrowToShort(i));
    }

    @Override
    public float getFloat(int index) {
        short s = this.get(index);
        return s == Short.MAX_VALUE ? Float.NaN : (float)s;
    }

    @Override
    public void setFloat(int index, float d) {
        this.set(index, Math2.roundToShort(d));
    }

    @Override
    public double getDouble(int index) {
        short s = this.get(index);
        return s == Short.MAX_VALUE ? Double.NaN : (double)s;
    }

    @Override
    public void setDouble(int index, double d) {
        this.set(index, Math2.roundToShort(d));
    }

    @Override
    public String getString(int index) {
        short b = this.get(index);
        return b == Short.MAX_VALUE ? "" : String.valueOf(b);
    }

    @Override
    public void setString(int index, String s) {
        this.set(index, Math2.narrowToShort(String2.parseInt(s)));
    }

    public int indexOf(short lookFor) {
        return this.indexOf(lookFor, 0);
    }

    public int indexOf(short lookFor, int startIndex) {
        for (int i = startIndex; i < this.size; ++i) {
            if (this.array[i] != lookFor) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(String lookFor, int startIndex) {
        return this.indexOf(Math2.roundToShort(String2.parseInt(lookFor)), startIndex);
    }

    public int lastIndexOf(short lookFor, int startIndex) {
        if (startIndex >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in ShortArray.get: startIndex (" + startIndex + ") >= size (" + this.size + ").");
        }
        for (int i = startIndex; i >= 0; --i) {
            if (this.array[i] != lookFor) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(String lookFor, int startIndex) {
        return this.lastIndexOf(Math2.roundToShort(String2.parseInt(lookFor)), startIndex);
    }

    @Override
    public void trimToSize() {
        this.array = this.toArray();
    }

    public boolean equals(Object o) {
        return this.testEquals(o).length() == 0;
    }

    @Override
    public String testEquals(Object o) {
        if (!(o instanceof ShortArray)) {
            return "The two objects aren't equal: this object is a ShortArray; the other is a " + o.getClass().getName() + ".";
        }
        ShortArray other = (ShortArray)o;
        if (other.size() != this.size) {
            return "The two ShortArrays aren't equal: one has " + this.size + " value" + (this.size == 0 ? "s" : (this.size == 1 ? " (" + this.array[0] + ")" : "s (from " + this.array[0] + " to " + this.array[this.size - 1] + ")")) + "; the other has " + other.size() + " value" + (other.size == 0 ? "s" : (other.size == 1 ? " (" + other.array[0] + ")" : "s (from " + other.array[0] + " to " + other.array[other.size - 1] + ")")) + ".";
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == other.array[i]) continue;
            return "The two ShortArrays aren't equal: this[" + i + "]=" + this.array[i] + "; other[" + i + "]=" + other.array[i] + ".";
        }
        return "";
    }

    @Override
    public String toString() {
        return String2.toCSSVString(this.toArray());
    }

    @Override
    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    @Override
    public int compare(int index1, int index2) {
        return this.array[index1] - this.array[index2];
    }

    @Override
    public void copy(int from, int to) {
        this.array[to] = this.array[from];
    }

    @Override
    public void reorder(int[] rank) {
        int n = rank.length;
        short[] newArray = new short[this.array.length];
        for (int i = 0; i < n; ++i) {
            newArray[i] = this.array[rank[i]];
        }
        this.array = newArray;
    }

    @Override
    public int writeDos(DataOutputStream dos, int i) throws Exception {
        dos.writeShort(this.array[i]);
        return 2;
    }

    @Override
    public void readDis(DataInputStream dis, int n) throws Exception {
        this.ensureCapacity((long)this.size + (long)n);
        for (int i = 0; i < n; ++i) {
            this.array[this.size++] = dis.readShort();
        }
    }

    @Override
    public void externalizeForDODS(DataOutputStream dos) throws Exception {
        dos.writeInt(this.size);
        dos.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            dos.writeInt(this.array[i]);
        }
    }

    @Override
    public void externalizeForDODS(DataOutputStream dos, int i) throws Exception {
        dos.writeInt(this.array[i]);
    }

    @Override
    public void internalizeFromDODS(DataInputStream dis) throws IOException {
        int nValues = dis.readInt();
        dis.readInt();
        this.ensureCapacity((long)this.size + (long)nValues);
        for (int i = 0; i < nValues; ++i) {
            this.array[this.size++] = (short)dis.readInt();
        }
    }

    public static double rafReadDouble(RandomAccessFile raf, long start, long index) throws Exception {
        raf.seek(start + 2L * index);
        short s = raf.readShort();
        return s == Short.MAX_VALUE ? Double.NaN : (double)s;
    }

    public static void rafWriteDouble(RandomAccessFile raf, double value) throws Exception {
        raf.writeShort(Math2.roundToShort(value));
    }

    public static void rafWriteDouble(RandomAccessFile raf, long start, long index, double value) throws Exception {
        raf.seek(start + 2L * index);
        raf.writeShort(Math2.roundToShort(value));
    }

    @Override
    public void append(PrimitiveArray primitiveArray) {
        int otherSize = primitiveArray.size();
        this.ensureCapacity((long)this.size + (long)otherSize);
        if (primitiveArray instanceof ShortArray) {
            System.arraycopy(((ShortArray)primitiveArray).array, 0, this.array, this.size, otherSize);
        } else {
            for (int i = 0; i < otherSize; ++i) {
                this.array[this.size + i] = Math2.narrowToShort(primitiveArray.getInt(i));
            }
        }
        this.size += otherSize;
    }

    @Override
    public PrimitiveArray makeIndices(IntArray indices) {
        indices.clear();
        if (this.size == 0) {
            return new ShortArray();
        }
        Integer dummy = new Integer(-1);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(Math2.roundToInt(1.4 * (double)this.size));
        short lastValue = this.array[0];
        hashMap.put(new Short(lastValue), dummy);
        boolean alreadySorted = true;
        for (int i = 1; i < this.size; ++i) {
            short currentValue = this.array[i];
            if (currentValue == lastValue) continue;
            if (currentValue < lastValue) {
                alreadySorted = false;
            }
            lastValue = currentValue;
            hashMap.put(new Short(lastValue), dummy);
        }
        Set keySet = hashMap.keySet();
        int nUnique = keySet.size();
        if (nUnique == this.size && alreadySorted) {
            indices.ensureCapacity(this.size);
            for (int i = 0; i < this.size; ++i) {
                indices.add(i);
            }
            return this;
        }
        Object[] unique = new Object[nUnique];
        Iterator iterator = keySet.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            unique[count++] = iterator.next();
        }
        Test.ensureEqual(nUnique, count, "ShortArray.makeRankArray nUnique != count!");
        Arrays.sort(unique);
        short[] tUnique = new short[nUnique];
        for (int i = 0; i < count; ++i) {
            hashMap.put(unique[i], new Integer(i));
            tUnique[i] = (Short)unique[i];
        }
        int[] ranks = new int[this.size];
        lastValue = this.array[0];
        ranks[0] = (Integer)hashMap.get(new Short(lastValue));
        int lastRank = ranks[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i] == lastValue) {
                ranks[i] = lastRank;
                continue;
            }
            lastValue = this.array[i];
            ranks[i] = (Integer)hashMap.get(new Short(lastValue));
            lastRank = ranks[i];
        }
        indices.append(new IntArray(ranks));
        return new ShortArray(tUnique);
    }

    @Override
    public int switchFromTo(String tFrom, String tTo) {
        short to;
        short from = Math2.roundToShort(String2.parseDouble(tFrom));
        if (from == (to = Math2.roundToShort(String2.parseDouble(tTo)))) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != from) continue;
            this.array[i] = to;
            ++count;
        }
        return count;
    }

    @Override
    public String isAscending() {
        if (this.size == 0) {
            return "";
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i - 1] <= this.array[i]) continue;
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + this.array[i - 1] + " > [" + i + "]=" + this.array[i]);
        }
        if (this.array[this.size - 1] == Short.MAX_VALUE) {
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + (this.size - 1) + "]=(" + ArrayMissingValue + ")");
        }
        return "";
    }

    @Override
    public String isDescending() {
        if (this.size == 0) {
            return "";
        }
        if (this.array[0] == Short.MAX_VALUE) {
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[0]=(" + ArrayMissingValue + ")");
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i - 1] >= this.array[i]) continue;
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + this.array[i - 1] + " < [" + i + "]=" + this.array[i]);
        }
        return "";
    }

    @Override
    public int firstTie() {
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i - 1] != this.array[i]) continue;
            return i - 1;
        }
        return -1;
    }

    @Override
    public String minValue() {
        return "-32768";
    }

    @Override
    public String maxValue() {
        return "32766";
    }

    @Override
    public int[] getNMinMaxIndex() {
        int n = 0;
        int tmini = -1;
        int tmaxi = -1;
        short tmin = 32766;
        short tmax = Short.MIN_VALUE;
        for (int i = 0; i < this.size; ++i) {
            short v = this.array[i];
            if (v == Short.MAX_VALUE) continue;
            ++n;
            if (v <= tmin) {
                tmini = i;
                tmin = v;
            }
            if (v < tmax) continue;
            tmaxi = i;
            tmax = v;
        }
        return new int[]{n, tmini, tmaxi};
    }

    public static void test() throws Throwable {
        String2.log("*** Testing ShortArray");
        ShortArray anArray = new ShortArray();
        Test.ensureEqual(anArray.size(), 0L, "");
        anArray.add((short)32000);
        Test.ensureEqual(anArray.size(), 1L, "");
        Test.ensureEqual(anArray.get(0), 32000L, "");
        Test.ensureEqual(anArray.getInt(0), 32000L, "");
        Test.ensureEqual(anArray.getFloat(0), 32000.0f, "");
        Test.ensureEqual(anArray.getDouble(0), 32000.0, "");
        Test.ensureEqual(anArray.getString(0), "32000", "");
        Test.ensureEqual(anArray.elementClass(), Short.TYPE, "");
        short[] tArray = anArray.toArray();
        Test.ensureEqual((Object)tArray, (Object)new short[]{32000}, "");
        try {
            anArray.get(1);
            throw new Throwable("It should have failed.");
        }
        catch (Exception e) {
            try {
                anArray.set(1, (short)100);
                throw new Throwable("It should have failed.");
            }
            catch (Exception e2) {
                try {
                    anArray.getInt(1);
                    throw new Throwable("It should have failed.");
                }
                catch (Exception e3) {
                    try {
                        anArray.setInt(1, 100);
                        throw new Throwable("It should have failed.");
                    }
                    catch (Exception e4) {
                        try {
                            anArray.getLong(1);
                            throw new Throwable("It should have failed.");
                        }
                        catch (Exception e5) {
                            try {
                                anArray.setLong(1, 100L);
                                throw new Throwable("It should have failed.");
                            }
                            catch (Exception e6) {
                                try {
                                    anArray.getFloat(1);
                                    throw new Throwable("It should have failed.");
                                }
                                catch (Exception e7) {
                                    try {
                                        anArray.setFloat(1, 100.0f);
                                        throw new Throwable("It should have failed.");
                                    }
                                    catch (Exception e8) {
                                        try {
                                            anArray.getDouble(1);
                                            throw new Throwable("It should have failed.");
                                        }
                                        catch (Exception e9) {
                                            try {
                                                anArray.setDouble(1, 100.0);
                                                throw new Throwable("It should have failed.");
                                            }
                                            catch (Exception e10) {
                                                try {
                                                    anArray.getString(1);
                                                    throw new Throwable("It should have failed.");
                                                }
                                                catch (Exception e11) {
                                                    try {
                                                        anArray.setString(1, "100");
                                                        throw new Throwable("It should have failed.");
                                                    }
                                                    catch (Exception e12) {
                                                        anArray.setDouble(0, Double.NaN);
                                                        Test.ensureEqual(anArray.getDouble(0), Double.NaN, "");
                                                        anArray.setDouble(0, -1.0E300);
                                                        Test.ensureEqual(anArray.getDouble(0), Double.NaN, "");
                                                        anArray.setDouble(0, 2.2);
                                                        Test.ensureEqual(anArray.getDouble(0), 2.0, "");
                                                        anArray.setFloat(0, Float.NaN);
                                                        Test.ensureEqual(anArray.getFloat(0), Float.NaN, "");
                                                        anArray.setFloat(0, -1.0E33f);
                                                        Test.ensureEqual(anArray.getFloat(0), Float.NaN, "");
                                                        anArray.setFloat(0, 3.3f);
                                                        Test.ensureEqual(anArray.getFloat(0), 3.0f, "");
                                                        anArray.setLong(0, Long.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getLong(0), Long.MAX_VALUE, "");
                                                        anArray.setLong(0, 9123456789L);
                                                        Test.ensureEqual(anArray.getLong(0), Long.MAX_VALUE, "");
                                                        anArray.setLong(0, 4L);
                                                        Test.ensureEqual(anArray.getLong(0), 4L, "");
                                                        anArray.setInt(0, Integer.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getInt(0), Integer.MAX_VALUE, "");
                                                        anArray.setInt(0, 1123456789);
                                                        Test.ensureEqual(anArray.getInt(0), Integer.MAX_VALUE, "");
                                                        anArray.setInt(0, 5);
                                                        Test.ensureEqual(anArray.getInt(0), 5L, "");
                                                        anArray = new ShortArray(2, false);
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        for (int i = 0; i < 10; ++i) {
                                                            anArray.add((short)i);
                                                            Test.ensureEqual(anArray.get(i), i, "");
                                                            Test.ensureEqual(anArray.size(), i + 1, "");
                                                        }
                                                        Test.ensureEqual(anArray.size(), 10L, "");
                                                        anArray.clear();
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        anArray = new ShortArray(3, true);
                                                        Test.ensureEqual(anArray.size(), 3L, "");
                                                        Test.ensureEqual(anArray.get(2), 0L, "");
                                                        anArray = new ShortArray(new short[]{0, 2, 4, 6, 8});
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 2L, "");
                                                        Test.ensureEqual(anArray.get(2), 4L, "");
                                                        Test.ensureEqual(anArray.get(3), 6L, "");
                                                        Test.ensureEqual(anArray.get(4), 8L, "");
                                                        Test.ensureEqual(anArray.compare(1, 3), -4L, "");
                                                        Test.ensureEqual(anArray.compare(1, 1), 0L, "");
                                                        Test.ensureEqual(anArray.compare(3, 1), 4L, "");
                                                        Test.ensureEqual(anArray.toString(), "0, 2, 4, 6, 8", "");
                                                        anArray.addString("");
                                                        double[] stats = anArray.calculateStats();
                                                        anArray.remove(5);
                                                        Test.ensureEqual(stats[0], 5.0, "");
                                                        Test.ensureEqual(stats[1], 0.0, "");
                                                        Test.ensureEqual(stats[2], 8.0, "");
                                                        Test.ensureEqual(stats[3], 20.0, "");
                                                        Test.ensureEqual(anArray.indexOf((short)0, 0), 0L, "");
                                                        Test.ensureEqual(anArray.indexOf((short)0, 1), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf((short)8, 0), 4L, "");
                                                        Test.ensureEqual(anArray.indexOf((short)9, 0), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 0), 0L, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 1), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf("8", 0), 4L, "");
                                                        Test.ensureEqual(anArray.indexOf("9", 0), -1L, "");
                                                        anArray.remove(1);
                                                        Test.ensureEqual(anArray.size(), 4L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 4L, "");
                                                        Test.ensureEqual(anArray.get(3), 8L, "");
                                                        anArray.add(1, (short)22);
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 22L, "");
                                                        Test.ensureEqual(anArray.get(2), 4L, "");
                                                        Test.ensureEqual(anArray.get(4), 8L, "");
                                                        anArray.remove(1);
                                                        anArray.removeRange(4, 4);
                                                        anArray.removeRange(1, 3);
                                                        Test.ensureEqual(anArray.size(), 2L, "");
                                                        Test.ensureEqual(anArray.get(0), 0L, "");
                                                        Test.ensureEqual(anArray.get(1), 8L, "");
                                                        Test.ensureEqual(anArray.toString(), "0, 8", "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        Test.ensureEqual(anArray.toStringArray(), new String[]{"0", "8"}, "");
                                                        anArray.trimToSize();
                                                        Test.ensureEqual(anArray.array.length, 2L, "");
                                                        ShortArray anArray2 = new ShortArray();
                                                        anArray2.add((short)0);
                                                        Test.ensureEqual(anArray.testEquals("A String"), "The two objects aren't equal: this object is a ShortArray; the other is a java.lang.String.", "");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two ShortArrays aren't equal: one has 2 values (from 0 to 8); the other has 1 value (0).", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.addString("7");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two ShortArrays aren't equal: this[1]=8; other[1]=7.", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.setString(1, "8");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "", "");
                                                        Test.ensureTrue(anArray.equals(anArray2), "");
                                                        Test.ensureEqual((Object)anArray.toArray(), anArray.toObjectArray(), "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        int[] rank = new int[]{1, 0};
                                                        anArray.reorder(rank);
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{8.0, 0.0}, "");
                                                        anArray = new ShortArray(new short[]{1});
                                                        anArray.append(new ByteArray(new byte[]{5, -5}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0}, "");
                                                        anArray.append(new StringArray(new String[]{"a", "9"}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray2 = (ShortArray)anArray.clone();
                                                        Test.ensureEqual((Object)anArray2.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray = new ShortArray(new short[]{0, 1, 2, 3, 4});
                                                        anArray.move(1, 3, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new short[]{1, 2, 0, 3, 4}, "");
                                                        anArray = new ShortArray(new short[]{0, 1, 2, 3, 4});
                                                        anArray.move(1, 2, 4);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new short[]{0, 2, 3, 1, 4}, "");
                                                        anArray = new ShortArray(new short[]{0, 1, 2, 3, 4});
                                                        anArray.move(1, 1, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new short[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(1, 2, 1);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new short[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(1, 2, 2);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new short[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(5, 5, 0);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new short[]{0, 1, 2, 3, 4}, "");
                                                        anArray.move(3, 5, 5);
                                                        Test.ensureEqual((Object)anArray.toArray(), (Object)new short[]{0, 1, 2, 3, 4}, "");
                                                        anArray = new ShortArray(new short[]{25, 1, 1, 10});
                                                        IntArray indices = new IntArray();
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "1, 10, 25", "");
                                                        Test.ensureEqual(indices.toString(), "2, 0, 0, 1", "");
                                                        anArray = new ShortArray(new short[]{35, 35, Short.MAX_VALUE, 1, 2});
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "1, 2, 35, 32767", "");
                                                        Test.ensureEqual(indices.toString(), "2, 2, 3, 0, 1", "");
                                                        anArray = new ShortArray(new short[]{10, 20, 30, 40});
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "10, 20, 30, 40", "");
                                                        Test.ensureEqual(indices.toString(), "0, 1, 2, 3", "");
                                                        anArray = new ShortArray(new short[]{Short.MAX_VALUE, 1, 2, Short.MAX_VALUE, 3, Short.MAX_VALUE});
                                                        Test.ensureEqual(anArray.switchFromTo("", "75"), 3L, "");
                                                        Test.ensureEqual(anArray.toString(), "75, 1, 2, 75, 3, 75", "");
                                                        anArray.switchFromTo("75", "");
                                                        Test.ensureEqual(anArray.toString(), "32767, 1, 2, 32767, 3, 32767", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 1, 4}, "");
                                                        anArray = new ShortArray(new short[]{25});
                                                        anArray.addN(2, (short)5);
                                                        Test.ensureEqual(anArray.toString(), "25, 5, 5", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 2, 0}, "");
                                                        anArray.add(new short[]{17, 19});
                                                        Test.ensureEqual(anArray.toString(), "25, 5, 5, 17, 19", "");
                                                        PrimitiveArray ss = anArray.subset(1, 3, 4);
                                                        Test.ensureEqual(ss.toString(), "5, 19", "");
                                                        ss = anArray.subset(0, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "25", "");
                                                        ss = anArray.subset(0, 1, -1);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        ss = anArray.subset(1, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        anArray = new ShortArray(new short[]{10, 20, 30});
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "", "");
                                                        anArray.set(2, (short)31);
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "ShortArray isn't evenly spaced: [0]=10.0, [1]=20.0, spacing=10.0, average spacing=10.5.", "");
                                                        Test.ensureEqual(anArray.smallestBiggestSpacing(), "  smallest spacing=10.0: [0]=10.0, [1]=20.0\n  biggest  spacing=11.0: [1]=20.0, [2]=31.0", "");
                                                        anArray = new ShortArray(new short[]{10, 10, 30});
                                                        Test.ensureEqual(anArray.isAscending(), "", "");
                                                        anArray.set(2, (short)Short.MAX_VALUE);
                                                        Test.ensureEqual(anArray.isAscending(), "ShortArray isn't sorted in ascending order: [2]=(missing value).", "");
                                                        anArray.set(1, (short)9);
                                                        Test.ensureEqual(anArray.isAscending(), "ShortArray isn't sorted in ascending order: [0]=10 > [1]=9.", "");
                                                        anArray = new ShortArray(new short[]{30, 10, 10});
                                                        Test.ensureEqual(anArray.isDescending(), "", "");
                                                        anArray.set(2, (short)Short.MAX_VALUE);
                                                        Test.ensureEqual(anArray.isDescending(), "ShortArray isn't sorted in descending order: [1]=10 < [2]=32767.", "");
                                                        anArray.set(1, (short)35);
                                                        Test.ensureEqual(anArray.isDescending(), "ShortArray isn't sorted in descending order: [0]=30 < [1]=35.", "");
                                                        anArray = new ShortArray(new short[]{30, 35, 10});
                                                        Test.ensureEqual(anArray.firstTie(), -1L, "");
                                                        anArray.set(1, (short)30);
                                                        Test.ensureEqual(anArray.firstTie(), 0L, "");
                                                        anArray = new ShortArray();
                                                        for (int i = 5; i < 1000; ++i) {
                                                            anArray.add((short)i);
                                                        }
                                                        String2.log("hashcode1=" + anArray.hashCode());
                                                        anArray2 = (ShortArray)anArray.clone();
                                                        Test.ensureEqual(anArray.hashCode(), anArray2.hashCode(), "");
                                                        anArray.add(0, (short)2);
                                                        Test.ensureTrue(anArray.hashCode() != anArray2.hashCode(), "");
                                                        BitSet bitset = new BitSet();
                                                        anArray = new ShortArray(new short[]{0, 11, 22, 33, 44});
                                                        bitset.set(1);
                                                        bitset.set(4);
                                                        anArray.justKeep(bitset);
                                                        Test.ensureEqual(anArray.toString(), "11, 44", "");
                                                        anArray = new ShortArray();
                                                        anArray.addString(anArray.minValue());
                                                        anArray.addString(anArray.maxValue());
                                                        Test.ensureEqual(anArray.getString(0), anArray.minValue(), "");
                                                        Test.ensureEqual(anArray.getString(0), "-32768", "");
                                                        Test.ensureEqual(anArray.getString(1), anArray.maxValue(), "");
                                                        return;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

