/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.array;

import com.cohort.array.ByteArray;
import com.cohort.array.DoubleArray;
import com.cohort.array.IntArray;
import com.cohort.array.PrimitiveArray;
import com.cohort.array.StringComparatorIgnoreCase;
import com.cohort.util.File2;
import com.cohort.util.Math2;
import com.cohort.util.MustBe;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class StringArray
extends PrimitiveArray {
    public String[] array;

    public StringArray() {
        this.array = new String[8];
    }

    public StringArray(PrimitiveArray primitiveArray) {
        this.array = new String[8];
        this.append(primitiveArray);
    }

    public StringArray(int capacity, boolean active) {
        Math2.ensureMemoryAvailable(16L * (long)capacity, "StringArray");
        this.array = new String[capacity];
        if (active) {
            this.size = capacity;
            for (int i = 0; i < this.size; ++i) {
                this.array[i] = "";
            }
        }
    }

    public StringArray(String[] anArray) {
        this.array = anArray;
        this.size = anArray.length;
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = String2.canonical(this.array[i]);
        }
    }

    public StringArray(Iterator iterator) {
        this.array = new String[8];
        while (iterator.hasNext()) {
            this.add(iterator.next().toString());
        }
    }

    public StringArray(Enumeration enumeration) {
        this.array = new String[8];
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement().toString());
        }
    }

    public static StringArray fromFile(String fileName) throws Exception {
        return StringArray.fromFile(fileName, null);
    }

    public static StringArray fromFile(String fileName, String charset) throws Exception {
        Math2.ensureMemoryAvailable(File2.length(fileName), "StringArray.fromFile");
        StringArray sa = new StringArray();
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = charset == null || charset.length() == 0 ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, charset);
        BufferedReader bufferedReader = new BufferedReader(isr);
        String s = bufferedReader.readLine();
        while (s != null) {
            sa.add(s);
            s = bufferedReader.readLine();
        }
        bufferedReader.close();
        return sa;
    }

    public static StringArray fromInputStream(InputStream inputStream, String charset) throws IOException {
        StringArray sa = new StringArray();
        InputStreamReader isr = charset == null || charset.length() == 0 ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(isr);
        String s = bufferedReader.readLine();
        while (s != null) {
            sa.add(s);
            s = bufferedReader.readLine();
        }
        bufferedReader.close();
        return sa;
    }

    public void toFile(String fileName) throws Exception {
        this.toFile(fileName, null, null);
    }

    public void toFile(String fileName, String charset, String lineSeparator) throws Exception {
        Exception e;
        block9: {
            if (lineSeparator == null || lineSeparator.length() == 0) {
                lineSeparator = String2.lineSeparator;
            }
            boolean append = false;
            e = null;
            BufferedWriter bufferedWriter = null;
            try {
                if (charset == null || charset.length() == 0) {
                    charset = "ISO-8859-1";
                }
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), charset);
                bufferedWriter = new BufferedWriter(w);
                for (int i = 0; i < this.size; ++i) {
                    bufferedWriter.write(this.array[i]);
                    bufferedWriter.write(lineSeparator);
                }
            }
            catch (Exception e2) {
                e = e2;
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception e2) {
                if (e != null) break block9;
                e = e2;
            }
        }
        if (e != null) {
            File2.delete(fileName);
            throw e;
        }
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.size; ++i) {
            code = 31 * code + this.array[i].hashCode();
        }
        return code;
    }

    @Override
    public PrimitiveArray subset(int startIndex, int stride, int stopIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(ArraySubsetStart, this.getClass().getSimpleName(), "" + startIndex));
        }
        if (stride < 1) {
            throw new IllegalArgumentException(MessageFormat.format(ArraySubsetStride, this.getClass().getSimpleName(), "" + stride));
        }
        if (stopIndex >= this.size) {
            stopIndex = this.size - 1;
        }
        if (stopIndex < startIndex) {
            return new StringArray(new String[0]);
        }
        int willFind = StringArray.strideWillFind(stopIndex - startIndex + 1, stride);
        Math2.ensureMemoryAvailable(16L * (long)willFind, "StringArray");
        String[] tar = new String[willFind];
        if (stride == 1) {
            System.arraycopy(this.array, startIndex, tar, 0, willFind);
        } else {
            int po = 0;
            for (int i = startIndex; i <= stopIndex; i += stride) {
                tar[po++] = this.array[i];
            }
        }
        return new StringArray(tar);
    }

    @Override
    public Class elementClass() {
        return String.class;
    }

    @Override
    public int elementClassIndex() {
        return 7;
    }

    public void add(String value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        this.array[this.size++] = String2.canonical(value);
    }

    public void addNotCanonical(String value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        this.array[this.size++] = value;
    }

    public void makeCanonical() {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = String2.canonical(this.array[i]);
        }
    }

    public void add(String[] sar) {
        int otherSize = sar.length;
        this.ensureCapacity((long)this.size + (long)otherSize);
        for (int i = 0; i < otherSize; ++i) {
            this.array[this.size + i] = String2.canonical(sar[i]);
        }
        this.size += otherSize;
    }

    public void addN(int n, String value) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayAddN, this.getClass().getSimpleName(), "" + n));
        }
        value = String2.canonical(value);
        this.ensureCapacity((long)this.size + (long)n);
        Arrays.fill(this.array, this.size, this.size + n, value);
        this.size += n;
    }

    public void add(int index, String value) {
        if (this.size == this.array.length) {
            this.ensureCapacity((long)this.size + 1L);
        }
        System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        ++this.size;
        this.array[index] = String2.canonical(value);
    }

    @Override
    public void addString(int index, String value) {
        this.add(index, String2.canonical(value));
    }

    @Override
    public void addNStrings(int n, String value) {
        this.addN(n, value);
    }

    @Override
    public void addString(String value) {
        this.add(value);
    }

    @Override
    public void addFloat(float value) {
        this.add(Math2.isFinite(value) ? String.valueOf(value) : "");
    }

    @Override
    public void addDouble(double value) {
        this.add(Math2.isFinite(value) ? String.valueOf(value) : "");
    }

    @Override
    public void addNDoubles(int n, double value) {
        this.addN(n, Math2.isFinite(value) ? String.valueOf(value) : "");
    }

    @Override
    public void addInt(int value) {
        this.add(value == Integer.MAX_VALUE ? "" : String.valueOf(value));
    }

    @Override
    public void addNInts(int n, int value) {
        this.addN(n, value == Integer.MAX_VALUE ? "" : String.valueOf(value));
    }

    @Override
    public void addLong(long value) {
        this.add(value == Long.MAX_VALUE ? "" : String.valueOf(value));
    }

    @Override
    public void addFromPA(PrimitiveArray otherPA, int otherIndex) {
        this.add(otherPA.getString(otherIndex));
    }

    @Override
    public void setFromPA(int index, PrimitiveArray otherPA, int otherIndex) {
        this.set(index, otherPA.getString(otherIndex));
    }

    @Override
    public void remove(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(MessageFormat.format(ArrayRemove, this.getClass().getSimpleName(), "" + index, "" + this.size));
        }
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
        this.array[this.size] = null;
    }

    @Override
    public void removeRange(int from, int to) {
        if (to > this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in StringArray.removeRange: to (" + to + ") > size (" + this.size + ").");
        }
        if (from >= to) {
            if (from == to) {
                return;
            }
            throw new IllegalArgumentException(String2.ERROR + " in StringArray.removeRange: from (" + from + ") > to (" + to + ").");
        }
        System.arraycopy(this.array, to, this.array, from, this.size - to);
        this.size -= to - from;
        Arrays.fill(this.array, this.size, this.size + to - from, null);
    }

    @Override
    public void move(int first, int last, int destination) {
        String errorIn = String2.ERROR + " in StringArray.move:\n";
        Test.ensureTrue(first >= 0, errorIn + "first (" + first + ") must be >= 0.");
        Test.ensureTrue(last >= first && last <= this.size, errorIn + "last (" + last + ") must be >= first (" + first + ") and <= size (" + this.size + ").");
        Test.ensureTrue(destination >= 0 && destination <= this.size, errorIn + "destination (" + destination + ") must be between 0 and size (" + this.size + ").");
        Test.ensureTrue(destination <= first || destination >= last, errorIn + "destination (" + destination + ") must be <= first (" + first + ") or >= last (" + last + ").");
        if (first == last || destination == first || destination == last) {
            return;
        }
        int nToMove = last - first;
        String[] temp = new String[nToMove];
        System.arraycopy(this.array, first, temp, 0, nToMove);
        if (destination < first) {
            System.arraycopy(this.array, destination, this.array, destination + nToMove, first - destination);
            System.arraycopy(temp, 0, this.array, destination, nToMove);
        } else {
            System.arraycopy(this.array, last, this.array, first, destination - last);
            System.arraycopy(temp, 0, this.array, destination - nToMove, nToMove);
        }
    }

    @Override
    public void justKeep(BitSet bitset) {
        int newSize = 0;
        for (int row = 0; row < this.size; ++row) {
            if (!bitset.get(row)) continue;
            this.array[newSize++] = this.array[row];
        }
        this.removeRange(newSize, this.size);
    }

    @Override
    public void ensureCapacity(long minCapacity) {
        if ((long)this.array.length < minCapacity) {
            Math2.ensureArraySizeOkay(minCapacity, "StringArray");
            int newCapacity = (int)Math.min(0x7FFFFFFEL, (long)this.array.length + (long)this.array.length);
            if ((long)newCapacity < minCapacity) {
                newCapacity = (int)minCapacity;
            }
            Math2.ensureMemoryAvailable(8L * (long)newCapacity, "StringArray");
            String[] newArray = new String[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    public String[] toArray() {
        if (this.array.length == this.size) {
            return this.array;
        }
        Math2.ensureMemoryAvailable(8L * (long)this.size, "StringArray.toArray");
        String[] tArray = new String[this.size];
        System.arraycopy(this.array, 0, tArray, 0, this.size);
        return tArray;
    }

    @Override
    public Object toObjectArray() {
        return this.toArray();
    }

    @Override
    public double[] toDoubleArray() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "StringArray.toDoubleArray");
        double[] dar = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            dar[i] = String2.parseDouble(this.array[i]);
        }
        return dar;
    }

    @Override
    public String[] toStringArray() {
        return this.toArray();
    }

    public String get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in StringArray.get: index (" + index + ") >= size (" + this.size + ").");
        }
        return this.array[index];
    }

    public void set(int index, String value) {
        if (index >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in StringArray.set: index (" + index + ") >= size (" + this.size + ").");
        }
        this.array[index] = String2.canonical(value);
    }

    @Override
    public int getInt(int index) {
        return String2.parseInt(this.get(index));
    }

    @Override
    public void setInt(int index, int i) {
        this.set(index, i == Integer.MAX_VALUE ? "" : String.valueOf(i));
    }

    @Override
    public long getLong(int index) {
        return String2.parseLong(this.get(index));
    }

    @Override
    public void setLong(int index, long i) {
        this.set(index, i == Long.MAX_VALUE ? "" : String.valueOf(i));
    }

    @Override
    public float getFloat(int index) {
        return String2.parseFloat(this.get(index));
    }

    @Override
    public void setFloat(int index, float d) {
        this.set(index, Math2.isFinite(d) ? String.valueOf(d) : "");
    }

    @Override
    public double getDouble(int index) {
        return String2.parseDouble(this.get(index));
    }

    @Override
    public void setDouble(int index, double d) {
        this.set(index, Math2.isFinite(d) ? String.valueOf(d) : "");
    }

    @Override
    public String getString(int index) {
        return this.get(index);
    }

    @Override
    public void setString(int index, String s) {
        this.set(index, s);
    }

    @Override
    public int indexOf(String lookFor) {
        return this.indexOf(lookFor, 0);
    }

    @Override
    public int indexOf(String lookFor, int startIndex) {
        for (int i = startIndex; i < this.size; ++i) {
            if (!this.array[i].equals(lookFor)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIgnoreCase(String lookFor) {
        return this.indexOfIgnoreCase(lookFor, 0);
    }

    public int indexOfIgnoreCase(String lookFor, int startIndex) {
        lookFor = lookFor.toLowerCase();
        for (int i = startIndex; i < this.size; ++i) {
            if (!this.array[i].toLowerCase().equals(lookFor)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(String lookFor, int startIndex) {
        if (startIndex >= this.size) {
            throw new IllegalArgumentException(String2.ERROR + " in StringArray.get: startIndex (" + startIndex + ") >= size (" + this.size + ").");
        }
        for (int i = startIndex; i >= 0; --i) {
            if (!this.array[i].equals(lookFor)) continue;
            return i;
        }
        return -1;
    }

    public int[] indexWith(String lookFor, int[] start) {
        int startPo = start[1];
        for (int i = start[0]; i < this.size; ++i) {
            int po = this.array[i].indexOf(lookFor, startPo);
            if (po >= 0) {
                start[0] = i;
                start[1] = po;
                return start;
            }
            startPo = 0;
        }
        start[0] = -1;
        start[1] = -1;
        return start;
    }

    @Override
    public void trimToSize() {
        this.array = this.toArray();
    }

    public boolean equals(Object o) {
        return this.testEquals(o).length() == 0;
    }

    @Override
    public String testEquals(Object o) {
        if (!(o instanceof StringArray)) {
            return "The two objects aren't equal: this object is a StringArray; the other is a " + o.getClass().getName() + ".";
        }
        StringArray other = (StringArray)o;
        if (other.size() != this.size) {
            return "The two StringArrays aren't equal: one has " + this.size + " value" + (this.size == 0 ? "s" : (this.size == 1 ? " (\"" + this.array[0] + "\")" : "s (from \"" + this.array[0] + "\" to \"" + this.array[this.size - 1] + "\")")) + "; the other has " + other.size() + " value" + (other.size == 0 ? "s" : (other.size == 1 ? " (\"" + other.array[0] + "\")" : "s (from \"" + other.array[0] + "\" to \"" + other.array[other.size - 1] + "\")")) + ".";
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i].equals(other.array[i])) continue;
            return "The two StringArrays aren't equal: this[" + i + "]=\"" + this.array[i] + "\"; other[" + i + "]=\"" + other.array[i] + "\".";
        }
        return "";
    }

    @Override
    public String toCSVString() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "StringArray.toCSVString");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            String s;
            if (i > 0) {
                sb.append(',');
            }
            if ((s = this.array[i]) == null) continue;
            if (s.indexOf(34) >= 0) {
                s = String2.replaceAll(s, "\"", "\"\"");
                sb.append("\"" + s + "\"");
                continue;
            }
            if (s.indexOf(44) >= 0) {
                sb.append("\"" + s + "\"");
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "StringArray.toString");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            String s;
            if (i > 0) {
                sb.append(", ");
            }
            if ((s = this.array[i]) == null) continue;
            if (s.indexOf(34) >= 0) {
                s = String2.replaceAll(s, "\"", "\"\"");
                sb.append("\"" + s + "\"");
                continue;
            }
            if (s.indexOf(44) >= 0) {
                sb.append("\"" + s + "\"");
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public String toJsonCsvString() {
        Math2.ensureMemoryAvailable(8L * (long)this.size, "StringArray.toJsonCsvString");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String2.toJson(this.array[i]));
        }
        return sb.toString();
    }

    public String toNewlineString() {
        return String2.toNewlineString(this.toArray());
    }

    @Override
    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    @Override
    public void sortIgnoreCase() {
        Arrays.sort(this.array, 0, this.size, new StringComparatorIgnoreCase());
    }

    @Override
    public int compare(int index1, int index2) {
        return this.array[index1].compareTo(this.array[index2]);
    }

    @Override
    public int compareIgnoreCase(int index1, int index2) {
        String s1 = this.array[index1];
        String s2 = this.array[index2];
        int c = s1.compareToIgnoreCase(s2);
        if (c != 0) {
            return c;
        }
        return s1.compareTo(s2);
    }

    @Override
    public void copy(int from, int to) {
        this.array[to] = this.array[from];
    }

    @Override
    public void reorder(int[] rank) {
        int n = rank.length;
        String[] newArray = new String[this.array.length];
        for (int i = 0; i < n; ++i) {
            newArray[i] = this.array[rank[i]];
        }
        this.array = newArray;
    }

    @Override
    public int writeDos(DataOutputStream dos, int i) throws Exception {
        int po = dos.size();
        dos.writeUTF(this.array[i]);
        return dos.size() - po;
    }

    @Override
    public void readDis(DataInputStream dis, int n) throws Exception {
        this.ensureCapacity((long)this.size + (long)n);
        for (int i = 0; i < n; ++i) {
            this.array[this.size++] = String2.canonical(dis.readUTF());
        }
    }

    public static void externalizeForDODS(DataOutputStream dos, String s) throws Exception {
        int n = s.length();
        dos.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dos.writeByte(s.charAt(i));
        }
        while (n++ % 4 != 0) {
            dos.writeByte(0);
        }
    }

    @Override
    public void externalizeForDODS(DataOutputStream dos) throws Exception {
        dos.writeInt(this.size);
        dos.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            StringArray.externalizeForDODS(dos, this.array[i]);
        }
    }

    @Override
    public void externalizeForDODS(DataOutputStream dos, int i) throws Exception {
        StringArray.externalizeForDODS(dos, this.array[i]);
    }

    @Override
    public void internalizeFromDODS(DataInputStream dis) throws IOException {
        int nStrings = dis.readInt();
        this.ensureCapacity((long)this.size + (long)nStrings);
        dis.readInt();
        byte[] buffer = new byte[80];
        for (int i = 0; i < nStrings; ++i) {
            int nChar = dis.readInt();
            if (buffer.length < nChar) {
                buffer = new byte[nChar + 10];
            }
            dis.readFully(buffer, 0, nChar);
            this.add(new String(buffer, 0, nChar));
            while (nChar++ % 4 != 0) {
                dis.readByte();
            }
        }
    }

    public static String rafReadString(RandomAccessFile raf, long start, int index, int nBytesPer) throws Exception {
        int po;
        raf.seek(start + (long)(nBytesPer * index));
        byte[] bar = new byte[nBytesPer];
        raf.readFully(bar);
        for (po = 0; po < nBytesPer && bar[po] != 0; ++po) {
        }
        return new String(bar, 0, po);
    }

    @Override
    public void append(PrimitiveArray primitiveArray) {
        int otherSize = primitiveArray.size();
        this.ensureCapacity((long)this.size + (long)otherSize);
        if (primitiveArray instanceof StringArray) {
            System.arraycopy(((StringArray)primitiveArray).array, 0, this.array, this.size, otherSize);
        } else {
            for (int i = 0; i < otherSize; ++i) {
                this.array[this.size + i] = String2.canonical(primitiveArray.getString(i));
            }
        }
        this.size += otherSize;
    }

    public int maxStringLength() {
        int max = 0;
        for (int i = 0; i < this.size; ++i) {
            max = Math.max(max, this.array[i] == null ? 0 : this.array[i].length());
        }
        return max;
    }

    @Override
    public PrimitiveArray makeIndices(IntArray indices) {
        indices.clear();
        if (this.size == 0) {
            return new StringArray();
        }
        Integer dummy = new Integer(-1);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(Math2.roundToInt(1.4 * (double)this.size));
        String lastValue = this.array[0];
        hashMap.put(lastValue, dummy);
        boolean alreadySorted = true;
        for (int i = 1; i < this.size; ++i) {
            String currentValue = this.array[i];
            int compare = lastValue.compareTo(currentValue);
            if (compare == 0) continue;
            if (compare > 0) {
                alreadySorted = false;
            }
            lastValue = currentValue;
            hashMap.put(lastValue, dummy);
        }
        Set keySet = hashMap.keySet();
        int nUnique = keySet.size();
        if (nUnique == this.size && alreadySorted) {
            indices.ensureCapacity(this.size);
            for (int i = 0; i < this.size; ++i) {
                indices.add(i);
            }
            return this;
        }
        Object[] unique = new String[nUnique];
        Iterator iterator = keySet.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            unique[count++] = (String)iterator.next();
        }
        Test.ensureEqual(nUnique, count, "StringArray.makeRankArray nUnique != count!");
        Arrays.sort(unique);
        if (((String)unique[0]).length() == 0) {
            System.arraycopy(unique, 1, unique, 0, nUnique - 1);
            unique[nUnique - 1] = "";
        }
        for (int i = 0; i < count; ++i) {
            hashMap.put(unique[i], new Integer(i));
        }
        int[] ranks = new int[this.size];
        lastValue = this.array[0];
        ranks[0] = (Integer)hashMap.get(lastValue);
        int lastRank = ranks[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i] == lastValue) {
                ranks[i] = lastRank;
                continue;
            }
            lastValue = this.array[i];
            ranks[i] = (Integer)hashMap.get(lastValue);
            lastRank = ranks[i];
        }
        indices.append(new IntArray(ranks));
        return new StringArray((String[])unique);
    }

    @Override
    public int switchFromTo(String from, String to) {
        if (from.equals(to)) {
            return 0;
        }
        to = String2.canonical(to);
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!this.array[i].equals(from)) continue;
            this.array[i] = to;
            ++count;
        }
        return count;
    }

    public static StringArray wordsAndQuotedPhrases(String searchFor) {
        StringArray sa = new StringArray();
        if (searchFor == null) {
            return sa;
        }
        int po = 0;
        int n = searchFor.length();
        while (po < n) {
            int po2;
            char ch = searchFor.charAt(po);
            if (ch == '\"') {
                po2 = po + 1;
                while (po2 < n) {
                    if (searchFor.charAt(po2) == '\"') {
                        if (po2 + 1 >= n || searchFor.charAt(po2 + 1) != '\"') break;
                        po2 += 2;
                        continue;
                    }
                    ++po2;
                }
                String s = searchFor.substring(po + 1, po2);
                sa.add(String2.replaceAll(s, "\"\"", "\""));
                po = po2 + 1;
                continue;
            }
            if (String2.isWhite(ch) || ch == ',') {
                ++po;
                continue;
            }
            for (po2 = po + 1; po2 < searchFor.length() && !String2.isWhite(searchFor.charAt(po2)) && searchFor.charAt(po2) != ','; ++po2) {
            }
            sa.add(searchFor.substring(po, po2));
            po = po2;
        }
        return sa;
    }

    public static StringArray fromCSV(String searchFor) {
        return new StringArray(StringArray.arrayFromCSV(searchFor));
    }

    public static StringArray fromCSVNoBlanks(String searchFor) {
        StringArray sa = new StringArray(StringArray.arrayFromCSV(searchFor));
        int tSize = sa.size;
        String[] tArray = sa.array;
        BitSet bitset = new BitSet(tSize);
        for (int i = 0; i < tSize; ++i) {
            if (tArray[i].length() <= 0) continue;
            bitset.set(i);
        }
        sa.justKeep(bitset);
        return sa;
    }

    public static String[] arrayFromCSV(String searchFor) {
        if (searchFor == null) {
            return new String[0];
        }
        ArrayList<String> al = new ArrayList<String>();
        int po = 0;
        StringBuilder word = new StringBuilder();
        int n = searchFor.length();
        block0: while (po < n) {
            char ch;
            if ((ch = searchFor.charAt(po++)) == '\"') {
                if (word.length() == 0) {
                    word.append(' ');
                }
                int start = po;
                if (po >= n) continue;
                while (true) {
                    if ((ch = searchFor.charAt(po++)) == '\"' && po < n && searchFor.charAt(po) == '\"') {
                        word.append(searchFor.substring(start, po - 1));
                        start = po++;
                        continue;
                    }
                    if (ch == '\\' && po < n) {
                        word.append(searchFor.substring(start, po - 1));
                        ch = searchFor.charAt(po++);
                        if (ch == 't') {
                            word.append('\t');
                        } else if (ch == 'n') {
                            word.append('\n');
                        } else if (ch == '\'') {
                            word.append('\'');
                        } else if (ch == '\"') {
                            word.append('\"');
                        } else if (ch == '\\') {
                            word.append('\\');
                        } else {
                            word.append("\\" + ch);
                        }
                        start = po;
                        continue;
                    }
                    if (ch == '\"') {
                        word.append(searchFor.substring(start, po - 1));
                        continue block0;
                    }
                    if (po == n) break;
                }
                word.append(searchFor.substring(start, po));
                continue;
            }
            if (ch == ',') {
                al.add(word.toString().trim());
                word.setLength(0);
                word.append(' ');
                continue;
            }
            word.append(ch);
        }
        if (word.length() > 0) {
            al.add(word.toString().trim());
        }
        return String2.toStringArray(al.toArray());
    }

    @Override
    public String isAscending() {
        if (this.size == 0) {
            return "";
        }
        if (this.array[0] == null) {
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[0]=null");
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i] == null) {
                return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + i + "]=null");
            }
            if (this.array[i - 1].compareTo(this.array[i]) <= 0) continue;
            return MessageFormat.format(ArrayNotAscending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + String2.toJson(this.array[i - 1]) + " > [" + i + "]=" + String2.toJson(this.array[i]));
        }
        return "";
    }

    @Override
    public String isDescending() {
        if (this.size == 0) {
            return "";
        }
        if (this.array[0] == null) {
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[0]=null");
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.array[i] == null) {
                return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[" + i + "]=null");
            }
            if (this.array[i - 1].compareTo(this.array[i]) >= 0) continue;
            return MessageFormat.format(ArrayNotDescending, this.getClass().getSimpleName(), "[" + (i - 1) + "]=" + String2.toJson(this.array[i - 1]) + " < [" + i + "]=" + String2.toJson(this.array[i]));
        }
        return "";
    }

    @Override
    public int firstTie() {
        for (int i = 1; i < this.size; ++i) {
            if (!(this.array[i - 1] == null ? this.array[i] == null : this.array[i - 1].equals(this.array[i]))) continue;
            return i - 1;
        }
        return -1;
    }

    @Override
    public String isEvenlySpaced() {
        if (this.size <= 2) {
            return "";
        }
        double average = (this.getDouble(this.size - 1) - this.getDouble(0)) / ((double)this.size - 1.0);
        for (int i = 1; i < this.size; ++i) {
            if (Math2.almostEqual(9, this.getDouble(i) - this.getDouble(i - 1), average)) continue;
            return MessageFormat.format(ArrayNotEvenlySpaced, this.getClass().getSimpleName(), "" + (i - 1), "" + this.getDouble(i - 1), "" + i, "" + this.getDouble(i), "" + (this.getDouble(i) - this.getDouble(i - 1)), "" + average);
        }
        return "";
    }

    public void intraReplaceAll(String from, String to) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == null) continue;
            this.array[i] = String2.canonical(String2.replaceAll(this.array[i], from, to));
        }
    }

    public void intraReplaceAllIgnoreCase(String from, String to) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == null) continue;
            this.array[i] = String2.canonical(String2.replaceAllIgnoreCase(this.array[i], from, to));
        }
    }

    @Override
    public String minValue() {
        return "\u0000";
    }

    @Override
    public String maxValue() {
        return "\uffff";
    }

    @Override
    public int[] getNMinMaxIndex() {
        int n = 0;
        int tmini = -1;
        int tmaxi = -1;
        String tmin = "\uffff";
        String tmax = "\u0000";
        for (int i = 0; i < this.size; ++i) {
            String s = this.array[i];
            if (s == null || s.length() <= 0) continue;
            ++n;
            if (s.compareTo(tmin) <= 0) {
                tmini = i;
                tmin = s;
            }
            if (s.compareTo(tmax) < 0) continue;
            tmaxi = i;
            tmax = s;
        }
        return new int[]{n, tmini, tmaxi};
    }

    public String[] getNMinMax() {
        int[] nmm = this.getNMinMaxIndex();
        if (nmm[0] == 0) {
            return new String[]{"0", "", ""};
        }
        return new String[]{"" + nmm[0], this.array[nmm[1]], this.array[nmm[2]]};
    }

    public static void diff(String fileName1, String fileName2) throws Exception {
        StringArray sa1 = StringArray.fromFile(fileName1);
        StringArray sa2 = StringArray.fromFile(fileName2);
        sa1.diff(sa2);
    }

    public static void repeatedDiff(String fileName1, String fileName2) throws Exception {
        while (true) {
            try {
                String2.log("\nComparing " + fileName1 + "\n      and " + fileName2);
                StringArray sa1 = StringArray.fromFile(fileName1);
                StringArray sa2 = StringArray.fromFile(fileName2);
                sa1.diff(sa2);
                String2.log("!!! The files are the same!!!");
            }
            catch (Exception e) {
                String2.getStringFromSystemIn(MustBe.throwableToString(e) + "\nPress ^C to stop or Enter to compare the files again...");
                continue;
            }
            break;
        }
    }

    public static void test() throws Throwable {
        String2.log("*** Testing StringArray");
        StringArray anArray = new StringArray();
        Test.ensureEqual(anArray.size(), 0L, "");
        anArray.add("1234.5");
        Test.ensureEqual(anArray.size(), 1L, "");
        Test.ensureEqual(anArray.get(0), "1234.5", "");
        Test.ensureEqual(anArray.getInt(0), 1235L, "");
        Test.ensureEqual(anArray.getFloat(0), 1234.5f, "");
        Test.ensureEqual(anArray.getDouble(0), 1234.5, "");
        Test.ensureEqual(anArray.getString(0), "1234.5", "");
        Test.ensureEqual(anArray.elementClass(), String.class, "");
        Object[] tArray = anArray.toArray();
        Test.ensureEqual(tArray, new String[]{"1234.5"}, "");
        try {
            anArray.get(1);
            throw new Throwable("It should have failed.");
        }
        catch (Exception e) {
            try {
                anArray.set(1, "100");
                throw new Throwable("It should have failed.");
            }
            catch (Exception e2) {
                try {
                    anArray.getInt(1);
                    throw new Throwable("It should have failed.");
                }
                catch (Exception e3) {
                    try {
                        anArray.setInt(1, 100);
                        throw new Throwable("It should have failed.");
                    }
                    catch (Exception e4) {
                        try {
                            anArray.getLong(1);
                            throw new Throwable("It should have failed.");
                        }
                        catch (Exception e5) {
                            try {
                                anArray.setLong(1, 100L);
                                throw new Throwable("It should have failed.");
                            }
                            catch (Exception e6) {
                                try {
                                    anArray.getFloat(1);
                                    throw new Throwable("It should have failed.");
                                }
                                catch (Exception e7) {
                                    try {
                                        anArray.setFloat(1, 100.0f);
                                        throw new Throwable("It should have failed.");
                                    }
                                    catch (Exception e8) {
                                        try {
                                            anArray.getDouble(1);
                                            throw new Throwable("It should have failed.");
                                        }
                                        catch (Exception e9) {
                                            try {
                                                anArray.setDouble(1, 100.0);
                                                throw new Throwable("It should have failed.");
                                            }
                                            catch (Exception e10) {
                                                try {
                                                    anArray.getString(1);
                                                    throw new Throwable("It should have failed.");
                                                }
                                                catch (Exception e11) {
                                                    try {
                                                        anArray.setString(1, "100");
                                                        throw new Throwable("It should have failed.");
                                                    }
                                                    catch (Exception e12) {
                                                        anArray.setDouble(0, Double.NaN);
                                                        Test.ensureEqual(anArray.getDouble(0), Double.NaN, "");
                                                        anArray.setDouble(0, -1.0E300);
                                                        Test.ensureEqual(anArray.getDouble(0), -1.0E300, "");
                                                        anArray.setDouble(0, 2.2);
                                                        Test.ensureEqual(anArray.getDouble(0), 2.2, "");
                                                        anArray.setFloat(0, Float.NaN);
                                                        Test.ensureEqual(anArray.getFloat(0), Float.NaN, "");
                                                        anArray.setFloat(0, -1.0E33f);
                                                        Test.ensureEqual(anArray.getFloat(0), -1.0E33f, "");
                                                        anArray.setFloat(0, 3.3f);
                                                        Test.ensureEqual(anArray.getFloat(0), 3.3f, "");
                                                        anArray.setLong(0, Long.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getLong(0), Long.MAX_VALUE, "");
                                                        anArray.setLong(0, 9123456789L);
                                                        Test.ensureEqual(anArray.getLong(0), 9123456789L, "");
                                                        anArray.setLong(0, 4L);
                                                        Test.ensureEqual(anArray.getLong(0), 4L, "");
                                                        anArray.setInt(0, Integer.MAX_VALUE);
                                                        Test.ensureEqual(anArray.getInt(0), Integer.MAX_VALUE, "");
                                                        anArray.setInt(0, 1123456789);
                                                        Test.ensureEqual(anArray.getInt(0), 1123456789L, "");
                                                        anArray.setInt(0, 5);
                                                        Test.ensureEqual(anArray.getInt(0), 5L, "");
                                                        anArray = new StringArray(2, false);
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        for (int i = 0; i < 10; ++i) {
                                                            anArray.add(String.valueOf(i));
                                                            Test.ensureEqual(anArray.get(i), "" + i, "");
                                                            Test.ensureEqual(anArray.size(), i + 1, "");
                                                        }
                                                        Test.ensureEqual(anArray.size(), 10L, "");
                                                        anArray.clear();
                                                        Test.ensureEqual(anArray.size(), 0L, "");
                                                        anArray = new StringArray(3, true);
                                                        Test.ensureEqual(anArray.size(), 3L, "");
                                                        Test.ensureEqual(anArray.get(2), "", "");
                                                        anArray = new StringArray(new String[]{"0", "2", "4", "6", "8"});
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), "0", "");
                                                        Test.ensureEqual(anArray.get(1), "2", "");
                                                        Test.ensureEqual(anArray.get(2), "4", "");
                                                        Test.ensureEqual(anArray.get(3), "6", "");
                                                        Test.ensureEqual(anArray.get(4), "8", "");
                                                        Test.ensureEqual(anArray.compare(1, 3), -4L, "");
                                                        Test.ensureEqual(anArray.compare(1, 1), 0L, "");
                                                        Test.ensureEqual(anArray.compare(3, 1), 4L, "");
                                                        StringArray cic = StringArray.fromCSV("A, a, ABE, abe");
                                                        Test.ensureEqual(cic.compareIgnoreCase(0, 1), -32L, "");
                                                        Test.ensureEqual(cic.compareIgnoreCase(1, 2), -2L, "");
                                                        Test.ensureEqual(cic.compareIgnoreCase(2, 3), -32L, "");
                                                        Test.ensureEqual(anArray.toString(), "0, 2, 4, 6, 8", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{5, 0, 4}, "");
                                                        Test.ensureEqual(anArray.getNMinMax(), new String[]{"5", "0", "8"}, "");
                                                        anArray.addString("");
                                                        double[] stats = anArray.calculateStats();
                                                        anArray.remove(5);
                                                        Test.ensureEqual(stats[0], 5.0, "");
                                                        Test.ensureEqual(stats[1], 0.0, "");
                                                        Test.ensureEqual(stats[2], 8.0, "");
                                                        Test.ensureEqual(stats[3], 20.0, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 0), 0L, "");
                                                        Test.ensureEqual(anArray.indexOf("0", 1), -1L, "");
                                                        Test.ensureEqual(anArray.indexOf("8", 0), 4L, "");
                                                        Test.ensureEqual(anArray.indexOf("9", 0), -1L, "");
                                                        Test.ensureEqual(anArray.lastIndexOf("0", 0), 0L, "");
                                                        Test.ensureEqual(anArray.lastIndexOf("0", 0), 0L, "");
                                                        Test.ensureEqual(anArray.lastIndexOf("8", 4), 4L, "");
                                                        Test.ensureEqual(anArray.lastIndexOf("6", 2), -1L, "");
                                                        Test.ensureEqual(anArray.lastIndexOf("6", 3), 3L, "");
                                                        Test.ensureEqual(anArray.lastIndexOf("9", 2), -1L, "");
                                                        anArray.remove(1);
                                                        Test.ensureEqual(anArray.size(), 4L, "");
                                                        Test.ensureEqual(anArray.get(0), "0", "");
                                                        Test.ensureEqual(anArray.get(1), "4", "");
                                                        Test.ensureEqual(anArray.get(3), "8", "");
                                                        Test.ensureEqual(anArray.array[4], null, "");
                                                        anArray.add(1, "22");
                                                        Test.ensureEqual(anArray.size(), 5L, "");
                                                        Test.ensureEqual(anArray.get(0), "0", "");
                                                        Test.ensureEqual(anArray.get(1), "22", "");
                                                        Test.ensureEqual(anArray.get(2), "4", "");
                                                        Test.ensureEqual(anArray.get(4), "8", "");
                                                        Test.ensureEqual(anArray.maxStringLength(), 2L, "");
                                                        anArray.remove(1);
                                                        Test.ensureEqual(anArray.maxStringLength(), 1L, "");
                                                        anArray.removeRange(4, 4);
                                                        anArray.removeRange(1, 3);
                                                        Test.ensureEqual(anArray.size(), 2L, "");
                                                        Test.ensureEqual(anArray.get(0), "0", "");
                                                        Test.ensureEqual(anArray.get(1), "8", "");
                                                        Test.ensureEqual(anArray.array[2], null, "");
                                                        Test.ensureEqual(anArray.array[3], null, "");
                                                        Test.ensureEqual(anArray.toString(), "0, 8", "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        Test.ensureEqual(anArray.toStringArray(), new String[]{"0", "8"}, "");
                                                        anArray.trimToSize();
                                                        Test.ensureEqual(anArray.array.length, 2L, "");
                                                        StringArray anArray2 = new StringArray();
                                                        anArray2.add("0");
                                                        Test.ensureEqual(anArray.testEquals("A String"), "The two objects aren't equal: this object is a StringArray; the other is a java.lang.String.", "");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two StringArrays aren't equal: one has 2 values (from \"0\" to \"8\"); the other has 1 value (\"0\").", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.addString("7");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "The two StringArrays aren't equal: this[1]=\"8\"; other[1]=\"7\".", "");
                                                        Test.ensureTrue(!anArray.equals(anArray2), "");
                                                        anArray2.setString(1, "8");
                                                        Test.ensureEqual(anArray.testEquals(anArray2), "", "");
                                                        Test.ensureTrue(anArray.equals(anArray2), "");
                                                        Test.ensureEqual((Object)anArray.toArray(), anArray.toObjectArray(), "");
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{0.0, 8.0}, "");
                                                        int[] rank = new int[]{1, 0};
                                                        anArray.reorder(rank);
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{8.0, 0.0}, "");
                                                        anArray = new StringArray(new String[]{"1"});
                                                        anArray.append(new ByteArray(new byte[]{5, -5}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0}, "");
                                                        anArray.append(new StringArray(new String[]{"a", "9"}));
                                                        Test.ensureEqual((Object)anArray.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray2 = (StringArray)anArray.clone();
                                                        Test.ensureEqual((Object)anArray2.toDoubleArray(), (Object)new double[]{1.0, 5.0, -5.0, Double.NaN, 9.0}, "");
                                                        anArray = new StringArray(new String[]{"0", "1", "2", "3", "4"});
                                                        anArray.move(1, 3, 0);
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"1", "2", "0", "3", "4"}, "");
                                                        anArray = new StringArray(new String[]{"0", "1", "2", "3", "4"});
                                                        anArray.move(1, 2, 4);
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"0", "2", "3", "1", "4"}, "");
                                                        anArray.reverse();
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"4", "1", "3", "2", "0"}, "");
                                                        anArray = new StringArray(new String[]{"0", "1", "2", "3", "4"});
                                                        anArray.move(1, 1, 0);
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"0", "1", "2", "3", "4"}, "");
                                                        anArray.move(1, 2, 1);
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"0", "1", "2", "3", "4"}, "");
                                                        anArray.move(1, 2, 2);
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"0", "1", "2", "3", "4"}, "");
                                                        anArray.move(5, 5, 0);
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"0", "1", "2", "3", "4"}, "");
                                                        anArray.move(3, 5, 5);
                                                        Test.ensureEqual(anArray.toArray(), new String[]{"0", "1", "2", "3", "4"}, "");
                                                        anArray = new StringArray(new String[]{"d", "a", "a", "b"});
                                                        IntArray indices = new IntArray();
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "a, b, d", "");
                                                        Test.ensureEqual(indices.toString(), "2, 0, 0, 1", "");
                                                        anArray = new StringArray(new String[]{"d", "d", "a", "", "b"});
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "a, b, d, ", "");
                                                        Test.ensureEqual(indices.toString(), "2, 2, 0, 3, 1", "");
                                                        anArray = new StringArray(new String[]{"aa", "ab", "ac", "ad"});
                                                        Test.ensureEqual(anArray.makeIndices(indices).toString(), "aa, ab, ac, ad", "");
                                                        Test.ensureEqual(indices.toString(), "0, 1, 2, 3", "");
                                                        anArray = new StringArray(new String[]{"", "1", "2", "", "3", ""});
                                                        Test.ensureEqual(anArray.switchFromTo("", "75"), 3L, "");
                                                        Test.ensureEqual(anArray.toString(), "75, 1, 2, 75, 3, 75", "");
                                                        anArray.switchFromTo("75", "");
                                                        Test.ensureEqual(anArray.toString(), ", 1, 2, , 3, ", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 1, 4}, "");
                                                        anArray = new StringArray(new String[]{"a"});
                                                        anArray.addN(2, "bb");
                                                        Test.ensureEqual(anArray.toString(), "a, bb, bb", "");
                                                        Test.ensureEqual((Object)anArray.getNMinMaxIndex(), (Object)new int[]{3, 0, 2}, "");
                                                        anArray.add(new String[]{"17", "19"});
                                                        Test.ensureEqual(anArray.toString(), "a, bb, bb, 17, 19", "");
                                                        PrimitiveArray ss = anArray.subset(1, 3, 4);
                                                        Test.ensureEqual(ss.toString(), "bb, 19", "");
                                                        ss = anArray.subset(0, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "a", "");
                                                        ss = anArray.subset(0, 1, -1);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        ss = anArray.subset(1, 1, 0);
                                                        Test.ensureEqual(ss.toString(), "", "");
                                                        Test.ensureEqual(StringArray.wordsAndQuotedPhrases(null).toString(), "", "");
                                                        Test.ensureEqual(StringArray.wordsAndQuotedPhrases("a bb").toString(), "a, bb", "");
                                                        Test.ensureEqual(StringArray.wordsAndQuotedPhrases(" a bb c ").toString(), "a, bb, c", "");
                                                        Test.ensureEqual(StringArray.wordsAndQuotedPhrases(",a,bb, c ,d").toString(), "a, bb, c, d", "");
                                                        Test.ensureEqual(StringArray.wordsAndQuotedPhrases(" a,\"b b\",c ").toString(), "a, b b, c", "");
                                                        Test.ensureEqual(StringArray.wordsAndQuotedPhrases(" a,\"b b").toString(), "a, b b", "");
                                                        Test.ensureEqual(StringArray.wordsAndQuotedPhrases(" , ").toString(), "", "");
                                                        anArray = StringArray.wordsAndQuotedPhrases(" a,\"b\"\"b\",c ");
                                                        Test.ensureEqual(anArray.toString(), "a, \"b\"\"b\", c", "");
                                                        Test.ensureEqual(anArray.get(1), "b\"b", "");
                                                        anArray = StringArray.wordsAndQuotedPhrases(" a \"b\"\"b\" c ");
                                                        Test.ensureEqual(anArray.toString(), "a, \"b\"\"b\", c", "");
                                                        Test.ensureEqual(anArray.get(1), "b\"b", "");
                                                        anArray = StringArray.wordsAndQuotedPhrases("a \"-bob\" c");
                                                        Test.ensureEqual(anArray.get(1), "-bob", "");
                                                        anArray = StringArray.wordsAndQuotedPhrases("a -\"bob\" c");
                                                        Test.ensureEqual(anArray.get(1), "-\"bob\"", "");
                                                        Test.ensureEqual(StringArray.fromCSV(null).toString(), "", "");
                                                        Test.ensureEqual(StringArray.fromCSV("a, b b").toString(), "a, b b", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a, b b ,c ").toString(), "a, b b, c", "");
                                                        Test.ensureEqual(StringArray.fromCSV(",a,b b, c ,d,").toString(), ", a, b b, c, d, ", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a, \"b b\" ,c ").toString(), "a, b b, c", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a,\"b b").toString(), "a, b b", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" , ").toString(), ", ", "");
                                                        anArray = StringArray.fromCSV(" a,\"b\"\"b\",c ");
                                                        Test.ensureEqual(anArray.get(1), "b\"b", "");
                                                        anArray = StringArray.fromCSV(" a,\"b\\\"b\",c ");
                                                        Test.ensureEqual(anArray.get(1), "b\"b", "");
                                                        anArray = StringArray.fromCSV(" a,\"b\\tb\",c ");
                                                        Test.ensureEqual(anArray.get(1), "b\tb", "");
                                                        anArray = StringArray.fromCSV(" a,\"b\\nb\",c ");
                                                        Test.ensureEqual(anArray.get(1), "b\nb", "");
                                                        anArray = StringArray.fromCSV(" a,\"b\\'b\",c ");
                                                        Test.ensureEqual(anArray.get(1), "b'b", "");
                                                        anArray = StringArray.fromCSV(" a,\"b\\\"b\",c ");
                                                        Test.ensureEqual(anArray.get(1), "b\"b", "");
                                                        anArray = StringArray.fromCSV(" a \"b\"\"b\" c ");
                                                        Test.ensureEqual(anArray.get(0), "a b\"b c", "");
                                                        anArray = new StringArray(new String[]{"10", "20", "30"});
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "", "");
                                                        anArray.set(2, "30.1");
                                                        Test.ensureEqual(anArray.isEvenlySpaced(), "StringArray isn't evenly spaced: [0]=10.0, [1]=20.0, spacing=10.0, average spacing=10.05.", "");
                                                        Test.ensureEqual(anArray.smallestBiggestSpacing(), "  smallest spacing=10.0: [0]=10.0, [1]=20.0\n  biggest  spacing=10.100000000000001: [1]=20.0, [2]=30.1", "");
                                                        Test.ensureEqual(StringArray.fromCSV(null).toString(), "", "");
                                                        Test.ensureEqual(StringArray.fromCSV("").toString(), "", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" ").toString(), "", "");
                                                        Test.ensureEqual(StringArray.fromCSV(",").toString(), ", ", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" , ").toString(), ", ", "");
                                                        Test.ensureEqual(StringArray.fromCSV("a,bb").toString(), "a, bb", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a , bb ").toString(), "a, bb", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a, bb ,c ").toString(), "a, bb, c", "");
                                                        Test.ensureEqual(StringArray.fromCSV(",a,bb, c ,").toString(), ", a, bb, c, ", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a,\"b b\",c ").toString(), "a, b b, c", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a,\"b b").toString(), "a, b b", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a,\"b \"\"\"\"b\"junk,c ").toString(), "a, \"b \"\"\"\"bjunk\", c", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a,\"b \"\"\"\"b\"junk,c ").get(1), "b \"\"bjunk", "");
                                                        Test.ensureEqual(StringArray.fromCSV(" a,\"b,b\"junk").toString(), "a, \"b,bjunk\"", "");
                                                        anArray = new StringArray(new String[]{"go", "go", "hi"});
                                                        Test.ensureEqual(anArray.isAscending(), "", "");
                                                        anArray.set(2, null);
                                                        Test.ensureEqual(anArray.isAscending(), "StringArray isn't sorted in ascending order: [2]=null.", "");
                                                        anArray.set(1, "ga");
                                                        Test.ensureEqual(anArray.isAscending(), "StringArray isn't sorted in ascending order: [0]=\"go\" > [1]=\"ga\".", "");
                                                        anArray = new StringArray(new String[]{"hi", "go", "go"});
                                                        Test.ensureEqual(anArray.isDescending(), "", "");
                                                        anArray.set(2, null);
                                                        Test.ensureEqual(anArray.isDescending(), "StringArray isn't sorted in descending order: [2]=null.", "");
                                                        anArray.set(1, "pa");
                                                        Test.ensureEqual(anArray.isDescending(), "StringArray isn't sorted in descending order: [0]=\"hi\" < [1]=\"pa\".", "");
                                                        anArray = new StringArray(new String[]{"hi", "pa", "go"});
                                                        Test.ensureEqual(anArray.firstTie(), -1L, "");
                                                        anArray.set(1, "hi");
                                                        Test.ensureEqual(anArray.firstTie(), 0L, "");
                                                        anArray.set(1, null);
                                                        Test.ensureEqual(anArray.firstTie(), -1L, "");
                                                        anArray.set(2, null);
                                                        Test.ensureEqual(anArray.firstTie(), 1L, "");
                                                        anArray = new StringArray(new String[]{"0", "11", "22"});
                                                        anArray2 = new StringArray(new String[]{"0", "11", "22"});
                                                        String s = anArray.diffString(anArray2);
                                                        Test.ensureEqual(s, "", "s=" + s);
                                                        anArray2.add("33");
                                                        s = anArray.diffString(anArray2);
                                                        Test.ensureEqual(s, "  old [3]=33,\n  new [3]=null.", "s=" + s);
                                                        anArray2.set(2, "23");
                                                        s = anArray.diffString(anArray2);
                                                        Test.ensureEqual(s, "  old [2]=23,\n  new [2]=22.", "s=" + s);
                                                        IntArray ia = new IntArray(new int[]{0, 11, 22});
                                                        s = anArray.diffString(ia);
                                                        Test.ensureEqual(s, "", "s=" + s);
                                                        ia.set(2, 23);
                                                        s = anArray.diffString(ia);
                                                        Test.ensureEqual(s, "  old [2]=23,\n  new [2]=22.", "s=" + s);
                                                        anArray = new StringArray();
                                                        for (int i = 5; i < 1000; ++i) {
                                                            anArray.add("" + i);
                                                        }
                                                        String2.log("hashcode1=" + anArray.hashCode());
                                                        anArray2 = (StringArray)anArray.clone();
                                                        Test.ensureEqual(anArray.hashCode(), anArray2.hashCode(), "");
                                                        anArray.add(0, "2");
                                                        Test.ensureTrue(anArray.hashCode() != anArray2.hashCode(), "");
                                                        BitSet bitset = new BitSet();
                                                        anArray = new StringArray(new String[]{"0", "11", "22", "33", "44"});
                                                        bitset.set(1);
                                                        bitset.set(4);
                                                        anArray.justKeep(bitset);
                                                        Test.ensureEqual(anArray.toString(), "11, 44", "");
                                                        anArray = new StringArray();
                                                        anArray.addString(anArray.minValue());
                                                        anArray.addString(anArray.maxValue());
                                                        Test.ensureEqual(anArray.getString(0), anArray.minValue(), "");
                                                        Test.ensureEqual(anArray.getString(0), "\u0000", "");
                                                        Test.ensureEqual(anArray.getString(1), anArray.maxValue(), "");
                                                        anArray = StringArray.fromCSV("AB, AB, Ab, Ab, aB, aB, ab, ab, ABC, ABc, AbC");
                                                        anArray.sortIgnoreCase();
                                                        Test.ensureEqual(anArray.toString(), "AB, AB, Ab, Ab, aB, aB, ab, ab, ABC, ABc, AbC", "");
                                                        DoubleArray da = new DoubleArray(new double[]{5.0, Double.NaN});
                                                        da.sort();
                                                        Test.ensureEqual(da.toString(), "5.0, NaN", "");
                                                        Test.ensureEqual(da.getString(1), "", "");
                                                        anArray = StringArray.fromCSV("a, b, d");
                                                        anArray2 = StringArray.fromCSV("a, c, d");
                                                        anArray.inCommon(anArray2);
                                                        Test.ensureEqual(anArray.toString(), "a, d", "");
                                                        anArray = StringArray.fromCSV("a, d");
                                                        anArray2 = StringArray.fromCSV("b, e");
                                                        anArray.inCommon(anArray2);
                                                        Test.ensureEqual(anArray.toString(), "", "");
                                                        anArray = StringArray.fromCSV("");
                                                        anArray2 = StringArray.fromCSV("a, c, d");
                                                        anArray.inCommon(anArray2);
                                                        Test.ensureEqual(anArray.toString(), "", "");
                                                        anArray = StringArray.fromCSV("");
                                                        anArray2 = StringArray.fromCSV("a, c, d");
                                                        anArray.inCommon(anArray2);
                                                        Test.ensureEqual(anArray.toString(), "", "");
                                                        anArray = StringArray.fromCSV("c");
                                                        anArray2 = StringArray.fromCSV("a, c, d");
                                                        anArray.inCommon(anArray2);
                                                        Test.ensureEqual(anArray.toString(), "c", "");
                                                        anArray = StringArray.fromCSV("a, b, c");
                                                        anArray2 = StringArray.fromCSV("c");
                                                        anArray.inCommon(anArray2);
                                                        Test.ensureEqual(anArray.toString(), "c", "");
                                                        anArray = StringArray.fromCSVNoBlanks(", b, ,d,,");
                                                        Test.ensureEqual(anArray.toString(), "b, d", "");
                                                        return;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

