/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.array.DoubleArray;
import com.cohort.array.StringArray;
import com.cohort.util.Math2;
import com.cohort.util.MustBe;
import com.cohort.util.SimpleException;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Calendar2 {
    public static final int ERA = 0;
    public static final int BC = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DATE = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int AM_PM = 9;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int MINUTES_PER_7DAYS = 10080;
    public static final int MINUTES_PER_30DAYS = 43200;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final String SECONDS_SINCE_1970 = "seconds since 1970-01-01T00:00:00Z";
    public static final TimeZone zuluTimeZone = TimeZone.getTimeZone("Zulu");
    private static final String[] MONTH_3 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] MONTH_FULL = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAY_OF_WEEK_3 = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final String[] DAY_OF_WEEK_FULL = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    public static String[] IDEAL_N_OPTIONS = new String[100];
    public static String[] IDEAL_UNITS_OPTIONS;
    public static double[] IDEAL_UNITS_SECONDS;
    public static int[] IDEAL_UNITS_FIELD;
    public static boolean verbose;
    public static boolean reallyVerbose;

    public static String fieldName(int field) {
        if (field == 1) {
            return "year";
        }
        if (field == 2) {
            return "month";
        }
        if (field == 5) {
            return "date";
        }
        if (field == 6) {
            return "day_of_year";
        }
        if (field == 10) {
            return "hour";
        }
        if (field == 11) {
            return "hour_of_day";
        }
        if (field == 12) {
            return "minute";
        }
        if (field == 13) {
            return "second";
        }
        if (field == 14) {
            return "millisecond";
        }
        if (field == 9) {
            return "am_pm";
        }
        if (field == 15) {
            return "zone_offset";
        }
        if (field == 16) {
            return "dst_offset";
        }
        return "unknown_field";
    }

    public static double[] getTimeBaseAndFactor(String tsUnits) throws Exception {
        String errorInMethod = String2.ERROR + " in Calendar2.getTimeBaseAndFactor(" + tsUnits + "):\n";
        Test.ensureNotNull(tsUnits, errorInMethod + "units string is null.");
        int sincePo = tsUnits.toLowerCase().indexOf(" since ");
        if (sincePo <= 0) {
            throw new SimpleException(errorInMethod + "units string doesn't contain \" since \".");
        }
        double factorToGetSeconds = Calendar2.factorToGetSeconds(tsUnits.substring(0, sincePo));
        GregorianCalendar baseGC = Calendar2.parseISODateTimeZulu(tsUnits.substring(sincePo + 7));
        double baseSeconds = (double)baseGC.getTimeInMillis() / 1000.0;
        return new double[]{baseSeconds, factorToGetSeconds};
    }

    public static double unitsSinceToEpochSeconds(double baseSeconds, double factorToGetSeconds, double unitsSince) {
        if (factorToGetSeconds >= 2592000.0) {
            int field;
            int intUnitsSince = Math2.roundToInt(Math.floor(unitsSince));
            if (intUnitsSince == Integer.MAX_VALUE) {
                return Double.NaN;
            }
            if (factorToGetSeconds == 2592000.0) {
                field = 2;
            } else if (factorToGetSeconds == 3.1104E7) {
                field = 1;
            } else {
                throw new RuntimeException(String2.ERROR + " in Calendar2.unitsSinceToEpochSeconds: factorToGetSeconds=\"" + factorToGetSeconds + "\" not expected.");
            }
            GregorianCalendar gc = Calendar2.epochSecondsToGc(baseSeconds);
            gc.add(field, intUnitsSince);
            if (unitsSince != (double)intUnitsSince) {
                double frac = unitsSince - (double)intUnitsSince;
                if (field == 2) {
                    gc.add(5, Math2.roundToInt(frac * 30.0));
                } else if (field == 1) {
                    gc.add(2, Math2.roundToInt(frac * 12.0));
                }
            }
            return Calendar2.gcToEpochSeconds(gc);
        }
        return baseSeconds + unitsSince * factorToGetSeconds;
    }

    public static double epochSecondsToUnitsSince(double baseSeconds, double factorToGetSeconds, double epochSeconds) {
        if (factorToGetSeconds >= 2592000.0) {
            if (!Math2.isFinite(epochSeconds)) {
                return Double.NaN;
            }
            GregorianCalendar es = Calendar2.epochSecondsToGc(epochSeconds);
            GregorianCalendar bs = Calendar2.epochSecondsToGc(baseSeconds);
            if (factorToGetSeconds == 2592000.0) {
                int esm = Calendar2.getYear(es) * 12 + es.get(2);
                int bsm = Calendar2.getYear(bs) * 12 + bs.get(2);
                return esm - bsm;
            }
            if (factorToGetSeconds == 3.1104E7) {
                return Calendar2.getYear(es) - Calendar2.getYear(bs);
            }
            throw new RuntimeException(String2.ERROR + " in Calendar2.epochSecondsToUnitsSince: factorToGetSeconds=\"" + factorToGetSeconds + "\" not expected.");
        }
        return (epochSeconds - baseSeconds) / factorToGetSeconds;
    }

    public static double factorToGetSeconds(String units) throws Exception {
        if ((units = units.trim().toLowerCase()).equals("ms") || units.equals("msec") || units.equals("msecs") || units.equals("millis") || units.equals("millisec") || units.equals("millisecs") || units.equals("millisecond") || units.equals("milliseconds")) {
            return 0.001;
        }
        if (units.equals("s") || units.equals("sec") || units.equals("secs") || units.equals("second") || units.equals("seconds")) {
            return 1.0;
        }
        if (units.equals("m") || units.equals("min") || units.equals("mins") || units.equals("minute") || units.equals("minutes")) {
            return 60.0;
        }
        if (units.equals("h") || units.equals("hr") || units.equals("hrs") || units.equals("hour") || units.equals("hours")) {
            return 3600.0;
        }
        if (units.equals("d") || units.equals("day") || units.equals("days")) {
            return 86400.0;
        }
        if (units.equals("week") || units.equals("weeks")) {
            return 604800.0;
        }
        if (units.equals("mon") || units.equals("mons") || units.equals("month") || units.equals("months")) {
            return 2592000.0;
        }
        if (units.equals("yr") || units.equals("yrs") || units.equals("year") || units.equals("years")) {
            return 3.1104E7;
        }
        Test.error(String2.ERROR + " in Calendar2.factorToGetSeconds: units=\"" + units + "\" is invalid.");
        return Double.NaN;
    }

    public static double isoStringToEpochSeconds(String isoZuluString) {
        return (double)Calendar2.isoZuluStringToMillis(isoZuluString) / 1000.0;
    }

    public static double safeIsoStringToEpochSeconds(String isoZuluString) {
        try {
            return (double)Calendar2.isoZuluStringToMillis(isoZuluString) / 1000.0;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static double nowStringToEpochSeconds(String nowString) {
        GregorianCalendar gc = Calendar2.newGCalendarZulu();
        gc.add(13, 1);
        gc.set(14, 0);
        String tError = "Query error: Timestamp constraints with \"now\" must be in the form \"now(+|-)[positiveInteger](seconds|minutes|hours|days|months|years)\".  \"" + nowString + "\" is invalid.";
        if (nowString == null || !nowString.startsWith("now")) {
            throw new SimpleException(tError);
        }
        if (nowString.length() > 3) {
            char ch = nowString.charAt(3);
            int start = -1;
            if (ch == '+' || ch == ' ') {
                start = 4;
            } else if (ch == '-') {
                start = 3;
            } else {
                throw new SimpleException(tError);
            }
            int n = 0;
            if (start > 0) {
                int end;
                for (end = 4; nowString.length() > end && String2.isDigit(nowString.charAt(end)); ++end) {
                }
                n = String2.parseInt(nowString.substring(start, end));
                if (n == Integer.MAX_VALUE) {
                    throw new SimpleException(tError);
                }
                start = end;
            }
            if (start > 0) {
                String sUnits = nowString.substring(start);
                if (sUnits.equals("second") || sUnits.equals("seconds")) {
                    gc.add(13, n);
                } else if (sUnits.equals("minute") || sUnits.equals("minutes")) {
                    gc.add(12, n);
                } else if (sUnits.equals("hour") || sUnits.equals("hours")) {
                    gc.add(10, n);
                } else if (sUnits.equals("day") || sUnits.equals("days")) {
                    gc.add(5, n);
                } else if (sUnits.equals("month") || sUnits.equals("months")) {
                    gc.add(2, n);
                } else if (sUnits.equals("year") || sUnits.equals("years")) {
                    gc.add(1, n);
                } else {
                    throw new SimpleException(tError);
                }
            }
        }
        return Calendar2.gcToEpochSeconds(gc);
    }

    public static double safeNowStringToEpochSeconds(String nowString, double troubleValue) {
        try {
            return Calendar2.nowStringToEpochSeconds(nowString);
        }
        catch (Throwable t) {
            String2.log(t.toString());
            return troubleValue;
        }
    }

    public static boolean isIsoDate(String s) {
        if (s == null) {
            return false;
        }
        return s.matches("-?\\d{4}-\\d{2}.*");
    }

    public static double gcToEpochSeconds(GregorianCalendar gc) {
        return (double)gc.getTimeInMillis() / 1000.0;
    }

    public static GregorianCalendar epochSecondsToGc(double seconds) {
        if (!Math2.isFinite(seconds)) {
            Test.error(String2.ERROR + " in epochSecondsToGc: seconds value is NaN!");
        }
        return Calendar2.newGCalendarZulu(Math2.roundToLong(seconds * 1000.0));
    }

    public static int isoStringToEpochHours(String isoZuluString) {
        long tl = Calendar2.isoZuluStringToMillis(isoZuluString);
        return Math2.roundToInt((double)tl / 3600000.0);
    }

    public static String epochSecondsToIsoStringT(double seconds) {
        if (!Math2.isFinite(seconds)) {
            Test.error(String2.ERROR + " in epochSecondsToIsoStringT: seconds is NaN!");
        }
        return Calendar2.millisToIsoZuluString(Math2.roundToLong(seconds * 1000.0));
    }

    public static String epochSecondsToIsoStringT3(double seconds) {
        if (!Math2.isFinite(seconds)) {
            Test.error(String2.ERROR + " in epochSecondsToIsoStringT3: seconds is NaN!");
        }
        return Calendar2.millisToIso3ZuluString(Math2.roundToLong(seconds * 1000.0));
    }

    public static String safeEpochSecondsToIsoStringT(double seconds, String NaNString) {
        return Math2.isFinite(seconds) ? Calendar2.millisToIsoZuluString(Math2.roundToLong(seconds * 1000.0)) : NaNString;
    }

    public static String safeEpochSecondsToIsoStringTZ(double seconds, String NaNString) {
        return Math2.isFinite(seconds) ? Calendar2.millisToIsoZuluString(Math2.roundToLong(seconds * 1000.0)) + "Z" : NaNString;
    }

    public static String safeEpochSecondsToIsoStringT3(double seconds, String NaNString) {
        return Math2.isFinite(seconds) ? Calendar2.millisToIso3ZuluString(Math2.roundToLong(seconds * 1000.0)) : NaNString;
    }

    public static String safeEpochSecondsToIsoStringT3Z(double seconds, String NaNString) {
        return Math2.isFinite(seconds) ? Calendar2.millisToIso3ZuluString(Math2.roundToLong(seconds * 1000.0)) + "Z" : NaNString;
    }

    public static String epochSecondsToLimitedIsoStringT(String time_precision, double seconds, String NaNString) {
        if (!Math2.isFinite(seconds)) {
            return NaNString;
        }
        return Calendar2.limitedFormatAsISODateTimeT(time_precision, Calendar2.newGCalendarZulu(Math2.roundToLong(seconds * 1000.0)));
    }

    public static String epochSecondsToIsoStringSpace(double seconds) {
        if (!Math2.isFinite(seconds)) {
            Test.error(String2.ERROR + " in epochSecondsToIsoStringSpace: seconds value is NaN!");
        }
        String s = Calendar2.millisToIsoZuluString(Math2.roundToLong(seconds * 1000.0));
        return String2.replaceAll(s, 'T', ' ');
    }

    public static String epochHoursToIsoString(int hours) {
        if (hours == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in epochHoursToIsoString: hours value is Integer.MAX_VALUE!");
        }
        return Calendar2.millisToIsoZuluString((long)hours * 3600000L);
    }

    public static String getMonthName3(int month) {
        return MONTH_3[month - 1];
    }

    public static String getMonthName(int month) {
        return MONTH_FULL[month - 1];
    }

    public static GregorianCalendar newGCalendarLocal() {
        GregorianCalendar gc = new GregorianCalendar();
        return gc;
    }

    public static GregorianCalendar newGCalendarLocal(long millis) {
        if (millis == Long.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarLocal: millis value is Long.MAX_VALUE!");
        }
        GregorianCalendar gcL = Calendar2.newGCalendarLocal();
        gcL.setTimeInMillis(millis);
        return gcL;
    }

    public static GregorianCalendar newGCalendarZulu() {
        return new GregorianCalendar(zuluTimeZone);
    }

    public static GregorianCalendar newGCalendarZulu(long millis) {
        if (millis == Long.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarZulu: millis value is Long.MAX_VALUE!");
        }
        GregorianCalendar gcZ = Calendar2.newGCalendarZulu();
        gcZ.setTimeInMillis(millis);
        return gcZ;
    }

    public static GregorianCalendar newGCalendarLocal(int year, int month, int dayOfMonth) {
        if (year == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarLocal: year value is Integer.MAX_VALUE!");
        }
        return new GregorianCalendar(year, month - 1, dayOfMonth);
    }

    public static GregorianCalendar newGCalendarZulu(int year, int month, int dayOfMonth) {
        if (year == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarZulu: year is Integer.MAX_VALUE!");
        }
        return Calendar2.newGCalendarZulu(year, month, dayOfMonth, 0, 0, 0, 0);
    }

    public static GregorianCalendar newGCalendarLocal(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis) {
        if (year == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarLocal: year value is Integer.MAX_VALUE!");
        }
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, dayOfMonth, hour, minute, second);
        gc.add(14, millis);
        return gc;
    }

    public static GregorianCalendar newGCalendarZulu(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis) {
        if (year == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarZulu: year value is Integer.MAX_VALUE!");
        }
        GregorianCalendar gc = new GregorianCalendar(zuluTimeZone);
        gc.clear();
        gc.set(year, month - 1, dayOfMonth, hour, minute, second);
        gc.set(14, millis);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar newGCalendarLocal(int year, int dayOfYear) {
        if (year == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarLocal: year value is Integer.MAX_VALUE!");
        }
        GregorianCalendar gc = new GregorianCalendar(year, 0, 1);
        gc.set(6, dayOfYear);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar newGCalendarZulu(int year, int dayOfYear) {
        if (year == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in newGCalendarLocal: year value is Integer.MAX_VALUE!");
        }
        GregorianCalendar gc = Calendar2.newGCalendarZulu(year, 1, 1);
        gc.set(6, dayOfYear);
        gc.get(1);
        return gc;
    }

    public static int getYear(GregorianCalendar gc) {
        return gc.get(0) == 0 ? 1 - gc.get(1) : gc.get(1);
    }

    public static String formatAsISOYear(GregorianCalendar gc) {
        int year = Calendar2.getYear(gc);
        return (year < 0 ? "-" : "") + String2.zeroPad("" + Math.abs(year), 4);
    }

    public static String formatAsISODate(GregorianCalendar gc) {
        return Calendar2.formatAsISOYear(gc) + "-" + String2.zeroPad("" + (gc.get(2) + 1), 2) + "-" + String2.zeroPad("" + gc.get(5), 2);
    }

    public static String formatAsISODateTimeT(GregorianCalendar gc) {
        return Calendar2.formatAsISODate(gc) + "T" + String2.zeroPad("" + gc.get(11), 2) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2);
    }

    public static String formatAsISODateTimeT3(GregorianCalendar gc) {
        return Calendar2.formatAsISODate(gc) + "T" + String2.zeroPad("" + gc.get(11), 2) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2) + "." + String2.zeroPad("" + gc.get(14), 3);
    }

    public static String limitedFormatAsISODateTimeT(String time_precision, GregorianCalendar gc) {
        String zString = "";
        if (time_precision == null || time_precision.length() == 0) {
            time_precision = "Z";
        }
        if (time_precision.charAt(time_precision.length() - 1) == 'Z') {
            time_precision = time_precision.substring(0, time_precision.length() - 1);
            zString = "Z";
        }
        StringBuilder sb = new StringBuilder(Calendar2.formatAsISOYear(gc));
        if (time_precision.equals("1970")) {
            return sb.toString();
        }
        sb.append("-" + String2.zeroPad("" + (gc.get(2) + 1), 2));
        if (time_precision.equals("1970-01")) {
            return sb.toString();
        }
        sb.append("-" + String2.zeroPad("" + gc.get(5), 2));
        if (time_precision.equals("1970-01-01")) {
            return sb.toString();
        }
        sb.append("T" + String2.zeroPad("" + gc.get(11), 2));
        if (time_precision.equals("1970-01-01T00")) {
            sb.append(zString);
            return sb.toString();
        }
        sb.append(":" + String2.zeroPad("" + gc.get(12), 2));
        if (time_precision.equals("1970-01-01T00:00")) {
            sb.append(zString);
            return sb.toString();
        }
        sb.append(":" + String2.zeroPad("" + gc.get(13), 2));
        if (time_precision.length() == 0 || time_precision.equals("1970-01-01T00:00:00")) {
            sb.append(zString);
            return sb.toString();
        }
        sb.append("." + String2.zeroPad("" + gc.get(14), 3));
        if (time_precision.equals("1970-01-01T00:00:00.0")) {
            sb.setLength(sb.length() - 2);
            sb.append(zString);
            return sb.toString();
        }
        if (time_precision.equals("1970-01-01T00:00:00.00")) {
            sb.setLength(sb.length() - 1);
            sb.append(zString);
            return sb.toString();
        }
        if (time_precision.equals("1970-01-01T00:00:00.000")) {
            sb.append(zString);
            return sb.toString();
        }
        sb.setLength(sb.length() - 4);
        sb.append('Z');
        return sb.toString();
    }

    public static String formatAsISODateTimeSpace(GregorianCalendar gc) {
        return Calendar2.formatAsISODate(gc) + " " + String2.zeroPad("" + gc.get(11), 2) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2);
    }

    public static String formatAsEsri(GregorianCalendar gc) {
        return Calendar2.formatAsISOYear(gc) + "/" + String2.zeroPad("" + (gc.get(2) + 1), 2) + "/" + String2.zeroPad("" + gc.get(5), 2) + " " + String2.zeroPad("" + gc.get(11), 2) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2) + " UTC";
    }

    public static String formatAsCompactDateTime(GregorianCalendar gc) {
        return Calendar2.formatAsISOYear(gc) + String2.zeroPad("" + (gc.get(2) + 1), 2) + String2.zeroPad("" + gc.get(5), 2) + String2.zeroPad("" + gc.get(11), 2) + String2.zeroPad("" + gc.get(12), 2) + String2.zeroPad("" + gc.get(13), 2);
    }

    public static String formatAsYYYYDDD(GregorianCalendar gc) {
        return Calendar2.formatAsISOYear(gc) + String2.zeroPad("" + gc.get(6), 3);
    }

    public static String formatAsYYYYMM(GregorianCalendar gc) {
        return Calendar2.formatAsISOYear(gc) + String2.zeroPad("" + (gc.get(2) + 1), 2);
    }

    public static String formatAsDDMonYYYY(GregorianCalendar gc) {
        return String2.zeroPad("" + gc.get(5), 2) + "-" + MONTH_3[gc.get(2)] + "-" + Calendar2.formatAsISOYear(gc) + " " + String2.zeroPad("" + gc.get(11), 2) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2);
    }

    public static String formatAsUSSlashAmPm(GregorianCalendar gc) {
        int hour = gc.get(10);
        return gc.get(2) + 1 + "/" + gc.get(5) + "/" + Calendar2.formatAsISOYear(gc) + " " + (hour == 0 ? 12 : hour) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2) + " " + (gc.get(9) == 0 ? "am" : "pm");
    }

    public static String formatAsRFC822GMT(GregorianCalendar gc) {
        return DAY_OF_WEEK_3[gc.get(7)] + ", " + String2.zeroPad("" + gc.get(5), 2) + " " + MONTH_3[gc.get(2)] + " " + Calendar2.formatAsISOYear(gc) + " " + String2.zeroPad("" + gc.get(11), 2) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2) + " GMT";
    }

    public static String formatAsUSSlash24(GregorianCalendar gc) {
        return gc.get(2) + 1 + "/" + gc.get(5) + "/" + Calendar2.formatAsISOYear(gc) + " " + String2.zeroPad("" + gc.get(11), 2) + ":" + String2.zeroPad("" + gc.get(12), 2) + ":" + String2.zeroPad("" + gc.get(13), 2);
    }

    private static void parseN(String s, char[] separatorN, int[] resultsN) {
        int sLength;
        if (s == null) {
            s = "";
        }
        if ((sLength = (s = s.trim()).length()) < 1 || s.charAt(0) != '-' && !String2.isDigit(s.charAt(0))) {
            resultsN[0] = Integer.MAX_VALUE;
            return;
        }
        int po2 = -1;
        boolean mMode = s.charAt(0) == '-';
        int nParts = separatorN.length;
        for (int part = 0; part < nParts; ++part) {
            int pmPart;
            int po1;
            if (po2 + 1 >= sLength) continue;
            po2 = po1 = po2 + 1;
            if (mMode) {
                if (po2 < sLength && s.charAt(po2) == '-') {
                    ++po2;
                } else {
                    resultsN[0] = Integer.MAX_VALUE;
                    return;
                }
            }
            while (po2 < sLength && String2.isDigit(s.charAt(po2))) {
                ++po2;
            }
            if (po2 == po1) {
                return;
            }
            resultsN[part] = part > 0 && separatorN[part - 1] == '.' ? Math2.roundToInt(1000.0 * String2.parseDouble("0." + s.substring(po1, po2))) : String2.parseInt(s.substring(po1, po2));
            if (resultsN[part] == Integer.MAX_VALUE) {
                resultsN[0] = Integer.MAX_VALUE;
                return;
            }
            if (po2 >= sLength) {
                return;
            }
            mMode = false;
            char ch = s.charAt(po2);
            if (ch == ',') {
                ch = '.';
            }
            if (separatorN[part] == '\u0000') continue;
            if (separatorN[part] == '\ufffd') {
                if (ch == '+') continue;
                if (ch == '-') {
                    --po2;
                    mMode = true;
                    continue;
                }
                resultsN[0] = Integer.MAX_VALUE;
                return;
            }
            if (ch == separatorN[part]) continue;
            if ((separatorN[part] == ':' || separatorN[part] == '.') && part < nParts - 1 && (pmPart = String2.indexOf(separatorN, '\ufffd', part + 1)) >= 0) {
                part = pmPart;
                if (ch == '+') continue;
                if (ch == '-') {
                    --po2;
                    mMode = true;
                    continue;
                }
                resultsN[0] = Integer.MAX_VALUE;
                return;
            }
            resultsN[0] = Integer.MAX_VALUE;
            return;
        }
    }

    public static boolean probablyISODateTime(String s) {
        if (s == null) {
            return false;
        }
        int sLength = s.length();
        if (sLength < 6) {
            return false;
        }
        int po = 0;
        if (s.charAt(po) == '-') {
            ++po;
            if (sLength < 7) {
                return false;
            }
        }
        if (!String2.isDigit(s.charAt(po++))) {
            return false;
        }
        if (!String2.isDigit(s.charAt(po++))) {
            return false;
        }
        if (!String2.isDigit(s.charAt(po++))) {
            return false;
        }
        if (!String2.isDigit(s.charAt(po++))) {
            return false;
        }
        if (s.charAt(po++) != '-') {
            return false;
        }
        return String2.isDigit(s.charAt(po++));
    }

    public static GregorianCalendar parseISODateTime(GregorianCalendar gc, String s) {
        String last3;
        boolean negative;
        if (s == null) {
            s = "";
        }
        if (negative = s.startsWith("-")) {
            s = s.substring(1);
        }
        if (s.length() < 1 || !String2.isDigit(s.charAt(0))) {
            Test.error(String2.ERROR + " in parseISODateTime: for first character of dateTime='" + s + "' isn't a digit!");
        }
        if (gc == null) {
            Test.error(String2.ERROR + " in parseISODateTime: gc is null!");
        }
        int[] ymdhmsmom = new int[]{Integer.MAX_VALUE, 1, 1, 0, 0, 0, 0, 0, 0};
        if (Character.toLowerCase((s = s.trim()).charAt(s.length() - 1)) == 'z') {
            s = s.substring(0, s.length() - 1).trim();
        }
        if (s.length() >= 3 && ((last3 = s.substring(s.length() - 3).toLowerCase()).equals("utc") || last3.equals("gmt"))) {
            s = s.substring(0, s.length() - 3).trim();
        }
        s = String2.replaceAll(s, ' ', '+');
        char[] separator = new char[]{'-', '-', '\u0000', ':', ':', '.', '\ufffd', ':', '\u0000'};
        Calendar2.parseN(s, separator, ymdhmsmom);
        if (ymdhmsmom[0] == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in parseISODateTime: dateTime='" + s + "' has an invalid format!");
        }
        if (ymdhmsmom[7] != 0) {
            ymdhmsmom[3] = ymdhmsmom[3] - ymdhmsmom[7];
        }
        if (ymdhmsmom[8] != 0) {
            ymdhmsmom[4] = ymdhmsmom[4] - (ymdhmsmom[7] < 0 ? -ymdhmsmom[8] : ymdhmsmom[8]);
        }
        gc.set((negative ? -1 : 1) * ymdhmsmom[0], ymdhmsmom[1] - 1, ymdhmsmom[2], ymdhmsmom[3], ymdhmsmom[4], ymdhmsmom[5]);
        gc.set(14, ymdhmsmom[6]);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar parseISODateTimeZulu(String s) {
        return Calendar2.parseISODateTime(Calendar2.newGCalendarZulu(), s);
    }

    public static GregorianCalendar parseUSSlash24(GregorianCalendar gc, String s) {
        int[] mdyhms = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0, 0};
        char[] separator = new char[]{'/', '/', ' ', ':', ':', '\u0000'};
        Calendar2.parseN(s, separator, mdyhms);
        if (mdyhms[0] == Integer.MAX_VALUE || mdyhms[1] == Integer.MAX_VALUE || mdyhms[2] == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in parseUSSlash24: s=" + s + " has an invalid format!");
        }
        if (mdyhms[2] >= 0 && mdyhms[2] <= 49) {
            mdyhms[2] = mdyhms[2] + 2000;
        }
        if (mdyhms[2] >= 50 && mdyhms[2] <= 99) {
            mdyhms[2] = mdyhms[2] + 1900;
        }
        gc.set(mdyhms[2], mdyhms[0] - 1, mdyhms[1], mdyhms[3], mdyhms[4], mdyhms[5]);
        gc.set(14, 0);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar parseUSSlash24Zulu(String s) {
        return Calendar2.parseUSSlash24(Calendar2.newGCalendarZulu(), s);
    }

    public static GregorianCalendar parseCompactDateTime(GregorianCalendar gc, String s) {
        int sLength;
        boolean negative;
        if (s == null) {
            s = "";
        }
        if (negative = s.startsWith("-")) {
            s = s.substring(1);
        }
        if ((sLength = s.length()) < 8) {
            Test.error(String2.ERROR + " in parseCompactDateTime: s=" + s + " has an invalid format!");
        }
        for (int i = 0; i < sLength; ++i) {
            if (String2.isDigit(s.charAt(i))) continue;
            Test.error(String2.ERROR + " in parseCompactDateTime: s=" + s + " has an invalid format!");
        }
        s = s + String2.makeString('0', 14 - sLength);
        gc.clear();
        gc.set((negative ? -1 : 1) * String2.parseInt(s.substring(0, 4)), String2.parseInt(s.substring(4, 6)) - 1, String2.parseInt(s.substring(6, 8)), String2.parseInt(s.substring(8, 10)), String2.parseInt(s.substring(10, 12)), String2.parseInt(s.substring(12, 14)));
        gc.set(14, 0);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar parseCompactDateTimeZulu(String s) {
        return Calendar2.parseCompactDateTime(Calendar2.newGCalendarZulu(), s);
    }

    public static GregorianCalendar parseDDMonYYYY(GregorianCalendar gc, String s) {
        int mon;
        int sLength;
        boolean negative;
        if (s == null) {
            s = "";
        }
        boolean bl = negative = (sLength = s.length()) >= 8 && s.charAt(7) == '-';
        if (negative) {
            s = s.substring(0, 7) + s.substring(8);
        }
        if (!(sLength >= 11 && String2.isDigit(s.charAt(0)) && String2.isDigit(s.charAt(1)) && s.charAt(2) == '-' && s.charAt(6) == '-' && String2.isDigit(s.charAt(7)) && String2.isDigit(s.charAt(8)) && String2.isDigit(s.charAt(9)) && String2.isDigit(s.charAt(10)))) {
            Test.error(String2.ERROR + " in parseDDMonYYYY: s=" + s + " has an invalid format!");
        }
        gc.clear();
        int hour = 0;
        int min = 0;
        int sec = 0;
        if (sLength >= 20) {
            if (!(s.charAt(11) == ' ' && String2.isDigit(s.charAt(12)) && String2.isDigit(s.charAt(13)) && s.charAt(14) == ':' && String2.isDigit(s.charAt(15)) && String2.isDigit(s.charAt(16)) && s.charAt(17) == ':')) {
                Test.error(String2.ERROR + " in parseDDMonYYYY: s=" + s + " has an invalid format!");
            }
            hour = String2.parseInt(s.substring(12, 14));
            min = String2.parseInt(s.substring(15, 17));
            sec = String2.parseInt(s.substring(18, 20));
        }
        String month = s.substring(3, 6).toLowerCase();
        for (mon = 0; mon < 12 && !MONTH_3[mon].toLowerCase().equals(month); ++mon) {
        }
        if (mon == 12) {
            Test.error(String2.ERROR + " in parseDDMonYYYY: s=" + s + " has an invalid format!");
        }
        gc.set((negative ? -1 : 1) * String2.parseInt(s.substring(7, 11)), mon, String2.parseInt(s.substring(0, 2)), hour, min, sec);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar parseDDMonYYYYZulu(String s) {
        return Calendar2.parseDDMonYYYY(Calendar2.newGCalendarZulu(), s);
    }

    public static GregorianCalendar parseYYYYDDD(GregorianCalendar gc, String s) {
        int sLength;
        boolean negative;
        if (s == null) {
            s = "";
        }
        if (negative = s.startsWith("-")) {
            s = s.substring(1);
        }
        if ((sLength = s.length()) != 7) {
            Test.error(String2.ERROR + " in parseYYYYDDD: s=" + s + " has an invalid format!");
        }
        for (int i = 0; i < sLength; ++i) {
            if (String2.isDigit(s.charAt(i))) continue;
            Test.error(String2.ERROR + " in parseYYYYDDD: s=" + s + " has an invalid format!");
        }
        gc.clear();
        gc.set((negative ? -1 : 1) * String2.parseInt(s.substring(0, 4)), 0, 1, 0, 0, 0);
        gc.set(6, String2.parseInt(s.substring(4, 7)));
        gc.set(14, 0);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar parseYYYYDDDZulu(String s) {
        return Calendar2.parseYYYYDDD(Calendar2.newGCalendarZulu(), s);
    }

    public static String getParseErrorString(String s, Exception e) {
        String error = MustBe.throwable(String2.ERROR + " while parsing \"" + s + "\".", e);
        return error;
    }

    public static String yyyydddToIsoDate(String s) {
        int sLength;
        boolean negative;
        if (s == null) {
            s = "";
        }
        if (negative = s.startsWith("-")) {
            s = s.substring(1);
        }
        if ((sLength = s.length()) != 7) {
            Test.error(String2.ERROR + " in yyyydddToIsoDate: yyyyddd='" + s + "' has an invalid format!");
        }
        for (int i = 0; i < sLength; ++i) {
            if (String2.isDigit(s.charAt(i))) continue;
            Test.error(String2.ERROR + " in yyyydddToIsoDate: yyyyddd='" + s + "' has an invalid format!");
        }
        GregorianCalendar gc = Calendar2.newGCalendarZulu((negative ? -1 : 1) * Integer.parseInt(s.substring(0, 4)), Integer.parseInt(s.substring(4)));
        return Calendar2.formatAsISODate(gc);
    }

    public static String getCurrentISODateTimeStringLocal() {
        return Calendar2.formatAsISODateTimeT(Calendar2.newGCalendarLocal());
    }

    public static String getCompactCurrentISODateTimeStringLocal() {
        return Calendar2.formatAsCompactDateTime(Calendar2.newGCalendarLocal());
    }

    public static String getCurrentISODateTimeStringZulu() {
        return Calendar2.formatAsISODateTimeT(Calendar2.newGCalendarZulu());
    }

    public static String getCurrentRFC822Zulu() {
        return Calendar2.formatAsRFC822GMT(Calendar2.newGCalendarZulu());
    }

    public static String getCurrentISODateStringZulu() {
        return Calendar2.formatAsISODate(Calendar2.newGCalendarZulu());
    }

    public static String getCurrentISODateStringLocal() {
        return Calendar2.formatAsISODate(Calendar2.newGCalendarLocal());
    }

    public static long isoZuluStringToMillis(String s) {
        GregorianCalendar gc = Calendar2.parseISODateTime(Calendar2.newGCalendarZulu(), s);
        return gc.getTimeInMillis();
    }

    public static String millisToIsoZuluString(long millis) {
        GregorianCalendar gc = Calendar2.newGCalendarZulu(millis);
        return Calendar2.formatAsISODateTimeT(gc);
    }

    public static String millisToIso3ZuluString(long millis) {
        GregorianCalendar gc = Calendar2.newGCalendarZulu(millis);
        return Calendar2.formatAsISODateTimeT3(gc);
    }

    public static String removeSpacesDashesColons(String s) {
        boolean negative = s.startsWith("-");
        if (negative) {
            s = s.substring(1);
        }
        s = String2.replaceAll(s, " ", "");
        s = String2.replaceAll(s, "-", "");
        s = String2.replaceAll(s, "T", "");
        return (negative ? "-" : "") + String2.replaceAll(s, ":", "");
    }

    public static int binaryFindClosest(String[] isoDates, String timeValue) {
        try {
            if (isoDates[0].startsWith("-")) {
                throw new RuntimeException(String2.ERROR + ": Calendar2.binaryFindClosest doesn't work with years < 0.");
            }
            double timeValueSeconds = Calendar2.isoStringToEpochSeconds(timeValue);
            int i = Arrays.binarySearch(isoDates, timeValue);
            if (i >= 0) {
                return i;
            }
            int insertionPoint = -i - 1;
            if (insertionPoint == 0) {
                return 0;
            }
            if (insertionPoint >= isoDates.length) {
                return insertionPoint - 1;
            }
            if (Math.abs(Calendar2.isoStringToEpochSeconds(isoDates[insertionPoint - 1]) - timeValueSeconds) < Math.abs(Calendar2.isoStringToEpochSeconds(isoDates[insertionPoint]) - timeValueSeconds)) {
                return insertionPoint - 1;
            }
            return insertionPoint;
        }
        catch (Exception e) {
            return isoDates.length - 1;
        }
    }

    public static int binaryFindLastLE(String[] isoDates, String timeValue) {
        try {
            if (isoDates[0].startsWith("-")) {
                throw new RuntimeException(String2.ERROR + ": Calendar2.binaryFindLastLE doesn't work with years < 0.");
            }
            double timeValueSeconds = Calendar2.isoStringToEpochSeconds(timeValue);
            int i = Arrays.binarySearch(isoDates, timeValue);
            if (i < 0) {
                int insertionPoint = -i - 1;
                i = insertionPoint - 1;
            }
            while (i < isoDates.length - 1 && Calendar2.isoStringToEpochSeconds(isoDates[i + 1]) <= timeValueSeconds) {
                ++i;
            }
            return i;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int binaryFindFirstGE(String[] isoDates, String timeValue) {
        try {
            if (isoDates[0].startsWith("-")) {
                throw new RuntimeException(String2.ERROR + ": Calendar2.binaryFindFirstGE doesn't work with years < 0.");
            }
            double timeValueSeconds = Calendar2.isoStringToEpochSeconds(timeValue);
            int i = Arrays.binarySearch(isoDates, timeValue);
            if (i < 0) {
                i = -i - 1;
            }
            while (i > 0 && Calendar2.isoStringToEpochSeconds(isoDates[i - 1]) >= timeValueSeconds) {
                --i;
            }
            return i;
        }
        catch (Exception e) {
            return isoDates.length;
        }
    }

    public static GregorianCalendar isoDateTimeAdd(String isoDate, int n, int field) throws Exception {
        if (n == Integer.MAX_VALUE) {
            Test.error(String2.ERROR + " in Calendar2.isoDateTimeAdd: invalid addN=" + n);
        }
        GregorianCalendar gc = Calendar2.parseISODateTimeZulu(isoDate);
        gc.add(field, n);
        return gc;
    }

    public static String elapsedTimeString(double millis) {
        if (!Math2.isFinite(millis)) {
            return "infinity";
        }
        long time = Math2.roundToLong(millis);
        String negative = "";
        if (time < 0L) {
            negative = "-";
            time = Math.abs(time);
        }
        if (time == Long.MAX_VALUE) {
            return "infinity";
        }
        long ms = time % 1000L;
        long sec = time / 1000L;
        long min = sec / 60L;
        long hr = min / 60L;
        long day = hr / 24L;
        if (day + (hr %= 24L) + (min %= 60L) + (sec %= 60L) == 0L) {
            return negative + time + " ms";
        }
        if (day + hr + min == 0L) {
            return negative + sec + "." + String2.zeroPad("" + ms, 3) + " s";
        }
        String ds = day + (day == 1L ? " day" : " days");
        if (hr + min + sec == 0L) {
            return negative + ds;
        }
        return (day > 0L ? negative + ds + " " : negative) + (day > 0L || hr > 0L ? hr + "h " : "") + min + "m " + sec + "s";
    }

    public static GregorianCalendar centerOfMonth(GregorianCalendar gc) throws Exception {
        int nDaysInMonth = gc.getActualMaximum(5);
        gc.set(5, 1 + nDaysInMonth / 2);
        gc.set(11, Math2.odd(nDaysInMonth) ? 12 : 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc;
    }

    public static GregorianCalendar clearSmallerFields(GregorianCalendar gc, int field) throws Exception {
        if (field != 14 && field != 13 && field != 12 && field != 10 && field != 11 && field != 5 && field != 6 && field != 2 && field != 1) {
            Test.error(String2.ERROR + " in Calendar2.clearSmallerFields: unsupported field=" + field);
        }
        if (field == 14) {
            return gc;
        }
        gc.set(14, 0);
        if (field == 13) {
            return gc;
        }
        gc.set(13, 0);
        if (field == 12) {
            return gc;
        }
        gc.set(12, 0);
        if (field == 10 || field == 11) {
            return gc;
        }
        gc.set(11, 0);
        if (field == 5) {
            return gc;
        }
        gc.set(5, 1);
        if (field == 2) {
            return gc;
        }
        gc.set(2, 0);
        return gc;
    }

    public static double backNDays(int nDays, double max) throws Exception {
        GregorianCalendar gc = Math2.isFinite(max) ? Calendar2.epochSecondsToGc(max) : Calendar2.newGCalendarZulu();
        Calendar2.clearSmallerFields(gc, 5);
        return Calendar2.gcToEpochSeconds(gc) - (double)(86400 * nDays);
    }

    public static double[] getNEvenlySpaced(double start, double stop, int maxNValues) {
        try {
            int[] nice;
            double divisor;
            int biggerField;
            int field;
            if (!Math2.isFinite(start) || !Math2.isFinite(stop)) {
                return null;
            }
            if (start == stop) {
                return new double[]{start};
            }
            if (start > stop) {
                double d = start;
                start = stop;
                stop = d;
            }
            double spm = 60.0;
            double sph = 3600.0;
            double spd = 86400.0;
            double range = stop - start;
            double mnv2 = maxNValues / 2;
            if (range <= mnv2 * spm) {
                field = 13;
                biggerField = 12;
                divisor = 1.0;
                nice = new int[]{1, 2, 5, 10, 15, 20, 30, 60};
            } else if (range <= mnv2 * sph) {
                field = 12;
                biggerField = 11;
                divisor = spm;
                nice = new int[]{1, 2, 5, 10, 15, 20, 30, 60};
            } else if (range <= mnv2 * spd) {
                field = 11;
                biggerField = 5;
                divisor = sph;
                nice = new int[]{1, 2, 3, 4, 6, 12, 24};
            } else if (range <= mnv2 * 30.0 * spd) {
                field = 5;
                biggerField = 2;
                divisor = spd;
                nice = new int[]{1, 2, 5, 7};
            } else if (range <= mnv2 * 365.0 * spd) {
                field = 2;
                biggerField = 1;
                divisor = 30.0 * spd;
                nice = new int[]{1, 2, 3, 6, 12};
            } else {
                field = 1;
                biggerField = -9999;
                divisor = 365.0 * spd;
                nice = new int[]{1, 2, 5, 10};
            }
            double dnValues = range / divisor / (double)maxNValues;
            int stride = Calendar2.nextNice(dnValues, nice);
            if (field == 5) {
                stride = Math.min(14, stride);
            }
            DoubleArray da = new DoubleArray();
            da.add(start);
            GregorianCalendar nextGc = Calendar2.epochSecondsToGc(start);
            if (field != 1) {
                Calendar2.clearSmallerFields(nextGc, biggerField);
            }
            double next = Calendar2.gcToEpochSeconds(nextGc);
            while (next < stop) {
                if (next > start) {
                    da.add(next);
                }
                if (field == 5) {
                    int oMonth = nextGc.get(2);
                    nextGc.add(field, 2 * stride);
                    if (nextGc.get(2) == oMonth) {
                        nextGc.add(field, -stride);
                    } else {
                        nextGc.set(5, 1);
                    }
                } else {
                    nextGc.add(field, stride);
                }
                next = Calendar2.gcToEpochSeconds(nextGc);
            }
            da.add(stop);
            if (reallyVerbose) {
                String2.log("Calendar2.getNEvenlySpaced start=" + Calendar2.epochSecondsToIsoStringT(start) + " stop=" + Calendar2.epochSecondsToIsoStringT(stop) + " field=" + Calendar2.fieldName(field) + "\n divisor=" + divisor + " range/divisor/maxNValues=" + dnValues + " stride=" + stride + " nValues=" + da.size());
            }
            return da.toArray();
        }
        catch (Exception e) {
            String2.log(MustBe.throwableToString(e));
            return null;
        }
    }

    public static int nextNice(double d, int[] nice) {
        int n = nice.length;
        for (int i = 0; i < n; ++i) {
            if (!(d <= (double)nice[i])) continue;
            return nice[i];
        }
        return Math2.roundToInt(Math.ceil(d / (double)nice[n - 1]));
    }

    public static GregorianCalendar roundToIdealGC(double epochSeconds, int idealN, int idealUnits) {
        GregorianCalendar gc = Calendar2.newGCalendarZulu(Math2.roundToLong(epochSeconds * 1000.0));
        if (idealUnits == 5) {
            double td = (double)Calendar2.getYear(gc) + (double)gc.get(2) / 12.0;
            int ti = Math2.roundToInt(td / (double)idealN) * idealN;
            gc = Calendar2.newGCalendarZulu(ti, 1, 1);
        } else if (idealUnits == 4) {
            double td = Calendar2.getYear(gc) * 12 + gc.get(2);
            int ti = Math2.roundToInt(td / (double)idealN) * idealN;
            gc = Calendar2.newGCalendarZulu(ti / 12, ti % 12 + 1, 1);
        } else {
            double chunk = (double)idealN * IDEAL_UNITS_SECONDS[idealUnits];
            double td = Math.rint(epochSeconds / chunk) * chunk;
            gc = Calendar2.newGCalendarZulu(Math2.roundToLong(td * 1000.0));
        }
        return gc;
    }

    public static String suggestDateTimeFormat(String sample) {
        if (sample == null || sample.length() == 0) {
            return "";
        }
        char ch = Character.toLowerCase(sample.charAt(0));
        if (ch >= '0' && ch <= '9') {
            if (sample.matches("[0-2][0-9]{3}-[0-3][0-9]{2}")) {
                return "yyyy-DDD";
            }
            if (sample.matches("[0-2][0-9]{3}[0-3][0-9]{2}")) {
                return "yyyyDDD";
            }
            if (sample.matches("[0-2][0-9]{3}-[0-1][0-9].*")) {
                return "yyyy-MM-dd'T'HH:mm:ssZ";
            }
            if (sample.matches("[0-2][0-9]{3}[0-1][0-9][0-3][0-9][0-2][0-9][0-5][0-9][0-5][0-9]")) {
                return "yyyyMMddHHmmss";
            }
            if (sample.matches("[0-2][0-9]{3}[0-1][0-9][0-3][0-9][0-2][0-9][0-5][0-9]")) {
                return "yyyyMMddHHmm";
            }
            if (sample.matches("[0-2][0-9]{3}[0-1][0-9][0-3][0-9][0-2][0-9]")) {
                return "yyyyMMddHH";
            }
            if (sample.matches("[0-2][0-9]{3}[0-1][0-9][0-3][0-9]")) {
                return "yyyyMMdd";
            }
            if (sample.matches("[0-2][0-9]{3}[0-1][0-9]")) {
                return "yyyyMM";
            }
            if (sample.matches("[0-9]{1,2}/[0-9]{1,2}/[0-9]{2,4}")) {
                return "M/d/yy";
            }
            if (sample.matches("[0-9]{1,2} [a-zA-Z]{3} [0-9]{2,4}")) {
                return "d MMM yy";
            }
            if (sample.matches("[0-9]{1,2}-[a-zA-Z]{3}-[0-9]{2,4}")) {
                return "d-MMM-yy";
            }
        } else if (ch >= 'a' && ch <= 'z') {
            if (sample.matches("[a-zA-Z]{3} [0-9]{1,2}, [0-9]{2,4}")) {
                return "MMM d, yy";
            }
            if (sample.matches("[a-zA-Z]{3}, [0-9]{2} [a-zA-Z]{3} [0-9]{4} [0-9]{2}:[0-9]{2}:[0-9]{2} GMT")) {
                return "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
            }
            if (sample.matches("[a-zA-Z]{3}, [0-9]{2} [a-zA-Z]{3} [0-9]{4} [0-9]{2}:[0-9]{2}:[0-9]{2} -[0-9]{2}:?[0-9]{2}")) {
                return "EEE, dd MMM yyyy HH:mm:ss Z";
            }
        }
        return "";
    }

    public static String suggestDateTimeFormat(StringArray sa) {
        boolean debugMode = false;
        int size = sa.size();
        String format = null;
        for (int row = 0; row < size; ++row) {
            String s = sa.get(row);
            if (s == null || s.length() == 0) continue;
            if (format == null) {
                format = Calendar2.suggestDateTimeFormat(s);
                if (format.length() != 0) continue;
                if (debugMode) {
                    String2.log("  suggestDateTimeFormat: no format for \"" + s + "\".");
                }
                return "";
            }
            String tFormat = Calendar2.suggestDateTimeFormat(s);
            if (format.equals(tFormat)) continue;
            if (debugMode) {
                String2.log("  suggestDateTimeFormat: [" + row + "]=\"" + s + "\" doesn't match format=\"" + format + "\".");
            }
            return "";
        }
        return format == null ? "" : format;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            Calendar2.IDEAL_N_OPTIONS[i] = "" + (i + 1);
        }
        IDEAL_UNITS_OPTIONS = new String[]{"second(s)", "minute(s)", "hour(s)", "day(s)", "month(s)", "year(s)"};
        IDEAL_UNITS_SECONDS = new double[]{1.0, 60.0, 3600.0, 86400.0, 2592000.0, 3.1536E7};
        IDEAL_UNITS_FIELD = new int[]{13, 12, 11, 5, 2, 1};
        verbose = false;
        reallyVerbose = false;
    }
}

