/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.util.Calendar2;
import com.cohort.util.Math2;
import com.cohort.util.MustBe;
import com.cohort.util.String2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class File2 {
    public static boolean verbose = false;
    private static String tempDirectory;

    public static boolean isFile(String dirName) {
        try {
            File file = new File(dirName);
            return file.isFile();
        }
        catch (Exception e) {
            if (verbose) {
                String2.log(MustBe.throwable("File2.isFile(" + dirName + ")", e));
            }
            return false;
        }
    }

    public static boolean isFile(String dirName, int nTimes) {
        try {
            File file = new File(dirName);
            boolean b = false;
            nTimes = Math.max(1, nTimes);
            for (int i = 0; i < nTimes; ++i) {
                b = file.isFile();
                if (b) {
                    return true;
                }
                if (i >= nTimes - 1) continue;
                Math2.sleep(200L);
            }
            return b;
        }
        catch (Exception e) {
            if (verbose) {
                String2.log(MustBe.throwable("File2.isFile(" + dirName + ")", e));
            }
            return false;
        }
    }

    public static boolean isDirectory(String dir) {
        try {
            File d = new File(dir);
            return d.isDirectory();
        }
        catch (Exception e) {
            if (verbose) {
                String2.log(MustBe.throwable("File2.isDirectory(" + dir + ")", e));
            }
            return false;
        }
    }

    public static boolean delete(String dirName) {
        int maxAttempts = String2.OSIsWindows ? 11 : 4;
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            try {
                File file = new File(dirName);
                if (!file.exists()) {
                    return attempt > 1;
                }
                boolean result = file.delete();
                file = null;
                if (result) {
                    return true;
                }
                if (attempt == maxAttempts) {
                    String2.log(String2.ERROR + ": File2.delete was unable to delete " + dirName);
                    return result;
                }
                String2.log("WARNING #" + attempt + ": File2.delete is having trouble. It will try again to delete " + dirName);
                if (attempt % 4 == 1) {
                    Math2.gc(1000L);
                    continue;
                }
                Math2.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                if (verbose) {
                    String2.log(MustBe.throwable("File2.delete(" + dirName + ")", e));
                }
                return false;
            }
        }
        return false;
    }

    public static boolean simpleDelete(String dirName) {
        try {
            File file = new File(dirName);
            if (!file.exists()) {
                return false;
            }
            return file.delete();
        }
        catch (Exception e) {
            if (verbose) {
                String2.log(MustBe.throwable("File2.simpleDelete(" + dirName + ")", e));
            }
            return false;
        }
    }

    public static void deleteAllFiles(String dir) {
        File2.deleteIfOld(dir, Long.MAX_VALUE, false, false);
    }

    public static void deleteAllFiles(String dir, boolean recursive, boolean deleteEmptySubdirectories) {
        File2.deleteIfOld(dir, Long.MAX_VALUE, recursive, deleteEmptySubdirectories);
    }

    public static int deleteIfOld(String dir, long time, boolean recursive, boolean deleteEmptySubdirectories) {
        try {
            File file = new File(dir);
            if (!file.isDirectory()) {
                return -1;
            }
            File[] files = file.listFiles();
            int nRemain = 0;
            int nDir = 0;
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    if (files[i].lastModified() < time) {
                        files[i].delete();
                        continue;
                    }
                    if (nRemain == -1) continue;
                    ++nRemain;
                    continue;
                }
                if (!recursive || !files[i].isDirectory()) continue;
                ++nDir;
                int tnRemain = File2.deleteIfOld(files[i].getAbsolutePath(), time, recursive, deleteEmptySubdirectories);
                if (tnRemain == -1) {
                    nRemain = -1;
                    continue;
                }
                if (nRemain != -1) {
                    nRemain += tnRemain;
                }
                if (tnRemain != 0 || !deleteEmptySubdirectories) continue;
                files[i].delete();
            }
            if (nRemain > 0) {
                String2.log("File2.deleteIfOld(" + dir + (time == Long.MAX_VALUE ? "" : ", " + Calendar2.safeEpochSecondsToIsoStringTZ((double)time / 1000.0, "" + time)) + ") nDir=" + nDir + " nDeleted=" + (files.length - nDir + nRemain) + " nRemain=" + nRemain);
            }
            return nRemain;
        }
        catch (Exception e) {
            String2.log(MustBe.throwable("File2.deleteIfOld(" + dir + ", " + time + ")", e));
            return -1;
        }
    }

    public static void rename(String dir, String oldName, String newName) throws RuntimeException {
        File2.rename(dir + oldName, dir + newName);
    }

    public static void rename(String fullOldName, String fullNewName) throws RuntimeException {
        File oldFile = new File(fullOldName);
        if (!oldFile.isFile()) {
            throw new RuntimeException("Unable to rename\n" + fullOldName + " to\n" + fullNewName + "\nbecause source file doesn't exist.");
        }
        File newFile = new File(fullNewName);
        if (newFile.isFile()) {
            if (!File2.delete(fullNewName)) {
                throw new RuntimeException("Unable to rename\n" + fullOldName + " to\n" + fullNewName + "\nbecause unable to delete an existing file with destinationName.");
            }
            if (String2.OSIsWindows) {
                Math2.gc(100L);
            }
        }
        if (oldFile.renameTo(newFile)) {
            return;
        }
        throw new RuntimeException("Unable to rename\n" + fullOldName + " to\n" + fullNewName);
    }

    public static void renameIfNewDoesntExist(String fullOldName, String fullNewName) throws RuntimeException {
        if (File2.isFile(fullNewName)) {
            File2.delete(fullOldName);
        } else {
            File2.rename(fullOldName, fullNewName);
        }
    }

    public static boolean touch(String dirName) {
        return File2.touch(dirName, 0L);
    }

    public static boolean touch(String dirName, long millisInPast) {
        try {
            File file = new File(dirName);
            return file.setLastModified(System.currentTimeMillis() - millisInPast);
        }
        catch (Exception e) {
            if (verbose) {
                String2.log(MustBe.throwable("File2.touch(" + dirName + ")", e));
            }
            return false;
        }
    }

    public static boolean setLastModified(String dirName, long millis) {
        try {
            File file = new File(dirName);
            return file.setLastModified(millis);
        }
        catch (Exception e) {
            if (verbose) {
                String2.log(MustBe.throwable("File2.setLastModified(" + dirName + ")", e));
            }
            return false;
        }
    }

    public static long length(String dirName) {
        try {
            File file = new File(dirName);
            if (!file.isFile()) {
                return -1L;
            }
            return file.length();
        }
        catch (Exception e) {
            if (verbose) {
                String2.log(MustBe.throwable("File2.length(" + dirName + ")", e));
            }
            return -1L;
        }
    }

    public static long getLastModified(String dirName) {
        try {
            File file = new File(dirName);
            return file.lastModified();
        }
        catch (Exception e) {
            try {
                Math2.gc(100L);
                File file = new File(dirName);
                return file.lastModified();
            }
            catch (Exception e2) {
                if (verbose) {
                    String2.log(MustBe.throwable("File2.getLastModified(" + dirName + ")", e2));
                }
                return 0L;
            }
        }
    }

    public static String getOldest(String[] dirNames) {
        int ti = 0;
        long tm = File2.getLastModified(dirNames[0]);
        for (int i = 1; i < dirNames.length; ++i) {
            long ttm = File2.getLastModified(dirNames[i]);
            if (ttm == 0L || ttm >= tm) continue;
            ti = i;
            tm = ttm;
        }
        return dirNames[ti];
    }

    public static String getYoungest(String[] dirNames) {
        int ti = 0;
        long tm = File2.getLastModified(dirNames[0]);
        for (int i = 1; i < dirNames.length; ++i) {
            long ttm = File2.getLastModified(dirNames[i]);
            if (ttm == 0L || ttm <= tm) continue;
            ti = i;
            tm = ttm;
        }
        return dirNames[ti];
    }

    public static String getProtocolDomain(String url) {
        if (url == null) {
            return url;
        }
        int urlLength = url.length();
        int po = url.indexOf(47);
        if (po < 0) {
            return url;
        }
        if (po == urlLength - 1 || po > 7) {
            return url.substring(0, po);
        }
        if (url.charAt(po + 1) == '/') {
            if (po == urlLength - 2) {
                return url;
            }
            return (po = url.indexOf(47, po + 2)) >= 0 ? url.substring(0, po) : url;
        }
        return url.substring(0, po);
    }

    public static String getDirectory(String dirName) {
        int po = dirName.lastIndexOf(47);
        if (po < 0) {
            po = dirName.lastIndexOf(92);
        }
        return po > 0 ? dirName.substring(0, po + 1) : File2.getCurrentDirectory();
    }

    public static String getCurrentDirectory() {
        String dir = System.getProperty("user.dir");
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir;
    }

    public static String getNameAndExtension(String dirName) {
        int po = dirName.lastIndexOf(47);
        if (po >= 0) {
            return dirName.substring(po + 1);
        }
        po = dirName.lastIndexOf(92);
        if (po >= 0) {
            return dirName.substring(po + 1);
        }
        return dirName;
    }

    public static String getExtension(String dirName) {
        String name = File2.getNameAndExtension(dirName);
        int po = name.lastIndexOf(46);
        if (po >= 0) {
            return name.substring(po);
        }
        return "";
    }

    public static String forceExtension(String dirName, String ext) {
        String oldExt = File2.getExtension(dirName);
        return dirName.substring(0, dirName.length() - oldExt.length()) + ext;
    }

    public static String getNameNoExtension(String dirName) {
        String name = File2.getNameAndExtension(dirName);
        String extension = File2.getExtension(dirName);
        return name.substring(0, name.length() - extension.length());
    }

    public static String hexDump(String fullFileName, int nBytes) throws Exception {
        FileInputStream fis = new FileInputStream(fullFileName);
        nBytes = Math.min(nBytes, fis.available());
        byte[] ba = new byte[nBytes];
        for (int bytesRead = 0; bytesRead < nBytes; bytesRead += fis.read(ba, bytesRead, nBytes - bytesRead)) {
        }
        fis.close();
        return String2.hexDump(ba);
    }

    public static long whereDifferent(String fullFileName1, String fullFileName2) {
        long length1 = File2.length(fullFileName1);
        long length2 = File2.length(fullFileName2);
        long length = Math.min(length1, length2);
        BufferedInputStream bis1 = null;
        BufferedInputStream bis2 = null;
        long po = 0L;
        try {
            bis1 = new BufferedInputStream(new FileInputStream(fullFileName1));
            bis2 = new BufferedInputStream(new FileInputStream(fullFileName2));
            for (po = 0L; po < length && bis1.read() == bis2.read(); ++po) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (bis1 != null) {
                bis1.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (bis2 != null) {
                bis2.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (po < length) {
            return po;
        }
        if (length1 != length2) {
            return length;
        }
        return -1L;
    }

    public static void makeDirectory(String name) throws RuntimeException {
        File dir = new File(name);
        if (dir.isFile()) {
            throw new RuntimeException("Unable to make directory=" + name + ". There is a file by that name!");
        }
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new RuntimeException("Unable to make directory=" + name + ".");
        }
    }

    public static boolean copy(String source, String destination) {
        if (source.equals(destination)) {
            return false;
        }
        FileOutputStream out = null;
        boolean success = false;
        try {
            File dir = new File(File2.getDirectory(destination));
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            out = new FileOutputStream(destination);
            success = File2.copy(source, out);
        }
        catch (Exception e) {
            String2.log(MustBe.throwable(String2.ERROR + " in File2.copy", e));
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!success) {
            File2.delete(destination);
        }
        return success;
    }

    public static boolean copy(String source, OutputStream out) {
        FileInputStream in = null;
        int bufferSize = 8192;
        byte[] buffer = new byte[bufferSize];
        boolean success = false;
        try {
            int read;
            File file = new File(source);
            if (!file.isFile()) {
                return false;
            }
            in = new FileInputStream(file);
            for (long remain = file.length(); remain > 0L; remain -= (long)read) {
                read = in.read(buffer);
                out.write(buffer, 0, read);
            }
            out.flush();
            success = true;
        }
        catch (Exception e) {
            String2.log(MustBe.throwable(String2.ERROR + " in File2.copy: ", e));
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return success;
    }

    public static void read(InputStream inputStream, byte[] byteArray, int offset, int length) throws Exception {
        int read;
        int po = offset;
        for (int remain = length; remain > 0; remain -= read) {
            read = inputStream.read(byteArray, po, remain);
            po += read;
        }
    }

    public static byte[] read(InputStream inputStream, int length) throws Exception {
        byte[] byteArray = new byte[length];
        File2.read(inputStream, byteArray, 0, length);
        return byteArray;
    }

    public static String getSystemTempDirectory() throws Exception {
        if (tempDirectory == null) {
            File file = File.createTempFile("File2.getSystemTempDirectory", ".tmp");
            tempDirectory = file.getCanonicalPath();
            tempDirectory = String2.replaceAll(tempDirectory, "\\", "/");
            int po = tempDirectory.lastIndexOf(47);
            tempDirectory = tempDirectory.substring(0, po + 1);
            file.delete();
        }
        return tempDirectory;
    }

    public static String addSlash(String dir) {
        if ("\\/".indexOf(dir.charAt(dir.length() - 1)) >= 0) {
            return dir;
        }
        int po = dir.indexOf(92);
        if (po < 0) {
            po = dir.indexOf(47);
        }
        char slash = po < 0 ? (char)'/' : (char)dir.charAt(po);
        return dir + slash;
    }
}

