/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.util.String2;
import com.cohort.util.Test;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache
extends LinkedHashMap {
    int maxSize;

    public LRUCache(int tMaxSize) {
        super(tMaxSize + 1, 0.75f, true);
        this.maxSize = tMaxSize;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.maxSize;
    }

    public static void test() {
        String2.log("\n*** LRUCache.test");
        LRUCache cache = new LRUCache(5);
        for (int i = 0; i < 5; ++i) {
            cache.put("" + i, "" + 11 * i);
        }
        Test.ensureEqual(cache.size(), 5L, "");
        Test.ensureNotNull(cache.get("0"), "");
        cache.put("6", "66");
        Test.ensureEqual(cache.size(), 5L, "");
        Test.ensureTrue(cache.get("1") == null, "");
        Test.ensureNotNull(cache.get("2"), "");
        cache.put("7", "77");
        Test.ensureEqual(cache.size(), 5L, "");
        Test.ensureTrue(cache.get("3") == null, "");
        Test.ensureNotNull(cache.get("4"), "");
        String2.log("LRUCache.test finished");
    }
}

