/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.array.StringComparatorIgnoreCase;
import com.cohort.util.Math2;
import com.cohort.util.SimpleException;
import com.cohort.util.String2;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class MustBe {
    public static String lineSeparator = "\n";
    public static String THERE_IS_NO_DATA = "Your query produced no matching results.";
    public static String NotNull = "{0} must not be null.";
    public static String NotEmpty = "{0} must not be an empty string.";
    public static String InternalError = "Internal Error";
    public static String OutOfMemoryError = "Out of Memory Error";

    public static String getStackTrace() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        new Exception().printStackTrace(ps);
        ps.close();
        return baos.toString();
    }

    public static String getStackTrace(Thread thread) {
        try {
            StringBuilder sb = new StringBuilder("Stack trace for thread=" + thread.getName() + ":\n");
            StackTraceElement[] st = thread.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                sb.append(st[i].toString() + "\n");
            }
            return sb.toString();
        }
        catch (Throwable t) {
            return "ERROR while trying to get stack trace:\n" + MustBe.throwableToString(t);
        }
    }

    public static void printStackTrace() {
        String2.log(MustBe.throwableToString(new Exception()));
    }

    public static String throwableStackTrace(Throwable throwable, int nRemoveLines, boolean removeAtJava, boolean removeAtSun, boolean removeAtOrgApache) {
        int i;
        if (throwable == null) {
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos, true);
        throwable.printStackTrace(ps);
        byte[] ba = baos.toByteArray();
        int n = ba.length;
        for (i = 0; i < n; ++i) {
            if (ba[i] != 9) continue;
            ba[i] = 32;
        }
        ArrayList arrayList = String2.multiLineStringToArrayList(new String(ba));
        if (nRemoveLines < 0) {
            nRemoveLines = 0;
        }
        if (nRemoveLines > arrayList.size()) {
            nRemoveLines = arrayList.size();
        }
        for (i = 0; i < nRemoveLines; ++i) {
            arrayList.remove(0);
        }
        String seBase = "com.cohort.util.";
        String seName = "SimpleException";
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < arrayList.size(); ++i) {
            String s = (String)arrayList.get(i);
            if (i == 0 && s.startsWith(seBase + seName)) {
                s = s.substring(seBase.length());
            }
            String trims = s.trim();
            if (removeAtJava && trims.startsWith("at java") || removeAtSun && trims.startsWith("at sun") || removeAtOrgApache && trims.startsWith("at org.apache")) continue;
            sb.append(s + lineSeparator);
        }
        return sb.toString();
    }

    public static String throwableToString(Throwable t) {
        return MustBe.throwableStackTrace(t, 0, true, true, true);
    }

    public static String throwableToShortString(Throwable t) {
        int nPo;
        String s = MustBe.throwableStackTrace(t, 0, true, true, true);
        int atPo = s.indexOf("\n at ");
        if (atPo > 0 && (nPo = s.indexOf("\n", atPo + 6)) > 0) {
            s = s.substring(0, nPo);
        }
        return s;
    }

    public static String stackTrace(int nRemoveLines, boolean removeAtJava, boolean removeAtSun, boolean removeAtOrgApache) {
        Exception e = new Exception();
        return MustBe.throwableStackTrace(e, nRemoveLines, removeAtJava, removeAtSun, removeAtOrgApache);
    }

    public static String stackTrace() {
        return MustBe.stackTrace(3, true, true, true);
    }

    public static String notNull(String classAndMethodName, String valueName) {
        return classAndMethodName + ":" + lineSeparator + MessageFormat.format(NotNull, String2.toJson(valueName)) + lineSeparator + MustBe.stackTrace();
    }

    public static String notEmpty(String classAndMethodName, String valueName) {
        return classAndMethodName + ":" + lineSeparator + MessageFormat.format(NotEmpty, String2.toJson(valueName)) + lineSeparator + MustBe.stackTrace();
    }

    public static String internalError(String classAndMethodName, String message) {
        return classAndMethodName + ":" + lineSeparator + InternalError + ": " + message + lineSeparator + MustBe.stackTrace();
    }

    public static String error(String classAndMethodName, String message) {
        return classAndMethodName + ":" + lineSeparator + message + lineSeparator + MustBe.stackTrace();
    }

    public static String throwable(String classAndMethodName, Throwable throwable) {
        return MustBe.throwableWithMessage(classAndMethodName, String2.ERROR + ":" + lineSeparator, throwable);
    }

    public static String throwableWithMessage(String classAndMethodName, String message, Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            return classAndMethodName + ":" + lineSeparator + message + lineSeparator + OutOfMemoryError + lineSeparator + MustBe.throwableStackTrace(throwable, 0, true, true, true) + "\nMustBe.throwableWithMessage detected OutOfMemoryError at\n" + MustBe.getStackTrace();
        }
        return classAndMethodName + ":" + lineSeparator + message + lineSeparator + MustBe.throwableStackTrace(throwable, 0, true, true, true);
    }

    public static String allStackTraces(boolean hideThisThread, boolean hideTomcatWaitingThreads) {
        try {
            Thread thread = Thread.currentThread();
            Object[] oar = thread.getAllStackTraces().entrySet().toArray();
            int count = 0;
            String[] sar = new String[oar.length];
            for (int i = 0; i < oar.length; ++i) {
                try {
                    String ste0;
                    Map.Entry me = (Map.Entry)oar[i];
                    Thread t = (Thread)me.getKey();
                    Object[] ste = (StackTraceElement[])me.getValue();
                    String string = ste0 = ste.length == 0 ? "" : ste[0].toString();
                    if (hideThisThread && ste0.startsWith("java.lang.Thread.dumpThreads(Native Method)") || hideTomcatWaitingThreads && ste.length == 4 && ste0.startsWith("java.lang.Object.wait(Native Method)") && ste[2].toString().startsWith("org.apache.tomcat.util.threads.ThreadPool") || hideTomcatWaitingThreads && ste.length == 5 && ste0.startsWith("java.lang.Object.wait(Native Method)") && ste[2].toString().startsWith("org.apache.tomcat.util.net.JIoEndpoint$Worker.await(JIoEndpoint.java:")) continue;
                    sar[count] = t.toString() + " " + t.getState().toString() + (t.isDaemon() ? " daemon\n" : "\n") + String2.toNewlineString(ste) + "\n";
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    sar[count] = MustBe.throwableToString(e) + "\n";
                    ++count;
                }
            }
            Arrays.sort(sar, 0, count, new StringComparatorIgnoreCase());
            StringBuilder sb = new StringBuilder();
            sb.append("Number of " + (hideTomcatWaitingThreads ? "non-Tomcat-waiting " : "") + "threads in this JVM = " + count + "\n" + "(format: #threadNumber Thread[threadName,threadPriority,threadGroup] threadStatus)\n\n");
            for (int i = 0; i < count; ++i) {
                sb.append("#" + (i + 1) + " " + sar[i]);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return MustBe.throwableToString(e) + "\n";
        }
    }

    public static String getShortErrorMessage(Throwable t) {
        String tError = t.getMessage();
        if (tError == null) {
            tError = "";
        }
        if (tError.length() <= 0 || !(t instanceof SimpleException) && tError.indexOf(THERE_IS_NO_DATA) < 0 && tError.toLowerCase().indexOf("error") < 0) {
            int cpo;
            tError = t.toString();
            if (tError == null) {
                tError = "UnknownError";
            }
            if ((cpo = tError.indexOf(":")) > 0) {
                int ppo = tError.substring(0, cpo).lastIndexOf(46);
                if (ppo > 0) {
                    tError = tError.substring(ppo + 1);
                }
                if (tError.startsWith("OutOfMemoryError")) {
                    tError = OutOfMemoryError + ": " + Math2.memoryTooMuchData;
                } else if (tError.startsWith("Exception:") || tError.startsWith("RuntimeException:")) {
                    cpo = tError.indexOf(":");
                    tError = tError.substring(cpo + 1).trim();
                }
            }
        }
        return tError;
    }
}

