/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.array.StringComparatorIgnoreCase;
import com.cohort.util.Math2;
import com.cohort.util.String2;
import com.cohort.util.Test;
import com.cohort.util.XML;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceBundle2 {
    public static boolean verbose = false;
    public static boolean reallyVerbose = false;
    protected ResourceBundle primaryRB;
    protected ResourceBundle secondaryRB;
    protected ConcurrentHashMap concurrentHashMap;

    public ResourceBundle2(String primaryBaseName, Locale locale) {
        this.primaryRB = ResourceBundle.getBundle(primaryBaseName, locale);
    }

    public ResourceBundle2(String primaryBaseName, String secondaryBaseName, Locale locale) {
        this.primaryRB = ResourceBundle.getBundle(primaryBaseName, locale);
        this.secondaryRB = ResourceBundle.getBundle(secondaryBaseName, locale);
    }

    public ResourceBundle2(String primaryBaseName) {
        this.primaryRB = ResourceBundle.getBundle(primaryBaseName);
    }

    public ResourceBundle2(String primaryBaseName, String secondaryBaseName) {
        this.primaryRB = ResourceBundle.getBundle(primaryBaseName);
        this.secondaryRB = ResourceBundle.getBundle(secondaryBaseName);
    }

    public ResourceBundle2(ConcurrentHashMap concurrentHashMap) {
        this.concurrentHashMap = concurrentHashMap;
    }

    public static ResourceBundle2 fromXml(Document doc) throws Exception {
        XPath xPath = XML.getXPath();
        NodeList nodeList = XML.getNodeList(doc, xPath, "/*/*");
        int n = nodeList.getLength();
        ConcurrentHashMap<String, String> tHash = new ConcurrentHashMap<String, String>(Math2.roundToInt(22.4), 0.75f, 4);
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String key = element.getNodeName();
            String value = XML.getTextContent(element);
            tHash.put(key, value);
        }
        return new ResourceBundle2(tHash);
    }

    public boolean getBoolean(String key, boolean theDefault) {
        try {
            String s = this.getString(key, null);
            return s.toLowerCase().equals("true");
        }
        catch (Exception e) {
            return theDefault;
        }
    }

    public int getInt(String key, int theDefault) {
        return String2.parseInt(this.getString(key, null), theDefault);
    }

    public long getLong(String key, long theDefault) {
        long tl = String2.parseLong(this.getString(key, null));
        return tl == Long.MAX_VALUE ? theDefault : tl;
    }

    public double getDouble(String key, double theDefault) {
        double d = String2.parseDouble(this.getString(key, null));
        return Double.isNaN(d) ? theDefault : d;
    }

    public String[] getStringArray(String key, String[] theDefault) {
        try {
            return this.getString(key, null).split("\\f");
        }
        catch (Exception e) {
            return theDefault;
        }
    }

    public String getString(String key, String theDefault) {
        try {
            String s;
            if (this.concurrentHashMap == null) {
                try {
                    s = this.primaryRB.getString(key);
                }
                catch (Exception e) {
                    if (this.secondaryRB == null) {
                        return theDefault;
                    }
                    s = this.secondaryRB.getString(key);
                }
            } else {
                s = (String)this.concurrentHashMap.get(key);
            }
            s = s.trim();
            if (reallyVerbose) {
                String2.log("  ResourceBundle2.getString(" + key + ") found \"" + s + "\".");
            }
            return s;
        }
        catch (Exception e) {
            if (reallyVerbose) {
                String2.log("  ResourceBundle2.getString(" + key + ") exception: \"" + e.toString() + "\"; so using default=\"" + theDefault + "\".");
            }
            return theDefault;
        }
    }

    public String getNotNullString(String key, String errorInMethod) {
        String value = this.getString(key, null);
        Test.ensureNotNull(value, errorInMethod + key + " is null!");
        return value;
    }

    public String getNotNothingString(String key, String errorInMethod) {
        String value = this.getString(key, null);
        Test.ensureNotNothing(value, errorInMethod + key + " is null or ''!");
        return value;
    }

    public String[] getKeys() {
        ArrayList cumulative = new ArrayList();
        if (this.concurrentHashMap != null) {
            cumulative.addAll(String2.toArrayList(this.concurrentHashMap.keys()));
        }
        if (this.primaryRB != null) {
            cumulative.addAll(String2.toArrayList(this.primaryRB.getKeys()));
        }
        if (this.secondaryRB != null) {
            cumulative.addAll(String2.toArrayList(this.secondaryRB.getKeys()));
        }
        String[] sar = String2.toStringArray(cumulative.toArray());
        Arrays.sort(sar, new StringComparatorIgnoreCase());
        return sar;
    }

    public static void test() throws Exception {
        String2.log("\n*************************************************ResourceBundle2.test");
        ResourceBundle2 rb2 = ResourceBundle2.fromXml(XML.parseXml(new StringReader("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<testr>\n  <level1 att1=\"value1\" att2=\"value 2\" > level 1 &amp; <!-- comment < > -->text  \n  </level1>\n  <levela />\n  <levelb> 16</levelb>\n  <bool> true</bool>\n  <dbl> 17.1</dbl>\n\n\n\n</testr>"), false));
        Test.ensureEqual(rb2.getString("level1", ""), "level 1 & text", "");
        Test.ensureEqual(rb2.getString("levela", ""), "", "");
        Test.ensureEqual(rb2.getBoolean("bool", false), true, "");
        Test.ensureEqual(rb2.getInt("levelb", 5), 16L, "");
        Test.ensureEqual(rb2.getLong("levelb", 5L), 16L, "");
        Test.ensureEqual(rb2.getDouble("dbl", 5.5), 17.1, "");
        Test.ensureEqual(rb2.getString("testr", ""), "", "");
        Test.ensureEqual(rb2.getBoolean("Z", true), true, "");
        Test.ensureEqual(rb2.getInt("Z", 5), 5L, "");
        Test.ensureEqual(rb2.getDouble("Z", 5.5), 5.5, "");
        Test.ensureEqual(rb2.getString("Z", "word"), "word", "");
    }
}

