/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.array.StringComparatorIgnoreCase;
import com.cohort.util.File2;
import com.cohort.util.MaskingThread;
import com.cohort.util.Math2;
import com.cohort.util.MustBe;
import com.cohort.util.SimpleException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class String2 {
    public static final double version = 1.0;
    public static String ERROR = "ERROR";
    private static boolean logToSystemOut = false;
    private static boolean logToSystemErr = true;
    private static BufferedWriter logFile;
    private static String logFileName;
    public static int logFileFlushEveryNth;
    private static int logFileFlushCount;
    private static StringBuffer logStringBuffer;
    private static int logMaxSize;
    private static long logFileSize;
    public static String lineSeparator;
    public static boolean OSIsWindows;
    public static boolean OSIsLinux;
    public static boolean OSIsMacOSX;
    private static DecimalFormat genStdFormat6;
    private static DecimalFormat genEngFormat6;
    private static DecimalFormat genExpFormat6;
    private static DecimalFormat genStdFormat10;
    private static DecimalFormat genEngFormat10;
    private static DecimalFormat genExpFormat10;
    private static String classPath;
    private static Map canonicalMap;
    public static final String plainASCII = " !cLoY|%:Ca<--R-o???'uP.,'o>????AAAAAAACEEEEIIIIDNOOOOOxOUUUUYpBaaaaaaaceeeeiiiionooooo/ouuuuypy";
    public static final String fileNameSafeDescription = "(A-Z, a-z, 0-9, _, -, or .)";
    public static int DistributionSize;
    private static int[] BinMax;

    public static String max(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1.compareTo(s2) >= 0 ? s1 : s2;
    }

    public static String min(String s1, String s2) {
        if (s1 == null) {
            return s1;
        }
        if (s2 == null) {
            return s2;
        }
        return s1.compareTo(s2) < 0 ? s1 : s2;
    }

    public static String makeString(char ch, int length) {
        if (length < 0 || length >= 1000000) {
            return "";
        }
        char[] car = new char[length];
        Arrays.fill(car, ch);
        return new String(car);
    }

    public static String right(String s, int length) {
        int toAdd = length - s.length();
        if (toAdd <= 0) {
            return s;
        }
        return String2.makeString(' ', toAdd).concat(s);
    }

    public static String left(String s, int length) {
        int toAdd = length - s.length();
        if (toAdd <= 0) {
            return s;
        }
        return s.concat(String2.makeString(' ', toAdd));
    }

    public static String center(String s, int length) {
        int toAdd = length - s.length();
        if (toAdd <= 0) {
            return s;
        }
        return String2.makeString(' ', toAdd / 2) + s + String2.makeString(' ', toAdd - toAdd / 2);
    }

    public static String noLongerThan(String s, int max) {
        if (s == null) {
            return "";
        }
        if (s.length() <= max) {
            return s;
        }
        return s.substring(0, max);
    }

    public static String annotatedString(String s) {
        if (s == null) {
            return "[null][end]";
        }
        int sLength = s.length();
        StringBuilder buffer = new StringBuilder(sLength / 5 * 6);
        for (int i = 0; i < sLength; ++i) {
            char ch = s.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                buffer.append(ch);
                continue;
            }
            buffer.append("[" + ch + "]");
            if (ch != '\n') continue;
            buffer.append('\n');
        }
        buffer.append("[end]");
        return buffer.toString();
    }

    public static int getNMatchingCharacters(String s1, String s2) {
        int minLength = Math.min(s1.length(), s2.length());
        for (int i = 0; i < minLength; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return minLength;
    }

    public static int indexOfIgnoreCase(String s, String find, int fromIndex) {
        if (s == null) {
            return -1;
        }
        int sLength = s.length();
        if (sLength == 0) {
            return -1;
        }
        int findLength = (find = find.toLowerCase()).length();
        if (findLength == 0) {
            return fromIndex;
        }
        int maxPo = sLength - findLength;
        char ch0 = find.charAt(0);
        for (int po = fromIndex; po <= maxPo; ++po) {
            int f2;
            if (Character.toLowerCase(s.charAt(po)) != ch0) continue;
            for (f2 = 1; f2 < findLength && Character.toLowerCase(s.charAt(po + f2)) == find.charAt(f2); ++f2) {
            }
            if (f2 != findLength) continue;
            return po;
        }
        return -1;
    }

    public static int indexOf(StringBuilder sb, String s, int fromIndex) {
        if (s == null) {
            return -1;
        }
        int sLength = s.length();
        if (sLength == 0) {
            return -1;
        }
        char ch = s.charAt(0);
        int tSize = sb.length() - sLength + 1;
        for (int index = Math.max(fromIndex, 0); index < tSize; ++index) {
            int nCharsMatched;
            if (sb.charAt(index) != ch) continue;
            for (nCharsMatched = 1; nCharsMatched < sLength && sb.charAt(index + nCharsMatched) == s.charAt(nCharsMatched); ++nCharsMatched) {
            }
            if (nCharsMatched != sLength) continue;
            return index;
        }
        return -1;
    }

    public static String extractRegex(String s, String regex, int fromIndex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        if (m.find(fromIndex)) {
            return s.substring(m.start(), m.end());
        }
        return null;
    }

    public static String[] extractAllRegexes(String s, String regex) {
        ArrayList<String> al = new ArrayList<String>();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        int fromIndex = 0;
        while (m.find(fromIndex)) {
            al.add(s.substring(m.start(), m.end()));
            fromIndex = m.end();
        }
        return String2.toStringArray(al.toArray());
    }

    public static int indexOf(int[] iArray, int i, int fromIndex) {
        int iArrayLength = iArray.length;
        for (int index = Math.max(fromIndex, 0); index < iArrayLength; ++index) {
            if (iArray[index] != i) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf(int[] iArray, int i) {
        return String2.indexOf(iArray, i, 0);
    }

    public static int indexOf(char[] cArray, char c, int fromIndex) {
        int cArrayLength = cArray.length;
        for (int index = Math.max(fromIndex, 0); index < cArrayLength; ++index) {
            if (cArray[index] != c) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf(char[] cArray, char c) {
        return String2.indexOf(cArray, c, 0);
    }

    public static int indexOf(String s, char[] car, int fromIndex) {
        int sLength = s.length();
        for (int index = Math.max(fromIndex, 0); index < sLength; ++index) {
            if (String2.indexOf(car, s.charAt(index)) < 0) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf(double[] dArray, double d, int fromIndex) {
        int dArrayLength = dArray.length;
        for (int index = Math.max(fromIndex, 0); index < dArrayLength; ++index) {
            if (!Math2.almostEqual(5, dArray[index], d)) continue;
            return index;
        }
        return -1;
    }

    public static int indexOf(double[] dArray, double d) {
        return String2.indexOf(dArray, d, 0);
    }

    public static String[] readFromFile(String fileName) {
        return String2.readFromFile(fileName, null, 3);
    }

    public static String[] readFromFile(String fileName, String charset) {
        return String2.readFromFile(fileName, charset, 3);
    }

    public static String[] readFromFile(String fileName, String charset, int maxAttempt) {
        String[] results;
        block15: {
            long time = System.currentTimeMillis();
            FileInputStream fis = null;
            InputStreamReader isr = null;
            BufferedReader bufferedReader = null;
            results = new String[]{"", ""};
            int errorIndex = 0;
            int contentsIndex = 1;
            try {
                maxAttempt = Math.max(1, maxAttempt);
                for (int attempt = 1; attempt <= maxAttempt; ++attempt) {
                    try {
                        fis = new FileInputStream(fileName);
                        isr = new InputStreamReader((InputStream)fis, charset == null || charset.length() == 0 ? "ISO-8859-1" : charset);
                        continue;
                    }
                    catch (Exception e) {
                        if (attempt == maxAttempt) {
                            String2.log(ERROR + ": String2.readFromFile was unable to read " + fileName);
                            throw e;
                        }
                        String2.log("WARNING #" + attempt + ": String2.readFromFile is having trouble. It will try again to read " + fileName);
                        if (attempt == 1) {
                            Math2.gc(1000L);
                            continue;
                        }
                        Math2.sleep(1000L);
                    }
                }
                bufferedReader = new BufferedReader(isr);
                StringBuilder sb = new StringBuilder(8192);
                String s = bufferedReader.readLine();
                while (s != null) {
                    sb.append(s);
                    sb.append('\n');
                    s = bufferedReader.readLine();
                }
                results[contentsIndex] = sb.toString();
            }
            catch (Exception e) {
                results[errorIndex] = MustBe.throwable("fileName=" + fileName, e);
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                } else if (isr != null) {
                    isr.close();
                } else if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                if (results[errorIndex].length() != 0) break block15;
                results[errorIndex] = e.toString();
            }
        }
        return results;
    }

    public static String writeToFile(String fileName, String contents) {
        return String2.lowWriteToFile(fileName, contents, null, "\n", false);
    }

    public static String appendFile(String fileName, String contents) {
        return String2.lowWriteToFile(fileName, contents, null, "\n", true);
    }

    public static String writeToFile(String fileName, String contents, String charset) {
        return String2.lowWriteToFile(fileName, contents, charset, "\n", false);
    }

    public static String appendFile(String fileName, String contents, String charset) {
        return String2.lowWriteToFile(fileName, contents, charset, "\n", true);
    }

    private static String lowWriteToFile(String fileName, String contents, String charset, String lineSeparator, boolean append) {
        String error;
        block7: {
            BufferedWriter bufferedWriter = null;
            error = "";
            try {
                OutputStreamWriter w = charset == null || charset.length() == 0 ? new FileWriter(fileName, append) : new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), charset);
                bufferedWriter = new BufferedWriter(w);
                if (!lineSeparator.equals("\n")) {
                    contents = String2.replaceAll(contents, "\n", lineSeparator);
                }
                bufferedWriter.write(contents);
            }
            catch (Exception e) {
                error = e.toString();
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception e) {
                if (error.length() != 0) break block7;
                error = e.toString();
            }
        }
        if (error.length() > 0 && !append) {
            File2.delete(fileName);
        }
        return error;
    }

    public static String javaInfo() {
        String javaVersion = System.getProperty("java.version");
        String mrjVersion = System.getProperty("mrj.version");
        mrjVersion = mrjVersion == null ? "" : " (mrj=" + mrjVersion + ")";
        return "Java " + javaVersion + mrjVersion + " (" + Math2.JavaBits + " bit, " + System.getProperty("java.vendor") + ") on " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ").";
    }

    public static final boolean isLetter(int c) {
        if (c < 65) {
            return false;
        }
        if (c <= 90) {
            return true;
        }
        if (c < 97) {
            return false;
        }
        if (c <= 122) {
            return true;
        }
        if (c < 192) {
            return false;
        }
        if (c == 215) {
            return false;
        }
        return c <= 255;
    }

    public static final boolean isIDFirstLetter(int c) {
        if (c == 95) {
            return true;
        }
        if (c == 36) {
            return true;
        }
        return String2.isLetter(c);
    }

    public static final boolean isHexDigit(int c) {
        if (c < 48) {
            return false;
        }
        if (c <= 57) {
            return true;
        }
        if (c < 65) {
            return false;
        }
        if (c <= 70) {
            return true;
        }
        if (c < 97) {
            return false;
        }
        return c <= 102;
    }

    public static final boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static final boolean isDigitLetter(int c) {
        return String2.isLetter(c) || String2.isDigit(c);
    }

    public static final boolean isNumber(String s) {
        boolean hasPeriod;
        if (s == null) {
            return false;
        }
        int sLength = s.length();
        if (sLength == 0) {
            return false;
        }
        char ch0 = s.charAt(0);
        if (ch0 == '0' && sLength >= 3 && Character.toUpperCase(s.charAt(1)) == 'X') {
            for (int po = 2; po < sLength; ++po) {
                if ("0123456789abcdefABCDEF".indexOf(s.charAt(po)) >= 0) continue;
                return false;
            }
            return true;
        }
        if (ch0 == 'n' || ch0 == 'N') {
            return s.toUpperCase().equals("NAN");
        }
        int po = 0;
        char ch = s.charAt(po);
        boolean bl = hasPeriod = ch == '.';
        if (hasPeriod || ch == '-') {
            if (sLength == 1) {
                return false;
            }
            if ((ch = s.charAt(++po)) == '.') {
                if (hasPeriod || sLength == 2) {
                    return false;
                }
                hasPeriod = true;
                ch = s.charAt(++po);
            }
        }
        if (ch < '0' || ch > '9') {
            return false;
        }
        boolean hasE = false;
        while (++po < sLength) {
            ch = s.charAt(po);
            if (ch == '.') {
                if (hasPeriod || hasE || po == sLength - 1) {
                    return false;
                }
                hasPeriod = true;
                continue;
            }
            if (ch == 'e' || ch == 'E') {
                if (hasE || po == sLength - 1) {
                    return false;
                }
                hasE = true;
                if ((ch = s.charAt(++po)) == '-' || ch == '+') {
                    if (po == sLength - 1) {
                        return false;
                    }
                    ch = s.charAt(++po);
                }
                if (ch >= '0' && ch <= '9') continue;
                return false;
            }
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhite(int c) {
        return c >= 1 && c <= 32;
    }

    public static final boolean isPrintable(int ch) {
        if (ch < 32) {
            return false;
        }
        if (ch <= 126) {
            return true;
        }
        if (ch < 161) {
            return false;
        }
        return ch <= 255;
    }

    public static final boolean isPrintable(String s) {
        if (s == null) {
            return false;
        }
        int sLength = s.length();
        for (int i = 0; i < sLength; ++i) {
            if (String2.isPrintable(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String justPrintable(String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        int start = 0;
        for (int i = 0; i < n; ++i) {
            if (String2.isPrintable(s.charAt(i))) continue;
            sb.append(s.substring(start, i));
            start = i + 1;
        }
        sb.append(s.substring(start));
        return sb.toString();
    }

    public static String modifyToBeASCII(String s) {
        StringBuilder sb = new StringBuilder(s);
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = sb.charAt(i);
            if (ch <= '\u007f') continue;
            if (ch >= '\u00a0' && ch <= '\u00ff') {
                sb.setCharAt(i, plainASCII.charAt(ch - 160));
                continue;
            }
            sb.setCharAt(i, '?');
        }
        return sb.toString();
    }

    public static boolean isFileNameSafe(char ch) {
        if (ch == '.' || ch == '-') {
            return true;
        }
        if (ch < '0') {
            return false;
        }
        if (ch <= '9') {
            return true;
        }
        if (ch < 'A') {
            return false;
        }
        if (ch <= 'Z') {
            return true;
        }
        if (ch == '_') {
            return true;
        }
        if (ch < 'a') {
            return false;
        }
        return ch <= 'z';
    }

    public static boolean isEmailAddress(String email) {
        if (email == null || email.length() == 0) {
            return false;
        }
        return email.matches("[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
    }

    public static boolean isUrl(String url) {
        if (url == null) {
            return false;
        }
        int po = url.indexOf("://");
        if (po == -1 || !String2.isPrintable(url) || url.indexOf(32) >= 0) {
            return false;
        }
        String protocol = url.substring(0, po).toLowerCase();
        return protocol.equals("file") || protocol.equals("ftp") || protocol.equals("http") || protocol.equals("https") || protocol.equals("sftp") || protocol.equals("smb");
    }

    public static boolean isFileNameSafe(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int sLength = s.length();
        for (int i = 0; i < sLength; ++i) {
            if (String2.isFileNameSafe(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String modifyToBeFileNameSafe(String s) {
        if (s == null) {
            return "_null";
        }
        int n = (s = String2.modifyToBeASCII(s)).length();
        if (n == 0) {
            return "_";
        }
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            sb.append(String2.isFileNameSafe(ch) ? ch : (char)'_');
        }
        while (sb.indexOf("__") >= 0) {
            String2.replaceAll(sb, "__", "_");
        }
        return sb.toString();
    }

    public static boolean isVariableNameSafe(String s) {
        if (s == null) {
            return false;
        }
        int n = s.length();
        if (n == 0) {
            return false;
        }
        char ch = s.charAt(0);
        if (!String2.isLetter(ch) && ch != '_') {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            ch = s.charAt(i);
            if (String2.isDigitLetter(ch) || ch == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isJsonpNameSafe(String s) {
        if (s == null) {
            return false;
        }
        int n = s.length();
        if (n == 0 || n > 255) {
            return false;
        }
        if (s.charAt(n - 1) == '.') {
            return false;
        }
        ArrayList al = String2.splitToArrayList(s, '.', false);
        int nal = al.size();
        for (int part = 0; part < nal; ++part) {
            String ts = (String)al.get(part);
            int tn = ts.length();
            if (tn == 0) {
                return false;
            }
            char ch = ts.charAt(0);
            if (!String2.isLetter(ch) && ch != '_') {
                return false;
            }
            for (int i = 1; i < tn; ++i) {
                ch = ts.charAt(i);
                if (String2.isDigitLetter(ch) || ch == '_') continue;
                return false;
            }
        }
        return true;
    }

    public static String modifyToBeVariableNameSafe(String s) {
        int n;
        if (s == null) {
            return "_null";
        }
        if ((s = String2.replaceAll(s, "%20", "_")).indexOf("%3a") >= 0) {
            s = String2.replaceAll(s, "CF%3afeature_type", "featureType");
            s = String2.replaceAll(s, "CF%3a", "");
            s = String2.replaceAll(s, "%3a", "_");
        }
        if ((n = s.length()) == 0) {
            return "_";
        }
        StringBuilder sb = new StringBuilder(n);
        char ch = s.charAt(0);
        sb.append(String2.isLetter(ch) ? ch : (char)'_');
        for (int i = 1; i < n; ++i) {
            ch = s.charAt(i);
            if (String2.isDigitLetter(ch)) {
                sb.append(ch);
                continue;
            }
            if (sb.charAt(sb.length() - 1) == '_') continue;
            sb.append('_');
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '_') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static int countAll(StringBuilder sb, String findS) {
        if (sb == null || findS == null || findS.length() == 0) {
            return 0;
        }
        int n = 0;
        int sLength = findS.length();
        int po = sb.indexOf(findS, 0);
        while (po >= 0) {
            ++n;
            po = sb.indexOf(findS, po + sLength);
        }
        return n;
    }

    public static int countAll(String s, String findS) {
        if (s == null || findS == null || findS.length() == 0) {
            return 0;
        }
        int n = 0;
        int sLength = findS.length();
        int po = s.indexOf(findS, 0);
        while (po >= 0) {
            ++n;
            po = s.indexOf(findS, po + sLength);
        }
        return n;
    }

    public static void replaceAll(StringBuilder sb, String oldS, String newS) {
        String2.replaceAll(sb, oldS, newS, false);
    }

    public static void replaceAllIgnoreCase(StringBuilder sb, String oldS, String newS) {
        String2.replaceAll(sb, oldS, newS, true);
    }

    public static void replaceAll(StringBuilder sb, String oldS, String newS, boolean ignoreCase) {
        int po;
        int sbL = sb.length();
        int oldSL = oldS.length();
        if (oldSL == 0) {
            return;
        }
        int newSL = newS.length();
        StringBuilder testSB = sb;
        String testOldS = oldS;
        if (ignoreCase) {
            testSB = new StringBuilder(sbL);
            for (int i = 0; i < sbL; ++i) {
                testSB.append(Character.toLowerCase(sb.charAt(i)));
            }
            testOldS = oldS.toLowerCase();
        }
        if ((po = testSB.indexOf(testOldS)) < 0) {
            return;
        }
        StringBuilder sb2 = new StringBuilder(sbL / 5 * 6);
        int base = 0;
        while (po >= 0) {
            sb2.append(sb.substring(base, po));
            sb2.append(newS);
            base = po + oldSL;
            po = testSB.indexOf(testOldS, base);
        }
        sb2.append(sb.substring(base));
        sb.setLength(0);
        sb.append((CharSequence)sb2);
    }

    public static String replaceAll(String s, String oldS, String newS) {
        StringBuilder sb = new StringBuilder(s);
        String2.replaceAll(sb, oldS, newS, false);
        return sb.toString();
    }

    public static String replaceAllIgnoreCase(String s, String oldS, String newS) {
        StringBuilder sb = new StringBuilder(s);
        String2.replaceAll(sb, oldS, newS, true);
        return sb.toString();
    }

    public static String combineSpaces(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        int sLength = s.length();
        int po = s.indexOf("  ");
        if (po < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(sLength);
        int base = 0;
        while (po >= 0) {
            int end;
            for (end = po + 2; end < sLength && s.charAt(end) == ' '; ++end) {
            }
            sb.append(s.substring(base, po + 1));
            base = end;
            po = s.indexOf("  ", base);
        }
        sb.append(s.substring(base));
        return sb.toString();
    }

    public static String replaceAll(String s, char oldCh, char newCh) {
        int po = s.indexOf(oldCh);
        if (po < 0) {
            return s;
        }
        StringBuilder buffer = new StringBuilder(s);
        while (po >= 0) {
            buffer.setCharAt(po, newCh);
            po = s.indexOf(oldCh, po + 1);
        }
        return buffer.toString();
    }

    public static String zeroPad(String number, int nDigits) {
        int toAdd;
        int decimal = number.indexOf(".");
        if (decimal < 0) {
            decimal = number.length();
        }
        if ((toAdd = nDigits - decimal) <= 0) {
            return number;
        }
        return String2.makeString('0', toAdd).concat(number);
    }

    public static String toJson(String s) {
        if (s == null) {
            return "null";
        }
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength / 5 * 6);
        sb.append('\"');
        int start = 0;
        for (int i = 0; i < sLength; ++i) {
            char ch = s.charAt(i);
            if (ch < ' ' || ch > '\u00ff') {
                sb.append(s.substring(start, i));
                start = i + 1;
                if (ch == '\f') {
                    sb.append("\\f");
                    continue;
                }
                if (ch == '\n') {
                    sb.append("\\n");
                    continue;
                }
                if (ch == '\r') {
                    sb.append("\\r");
                    continue;
                }
                if (ch == '\t') {
                    sb.append("\\t");
                    continue;
                }
                sb.append("\\u" + String2.zeroPad(Integer.toHexString(ch), 4));
                continue;
            }
            if (ch == '\\') {
                sb.append(s.substring(start, i));
                start = i + 1;
                sb.append("\\\\");
                continue;
            }
            if (ch != '\"') continue;
            sb.append(s.substring(start, i));
            start = i + 1;
            sb.append("\\\"");
        }
        sb.append(s.substring(start));
        sb.append('\"');
        return sb.toString();
    }

    public static String fromJson(String s) {
        if (s == null || s.equals("null")) {
            return null;
        }
        if (s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        int start = 0;
        for (int po = 0; po < sLength; ++po) {
            String os;
            char ch = s.charAt(po);
            if (ch != '\\') continue;
            sb.append(s.substring(start, po));
            if (po == sLength - 1) {
                --po;
            }
            start = ++po + 1;
            ch = s.charAt(po);
            if (ch == 'f') {
                sb.append('\f');
                continue;
            }
            if (ch == 'n') {
                sb.append('\n');
                continue;
            }
            if (ch == 'r') {
                sb.append('\r');
                continue;
            }
            if (ch == 't') {
                sb.append('\t');
                continue;
            }
            if (ch == '?') {
                sb.append('?');
                continue;
            }
            if (ch == '\\') {
                sb.append('\\');
                continue;
            }
            if (ch == '\"') {
                sb.append('\"');
                continue;
            }
            if (ch == '\'') {
                sb.append('\'');
                continue;
            }
            if (ch == 'a' || ch == 'b' || ch == 'v') continue;
            if (String2.isDigit(ch) && po + 2 < sLength) {
                os = s.substring(po, po + 3);
                try {
                    start = (po += 2) + 1;
                    sb.append((char)Integer.parseInt(os, 8));
                }
                catch (Exception e) {
                    String2.log("ERROR in fromJson: invalid escape sequence \\" + os);
                }
                continue;
            }
            if (ch == 'x' && po + 2 < sLength) {
                os = s.substring(po + 1, po + 3);
                try {
                    start = (po += 2) + 1;
                    sb.append((char)Integer.parseInt(os, 16));
                }
                catch (Exception e) {
                    String2.log("ERROR in fromJson: invalid escape sequence \\x" + os);
                }
                continue;
            }
            if (ch == 'u' && po + 4 < sLength) {
                os = s.substring(po + 1, po + 5);
                try {
                    start = (po += 4) + 1;
                    sb.append((char)Integer.parseInt(os, 16));
                }
                catch (Exception e) {
                    String2.log("ERROR in fromJson: invalid escape sequence \\u" + os);
                }
                continue;
            }
            String2.log("ERROR in fromJson: invalid escape sequence \\" + ch);
            sb.append('\\');
            sb.append(ch);
        }
        sb.append(s.substring(start));
        return sb.toString();
    }

    public static ArrayList multiLineStringToArrayList(String s) {
        char endOfLineChar = s.indexOf(10) >= 0 ? (char)'\n' : '\r';
        int sLength = s.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder oneLine = new StringBuilder(512);
        int start = 0;
        for (int po = 0; po < sLength; ++po) {
            char ch = s.charAt(po);
            if (String2.isPrintable(ch) || ch == '\t') continue;
            oneLine.append(s.substring(start, po));
            start = po + 1;
            if (ch != endOfLineChar) continue;
            arrayList.add(oneLine.toString());
            oneLine.setLength(0);
        }
        arrayList.add(oneLine.toString());
        return arrayList;
    }

    public static ArrayList toArrayList(Enumeration e) {
        ArrayList al = new ArrayList();
        while (e.hasMoreElements()) {
            al.add(e.nextElement());
        }
        return al;
    }

    public static ArrayList toArrayList(Object[] objectArray) {
        int n = objectArray.length;
        ArrayList<Object> al = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            al.add(objectArray[i]);
        }
        return al;
    }

    public static String standardHelpAboutMessage() {
        return "This program is using\n" + String2.javaInfo();
    }

    public static String substitute(String msg, String s0, String s1, String s2) {
        StringBuilder msgSB = new StringBuilder(msg);
        if (s0 != null) {
            String2.replaceAll(msgSB, "{0}", s0);
        }
        if (s1 != null) {
            String2.replaceAll(msgSB, "{1}", s1);
        }
        if (s2 != null) {
            String2.replaceAll(msgSB, "{2}", s2);
        }
        return msgSB.toString();
    }

    public static String toCSSVString(Enumeration en) {
        return String2.toSVString(String2.toArrayList(en).toArray(), ", ", false);
    }

    public static String toCSSVString(ArrayList al) {
        return String2.toSVString(al.toArray(), ", ", false);
    }

    public static String toCSSVString(Vector v) {
        return String2.toSVString(v.toArray(), ", ", false);
    }

    public static String toCSSVString(Object[] ar) {
        return String2.toSVString(ar, ", ", false);
    }

    public static String toSSVString(Object[] ar) {
        return String2.toSVString(ar, " ", false);
    }

    public static String toTSVString(Object[] ar) {
        return String2.toSVString(ar, "\t", false);
    }

    public static String toNewlineString(Object[] ar) {
        return String2.toSVString(ar, "\n", true);
    }

    public static String toSVString(Object[] ar, String separator, boolean finalSeparator) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        boolean csv = separator.charAt(0) == ',';
        StringBuilder sb = new StringBuilder(8 * Math.min(n, 0xFFFFBFF));
        for (int i = 0; i < n; ++i) {
            Object o;
            if (i > 0) {
                sb.append(separator);
            }
            if ((o = ar[i]) == null) {
                sb.append("[null]");
                continue;
            }
            String s = o.toString();
            if (csv && (s.indexOf(44) >= 0 || s.indexOf(34) >= 0)) {
                s = String2.toJson(s);
            }
            sb.append(s);
        }
        if (finalSeparator && n > 0) {
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String toCSSVString(boolean[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(7 * Math.min(n, 306782207));
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ar[i]);
        }
        return sb.toString();
    }

    public static String toCSSVString(byte[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(5 * Math.min(n, 0x19999333));
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ar[i]);
        }
        return sb.toString();
    }

    public static String toCSSVString(char[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(6 * Math.min(n, 357912575));
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((int)ar[i]);
        }
        return sb.toString();
    }

    public static String toHexCSSVString(byte[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(6 * Math.min(n, 357912575));
        for (int i = 0; i < n; ++i) {
            String s;
            if (i > 0) {
                sb.append(", ");
            }
            if ((s = Integer.toHexString(ar[i])).length() == 8 && s.startsWith("ffffff")) {
                s = s.substring(6);
            }
            sb.append("0x" + s);
        }
        return sb.toString();
    }

    public static String toCSSVString(short[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(7 * Math.min(n, 306782207));
        for (int i = 0; i < n; ++i) {
            sb.append(ar[i]);
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toHexCSSVString(short[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(8 * Math.min(n, 0xFFFFBFF));
        for (int i = 0; i < n; ++i) {
            String s = Integer.toHexString(ar[i]);
            if (s.length() == 8 && s.startsWith("ffff")) {
                s = s.substring(4);
            }
            sb.append("0x" + s);
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toCSSVString(int[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(8 * Math.min(n, 0xFFFFBFF));
        for (int i = 0; i < n; ++i) {
            sb.append(ar[i]);
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toHexCSSVString(int[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(12 * Math.min(n, 0xAAAA7FF));
        for (int i = 0; i < n; ++i) {
            sb.append("0x" + Integer.toHexString(ar[i]));
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toCSSVString(long[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(12 * Math.min(n, 0xAAAA7FF));
        for (int i = 0; i < n; ++i) {
            sb.append(ar[i]);
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toCSSVString(float[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(12 * Math.min(n, 0xAAAA7FF));
        for (int i = 0; i < n; ++i) {
            sb.append(ar[i]);
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toCSSVString(double[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(12 * Math.min(n, 0xAAAA7FF));
        for (int i = 0; i < n; ++i) {
            sb.append(ar[i]);
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toNewlineString(int[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(12 * Math.min(n, 0xAAAA7FF));
        for (int i = 0; i < n; ++i) {
            sb.append(ar[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String toNewlineString(double[] ar) {
        if (ar == null) {
            return null;
        }
        int n = ar.length;
        StringBuilder sb = new StringBuilder(12 * Math.min(n, 0xAAAA7FF));
        for (int i = 0; i < n; ++i) {
            sb.append(ar[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String[] toStringArray(Object[] aa) {
        if (aa == null) {
            return null;
        }
        int n = aa.length;
        Math2.ensureMemoryAvailable(8L * (long)n, "String2.toStringArray");
        String[] sa = new String[n];
        for (int i = 0; i < n; ++i) {
            Object o = aa[i];
            sa[i] = o == null ? (String)o : o.toString();
        }
        return sa;
    }

    public static void add(ArrayList arrayList, Object[] ar) {
        if (arrayList == null || ar == null) {
            return;
        }
        int n = ar.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(ar[i]);
        }
    }

    public static String toString(BitSet bitSet) {
        if (bitSet == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1024);
        String separator = "";
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            sb.append(separator + i);
            separator = ", ";
            i = bitSet.nextSetBit(i + 1);
        }
        return sb.toString();
    }

    public static String toString(Map map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1024);
        Set entrySet = map.entrySet();
        for (Map.Entry me : entrySet) {
            sb.append(me.getKey().toString() + " = " + me.getValue().toString() + "\n");
        }
        return sb.toString();
    }

    public static String alternateToString(ArrayList arrayList) {
        if (arrayList == null) {
            return "    [null]\n";
        }
        int n = arrayList.size();
        StringBuilder sb = new StringBuilder(32 * Math.min(n, 0x3FFFEFF));
        for (int i = 0; i < n; i += 2) {
            sb.append("    ");
            sb.append(arrayList.get(i).toString());
            sb.append('=');
            sb.append(String2.arrayToCSSVString(arrayList.get(i + 1)));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String[] alternateGetNames(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        String[] sar = new String[n / 2];
        int i2 = 0;
        for (int i = 0; i < n / 2; ++i) {
            sar[i] = arrayList.get(i2).toString();
            i2 += 2;
        }
        return sar;
    }

    public static Object alternateGetValue(ArrayList arrayList, String attributeName) {
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; i += 2) {
            if (!arrayList.get(i).toString().equals(attributeName)) continue;
            return arrayList.get(i + 1);
        }
        return null;
    }

    public static Object alternateSetValue(ArrayList arrayList, String attributeName, Object value) {
        if (arrayList == null) {
            throw new SimpleException(ERROR + " in String2.alternateSetValue: arrayList is null.");
        }
        int n = arrayList.size();
        for (int i = 0; i < n; i += 2) {
            if (!arrayList.get(i).toString().equals(attributeName)) continue;
            Object oldValue = arrayList.get(i + 1);
            if (value == null) {
                arrayList.remove(i + 1);
                arrayList.remove(i);
            } else {
                arrayList.set(i + 1, value);
            }
            return oldValue;
        }
        if (value == null) {
            return null;
        }
        arrayList.add(attributeName);
        arrayList.add(value);
        return null;
    }

    public static String arrayToCSSVString(Object value) {
        if (value instanceof byte[]) {
            return String2.toCSSVString((byte[])value);
        }
        if (value instanceof char[]) {
            return String2.toCSSVString((char[])value);
        }
        if (value instanceof short[]) {
            return String2.toCSSVString((short[])value);
        }
        if (value instanceof int[]) {
            return String2.toCSSVString((int[])value);
        }
        if (value instanceof long[]) {
            return String2.toCSSVString((long[])value);
        }
        if (value instanceof float[]) {
            return String2.toCSSVString((float[])value);
        }
        if (value instanceof double[]) {
            return String2.toCSSVString((double[])value);
        }
        return value.toString();
    }

    public static byte[] toByteArray(String s) {
        if (s == null) {
            return null;
        }
        int sLength = s.length();
        byte[] ba = new byte[sLength];
        for (int i = 0; i < sLength; ++i) {
            ba[i] = (byte)s.charAt(i);
        }
        return ba;
    }

    public static byte[] toByteArray(StringBuilder sb) {
        if (sb == null) {
            return null;
        }
        int sbLength = sb.length();
        byte[] ba = new byte[sbLength];
        for (int i = 0; i < sbLength; ++i) {
            ba[i] = (byte)sb.charAt(i);
        }
        return ba;
    }

    public static String hexDump(byte[] byteArray) {
        int bal = byteArray.length;
        StringBuilder printable = new StringBuilder(32);
        StringBuilder sb = new StringBuilder(5 * Math.min(bal, 0x19999333));
        for (int i = 0; i < bal; ++i) {
            int data = byteArray[i] & 0xFF;
            sb.append(String2.zeroPad(Integer.toHexString(data), 2) + " ");
            printable.append(data >= 32 && data <= 126 ? (char)data : (char)' ');
            if (i % 8 == 7) {
                sb.append("  ");
            }
            if (i % 16 != 15) continue;
            sb.append(printable + " |\n");
            printable.setLength(0);
        }
        if (byteArray.length % 16 != 0) {
            sb.append((CharSequence)printable);
            sb.append(String2.makeString(' ', 69 - sb.length() % 71));
            sb.append("|\n");
        }
        return sb.toString();
    }

    public static int indexOf(Object[] ar, String s) {
        return String2.indexOf(ar, s, 0);
    }

    public static int indexOf(Object[] ar, String s, int startAt) {
        if (ar == null || s == null) {
            return -1;
        }
        int n = ar.length;
        for (int i = Math.max(0, startAt); i < n; ++i) {
            if (ar[i] == null || !s.equals(ar[i].toString())) continue;
            return i;
        }
        return -1;
    }

    public static int caseInsensitiveIndexOf(Object[] ar, String s) {
        if (ar == null || s == null) {
            return -1;
        }
        int n = ar.length;
        s = s.toLowerCase();
        for (int i = 0; i < n; ++i) {
            if (ar[i] == null || !s.equals(ar[i].toString().toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public static int lineContaining(Object[] ar, String s) {
        return String2.lineContaining(ar, s, 0);
    }

    public static int lineContaining(Object[] ar, String s, int startAt) {
        if (ar == null || s == null) {
            return -1;
        }
        int n = ar.length;
        for (int i = Math.max(0, startAt); i < n; ++i) {
            if (ar[i] == null || ar[i].toString().indexOf(s) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String stringStartsWith(Object[] ar, String s) {
        int i = String2.lineStartsWith(ar, s, 0);
        return i < 0 ? null : ar[i].toString();
    }

    public static int lineStartsWith(Object[] ar, String s) {
        return String2.lineStartsWith(ar, s, 0);
    }

    public static int lineStartsWith(Object[] ar, String s, int startAt) {
        if (ar == null || s == null) {
            return -1;
        }
        int n = ar.length;
        for (int i = Math.max(0, startAt); i < n; ++i) {
            if (ar[i] == null || !ar[i].toString().startsWith(s)) continue;
            return i;
        }
        return -1;
    }

    public static int lineStartsWithIgnoreCase(Object[] ar, String s, int startAt) {
        if (ar == null || s == null) {
            return -1;
        }
        s = s.toLowerCase();
        int n = ar.length;
        for (int i = Math.max(0, startAt); i < n; ++i) {
            if (ar[i] == null || !ar[i].toString().toLowerCase().startsWith(s)) continue;
            return i;
        }
        return -1;
    }

    public static void setupCommonsLogging(int level) {
        System.setProperty("org.apache.commons.logging.LogFactory", "com.cohort.util.String2LogFactory");
        if (level >= 0) {
            System.setProperty("com.cohort.util.String2Log.level", "" + level);
        } else if (System.getProperty("com.cohort.util.String2Log.level") == null) {
            System.setProperty("com.cohort.util.String2Log.level", "3");
        }
    }

    public static synchronized void setupLog(boolean tLogToSystemOut, boolean tLogToSystemErr, String fullFileName, boolean logToStringBuffer, boolean append, int maxSize) throws Exception {
        if (logFileName != null && logFileName.equals(fullFileName)) {
            return;
        }
        logToSystemOut = tLogToSystemOut;
        logToSystemErr = tLogToSystemErr;
        if (!append) {
            logFileSize = 0L;
        }
        logMaxSize = maxSize;
        String2.closeLogFile();
        if (logToStringBuffer) {
            if (!append || logStringBuffer == null) {
                logStringBuffer = new StringBuffer();
            }
        } else {
            logStringBuffer = null;
        }
        if (fullFileName.length() == 0) {
            return;
        }
        logFileName = fullFileName;
        logFile = new BufferedWriter(new FileWriter(fullFileName, append));
        logFileSize = new File(fullFileName).length();
    }

    public static void closeLogFile() {
        if (logFile != null) {
            try {
                logFile.close();
                logFile = null;
                logFileName = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void log(String message) {
        String2.lowLog(message, true);
    }

    public static void logNoNewline(String message) {
        String2.lowLog(message, false);
    }

    public static synchronized void lowLog(String message, boolean addNewline) {
        try {
            if (logStringBuffer != null) {
                if (logStringBuffer.length() > logMaxSize && logMaxSize > 0) {
                    logStringBuffer.delete(0, logMaxSize / 2);
                }
                logStringBuffer.append(message);
                if (addNewline) {
                    logStringBuffer.append('\n');
                }
            }
            if (!lineSeparator.equals("\n")) {
                message = String2.replaceAll(message, "\n", lineSeparator);
            }
            if (logToSystemOut) {
                if (addNewline) {
                    System.out.println(message);
                } else {
                    System.out.print(message);
                }
            }
            if (logToSystemErr) {
                if (addNewline) {
                    System.err.println(message);
                } else {
                    System.err.print(message);
                }
            }
            if (logFile != null) {
                if (logFileSize > (long)logMaxSize && logMaxSize > 0) {
                    logFile.close();
                    logFile = null;
                    File2.rename(logFileName, logFileName + ".previous");
                    logFile = new BufferedWriter(new FileWriter(logFileName));
                    logFileSize = 0L;
                }
                logFile.write(message);
                if (addNewline) {
                    logFile.write(lineSeparator);
                }
                if (++logFileFlushCount >= logFileFlushEveryNth) {
                    logFile.flush();
                    logFileFlushCount = 0;
                }
                logFileSize += (long)message.length();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String logFileName() {
        return logFileName;
    }

    public static synchronized StringBuffer getLogStringBuffer() {
        return logStringBuffer;
    }

    public static ArrayList splitToArrayList(String s, char separator) {
        return String2.splitToArrayList(s, separator, true);
    }

    public static ArrayList splitToArrayList(String s, char separator, boolean trim) {
        if (s == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        int sLength = s.length();
        int start = 0;
        for (int index = 0; index < sLength; ++index) {
            if (s.charAt(index) != separator) continue;
            String ts = s.substring(start, index);
            if (trim) {
                ts = ts.trim();
            }
            al.add(ts);
            start = index + 1;
        }
        String ts = s.substring(start, sLength);
        if (trim) {
            ts = ts.trim();
        }
        al.add(ts);
        return al;
    }

    public static String[] split(String s, char separator) {
        ArrayList al = String2.splitToArrayList(s, separator, true);
        if (al == null) {
            return null;
        }
        return String2.toStringArray(al.toArray());
    }

    public static String[] splitNoTrim(String s, char separator) {
        ArrayList al = String2.splitToArrayList(s, separator, false);
        if (al == null) {
            return null;
        }
        return String2.toStringArray(al.toArray());
    }

    public static int[] toIntArray(Object[] oar) {
        if (oar == null) {
            return null;
        }
        int n = oar.length;
        Math2.ensureMemoryAvailable(4L * (long)n, "String2.toIntArray");
        int[] ia = new int[n];
        for (int i = 0; i < n; ++i) {
            ia[i] = String2.parseInt(oar[i].toString());
        }
        return ia;
    }

    public static float[] toFloatArray(Object[] oar) {
        if (oar == null) {
            return null;
        }
        int n = oar.length;
        Math2.ensureMemoryAvailable(4L * (long)n, "String2.toFloatArray");
        float[] fa = new float[n];
        for (int i = 0; i < n; ++i) {
            fa[i] = String2.parseFloat(oar[i].toString());
        }
        return fa;
    }

    public static double[] toDoubleArray(Object[] oar) {
        if (oar == null) {
            return null;
        }
        int n = oar.length;
        Math2.ensureMemoryAvailable(8L * (long)n, "String2.toDoubleArray");
        double[] da = new double[n];
        for (int i = 0; i < n; ++i) {
            da[i] = String2.parseDouble(oar[i].toString());
        }
        return da;
    }

    public static int[] toIntArray(ArrayList al) {
        if (al == null) {
            return null;
        }
        int n = al.size();
        Math2.ensureMemoryAvailable(4L * (long)n, "String2.toIntArray");
        int[] ia = new int[n];
        for (int i = 0; i < n; ++i) {
            ia[i] = (Integer)al.get(i);
        }
        return ia;
    }

    public static float[] toFloatArray(ArrayList al) {
        if (al == null) {
            return null;
        }
        int n = al.size();
        Math2.ensureMemoryAvailable(4L * (long)n, "String2.toFloatArray");
        float[] fa = new float[n];
        for (int i = 0; i < n; ++i) {
            fa[i] = ((Float)al.get(i)).floatValue();
        }
        return fa;
    }

    public static double[] toDoubleArray(ArrayList al) {
        if (al == null) {
            return null;
        }
        int n = al.size();
        Math2.ensureMemoryAvailable(4L * (long)n, "String2.toDoubleArray");
        double[] da = new double[n];
        for (int i = 0; i < n; ++i) {
            da[i] = (Double)al.get(i);
        }
        return da;
    }

    public static int[] justFiniteValues(int[] iar) {
        if (iar == null) {
            return null;
        }
        int n = iar.length;
        int nFinite = 0;
        int[] ia = new int[n];
        for (int i = 0; i < n; ++i) {
            if (iar[i] >= Integer.MAX_VALUE) continue;
            ia[nFinite++] = iar[i];
        }
        int[] iaf = new int[nFinite];
        System.arraycopy(ia, 0, iaf, 0, nFinite);
        return iaf;
    }

    public static double[] justFiniteValues(double[] dar) {
        if (dar == null) {
            return null;
        }
        int n = dar.length;
        int nFinite = 0;
        double[] da = new double[n];
        for (int i = 0; i < n; ++i) {
            if (!Math2.isFinite(dar[i])) continue;
            da[nFinite++] = dar[i];
        }
        double[] daf = new double[nFinite];
        System.arraycopy(da, 0, daf, 0, nFinite);
        return daf;
    }

    public static String[] removeNull(String[] sar) {
        if (sar == null) {
            return null;
        }
        int n = sar.length;
        int nValid = 0;
        String[] sa = new String[n];
        for (int i = 0; i < n; ++i) {
            if (sar[i] == null) continue;
            sa[nValid++] = sar[i];
        }
        String[] sa2 = new String[nValid];
        System.arraycopy(sa, 0, sa2, 0, nValid);
        return sa2;
    }

    public static String[] removeNullOrEmpty(String[] sar) {
        if (sar == null) {
            return null;
        }
        int n = sar.length;
        int nValid = 0;
        String[] sa = new String[n];
        for (int i = 0; i < n; ++i) {
            if (sar[i] == null || sar[i].length() <= 0) continue;
            sa[nValid++] = sar[i];
        }
        String[] sa2 = new String[nValid];
        System.arraycopy(sa, 0, sa2, 0, nValid);
        return sa2;
    }

    public static int[] csvToIntArray(String csv) {
        return String2.toIntArray(String2.split(csv, ','));
    }

    public static double[] csvToDoubleArray(String csv) {
        return String2.toDoubleArray(String2.split(csv, ','));
    }

    public static boolean parseBoolean(String s) {
        if (s == null) {
            return true;
        }
        return !(s = s.toLowerCase().trim()).equals("false") && !s.equals("f") && !s.equals("0");
    }

    public static String removeLeading(String s, char ch) {
        int start;
        if (s == null) {
            return s;
        }
        int sLength = s.length();
        for (start = 0; start < sLength && s.charAt(start) == ch; ++start) {
        }
        return start == 0 ? s : s.substring(start);
    }

    public static int parseInt(String s, int def) {
        int i = String2.parseInt(s);
        return i == Integer.MAX_VALUE ? def : i;
    }

    public static int parseInt(String s) {
        if (s == null) {
            return Integer.MAX_VALUE;
        }
        if ((s = s.trim()).length() == 0) {
            return Integer.MAX_VALUE;
        }
        char ch = s.charAt(0);
        if ((ch < '0' || ch > '9') && ch != '-' && ch != '+' && ch != '.') {
            return Integer.MAX_VALUE;
        }
        try {
            if (s.startsWith("0x")) {
                return Integer.parseInt(s.substring(2), 16);
            }
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            try {
                return Math2.roundToInt(Double.parseDouble(s));
            }
            catch (Exception e2) {
                return Integer.MAX_VALUE;
            }
        }
    }

    public static double parseDouble(String s) {
        if (s == null) {
            return Double.NaN;
        }
        if ((s = s.trim()).length() == 0) {
            return Double.NaN;
        }
        char ch = s.charAt(0);
        if ((ch < '0' || ch > '9') && ch != '-' && ch != '+' && ch != '.') {
            return Double.NaN;
        }
        try {
            if (s.startsWith("0x")) {
                return Integer.parseInt(s.substring(2), 16);
            }
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static boolean isDoubleTrouble(String s) {
        if (s == null || s.length() < 22) {
            return false;
        }
        return String2.replaceAll(s, ".", "").indexOf("2225073858507201") >= 0;
    }

    public static double roundingParseInt(String s) {
        return Math2.roundToInt(String2.parseDouble(s));
    }

    public static long parseLong(String s) {
        if (s == null) {
            return Long.MAX_VALUE;
        }
        if ((s = s.trim()).length() == 0) {
            return Long.MAX_VALUE;
        }
        char ch = s.charAt(0);
        if ((ch < '0' || ch > '9') && ch != '-' && ch != '+') {
            return Long.MAX_VALUE;
        }
        try {
            if (s.startsWith("0x")) {
                return Long.parseLong(s.substring(2), 16);
            }
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    public static float parseFloat(String s) {
        if (s == null) {
            return Float.NaN;
        }
        if ((s = s.trim()).length() == 0) {
            return Float.NaN;
        }
        char ch = s.charAt(0);
        if ((ch < '0' || ch > '9') && ch != '-' && ch != '+' && ch != '.') {
            return Float.NaN;
        }
        try {
            s = s.replace(',', '.');
            return Float.parseFloat(s);
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    public static String[] tokenize(String s) {
        int index;
        if (s == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int sLength = s.length();
        for (index = 0; index < sLength && s.charAt(index) == ' '; ++index) {
        }
        while (index < sLength) {
            int stop;
            int start = index;
            if (s.charAt(index) == '\"') {
                ++index;
                ++start;
                while (index < sLength && s.charAt(index) != '\"') {
                    ++index;
                }
                stop = index++;
            } else {
                while (index < sLength && s.charAt(index) != ' ') {
                    ++index;
                }
                stop = index;
            }
            arrayList.add(s.substring(start, stop));
            while (index < sLength && s.charAt(index) == ' ') {
                ++index;
            }
        }
        return String2.toStringArray(arrayList.toArray());
    }

    public static void distribute(long aTime, int[] distribution) {
        if (aTime < 0L) {
            aTime = 0L;
        }
        if (aTime > 3600000L) {
            distribution[21] = distribution[21] + 1;
            return;
        }
        int iTime = (int)aTime;
        for (int bin = 0; bin < DistributionSize; ++bin) {
            if (iTime > BinMax[bin]) continue;
            int n = bin;
            distribution[n] = distribution[n] + 1;
            return;
        }
    }

    public static int getDistributionN(int[] distribution) {
        int n = 0;
        for (int bin = 0; bin < DistributionSize; ++bin) {
            n += distribution[bin];
        }
        return n;
    }

    public static int getDistributionMedian(int[] distribution, int n) {
        double n2 = (double)n / 2.0;
        if (n > 0) {
            int cum = distribution[0];
            if ((double)cum >= n2) {
                return 0;
            }
            for (int bin = 1; bin < DistributionSize; ++bin) {
                if (distribution[bin] <= 0) continue;
                int tCum = cum + distribution[bin];
                if ((double)cum <= n2 && (double)tCum >= n2) {
                    int tBinMax = bin == DistributionSize - 1 ? BinMax[bin - 1] * 3 : BinMax[bin];
                    return Math2.roundToInt((double)BinMax[bin - 1] + (n2 - (double)cum + 0.0) / (double)distribution[bin] * (double)(tBinMax - BinMax[bin - 1]));
                }
                cum = tCum;
            }
        }
        return -1;
    }

    public static String getBriefDistributionStatistics(int[] distribution) {
        int n = String2.getDistributionN(distribution);
        String s = "n =" + String2.right("" + n, 9);
        if (n == 0) {
            return s;
        }
        int median = String2.getDistributionMedian(distribution, n);
        return s + ",  median ~=" + String2.right("" + median, 9) + " ms";
    }

    public static String getDistributionStatistics(int[] distribution) {
        int n = String2.getDistributionN(distribution);
        String s = "    " + String2.getBriefDistributionStatistics(distribution) + "\n";
        if (n == 0) {
            return s;
        }
        return s + "    0 ms:      " + String2.right("" + distribution[0], 10) + "\n" + "    1 ms:      " + String2.right("" + distribution[1], 10) + "\n" + "    2 ms:      " + String2.right("" + distribution[2], 10) + "\n" + "    <= 5 ms:   " + String2.right("" + distribution[3], 10) + "\n" + "    <= 10 ms:  " + String2.right("" + distribution[4], 10) + "\n" + "    <= 20 ms:  " + String2.right("" + distribution[5], 10) + "\n" + "    <= 50 ms:  " + String2.right("" + distribution[6], 10) + "\n" + "    <= 100 ms: " + String2.right("" + distribution[7], 10) + "\n" + "    <= 200 ms: " + String2.right("" + distribution[8], 10) + "\n" + "    <= 500 ms: " + String2.right("" + distribution[9], 10) + "\n" + "    <= 1 s:    " + String2.right("" + distribution[10], 10) + "\n" + "    <= 2 s:    " + String2.right("" + distribution[11], 10) + "\n" + "    <= 5 s:    " + String2.right("" + distribution[12], 10) + "\n" + "    <= 10 s:   " + String2.right("" + distribution[13], 10) + "\n" + "    <= 20 s:   " + String2.right("" + distribution[14], 10) + "\n" + "    <= 1 min:  " + String2.right("" + distribution[15], 10) + "\n" + "    <= 2 min:  " + String2.right("" + distribution[16], 10) + "\n" + "    <= 5 min:  " + String2.right("" + distribution[17], 10) + "\n" + "    <= 10 min: " + String2.right("" + distribution[18], 10) + "\n" + "    <= 20 min: " + String2.right("" + distribution[19], 10) + "\n" + "    <= 1 hr:   " + String2.right("" + distribution[20], 10) + "\n" + "    >  1 hr:   " + String2.right("" + distribution[21], 10) + "\n";
    }

    public static String noLongLines(String s, int maxLength, String spaces) {
        int maxLength2 = maxLength / 2;
        int spacesLength = spaces.length();
        int start = 0;
        int count = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength / 5 * 6);
        for (int i = 0; i < sLength; ++i) {
            if (s.charAt(i) == '\n') {
                count = 0;
                continue;
            }
            if (++count < maxLength) continue;
            int oi = i;
            char ch1 = s.charAt(i);
            while (count > maxLength2) {
                char ch = ch1;
                ch1 = s.charAt(i - 1);
                if (!String2.isDigitLetter(ch1) && ch1 != '(' && String2.isDigitLetter(ch)) {
                    count = 0;
                    break;
                }
                --count;
                --i;
            }
            if (count > 0) {
                i = oi;
            }
            sb.append(s.substring(start, i));
            sb.append("\n" + spaces);
            start = i;
            count = spacesLength;
        }
        if (start == 0) {
            return s;
        }
        sb.append(s.substring(start));
        return sb.toString();
    }

    public static StringBuilder noLongLinesAtSpace(StringBuilder sb, int maxLength, String spaces) {
        int sbLength = sb.length();
        if (sbLength <= maxLength) {
            return sb;
        }
        StringBuilder newSB = new StringBuilder(sbLength / 5 * 6);
        int minCount = maxLength / 2;
        int startAt = 0;
        int count = 0;
        int lastSpaceAt = -1;
        for (int sbi = 0; sbi < sbLength; ++sbi) {
            char ch = sb.charAt(sbi);
            if (ch == '\n') {
                newSB.append(sb, startAt, sbi + 1);
                startAt = sbi + 1;
                count = 0;
                lastSpaceAt = -1;
                continue;
            }
            if (ch == ' ' && count >= minCount) {
                lastSpaceAt = sbi;
            }
            if (++count < maxLength || lastSpaceAt < 0) continue;
            newSB.append(sb, startAt, lastSpaceAt);
            newSB.append('\n');
            newSB.append(spaces);
            sbi = lastSpaceAt;
            lastSpaceAt = -1;
            count = spaces.length();
            while (sbi < sbLength - 1 && sb.charAt(sbi + 1) == ' ') {
                ++sbi;
            }
            startAt = sbi + 1;
        }
        if (startAt < sbLength) {
            newSB.append(sb, startAt, sbLength);
        }
        return newSB;
    }

    public static String noLongLinesAtSpace(String s, int maxLength, String spaces) {
        if (s.length() <= maxLength) {
            return s;
        }
        return String2.noLongLinesAtSpace(new StringBuilder(s), maxLength, spaces).toString();
    }

    public static void simpleSearchAndReplace(String fullInFileName, String fullOutFileName, String search, String replace) throws Exception {
        String2.log("simpleSearchAndReplace in=" + fullInFileName + " out=" + fullOutFileName + " search=" + search + " replace=" + replace);
        String tOutFileName = fullOutFileName + Math2.random(Integer.MAX_VALUE);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fullInFileName));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tOutFileName));
        try {
            String s = bufferedReader.readLine();
            while (s != null) {
                bufferedWriter.write(String2.replaceAll(s, search, replace));
                bufferedWriter.write(lineSeparator);
                s = bufferedReader.readLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
            if (fullInFileName.equals(fullOutFileName)) {
                File2.rename(fullInFileName, fullInFileName + ".original");
            }
            File2.rename(tOutFileName, fullOutFileName);
            if (fullInFileName.equals(fullOutFileName)) {
                File2.delete(fullInFileName + ".original");
            }
        }
        catch (Exception e) {
            try {
                bufferedReader.close();
                bufferedWriter.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            File2.delete(tOutFileName);
            throw e;
        }
    }

    public static void regexSearchAndReplace(String fullInFileName, String fullOutFileName, String search, String replace) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fullInFileName));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fullOutFileName));
        String s = bufferedReader.readLine();
        while (s != null) {
            bufferedWriter.write(s.replaceAll(search, replace));
            bufferedWriter.write(lineSeparator);
            s = bufferedReader.readLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    public static String getKeysAndValuesString(Map map) {
        ArrayList<String> al = new ArrayList<String>();
        for (Object key : map.keySet()) {
            al.add(key.toString() + ": " + map.get(key).toString());
        }
        Collections.sort(al, new StringComparatorIgnoreCase());
        return String2.toNewlineString(al.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genEFormat6(double d) {
        if (!Math2.isFinite(d)) {
            return "" + d;
        }
        if (Math2.almost0(d)) {
            return "0";
        }
        if (Math.abs(d) < 0.0999995 && !Math2.almostEqual(6, d * 10000.0, Math.rint(d * 10000.0))) {
            DecimalFormat decimalFormat = genExpFormat6;
            synchronized (decimalFormat) {
                return genExpFormat6.format(d);
            }
        }
        if (Math.abs(d) < 1.0E13 && d == Math.rint(d)) {
            return "" + Math2.roundToLong(d);
        }
        if (Math.abs(d) >= 999999.9999995) {
            DecimalFormat decimalFormat = genExpFormat6;
            synchronized (decimalFormat) {
                return genExpFormat6.format(d);
            }
        }
        DecimalFormat decimalFormat = genStdFormat6;
        synchronized (decimalFormat) {
            return genStdFormat6.format(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genEFormat10(double d) {
        if (!Math2.isFinite(d)) {
            return "" + d;
        }
        if (Math2.almost0(d)) {
            return "0";
        }
        if (Math.abs(d) < 0.09999999995 && !Math2.almostEqual(9, d * 1000000.0, Math.rint(d * 1000000.0))) {
            DecimalFormat decimalFormat = genExpFormat10;
            synchronized (decimalFormat) {
                return genExpFormat10.format(d);
            }
        }
        if (Math.abs(d) < 1.0E13 && d == Math.rint(d)) {
            return "" + Math2.roundToLong(d);
        }
        if (Math.abs(d) >= 1000000.0) {
            DecimalFormat decimalFormat = genExpFormat10;
            synchronized (decimalFormat) {
                return genExpFormat10.format(d);
            }
        }
        DecimalFormat decimalFormat = genStdFormat10;
        synchronized (decimalFormat) {
            return genStdFormat10.format(d);
        }
    }

    public static String genX10Format6(double d) {
        return String2.replaceAll(String2.genEFormat6(d), "E", "x10^");
    }

    public static String genX10Format10(double d) {
        return String2.replaceAll(String2.genEFormat10(d), "E", "x10^");
    }

    public static String genHTMLFormat6(double d) {
        String s = String2.genEFormat6(d);
        int po = s.indexOf(69);
        if (po >= 0) {
            s = String2.replaceAll(String2.genEFormat6(d), "E", "x10<sup>") + "</sup>";
        }
        return s;
    }

    public static String genHTMLFormat10(double d) {
        String s = String2.genEFormat10(d);
        int po = s.indexOf(69);
        if (po >= 0) {
            s = String2.replaceAll(String2.genEFormat10(d), "E", "x10<sup>") + "</sup>";
        }
        return s;
    }

    public static StringBuilder trim(StringBuilder sb) {
        int po;
        for (po = 0; po < sb.length() && String2.isWhite(sb.charAt(po)); ++po) {
        }
        sb.delete(0, po);
        for (po = sb.length(); po > 0 && String2.isWhite(sb.charAt(po - 1)); --po) {
        }
        sb.delete(po, sb.length());
        return sb;
    }

    public static String trimStart(String s) {
        int po;
        if (s == null) {
            return s;
        }
        int sLength = s.length();
        for (po = 0; po < sLength && String2.isWhite(s.charAt(po)); ++po) {
        }
        return po > 0 ? s.substring(po) : s;
    }

    public static String trimEnd(String s) {
        int sLength;
        int po;
        if (s == null) {
            return s;
        }
        for (po = sLength = s.length(); po > 0 && String2.isWhite(s.charAt(po - 1)); --po) {
        }
        return po < sLength ? s.substring(0, po) : s;
    }

    public static String getClassPath() {
        if (classPath == null) {
            String find = "/com/cohort/util/String2.class";
            classPath = String2.class.getResource(find).getFile();
            classPath = String2.replaceAll(classPath, '\\', '/');
            int po = classPath.indexOf(find);
            classPath = classPath.substring(0, po + 1);
            if (OSIsWindows && classPath.length() > 2 && classPath.charAt(0) == '/' && classPath.charAt(2) == ':') {
                classPath = classPath.substring(1);
            }
            try {
                classPath = URLDecoder.decode(classPath, "UTF-8");
            }
            catch (Throwable t) {
                String2.log(MustBe.throwableToString(t));
            }
        }
        return classPath;
    }

    public static String getStringFromSystemIn(String prompt) throws Exception {
        System.out.print(prompt);
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        return inReader.readLine();
    }

    public static final String getPasswordFromSystemIn(String prompt) throws Exception {
        char[] lineBuffer;
        InputStream in = System.in;
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread thread = new Thread(maskingthread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        try {
            int c;
            while ((c = in.read()) != -1 && c != 10) {
                if (c == 13) {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                if (--room < 0) {
                    buf = new char[offset + 128];
                    room = buf.length - offset - 1;
                    System.arraycopy(lineBuffer, 0, buf, 0, offset);
                    Arrays.fill(lineBuffer, ' ');
                    lineBuffer = buf;
                }
                buf[offset++] = (char)c;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return "";
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return new String(ret);
    }

    public static int binaryFindLastLE(String[] sar, String s) {
        if (s == null) {
            return -1;
        }
        int i = Arrays.binarySearch(sar, s);
        if (i >= 0) {
            while (i < sar.length - 1 && sar[i + 1].compareTo(s) <= 0) {
                ++i;
            }
            return i;
        }
        int insertionPoint = -i - 1;
        return insertionPoint - 1;
    }

    public static int binaryFindFirstGE(String[] sar, String s) {
        if (s == null) {
            return sar.length;
        }
        int i = Arrays.binarySearch(sar, s);
        if (i >= 0) {
            while (i > 0 && sar[i - 1].compareTo(s) >= 0) {
                --i;
            }
            return i;
        }
        return -i - 1;
    }

    public static int binaryFindClosest(String[] sar, String s) {
        if (s == null) {
            return -1;
        }
        int i = Arrays.binarySearch(sar, s);
        if (i >= 0) {
            return i;
        }
        int insertionPoint = -i - 1;
        if (insertionPoint == 0) {
            return 0;
        }
        if (insertionPoint >= sar.length) {
            return sar.length - 1;
        }
        int preIndex = insertionPoint - 1;
        int postIndex = insertionPoint;
        String pre = sar[preIndex];
        String post = sar[postIndex];
        int longest = Math.max(s.length(), Math.max(pre.length(), post.length()));
        String ts = s + String2.makeString(' ', longest - s.length());
        pre = pre + String2.makeString(' ', longest - pre.length());
        post = post + String2.makeString(' ', longest - post.length());
        for (i = 0; i < longest; ++i) {
            char ch = ts.charAt(i);
            char preCh = pre.charAt(i);
            char postCh = post.charAt(i);
            if (preCh == ch && postCh != ch) {
                return preIndex;
            }
            if (preCh != ch && postCh == ch) {
                return postIndex;
            }
            if (preCh == ch || postCh == ch) continue;
            return Math.abs(preCh - ch) < Math.abs(postCh - ch) ? preIndex : postIndex;
        }
        return preIndex;
    }

    public static int findInvalidUtf8(String s, String alsoOK) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (alsoOK.indexOf(ch) >= 0) continue;
            if (ch < ' ') {
                return i;
            }
            if (ch <= '~' || ch > '\u009f') continue;
            return i;
        }
        return -1;
    }

    public static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (Exception e) {
            String2.log(ERROR + " in String2.getUTF8Bytes(" + s + "): " + e.toString());
            return null;
        }
    }

    public static String utf8ToString(byte[] bar) {
        try {
            return new String(bar, "UTF-8");
        }
        catch (Exception e) {
            String2.log(ERROR + " in String2.utf8ToString: " + e.toString());
            return null;
        }
    }

    public static int[] makeJumpTable(byte[] find) {
        int findLength = find.length;
        int[] jump = new int[256];
        Arrays.fill(jump, findLength);
        for (int po = 0; po < findLength; ++po) {
            jump[find[po] & 0xFF] = findLength - 1 - po;
        }
        return jump;
    }

    public static int indexOf(byte[] s, byte[] find, int[] jumpTable) {
        int findLength1;
        int findLength = find.length;
        int sLength = s.length;
        if (findLength == 0) {
            return 0;
        }
        if (sLength == 0) {
            return -1;
        }
        int endPo = findLength1 = findLength - 1;
        byte lastFindByte = find[findLength1];
        if (findLength == 1) {
            int po = -1;
            while (++po < sLength) {
                if (s[po] != lastFindByte) continue;
                return po;
            }
            return -1;
        }
        block1: while (endPo < sLength) {
            byte b = s[endPo];
            if (b != lastFindByte) {
                endPo += jumpTable[b & 0xFF];
                continue;
            }
            int countBack = 1;
            do {
                if (s[endPo - countBack] == find[findLength1 - countBack]) continue;
                ++endPo;
                continue block1;
            } while (++countBack < findLength);
            return endPo - findLength1;
        }
        return -1;
    }

    public static String md5Hex(String password) {
        try {
            if (password == null) {
                return null;
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(String2.getUTF8Bytes(password));
            byte[] bytes = md.digest();
            int nBytes = bytes.length;
            StringBuilder sb = new StringBuilder(nBytes * 2);
            for (int i = 0; i < nBytes; ++i) {
                sb.append(String2.zeroPad(Integer.toHexString(bytes[i] & 0xFF), 2));
            }
            return sb.toString();
        }
        catch (Throwable t) {
            String2.log(MustBe.throwableToString(t));
            return null;
        }
    }

    public static String md5Hex12(String password) {
        String s = String2.md5Hex(password);
        return s == null ? null : s.substring(20, 24) + "_" + s.substring(24, 28) + "_" + s.substring(28, 32);
    }

    public static String differentLine(String oldS, String newS) {
        int oldEnd;
        int po;
        if (oldS == null) {
            return "(There is no old version.)";
        }
        if (newS == null) {
            return "(There is no new version.)";
        }
        int oldLength = oldS.length();
        int newLength = newS.length();
        int newlinePo = -1;
        int line = 1;
        int n = Math.min(oldLength, newLength);
        for (po = 0; po < n && oldS.charAt(po) == newS.charAt(po); ++po) {
            if (oldS.charAt(po) != '\n') continue;
            newlinePo = po;
            ++line;
        }
        if (po == oldLength && po == newLength) {
            return "";
        }
        int newEnd = newlinePo + 1;
        for (oldEnd = newlinePo + 1; oldEnd < oldLength && oldS.charAt(oldEnd) != '\n'; ++oldEnd) {
        }
        while (newEnd < newLength && newS.charAt(newEnd) != '\n') {
            ++newEnd;
        }
        return "  old line #" + line + "=" + String2.toJson(oldS.substring(newlinePo + 1, oldEnd)) + ",\n" + "  new line #" + line + "=" + String2.toJson(newS.substring(newlinePo + 1, newEnd)) + ".";
    }

    public static int[] toRational(double d) {
        int dpo;
        if (d == 0.0) {
            return new int[]{0, 0};
        }
        if (!Math2.isFinite(d)) {
            return new int[]{1, Integer.MAX_VALUE};
        }
        String s = "" + d;
        int ten = 0;
        int epo = s.indexOf(69);
        if (epo > 0) {
            ten = String2.parseInt(s.substring(epo + 1));
            s = s.substring(0, epo);
        }
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        if ((dpo = s.indexOf(46)) > 0) {
            ten -= s.length() - dpo - 1;
            s = s.substring(0, dpo) + s.substring(dpo + 1);
        }
        long tl = String2.parseLong(s);
        while (Math.abs(tl) > 1000000000L) {
            tl = Math.round((double)tl / 10.0);
            ++ten;
        }
        while (tl != 0L && (double)(tl / 10L) == (double)tl / 10.0) {
            tl /= 10L;
            ++ten;
        }
        if (tl < 100000L && ten >= 1 && ten <= 3) {
            while (ten > 0) {
                tl *= 10L;
                --ten;
            }
        }
        return new int[]{(int)tl, ten};
    }

    public static String encodeFileNameSafe(String s) {
        if (s == null) {
            return "x-1";
        }
        int n = s.length();
        if (n == 0) {
            return "x-0";
        }
        StringBuilder sb = new StringBuilder(n / 3 * 4);
        for (int i = 0; i < n; ++i) {
            if (sb.length() >= 25) {
                sb.append("xh" + String2.md5Hex12(s));
                break;
            }
            char ch = s.charAt(i);
            if (ch != 'x' && String2.isFileNameSafe(ch)) {
                sb.append(ch);
                continue;
            }
            if (ch <= '\u00ff') {
                sb.append("x" + String2.zeroPad(Integer.toHexString(ch), 2));
                continue;
            }
            sb.append("xx" + String2.zeroPad(Integer.toHexString(ch), 4));
        }
        return sb.toString();
    }

    public static String encodeVariableNameSafe(String s) {
        if (s == null) {
            return "x_1";
        }
        int n = s.length();
        if (n == 0) {
            return "x_0";
        }
        StringBuilder sb = new StringBuilder(n / 3 * 4);
        for (int i = 0; i < n; ++i) {
            if (sb.length() >= 25) {
                sb.append("xh" + String2.md5Hex12(s));
                break;
            }
            char ch = s.charAt(i);
            if (ch != 'x' && String2.isFileNameSafe(ch) && ch != '-' && ch != '.' && (i > 0 || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_')) {
                sb.append(ch);
                continue;
            }
            if (ch <= '\u00ff') {
                sb.append("x" + String2.zeroPad(Integer.toHexString(ch), 2));
                continue;
            }
            sb.append("xx" + String2.zeroPad(Integer.toHexString(ch), 4));
        }
        return sb.toString();
    }

    public static String getClipboardString() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = clipboard.getContents(null);
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)t.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Throwable th) {
            String2.log(ERROR + " while getting the string from the clipboard:\n" + MustBe.throwableToString(th));
        }
        return null;
    }

    public static void setClipboardString(String s) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(s), null);
        }
        catch (Throwable t) {
            String2.log(ERROR + " while putting the string on the clipboard:\n" + MustBe.throwableToString(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String canonical(String s) {
        if (s == null) {
            return null;
        }
        Map map = canonicalMap;
        synchronized (map) {
            String canonical;
            WeakReference wr = (WeakReference)canonicalMap.get(s);
            String string = canonical = wr == null ? null : (String)wr.get();
            if (canonical == null) {
                canonical = new String(s);
                canonicalMap.put(canonical, new WeakReference<String>(canonical));
            }
            return canonical;
        }
    }

    public static int canonicalSize() {
        return canonicalMap.size();
    }

    public static String quoteIfNeeded(boolean quoted, String s) {
        int po = s.indexOf(10);
        if (po >= 0) {
            s = String2.replaceAll(s, '\n', '\u00a6');
            s = String2.replaceAll(s, "\r", "");
        } else {
            s = String2.replaceAll(s, '\r', '\u00a6');
            s = String2.replaceAll(s, "\n", "");
        }
        if (quoted && (s.indexOf(34) >= 0 || s.indexOf(44) >= 0 || s.length() > 0 && (s.charAt(0) == ' ' || s.charAt(s.length() - 1) == ' '))) {
            s = "\"" + String2.replaceAll(s, "\"", "\"\"") + "\"";
        }
        return s;
    }

    public static String toTitleCase(String s) {
        if (s == null) {
            return null;
        }
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(s);
        char c = ' ';
        char oc = ' ';
        for (int i = 0; i < sLength; ++i) {
            oc = c;
            c = sb.charAt(i);
            if (!String2.isLetter(c)) continue;
            sb.setCharAt(i, String2.isLetter(oc) ? Character.toLowerCase(c) : Character.toUpperCase(c));
        }
        return sb.toString();
    }

    public static String toSentenceCase(String s) {
        if (s == null) {
            return null;
        }
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(s);
        boolean capNext = true;
        for (int i = 0; i < sLength; ++i) {
            char c = sb.charAt(i);
            if (String2.isLetter(c)) {
                if (capNext) {
                    sb.setCharAt(i, Character.toUpperCase(c));
                    capNext = false;
                    continue;
                }
                sb.setCharAt(i, Character.toLowerCase(c));
                continue;
            }
            if (c != '.') continue;
            capNext = true;
        }
        return sb.toString();
    }

    public static String toVariableName(String s) {
        if (s == null) {
            return "null";
        }
        int sLength = s.length();
        if (sLength == 0) {
            return "a";
        }
        s = String2.modifyToBeASCII(s);
        s = String2.toTitleCase(s);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sLength; ++i) {
            char c = s.charAt(i);
            if (!String2.isDigitLetter(c)) continue;
            sb.append(c);
        }
        if (sb.length() == 0) {
            return "a";
        }
        char c = sb.charAt(0);
        sb.setCharAt(0, Character.toLowerCase(c));
        if (c >= '0' && c <= '9') {
            sb.insert(0, 'a');
        }
        return sb.toString();
    }

    public static boolean isIso8859(String s) {
        int sLength = s.length();
        for (int i = 0; i < sLength; ++i) {
            if (s.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    static {
        logFileFlushEveryNth = 2;
        logFileFlushCount = 0;
        lineSeparator = System.getProperty("line.separator");
        OSIsWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
        OSIsLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
        OSIsMacOSX = System.getProperty("mrj.version") != null;
        genStdFormat6 = new DecimalFormat("0.######");
        genEngFormat6 = new DecimalFormat("##0.#####E0");
        genExpFormat6 = new DecimalFormat("0.######E0");
        genStdFormat10 = new DecimalFormat("0.##########");
        genEngFormat10 = new DecimalFormat("##0.#########E0");
        genExpFormat10 = new DecimalFormat("0.##########E0");
        canonicalMap = new WeakHashMap();
        DistributionSize = 22;
        BinMax = new int[]{0, 1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 60000, 120000, 300000, 600000, 1200000, 3600000, Integer.MAX_VALUE};
    }
}

