/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.array.Attributes;
import com.cohort.util.Calendar2;
import com.cohort.util.Math2;
import com.cohort.util.String2;
import java.util.GregorianCalendar;

public class Test {
    public static String utilDir = String2.getClassPath() + "com/cohort/util/";
    private static final String errorInObjectEquals = "\n" + String2.ERROR + " in Test.ensureEqual(object.equals):\n";

    public static void error(String message) throws RuntimeException {
        throw new RuntimeException(message);
    }

    public static void ensureEqual(boolean b1, boolean b2, String message) throws RuntimeException {
        if (b1 != b2) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(boolean):\n" + message + "\nSpecifically: " + b1 + " != " + b2);
        }
    }

    public static void ensureTrue(boolean b, String message) throws RuntimeException {
        if (!b) {
            Test.error("\n" + String2.ERROR + " in Test.ensureTrue:\n" + message);
        }
    }

    public static void ensureEqual(char c1, char c2, String message) throws RuntimeException {
        if (c1 != c2) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(char):\n" + message + "\nSpecifically: " + c1 + " != " + c2);
        }
    }

    public static void ensureEqual(long i1, long i2, String message) throws RuntimeException {
        if (i1 != i2) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(int):\n" + message + "\nSpecifically: " + i1 + " != " + i2);
        }
    }

    public static void ensureNotEqual(long i1, long i2, String message) throws RuntimeException {
        if (i1 == i2) {
            Test.error("\n" + String2.ERROR + " in Test.ensureNotEqual(int):\n" + message + "\nSpecifically: " + i1 + " = " + i2);
        }
    }

    public static boolean equal(float f1, float f2) {
        if (Float.isNaN(f1) && Float.isNaN(f2)) {
            return true;
        }
        if (Float.isInfinite(f1) && Float.isInfinite(f2)) {
            return !(f1 > 0.0f ^ f2 > 0.0f);
        }
        return Math2.almostEqual(5, f1, f2);
    }

    public static boolean equal(double d1, double d2) {
        if (Double.isNaN(d1) && Double.isNaN(d2)) {
            return true;
        }
        if (Double.isInfinite(d1) && Double.isInfinite(d2)) {
            return !(d1 > 0.0 ^ d2 > 0.0);
        }
        return Math2.almostEqual(9, d1, d2);
    }

    public static boolean equal(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static void ensureEqual(float f1, float f2, String message) throws RuntimeException {
        if (!Test.equal(f1, f2)) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(float):\n" + message + "\nSpecifically: " + f1 + " != " + f2);
        }
    }

    public static void ensureEqual(double d1, double d2, String message) throws RuntimeException {
        if (!Test.equal(d1, d2)) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(double):\n" + message + "\nSpecifically: " + d1 + " != " + d2);
        }
    }

    public static void ensureNotEqual(double d1, double d2, String message) throws RuntimeException {
        if (Double.isNaN(d1) && Double.isNaN(d2) || Double.isInfinite(d1) && Double.isInfinite(d2) || Math2.almostEqual(9, d1, d2)) {
            Test.error("\n" + String2.ERROR + " in Test.ensureNotEqual(double):\n" + message + "\nSpecifically: " + d1 + " = " + d2);
        }
    }

    public static void ensureBetween(double d, double minAllowed, double maxAllowed, String message) throws RuntimeException {
        if (Double.isNaN(d) || d < minAllowed || d > maxAllowed) {
            Test.error("\n" + String2.ERROR + " in Test.ensureBetween:\n" + message + "\nSpecifically: " + d + " isn't between " + minAllowed + " and " + maxAllowed + ".");
        }
    }

    public static void ensureEqual(String s1, String s2, String message) throws RuntimeException {
        String result = Test.testEqual(s1, s2, message);
        if (result.length() == 0) {
            return;
        }
        Test.error(result);
    }

    public static String testEqual(String s1, String s2, String message) {
        int line1End;
        int po;
        if (s1 == null && s2 == null) {
            return "";
        }
        if (s1 == null && s2 != null) {
            return "\n" + String2.ERROR + " in Test.ensureEqual(Strings):\n" + message + "\nSpecifically: " + "s1=[null]\n" + "s2=" + String2.noLongerThan(s2, 70);
        }
        if (s1 != null && s2 == null) {
            return "\n" + String2.ERROR + " in Test.ensureEqual(Strings):\n" + message + "\nSpecifically:\n" + "s1=" + String2.noLongerThan(s1, 70) + "\n" + "s2=[null]";
        }
        if (s1.equals(s2)) {
            return "";
        }
        int line = 1;
        int lastNewlinePo = -1;
        if (s1 != null && s2 != null) {
            for (po = 0; po < s1.length() && po < s2.length() && s1.charAt(po) == s2.charAt(po); ++po) {
                if (s1.charAt(po) != '\n') continue;
                ++line;
                lastNewlinePo = po;
            }
        }
        String c1 = po >= s1.length() ? "" : String2.annotatedString("" + s1.charAt(po));
        String c2 = po >= s2.length() ? "" : String2.annotatedString("" + s2.charAt(po));
        int line2End = po;
        for (line1End = po; line1End < s1.length() && s1.charAt(line1End) != '\n'; ++line1End) {
        }
        while (line2End < s2.length() && s2.charAt(line2End) != '\n') {
            ++line2End;
        }
        String line1Sample = String2.annotatedString(s1.substring(lastNewlinePo + 1, line1End));
        String line2Sample = String2.annotatedString(s2.substring(lastNewlinePo + 1, line2End));
        String annS1 = String2.annotatedString(s1);
        String annS2 = String2.annotatedString(s2);
        String lineString = "line=" + line + ": ";
        return "\n" + String2.ERROR + " in Test.ensureEqual(Strings) line=" + line + " col=" + (po - lastNewlinePo) + " '" + c1 + "'!='" + c2 + "':\n" + message + "\nSpecifically:\n" + "s1 " + lineString + line1Sample + "\n" + "s2 " + lineString + line2Sample + "\n" + String2.makeString(' ', 3 + lineString.length() + po - lastNewlinePo - 1) + "^" + "\n" + (line > 1 ? "\"" + annS1 + "\" != \n\"" + annS2 + "\"" : "");
    }

    public static void ensureEqual(GregorianCalendar g1, GregorianCalendar g2, String message) throws RuntimeException {
        if (g1 == null && g2 == null) {
            return;
        }
        if (g1 == null && g2 != null) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(GregorianCalendar):\n" + message + "\nSpecifically: " + "g1=[null]\n" + "g2=" + Calendar2.formatAsISODateTimeT(g2));
        }
        if (g1 != null && g2 == null) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(GregorianCalendar):\n" + message + "\nSpecifically:\n" + "g1=" + Calendar2.formatAsISODateTimeT(g1) + "\n" + "g2=[null]");
        }
        if (!g1.equals(g2)) {
            Test.error("\n" + String2.ERROR + " in Test.ensureEqual(GregorianCalendar):\n" + message + "\nSpecifically: " + Calendar2.formatAsISODateTimeT(g1) + " != " + Calendar2.formatAsISODateTimeT(g2));
        }
    }

    public static void ensureNotNull(Object o, String message) throws RuntimeException {
        if (o == null) {
            Test.error("\n" + String2.ERROR + " in Test.ensureNotNull:\n" + message);
        }
    }

    public static void ensureNotNothing(String s, String message) throws RuntimeException {
        if (s == null || s.length() == 0) {
            Test.error("\n" + String2.ERROR + " in Test.ensureNotNothing:\n" + message);
        }
    }

    public static void ensurePrintable(String s, String message) throws RuntimeException {
        Test.ensureNotNull(s, message);
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (String2.isPrintable(ch) || ch == '\n' || ch == '\t') continue;
            Test.error("\n" + String2.ERROR + " in Test.ensurePrintable:\n" + message + "\nTrouble: [" + ch + "] at position " + i + " in:\n" + String2.annotatedString(s));
        }
    }

    public static void ensureASCII(String s, String message) throws RuntimeException {
        Test.ensureNotNull(s, message);
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch >= ' ' && ch <= '~' || ch == '\n') continue;
            Test.error("\n" + String2.ERROR + " in Test.ensureASCII:\n" + message + "\nTrouble: [" + ch + "] at position " + i + " in:\n" + String2.annotatedString(s));
        }
    }

    public static void ensureEqual(Object[] ar1, Object[] ar2, String message) throws RuntimeException {
        if (ar1 == null && ar2 == null) {
            return;
        }
        Test.ensureEqual(ar1.length, ar2.length, String2.ERROR + " in Test.ensureEqual(Object[].length): " + message + "\n  ar1=" + String2.toNewlineString(ar1) + "\n  ar2=" + String2.toNewlineString(ar2));
        for (int i = 0; i < ar1.length; ++i) {
            Test.ensureEqual(ar1[i].toString(), ar2[i].toString(), String2.ERROR + " in Test.ensureEqual(Object[" + i + "]): " + message);
        }
    }

    public static void ensureEqual(Object a, Object b, String message) {
        if (a == null && b == null) {
            return;
        }
        if (a == null && b != null) {
            Test.error(errorInObjectEquals + message + "\nSpecifically: a=null");
        }
        if (a != null && b == null) {
            Test.error(errorInObjectEquals + message + "\nSpecifically: b=null");
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            byte[] aar = (byte[])a;
            byte[] bar = (byte[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na byte[] length != b byte[] length");
            for (int i = 0; i < an; ++i) {
                if (aar[i] == bar[i]) continue;
                Test.error(errorInObjectEquals + message + "\na byte[" + i + "]=" + aar[i] + " != b byte[" + i + "]=" + bar[i] + ".");
            }
            return;
        }
        if (a instanceof char[] && b instanceof char[]) {
            char[] aar = (char[])a;
            char[] bar = (char[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na char[] length != b char[] length");
            for (int i = 0; i < an; ++i) {
                if (aar[i] == bar[i]) continue;
                Test.error(errorInObjectEquals + message + "\na char[" + i + "]=" + aar[i] + " != b char[" + i + "]=" + bar[i] + ".");
            }
            return;
        }
        if (a instanceof short[] && b instanceof short[]) {
            short[] aar = (short[])a;
            short[] bar = (short[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na short[] length != b short[] length");
            for (int i = 0; i < an; ++i) {
                if (aar[i] == bar[i]) continue;
                Test.error(errorInObjectEquals + message + "\na short[" + i + "]=" + aar[i] + " != b short[" + i + "]=" + bar[i] + ".");
            }
            return;
        }
        if (a instanceof int[] && b instanceof int[]) {
            int[] aar = (int[])a;
            int[] bar = (int[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na int[] length != b int[] length");
            for (int i = 0; i < an; ++i) {
                if (aar[i] == bar[i]) continue;
                Test.error(errorInObjectEquals + message + "\na int[" + i + "]=" + aar[i] + " != b int[" + i + "]=" + bar[i] + ".");
            }
            return;
        }
        if (a instanceof long[] && b instanceof long[]) {
            long[] aar = (long[])a;
            long[] bar = (long[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na long[] length != b long[] length");
            for (int i = 0; i < an; ++i) {
                if (aar[i] == bar[i]) continue;
                Test.error(errorInObjectEquals + message + "\na long[" + i + "]=" + aar[i] + " != b long[" + i + "]=" + bar[i] + ".");
            }
            return;
        }
        if (a instanceof float[] && b instanceof float[]) {
            float[] aar = (float[])a;
            float[] bar = (float[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na float[] length != b float[] length");
            for (int i = 0; i < an; ++i) {
                if (Test.equal(aar[i], bar[i])) continue;
                Test.error(errorInObjectEquals + message + "\na float[" + i + "]=" + aar[i] + " != b float[" + i + "]=" + bar[i] + ".");
            }
            return;
        }
        if (a instanceof double[] && b instanceof double[]) {
            double[] aar = (double[])a;
            double[] bar = (double[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na double[] length != b double[] length");
            for (int i = 0; i < an; ++i) {
                if (Test.equal(aar[i], bar[i])) continue;
                Test.error(errorInObjectEquals + message + "\na double[" + i + "]=" + aar[i] + " != b double[" + i + "]=" + bar[i] + ".");
            }
            return;
        }
        if (a instanceof String[] && b instanceof String[]) {
            String[] aar = (String[])a;
            String[] bar = (String[])b;
            int an = aar.length;
            int bn = bar.length;
            Test.ensureEqual(an, bn, errorInObjectEquals + message + "\na String[] length != b String[] length");
            for (int i = 0; i < an; ++i) {
                if (aar[i].equals(bar[i])) continue;
                Test.error(errorInObjectEquals + message + "\na String[" + i + "]=\"" + aar[i] + "\" != b String[" + i + "]=\"" + bar[i] + "\".");
            }
            return;
        }
        if (a instanceof StringBuilder && b instanceof StringBuilder) {
            Test.ensureEqual(a.toString(), b.toString(), message);
            return;
        }
        if (!a.equals(b)) {
            Test.error(errorInObjectEquals + message + "\nSpecifically:\n" + "a(" + a.getClass().getName() + ")=" + a.toString() + "\n" + "b(" + b.getClass().getName() + ")=" + b.toString());
        }
    }

    public static void ensureFileNameSafe(String s, String message) throws RuntimeException {
        if (!String2.isFileNameSafe(s)) {
            Test.error("\n" + String2.ERROR + " in Test.ensureFileNameSafe():\n" + message + "=\"" + String2.annotatedString(s) + "\" must have length>0 and must contain only safe characters " + "(A-Z, a-z, 0-9, _, -, or .)" + ".");
        }
    }

    public static void ensureSomethingUtf8(String s, String message) throws RuntimeException {
        int po;
        if (s == null || s.trim().length() == 0) {
            Test.error("\n" + String2.ERROR + " in Test.ensureSomethingUtf8():\n" + message + " wasn't set.");
        }
        if ((po = String2.findInvalidUtf8(s, "\r\n\t")) >= 0) {
            int max = Math.min(po + 20, s.length());
            Test.error("\n" + String2.ERROR + " in Test.ensureSomthingUtf8():\n" + message + " has an invalid UTF-8 character (#" + s.charAt(po) + ") at position=" + po + (po > 80 ? "\npartial s=\"" + String2.annotatedString(s.substring(po - 20, max)) + "\"" : "\ns=\"" + String2.annotatedString(s) + "\""));
        }
    }

    public static void ensureSomethingUtf8(Attributes atts, String message) throws RuntimeException {
        if (atts == null) {
            Test.error("\n" + String2.ERROR + " in Test.ensureSomethingUtf8():\n" + message + " wasn't set.");
        }
        String[] names = atts.getNames();
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            Test.ensureSomethingUtf8(names[i], message + ": an attribute name");
            Test.ensureSomethingUtf8(atts.get(names[i]).toString(), message + ": the attribute value for name=" + names[i]);
        }
    }
}

