/*
 * Decompiled with CFR 0.152.
 */
package com.cohort.util;

import com.cohort.util.MustBe;
import com.cohort.util.String2;
import com.cohort.util.Test;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XML {
    public static String LS = System.getProperty("line.separator");
    public static String[] HTML_ENTITIES = new String[]{"", "", "", "", "", "", "", "", "", "&#9;", "\n", "", "", "\r", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", " ", "!", "&quot;", "#", "$", "&#37;", "&amp;", "&#39;", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "&lt;", "=", "&gt;", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "", "", "", "&#130;", "&#131;", "&#132;", "&#133;", "&#134;", "&#135;", "&#136;", "&#137;", "&#138;", "&#139;", "&#140;", "", "&#142;", "", "", "&#145;", "&#146;", "&#147;", "&#148;", "&#149;", "&#150;", "&#151;", "&#152;", "&#153;", "&#154;", "&#155;", "&#156;", "", "&#158;", "&#159;", "&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;"};

    public static String removeHTMLTags(String htmlString) {
        int htmlStringLength = htmlString.length();
        StringBuilder sb = new StringBuilder();
        int po = 0;
        while (po < htmlStringLength) {
            char ch;
            if ((ch = htmlString.charAt(po++)) == '<') {
                while (po < htmlStringLength && ch != '>') {
                    ch = htmlString.charAt(po++);
                }
                continue;
            }
            sb.append(ch);
        }
        return XML.decodeEntities(sb.toString());
    }

    public static String encodeAsHTML(String plainText) {
        int size = plainText.length();
        StringBuilder output = new StringBuilder(size * 2);
        for (int i = 0; i < size; ++i) {
            char chi = plainText.charAt(i);
            if (chi <= '\u00ff') {
                output.append(HTML_ENTITIES[chi]);
                continue;
            }
            output.append("&#x" + Integer.toHexString(chi) + ";");
        }
        return output.toString();
    }

    public static String encodeAsHTML(String s, boolean encodeAsHTML) {
        return encodeAsHTML ? XML.encodeAsHTML(s) : s;
    }

    public static String encodeAsHTMLAttribute(String plainText) {
        int size = plainText.length();
        StringBuilder output = new StringBuilder(size * 2);
        for (int i = 0; i < size; ++i) {
            char chi = plainText.charAt(i);
            if (String2.isDigitLetter(chi)) {
                output.append(chi);
                continue;
            }
            output.append("&#x" + Integer.toHexString(chi) + ";");
        }
        return output.toString();
    }

    public static String encodeAsXML(String plainText) {
        int size = plainText.length();
        StringBuilder output = new StringBuilder(size * 2);
        for (int i = 0; i < size; ++i) {
            char chi = plainText.charAt(i);
            if (chi <= '\u007f') {
                output.append(HTML_ENTITIES[chi]);
                continue;
            }
            output.append("&#x" + Integer.toHexString(chi) + ";");
        }
        return output.toString();
    }

    public static String encodeAsXML(String s, boolean encodeAsXML) {
        return encodeAsXML ? XML.encodeAsXML(s) : s;
    }

    public static String minimalEncodeSpaces(String s) {
        int nSpacesAtEnd;
        int sLength = s.length();
        if (sLength == 0) {
            return s;
        }
        for (nSpacesAtEnd = 0; nSpacesAtEnd < sLength && s.charAt(sLength - (nSpacesAtEnd + 1)) == ' '; ++nSpacesAtEnd) {
        }
        StringBuilder sb = new StringBuilder();
        if (nSpacesAtEnd < sLength) {
            int po;
            int tsLength = sLength - nSpacesAtEnd;
            for (po = 0; po < tsLength && s.charAt(po) == ' '; ++po) {
                sb.append('\u00a0');
            }
            while (po < tsLength - 1) {
                if (s.charAt(po) == ' ' && s.charAt(po + 1) == ' ') {
                    while (po < tsLength - 1 && s.charAt(po) == ' ') {
                        sb.append('\u00a0');
                        ++po;
                    }
                    continue;
                }
                sb.append(s.charAt(po++));
            }
            sb.append(s.charAt(tsLength - 1));
        }
        for (int i = 0; i < nSpacesAtEnd; ++i) {
            sb.append('\u00a0');
        }
        return sb.toString();
    }

    public static String encodeAsPreHTML(String plainText, int maxLineLength) {
        String s = String2.noLongLinesAtSpace(plainText, maxLineLength, "");
        s = XML.encodeAsHTML(s);
        s = String2.replaceAll(s, "\r", "");
        s = String2.replaceAll(s, "\n", "<br>");
        return s;
    }

    public static String decodeEntities(String s) {
        int size = s.length();
        StringBuilder output = new StringBuilder(size * 2);
        int i = 0;
        while (i < size) {
            char ch;
            if ((ch = s.charAt(i++)) == '&') {
                int po = s.indexOf(59, i);
                if (po > 0) {
                    String entity = s.substring(i - 1, po + 1);
                    if (entity.charAt(1) == '#') {
                        int v;
                        String num = entity.substring(2, entity.length() - 1);
                        if (num.length() != 0 && num.charAt(0) == 'x') {
                            num = "0" + num;
                        }
                        output.append((v = String2.parseInt(num)) == 160 ? " " : (v < 65535 ? "" + (char)v : entity));
                    } else if (entity.equals("&amp;")) {
                        output.append('&');
                    } else if (entity.equals("&quot;")) {
                        output.append('\"');
                    } else if (entity.equals("&lt;")) {
                        output.append('<');
                    } else if (entity.equals("&gt;")) {
                        output.append('>');
                    } else {
                        int which = String2.indexOf(HTML_ENTITIES, entity);
                        if (which >= 0) {
                            output.append((char)which);
                        } else {
                            output.append(entity);
                        }
                    }
                    i = po + 1;
                    continue;
                }
                output.append(ch);
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String toWriter(Writer out, String s, String error) {
        block2: {
            try {
                out.write(s);
            }
            catch (Exception e) {
                if (error.length() != 0) break block2;
                error = MustBe.throwableToString(e);
            }
        }
        return error;
    }

    public static String writeXMLStartElement(Writer out, String indent, String name, String error) {
        return XML.toWriter(out, indent + '<' + name + '>' + LS, error);
    }

    public static String writeXMLEndElement(Writer out, String indent, String name, String error) {
        return XML.toWriter(out, indent + "</" + name + '>' + LS, error);
    }

    public static String writeXMLElement(Writer out, String indent, String name, String value, String error) {
        return XML.toWriter(out, indent + '<' + name + '>' + XML.encodeAsXML(value) + "</" + name + '>' + LS, error);
    }

    public static String textToXMLName(String text) {
        text = text.trim();
        text = XML.removeHTMLTags(text);
        int textLength = text.length();
        StringBuilder sb = new StringBuilder(textLength + 1);
        for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                sb.append('_');
                continue;
            }
            if (!String2.isDigitLetter(ch) && ch != '_' && ch != '-' && ch != '.') continue;
            sb.append(ch);
        }
        if (sb.length() > 0 && !String2.isLetter(sb.charAt(0)) && sb.charAt(0) != '_') {
            sb.insert(0, '_');
        }
        return sb.toString();
    }

    public static void substitute(StringBuilder template, String[] substitutions) {
        for (int subN = 0; subN < substitutions.length; ++subN) {
            int temPo = 0;
            String sub = substitutions[subN];
            int tagStart = 0;
            String tag = null;
            while (sub.charAt(tagStart) == '<') {
                int tagEnd = sub.indexOf(62, tagStart + 1);
                tag = sub.substring(tagStart, tagEnd + 1);
                tagStart = tagEnd + 1;
                temPo = template.indexOf(tag, temPo);
                Test.ensureNotEqual(temPo, -1L, "FGDC.substitute subN=" + subN + " tag not found =" + XML.encodeAsXML(tag) + "\n  substitution=" + XML.encodeAsXML(sub));
                temPo += tag.length();
            }
            String closeTag = "</" + tag.substring(1);
            int closeTagAt = template.indexOf(closeTag, temPo);
            Test.ensureNotEqual(closeTagAt, -1L, "FGDC.substitute subN=" + subN + " close tag not found =" + XML.encodeAsXML(closeTag) + "\n  substitution=" + XML.encodeAsXML(sub));
            template.delete(temPo, closeTagAt);
            String data = sub.substring(tagStart);
            template.insert(temPo, data);
        }
    }

    public static void removeComments(StringBuilder document) {
        int startPo = document.indexOf("<!--");
        while (startPo >= 0) {
            int endPo = document.indexOf("-->", startPo + 4);
            document.delete(startPo, endPo + 3);
            startPo = document.indexOf("<!--", startPo);
        }
    }

    public static Document parseXml(String fileName, boolean validating) throws Exception {
        return XML.parseXml(new InputSource(fileName), validating);
    }

    public static Document parseXml(Reader input, boolean validating) throws Exception {
        return XML.parseXml(new InputSource(input), validating);
    }

    public static Document parseXml(InputSource inputSource, boolean validating) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        return factory.newDocumentBuilder().parse(inputSource);
    }

    public static XPath getXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static NodeList getNodeList(Object item, XPath xPath, String xPathQuery) throws Exception {
        return (NodeList)xPath.evaluate(xPathQuery, item, XPathConstants.NODESET);
    }

    public static Node getFirstNode(Object item, XPath xPath, String xPathQuery) throws Exception {
        NodeList nodeList = XML.getNodeList(item, xPath, xPathQuery);
        return nodeList.getLength() == 0 ? null : nodeList.item(0);
    }

    public static String getAttribute(Node node, String attributeName) {
        if (node == null) {
            return null;
        }
        Node att = node.getAttributes().getNamedItem(attributeName);
        if (att == null) {
            return null;
        }
        return att.getNodeValue();
    }

    public static String getTextContent(Node node) {
        int lastValid;
        int firstValid;
        if (node == null) {
            return "";
        }
        String s = node.getTextContent();
        int length = s.length();
        for (firstValid = 0; firstValid < length && String2.isWhite(s.charAt(firstValid)); ++firstValid) {
        }
        for (lastValid = length - 1; lastValid > firstValid && String2.isWhite(s.charAt(lastValid)); --lastValid) {
        }
        return s.substring(firstValid, lastValid + 1);
    }

    public static String getTextContent1(Object item, XPath xPath, String xPathQuery) throws Exception {
        return XML.getTextContent(XML.getFirstNode(item, xPath, xPathQuery));
    }

    public static void prettyXml(String inFileName, String outFileName) {
        String2.log("prettyXml\n in=" + inFileName + "\nout=" + outFileName);
        if (inFileName.equals(outFileName)) {
            throw new RuntimeException("Error: inFileName equals outFileName!");
        }
        String[] in = String2.readFromFile(inFileName, "UTF-8");
        if (in[0].length() > 0) {
            throw new RuntimeException("Error while reading " + inFileName + "\n" + in[0]);
        }
        String xml = in[1];
        int xmlLength = xml.length();
        StringBuilder sb = new StringBuilder();
        int nextStart = xml.indexOf(60);
        int indent = -2;
        boolean lastHadContent = false;
        while (nextStart >= 0 && nextStart < xmlLength) {
            int i;
            String content;
            int end;
            int start = nextStart;
            if (xml.substring(start, start + 4).equals("<!--")) {
                end = xml.indexOf("-->", start + 4);
                if (end < 0) {
                    throw new RuntimeException("No end '-->' for last comment.");
                }
                nextStart = xml.indexOf(60, end + 3);
                if (nextStart < 0) {
                    nextStart = xmlLength;
                }
                content = xml.substring(end + 3, nextStart).trim();
                if (start > 0) {
                    sb.append('\n');
                }
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
                sb.append(xml.substring(start, end + 3));
                sb.append(content);
                lastHadContent = false;
                continue;
            }
            if (xml.substring(start, start + 9).equals("<![CDATA[")) {
                end = xml.indexOf("]]>", start + 9);
                if (end < 0) {
                    throw new RuntimeException("No end ']]>' for last <![CDATA[.");
                }
                nextStart = xml.indexOf(60, end + 3);
                if (nextStart < 0) {
                    nextStart = xmlLength;
                }
                content = xml.substring(end + 3, nextStart).trim();
                sb.append(xml.substring(start, end + 3));
                sb.append(content);
                lastHadContent = true;
                continue;
            }
            end = xml.indexOf(62, start + 1);
            if (end < 0) {
                throw new RuntimeException("No '>' for last tag.");
            }
            nextStart = xml.indexOf(60, end + 1);
            if (nextStart < 0) {
                nextStart = xmlLength;
            }
            content = xml.substring(end + 1, nextStart).trim();
            if (xml.charAt(start + 1) == '/') {
                indent -= 2;
            }
            if (!lastHadContent) {
                if (start > 0) {
                    sb.append('\n');
                }
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(xml.substring(start, end + 1));
            sb.append(content);
            boolean bl = lastHadContent = content.length() > 0;
            if (xml.charAt(end - 1) == '/' || xml.charAt(start + 1) == '/') continue;
            indent += 2;
        }
        String2.writeToFile(outFileName, sb.toString());
    }

    public static void test() throws Exception {
        String2.log("\n*********************************************************** XML.test");
        String2.log("test removeHTMLTags");
        Test.ensureEqual(XML.removeHTMLTags("Hi, <b>bob.simons&amp;</b>!"), "Hi, bob.simons&!", "a");
        String2.log("test encode");
        Test.ensureEqual(XML.encodeAsXML("Hi &<>\"\u00b0\u1234Bob"), "Hi &amp;&lt;&gt;&quot;&#xb0;&#x1234;Bob", "XML");
        Test.ensureEqual(XML.encodeAsHTML("Hi &<>\"\u00b0\u1234Bob"), "Hi &amp;&lt;&gt;&quot;&deg;&#x1234;Bob", "HTML");
        Test.ensureEqual(XML.encodeAsHTMLAttribute("Hi &<>\"\u00b0\u1234Bob"), "Hi&#x20;&#x26;&#x3c;&#x3e;&#x22;&#xb0;&#x1234;Bob", "HTML");
        String2.log("test decodeEntities");
        Test.ensureEqual(XML.decodeEntities("Hi&#037;&#37;&#x025;&#x25; &amp;&lt;&gt;&quot;&nbsp;&#176;&deg;"), "Hi%%%% &<>\"\u00a0\u00b0\u00b0", "decode");
        for (int ch = 0; ch < 260; ++ch) {
            char ch1 = (char)ch;
            String ch2 = XML.decodeEntities(XML.encodeAsXML("" + ch1));
            if (ch2.length() > 0 && ch != 160) {
                Test.ensureEqual(ch2, "" + ch1, "XML encode/decode ch=" + ch);
            }
            if ((ch2 = XML.decodeEntities(XML.encodeAsHTML("" + ch1))).length() <= 0) continue;
            Test.ensureEqual(ch2, "" + ch1, "HTML encode/decode ch=" + ch);
        }
        String2.log("test textToXMLName");
        Test.ensureEqual(XML.textToXMLName("3 my._-te#st"), "_3_my._-test", "e");
        String doc = "<!-- comment --> <tag1>a<tag2>bb</tag2>ccc<tag3>dddd<tag4>eeee</tag4></tag3></tag1>f<!--comment-->g";
        String[] sub = new String[]{"<tag1><tag2>Nate", "<tag1><tag2><tag3><tag4>Nancy"};
        StringBuilder sb = new StringBuilder(doc);
        XML.substitute(sb, sub);
        Test.ensureEqual(sb.toString(), "<!-- comment --> <tag1>a<tag2>Nate</tag2>ccc<tag3>dddd<tag4>Nancy</tag4></tag3></tag1>f<!--comment-->g", "f");
        sub = new String[]{"<tag1><tag2> <tag3><tag4>Nancy"};
        sb = new StringBuilder(doc);
        XML.substitute(sb, sub);
        Test.ensureEqual(sb.toString(), "<!-- comment --> <tag1>a<tag2> <tag3><tag4>Nancy</tag2>ccc<tag3>dddd<tag4>eeee</tag4></tag3></tag1>f<!--comment-->g", "g");
        sb = new StringBuilder(doc);
        XML.removeComments(sb);
        Test.ensureEqual(sb.toString(), " <tag1>a<tag2>bb</tag2>ccc<tag3>dddd<tag4>eeee</tag4></tag3></tag1>fg", "h");
        XPath xPath = XML.getXPath();
        Document document = XML.parseXml(new BufferedReader(new StringReader("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<testr>\n  <level1 att1=\"value1\" att2=\"value 2\" > level 1 &amp; <!-- comment -->text  \n  </level1>\n  <levela />\n  <levelb> <!-- < > --> stuff</levelb>\n  <level1>test of level 1</level1>\n\n\n\n</testr>")), false);
        NodeList nodeList = XML.getNodeList(document, xPath, "/*");
        Test.ensureEqual(nodeList.getLength(), 1L, "");
        Test.ensureEqual(nodeList.item(0).getNodeName(), "testr", "get root node");
        nodeList = XML.getNodeList(document, xPath, "/testr/level1");
        Test.ensureEqual(nodeList.getLength(), 2L, "");
        Test.ensureEqual(XML.getTextContent(nodeList.item(0)), "level 1 & text", "get text");
        Test.ensureEqual(XML.getTextContent(nodeList.item(1)), "test of level 1", "get text");
        Test.ensureEqual(XML.getTextContent(XML.getFirstNode(document, xPath, "/testr/level1")), "level 1 & text", "get text");
        Test.ensureEqual(XML.getTextContent(null), "", "get text");
        Test.ensureEqual(XML.getTextContent1(document, xPath, "/testr/level1"), "level 1 & text", "get text");
        nodeList = XML.getNodeList(document, xPath, "/testr/level1[@att1]");
        Test.ensureEqual(nodeList.getLength(), 1L, "");
        Test.ensureEqual(XML.getAttribute(nodeList.item(0), "att1"), "value1", "get attribute");
        Test.ensureEqual(XML.getAttribute(nodeList.item(0), "zz"), null, "get attribute");
        Test.ensureEqual(XML.getAttribute(XML.getFirstNode(document, xPath, "/testr/level1[@att1]"), "att1"), "value1", "get attribute");
        Test.ensureEqual(XML.getAttribute(null, "att1"), null, "get attribute");
        nodeList = XML.getNodeList(document, xPath, "/testr/level1[@att1 and @att2]");
        Test.ensureEqual(nodeList.getLength(), 1L, "");
        nodeList = XML.getNodeList(document, xPath, "/testr/level1[@att1='value1']");
        Test.ensureEqual(nodeList.getLength(), 1L, "");
        Test.ensureEqual(XML.minimalEncodeSpaces(""), "", "");
        Test.ensureEqual(XML.minimalEncodeSpaces(" "), "\u00a0", "");
        Test.ensureEqual(XML.minimalEncodeSpaces("  "), "\u00a0\u00a0", "");
        Test.ensureEqual(XML.minimalEncodeSpaces(" a "), "\u00a0a\u00a0", "");
        Test.ensureEqual(XML.minimalEncodeSpaces("  a  "), "\u00a0\u00a0a\u00a0\u00a0", "");
        Test.ensureEqual(XML.minimalEncodeSpaces(" ab "), "\u00a0ab\u00a0", "");
        Test.ensureEqual(XML.minimalEncodeSpaces("a b"), "a b", "");
        Test.ensureEqual(XML.minimalEncodeSpaces(" a  b "), "\u00a0a\u00a0\u00a0b\u00a0", "");
        Test.ensureEqual(XML.minimalEncodeSpaces("  a   bc d  "), "\u00a0\u00a0a\u00a0\u00a0\u00a0bc d\u00a0\u00a0", "");
        String2.log("XML.test finished successfully.");
    }
}

