/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.waterml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.opengis.waterml.x20.CollectionType;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ogc.MarshallingUtil;
import ucar.nc2.ogc.om.NcOMObservationPropertyType;
import ucar.nc2.ogc.waterml.NcDocumentMetadataPropertyType;

public abstract class NcCollectionType {
    public static CollectionType initCollection(CollectionType collection, FeatureDatasetPoint fdPoint, VariableSimpleIF dataVar) throws IOException {
        String id = MarshallingUtil.createIdForType(CollectionType.class);
        collection.setId(id);
        NcDocumentMetadataPropertyType.initMetadata(collection.addNewMetadata());
        StationTimeSeriesFeatureCollection stationFeatColl = NcCollectionType.getStationFeatures(fdPoint);
        PointFeatureCollectionIterator stationFeatCollIter = stationFeatColl.getPointFeatureCollectionIterator(-1);
        while (stationFeatCollIter.hasNext()) {
            StationTimeSeriesFeature stationFeat = (StationTimeSeriesFeature)stationFeatCollIter.next();
            NcOMObservationPropertyType.initObservationMember(collection.addNewObservationMember(), stationFeat, dataVar);
        }
        return collection;
    }

    public static StationTimeSeriesFeatureCollection getStationFeatures(FeatureDatasetPoint fdPoint) {
        String datasetFileName = new File(fdPoint.getNetcdfFile().getLocation()).getName();
        if (!fdPoint.getFeatureType().equals((Object)FeatureType.STATION)) {
            throw new IllegalArgumentException(String.format("In %s, expected feature type to be STATION, not %s.", datasetFileName, fdPoint.getFeatureType()));
        }
        List featCollList = fdPoint.getPointFeatureCollectionList();
        if (featCollList.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected %s to contain 1 FeatureCollection, not %s.", datasetFileName, featCollList.size()));
        }
        if (!(featCollList.get(0) instanceof StationTimeSeriesFeatureCollection)) {
            String expectedClassName = StationTimeSeriesFeatureCollection.class.getName();
            String actualClassName = ((FeatureCollection)featCollList.get(0)).getClass().getName();
            throw new IllegalArgumentException(String.format("Expected %s's FeatureCollection to be a %s, not a %s.", datasetFileName, expectedClassName, actualClassName));
        }
        return (StationTimeSeriesFeatureCollection)featCollList.get(0);
    }

    private NcCollectionType() {
    }
}

