/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.bufrvalidate;

import edu.ucar.unidata.bufrvalidate.FileUploadBean;
import java.io.File;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import ucar.nc2.util.DiskCache2;

public class BtFileUploadController
extends SimpleFormController {
    private DiskCache2 diskCache = null;

    public void setCache(DiskCache2 cache) {
        this.diskCache = cache;
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        FileUploadBean bean = (FileUploadBean)command;
        MultipartFile file = bean.getFile();
        if (file == null) {
            response.sendError(400, "No file was uploaded");
            return null;
        }
        String username = bean.getUsername();
        if (username == null) {
            username = "anon";
        }
        if ((username = username.trim()).length() == 0) {
            username = "anon";
        }
        String fname = username + "/" + file.getOriginalFilename();
        String redirectURL = "/validate/file";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filename", fname);
        map.put("xml", bean.isXml());
        File dest = this.diskCache.getCacheFile(fname);
        file.transferTo(dest);
        return new ModelAndView((View)new RedirectView(redirectURL, true), map);
    }
}

