/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.repository;

import edu.ucar.unidata.wmotables.domain.Table;
import edu.ucar.unidata.wmotables.repository.TableDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcTableDao
extends JdbcDaoSupport
implements TableDao {
    private SimpleJdbcInsert insertActor;

    @Override
    public Table lookupTable(int tableId) {
        String sql = "SELECT * FROM tables WHERE tableId = ?";
        List tables = this.getJdbcTemplate().query(sql, (RowMapper)new TableMapper(), new Object[]{tableId});
        if (tables.isEmpty()) {
            throw new RecoverableDataAccessException("Unable to find table with Id: " + new Integer(tableId).toString());
        }
        return (Table)tables.get(0);
    }

    @Override
    public Table lookupTable(String checksum) {
        String sql = "SELECT * FROM tables WHERE checksum = ?";
        List tables = this.getJdbcTemplate().query(sql, (RowMapper)new TableMapper(), new Object[]{checksum});
        if (tables.isEmpty()) {
            throw new RecoverableDataAccessException("Unable to find table with checksum: " + checksum);
        }
        return (Table)tables.get(0);
    }

    @Override
    public List<Table> getTableList() {
        String sql = "SELECT * FROM tables ORDER BY dateCreated DESC";
        List tables = this.getJdbcTemplate().query(sql, (RowMapper)new TableMapper());
        return tables;
    }

    @Override
    public List<Table> getTableList(int userId) {
        String sql = "SELECT * FROM tables WHERE userId = ? ORDER BY dateCreated DESC";
        List tables = this.getJdbcTemplate().query(sql, (RowMapper)new TableMapper(), new Object[]{userId});
        return tables;
    }

    @Override
    public int getTableCount() {
        String sql = "SELECT count(*) FROM tables";
        List tables = this.getJdbcTemplate().query(sql, (RowMapper)new TableMapper());
        return tables.size();
    }

    @Override
    public int getTableCount(int userId) {
        String sql = "SELECT count(*) FROM tables WHERE userId = ?";
        List tables = this.getJdbcTemplate().query(sql, (RowMapper)new TableMapper(), new Object[]{userId});
        return tables.size();
    }

    @Override
    public void toggleTableVisibility(Table table) {
        String sql = "UPDATE tables SET visibility = ? WHERE tableId = ?";
        int rowsAffected = this.getJdbcTemplate().update(sql, new Object[]{table.getVisibility(), table.getTableId()});
        if (rowsAffected <= 0) {
            throw new RecoverableDataAccessException("Unable to toggle table visibility. No table found with checksum: " + table.getChecksum());
        }
    }

    @Override
    public void createTable(Table table) {
        String sql = "SELECT * FROM tables WHERE checksum = ?";
        List tables = this.getJdbcTemplate().query(sql, (RowMapper)new TableMapper(), new Object[]{table.getChecksum()});
        if (!tables.isEmpty()) {
            throw new RecoverableDataAccessException("An identical table has already been uploaded.");
        }
        this.insertActor = new SimpleJdbcInsert(this.getDataSource()).withTableName("tables").usingGeneratedKeyColumns(new String[]{"tableId"});
        BeanPropertySqlParameterSource parameters = new BeanPropertySqlParameterSource((Object)table);
        Number newTableId = this.insertActor.executeAndReturnKey((SqlParameterSource)parameters);
        table.setTableId(newTableId.intValue());
    }

    @Override
    public void updateTable(Table table) {
        String sql = "UPDATE tables SET title = ?, description = ?, localVersion = ?, center= ?, subCenter= ?, tableType = ?, dateModified = ? WHERE tableId = ?";
        int rowsAffected = this.getJdbcTemplate().update(sql, new Object[]{table.getTitle(), table.getDescription(), table.getLocalVersion(), table.getCenter(), table.getSubCenter(), table.getTableType(), table.getDateModified(), table.getTableId()});
        if (rowsAffected <= 0) {
            throw new RecoverableDataAccessException("Unable to update table.  No table found with checksum: " + table.getChecksum());
        }
    }

    private static class TableMapper
    implements RowMapper<Table> {
        private TableMapper() {
        }

        public Table mapRow(ResultSet rs, int rowNum) throws SQLException {
            Table table = new Table();
            table.setTableId(rs.getInt("tableId"));
            table.setTitle(rs.getString("title"));
            table.setDescription(rs.getString("description"));
            table.setOriginalName(rs.getString("originalName"));
            table.setLocalVersion(rs.getInt("localVersion"));
            table.setCenter(rs.getInt("center"));
            table.setSubCenter(rs.getInt("subCenter"));
            table.setTableType(rs.getString("tableType"));
            table.setMimeType(rs.getString("mimeType"));
            table.setChecksum(rs.getString("checksum"));
            table.setUserId(rs.getInt("userId"));
            table.setVisibility(rs.getInt("visibility"));
            table.setDateCreated(rs.getTimestamp("dateCreated"));
            table.setDateModified(rs.getTimestamp("dateModified"));
            return table;
        }
    }
}

