/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.repository;

import edu.ucar.unidata.wmotables.domain.User;
import edu.ucar.unidata.wmotables.repository.UserDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcUserDao
extends JdbcDaoSupport
implements UserDao {
    private static Logger logger = LoggerFactory.getLogger(JdbcDaoSupport.class);
    private SimpleJdbcInsert insertActor;

    @Override
    public User lookupUser(int userId) {
        String sql = "SELECT * FROM users WHERE userId = ?";
        List users = this.getJdbcTemplate().query(sql, (RowMapper)new UserMapper(), new Object[]{userId});
        if (users.isEmpty()) {
            throw new RecoverableDataAccessException("Unable to find user with Id: " + new Integer(userId).toString());
        }
        return (User)users.get(0);
    }

    @Override
    public User lookupUser(String userName) {
        String sql = "SELECT * FROM users WHERE userName = ?";
        List users = this.getJdbcTemplate().query(sql, (RowMapper)new UserMapper(), new Object[]{userName});
        if (users.isEmpty()) {
            throw new RecoverableDataAccessException("Unable to find user with user name: " + userName);
        }
        return (User)users.get(0);
    }

    @Override
    public List<User> getUserList() {
        String sql = "SELECT * FROM users ORDER BY dateCreated DESC";
        List users = this.getJdbcTemplate().query(sql, (RowMapper)new UserMapper());
        return users;
    }

    @Override
    public int getUserCount() {
        String sql = "SELECT count(*) FROM users";
        List users = this.getJdbcTemplate().query(sql, (RowMapper)new UserMapper());
        return users.size();
    }

    @Override
    public void deleteUser(int userId) {
        String sql = "DELETE FROM users WHERE userId = ?";
        int rowsAffected = this.getJdbcTemplate().update(sql, new Object[]{userId});
        if (rowsAffected <= 0) {
            throw new RecoverableDataAccessException("Unable to delete user. No user found with Id: " + new Integer(userId).toString());
        }
    }

    @Override
    public void deleteUser(String userName) {
        String sql = "DELETE FROM users WHERE userName = ?";
        int rowsAffected = this.getJdbcTemplate().update(sql, new Object[]{userName});
        if (rowsAffected <= 0) {
            throw new RecoverableDataAccessException("Unable to delete user. No user found with user name: " + userName);
        }
    }

    @Override
    public void createUser(User user) {
        String sql = "SELECT * FROM users WHERE userName = ?";
        List users = this.getJdbcTemplate().query(sql, (RowMapper)new UserMapper(), new Object[]{user.getUserName()});
        if (!users.isEmpty()) {
            throw new RecoverableDataAccessException("User with user name \"" + user.getUserName() + "\" already exists.");
        }
        this.insertActor = new SimpleJdbcInsert(this.getDataSource()).withTableName("users").usingGeneratedKeyColumns(new String[]{"userId"});
        BeanPropertySqlParameterSource parameters = new BeanPropertySqlParameterSource((Object)user);
        Number newUserId = this.insertActor.executeAndReturnKey((SqlParameterSource)parameters);
        user.setUserId(newUserId.intValue());
    }

    @Override
    public void updateUser(User user) {
        String sql = "UPDATE users SET emailAddress = ?, fullName = ?, center= ?, subCenter= ?, dateModified = ? WHERE userId = ?";
        int rowsAffected = this.getJdbcTemplate().update(sql, new Object[]{user.getEmailAddress(), user.getFullName(), user.getCenter(), user.getSubCenter(), user.getDateModified(), user.getUserId()});
        if (rowsAffected <= 0) {
            throw new RecoverableDataAccessException("Unable to update user.  No user for with user name: " + user.getUserName());
        }
    }

    @Override
    public void updatePassword(User user) {
        String sql = "UPDATE users SET password = ?, dateModified = ? WHERE userId = ?";
        int rowsAffected = this.getJdbcTemplate().update(sql, new Object[]{user.getPassword(), user.getDateModified(), user.getUserId()});
        if (rowsAffected <= 0) {
            throw new RecoverableDataAccessException("Unable to update user.  User not found: " + user.toString());
        }
    }

    private static class UserMapper
    implements RowMapper<User> {
        private UserMapper() {
        }

        public User mapRow(ResultSet rs, int rowNum) throws SQLException {
            User user = new User();
            user.setUserId(rs.getInt("userId"));
            user.setUserName(rs.getString("userName"));
            user.setPassword(rs.getString("password"));
            user.setAccessLevel(rs.getInt("accessLevel"));
            user.setEmailAddress(rs.getString("emailAddress"));
            user.setFullName(rs.getString("fullName"));
            user.setCenter(rs.getInt("center"));
            user.setSubCenter(rs.getInt("subCenter"));
            user.setDateCreated(rs.getTimestamp("dateCreated"));
            user.setDateModified(rs.getTimestamp("dateModified"));
            return user;
        }
    }
}

