/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.service;

import edu.ucar.unidata.wmotables.domain.Table;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
public class TableValidator
implements Validator {
    private static Logger logger = LoggerFactory.getLogger(TableValidator.class);
    private String[] NAUGHTY_STRINGS = new String[]{"<script>", "../", "javascript", "::", "&quot;", "fromcharCode", "%3", "$#", "alert(", ".js", ".source", "\\", "scriptlet", ".css", "binding:", ".htc", "vbscript", "mocha:", "livescript:", "base64", "\u0000", "xss:", "%77", "0x", "IS NULL;", "1;", "; --", "1=1"};
    private String[] NAUGHTY_CHARS = new String[]{"<", ">", "`", "^", "|", "}", "{"};
    private Pattern pattern;
    private Matcher matcher;
    private static final String CONTENT_TYPE_PATTERN = "((.*)(csv|text|xml)(.*))";
    @Value(value="${table.types}")
    private String tableTypeString;

    public boolean supports(Class clazz) {
        return Table.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors errors) {
        Table table = (Table)obj;
        this.validateTitle(table.getTitle(), errors);
        this.validateDescription(table.getDescription(), errors);
        this.validateLocalVersion(table.getLocalVersion(), errors);
        this.validateCenter(table.getCenter(), errors);
        this.validateSubCenter(table.getSubCenter(), errors);
        this.validateTableType(table.getTableType(), errors);
    }

    public void validateFileSize(CommonsMultipartFile file, Errors errors) {
        if (file.isEmpty()) {
            errors.rejectValue("file", "table.error", "You're attempting to upload an empty file.");
            return;
        }
        if (file.getSize() > 0x100000L) {
            errors.rejectValue("file", "table.error", "File upload too big! File size is restricted to 1MB max.");
            return;
        }
    }

    public void validateFileType(String contentType, Errors errors) {
        this.pattern = Pattern.compile(CONTENT_TYPE_PATTERN);
        this.matcher = this.pattern.matcher(StringUtils.lowerCase((String)contentType));
        if (!this.matcher.matches()) {
            errors.rejectValue("file", "table.error", "Bad content type for file.  Only files of type text, csv and xml allowed.");
            return;
        }
    }

    public void validateTitle(String input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)input)) {
            errors.rejectValue("title", "table.error", "Table title is required!");
            return;
        }
        if (StringUtils.length((CharSequence)input) < 3 || StringUtils.length((CharSequence)input) > 75) {
            errors.rejectValue("title", "table.error", "The table title must be between 3 and 75 characters in length.");
            return;
        }
        this.validateInput("title", input, errors);
    }

    public void validateDescription(String input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)input)) {
            errors.rejectValue("description", "table.error", "Table description is required!");
            return;
        }
        if (StringUtils.length((CharSequence)input) < 6 || StringUtils.length((CharSequence)input) > 225) {
            errors.rejectValue("description", "table.error", "The description must be between 6 and 225 characters in length.");
            return;
        }
        this.validateInput("description", input, errors);
    }

    public void validateLocalVersion(int input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)new Integer(input).toString())) {
            errors.rejectValue("localVersion", "table.error", "Local Version is required!");
            return;
        }
    }

    public void validateCenter(int input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)new Integer(input).toString())) {
            errors.rejectValue("center", "table.error", "Table center is required!");
            return;
        }
    }

    public void validateSubCenter(int input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)new Integer(input).toString())) {
            errors.rejectValue("subCenter", "table.error", "Table sub center is required!");
            return;
        }
    }

    public void validateTableType(String input, Errors errors) {
        List<String> tableTypesList = this.getTableTypes();
        if (!tableTypesList.contains(input)) {
            errors.rejectValue("tableType", "table.error", "You must select a table type!");
            return;
        }
    }

    public void validateInput(String formField, String input, Errors errors) {
        String badChar = this.checkForNaughtyChars(input);
        if (badChar != null) {
            logger.warn("Bad value submitted for " + formField + " : " + badChar);
            errors.rejectValue(formField, "table.error", "Bad value submitted: " + badChar);
            return;
        }
        String badString = this.checkForNaughtyStrings(input);
        if (badString != null) {
            logger.warn("Bad value submitted for " + formField + " : " + badString);
            errors.rejectValue(formField, "table.error", "Bad value submitted: " + badString);
            return;
        }
    }

    public String checkForNaughtyStrings(String itemToCheck) {
        for (String item : this.NAUGHTY_STRINGS) {
            if (!StringUtils.contains((CharSequence)StringUtils.lowerCase((String)itemToCheck), (CharSequence)item)) continue;
            return item;
        }
        return null;
    }

    public String checkForNaughtyChars(String itemToCheck) {
        for (String item : this.NAUGHTY_CHARS) {
            if (!StringUtils.contains((CharSequence)itemToCheck, (CharSequence)item)) continue;
            return item;
        }
        return null;
    }

    public List<String> getTableTypes() {
        String[] a = StringUtils.split((String)this.tableTypeString, (String)",");
        List<String> tableTypes = Arrays.asList(a);
        return tableTypes;
    }
}

